/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps.wf;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.border.Border;
import org.compiere.apps.wf.WFIcon;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.wf.MWFNode;

public class WFNode
extends JComponent {
    public static String PROPERTY_SELECTED = "selected";
    private static Border s_border = BorderFactory.createBevelBorder(0);
    private static Border s_borderSelected = BorderFactory.createBevelBorder(1);
    private static Dimension s_size = new Dimension(120, 50);
    private static CLogger log = CLogger.getCLogger(WFNode.class);
    private MWFNode m_node = null;
    private WFIcon m_icon = null;
    private String m_name = null;
    private boolean m_selected = false;
    private boolean m_visited = false;
    private boolean m_moved = false;

    public WFNode(MWFNode node) {
        this.setOpaque(true);
        this.m_node = node;
        this.setName(this.m_node.getName());
        this.m_icon = new WFIcon(node.getAction());
        this.m_name = this.m_node.getName(true);
        this.setBorder(s_border);
        String description = node.getDescription(true);
        if (description != null && description.length() > 0) {
            this.setToolTipText(description);
        } else {
            this.setToolTipText(node.getName(true));
        }
        this.setBounds(node.getXPosition(), node.getYPosition(), WFNode.s_size.width, WFNode.s_size.height);
        log.config(node.getAD_WF_Node_ID() + "," + node.getName() + " - " + this.getLocation());
        this.setSelected(false);
        this.setVisited(false);
    }

    public void setSelected(boolean selected) {
        this.firePropertyChange(PROPERTY_SELECTED, this.m_selected, selected);
        this.m_selected = selected;
        if (this.m_selected) {
            this.setBorder(s_borderSelected);
            this.setForeground(Color.blue);
        } else {
            this.setBorder(s_border);
            this.setForeground(Color.black);
        }
    }

    public void setVisited(boolean visited) {
        this.m_visited = visited;
        if (this.m_visited) {
            this.setBackground(Color.green);
        } else {
            this.setBackground(Color.lightGray);
        }
    }

    public boolean isSelected() {
        return this.m_selected;
    }

    public int getAD_Client_ID() {
        return this.m_node.getAD_Client_ID();
    }

    public boolean isEditable() {
        return this.getAD_Client_ID() == Env.getAD_Client_ID(Env.getCtx());
    }

    public int getAD_WF_Node_ID() {
        return this.m_node.getAD_WF_Node_ID();
    }

    public MWFNode getModel() {
        return this.m_node;
    }

    public void setLocation(int x, int y) {
        super.setLocation(x, y);
        this.m_node.setPosition(x, y);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("WFNode[");
        sb.append(this.getAD_WF_Node_ID()).append("-").append(this.m_name).append(",").append(this.getBounds()).append("]");
        return sb.toString();
    }

    public Font getFont() {
        Font base = new Font(null);
        if (!this.isEditable()) {
            return base;
        }
        return new Font(base.getName(), 3, base.getSize());
    }

    public Dimension getPreferredSize() {
        return s_size;
    }

    protected void paintComponent(Graphics g) {
        Graphics2D g2D = (Graphics2D)g;
        Rectangle bounds = this.getBounds();
        this.m_icon.paintIcon(this, g2D, 0, 0);
        Color color = this.getForeground();
        g2D.setPaint(color);
        Font font = this.getFont();
        AttributedString aString = new AttributedString(this.m_name);
        aString.addAttribute(TextAttribute.FONT, font);
        aString.addAttribute(TextAttribute.FOREGROUND, color);
        AttributedCharacterIterator iter = aString.getIterator();
        LineBreakMeasurer measurer = new LineBreakMeasurer(iter, g2D.getFontRenderContext());
        float width = WFNode.s_size.width - this.m_icon.getIconWidth() - 2;
        TextLayout layout = measurer.nextLayout(width);
        float xPos = this.m_icon.getIconWidth();
        float yPos = layout.getAscent() + 2.0f;
        layout.draw(g2D, xPos, yPos);
        width = WFNode.s_size.width - 4;
        while (measurer.getPosition() < iter.getEndIndex()) {
            layout = measurer.nextLayout(width);
            layout.draw(g2D, 2.0f, yPos += layout.getAscent() + layout.getDescent() + layout.getLeading());
        }
    }
}

