/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps.wf;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import org.compiere.apps.wf.WFContentPanel;
import org.compiere.apps.wf.WFNode;
import org.compiere.util.CLogger;

public class WFLayoutManager
implements LayoutManager {
    private static CLogger log = CLogger.getCLogger(WFLayoutManager.class);
    private Dimension m_size = null;

    public void addLayoutComponent(String name, Component comp) {
        this.invalidateLayout();
    }

    public void removeLayoutComponent(Component comp) {
        if (comp == null) {
            return;
        }
        this.invalidateLayout();
    }

    public Dimension preferredLayoutSize(Container parent) {
        if (this.m_size == null) {
            this.layoutContainer(parent);
        }
        return this.m_size;
    }

    public Dimension minimumLayoutSize(Container parent) {
        return this.preferredLayoutSize(parent);
    }

    public void layoutContainer(Container parent) {
        Insets insets = parent.getInsets();
        int width = insets.left;
        int height = insets.top;
        if (this.needLayout(parent)) {
            int x = 5;
            int y = 5;
            for (int i = 0; i < parent.getComponentCount(); ++i) {
                Component comp = parent.getComponent(i);
                if (!comp.isVisible() || !(comp instanceof WFNode)) continue;
                Dimension ps = comp.getPreferredSize();
                comp.setLocation(x, y);
                comp.setBounds(x, y, ps.width, ps.height);
                width = x + ps.width;
                height = y + ps.height;
                if (x == 5) {
                    x = 230;
                    continue;
                }
                x = 5;
                y += 100;
            }
        } else {
            for (int i = 0; i < parent.getComponentCount(); ++i) {
                Component comp = parent.getComponent(i);
                if (!comp.isVisible() || !(comp instanceof WFNode)) continue;
                Dimension ps = comp.getPreferredSize();
                Point loc = comp.getLocation();
                int maxWidth = comp.getX() + ps.width;
                int maxHeight = comp.getY() + ps.height;
                if (width < maxWidth) {
                    width = maxWidth;
                }
                if (height < maxHeight) {
                    height = maxHeight;
                }
                comp.setBounds(loc.x, loc.y, ps.width, ps.height);
            }
        }
        WFContentPanel panel = (WFContentPanel)parent;
        panel.createLines();
        this.m_size = new Dimension(width += insets.right, height += insets.bottom);
        log.finer("Size=" + this.m_size);
    }

    private boolean needLayout(Container parent) {
        Point p00 = new Point(0, 0);
        for (int i = 0; i < parent.getComponentCount(); ++i) {
            Component comp = parent.getComponent(i);
            if (!(comp instanceof WFNode) || !comp.getLocation().equals(p00)) continue;
            log.fine(comp.toString());
            return true;
        }
        return false;
    }

    private void invalidateLayout() {
        this.m_size = null;
    }
}

