/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps.search;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.sql.Timestamp;
import java.util.GregorianCalendar;
import java.util.logging.Level;
import javax.swing.JScrollPane;
import org.compiere.apps.search.InfoSchedule;
import org.compiere.apps.search.VSchedulePanel;
import org.compiere.apps.search.VScheduleTimePanel;
import org.compiere.model.MAssignmentSlot;
import org.compiere.model.ScheduleUtil;
import org.compiere.swing.CPanel;
import org.compiere.util.CLogger;
import org.compiere.util.Env;

public class VSchedule
extends CPanel {
    public static final int TYPE_DAY = 5;
    public static final int TYPE_WEEK = 3;
    public static final int TYPE_MONTH = 2;
    private int m_type = 5;
    private ScheduleUtil m_model = null;
    private Timestamp m_startDate;
    private Timestamp m_endDate;
    private static CLogger log = CLogger.getCLogger(VSchedule.class);
    private BorderLayout mainLayout = new BorderLayout();
    private VScheduleTimePanel timePanel = new VScheduleTimePanel();
    private VSchedulePanel schedulePanel = new VSchedulePanel();
    private JScrollPane schedulePane = new JScrollPane();

    public VSchedule(InfoSchedule is, int type) {
        this.m_type = type;
        this.m_model = new ScheduleUtil(Env.getCtx());
        this.schedulePanel.setType(this.m_type);
        this.schedulePanel.setTimePanel(this.timePanel);
        this.schedulePanel.setInfoSchedule(is);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "VSchedule", e);
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(this.mainLayout);
        this.add((Component)this.timePanel, "West");
        this.schedulePane.setVerticalScrollBarPolicy(21);
        this.schedulePane.getViewport().add((Component)this.schedulePanel, null);
        this.schedulePane.setPreferredSize(new Dimension(200, 200));
        this.schedulePane.setBorder(null);
        this.add((Component)this.schedulePane, "Center");
    }

    public void recreate(int S_Resource_ID, Timestamp date) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        cal.set(10, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        if (this.m_type == 3) {
            cal.set(7, cal.getFirstDayOfWeek());
        } else if (this.m_type == 2) {
            cal.set(5, 1);
        }
        this.m_startDate = new Timestamp(cal.getTimeInMillis());
        cal.add(this.m_type, 1);
        this.m_endDate = new Timestamp(cal.getTimeInMillis());
        log.config("(" + this.m_type + ") Resource_ID=" + S_Resource_ID + ": " + this.m_startDate + "->" + this.m_endDate);
        MAssignmentSlot[] mas = this.m_model.getAssignmentSlots(S_Resource_ID, this.m_startDate, this.m_endDate, null, true, null);
        MAssignmentSlot[] mts = this.m_model.getDayTimeSlots();
        this.timePanel.setTimeSlots(mts);
        this.schedulePanel.setAssignmentSlots(mas, S_Resource_ID, this.m_startDate, this.m_endDate);
        this.schedulePanel.setHeight(this.timePanel.getPreferredSize().height);
    }

    public void setCreateNew(boolean createNew) {
        this.schedulePanel.setCreateNew(createNew);
    }

    public void dispose() {
        this.m_model = null;
        this.timePanel = null;
        if (this.schedulePanel != null) {
            this.schedulePanel.dispose();
        }
        this.schedulePanel = null;
        this.removeAll();
    }

    public Timestamp getStartDate() {
        return this.m_startDate;
    }
}

