/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps.search;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.logging.Level;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import org.compiere.apps.AEnv;
import org.compiere.apps.ConfirmPanel;
import org.compiere.minigrid.ColumnInfo;
import org.compiere.minigrid.IDColumn;
import org.compiere.minigrid.MiniTable;
import org.compiere.swing.CCheckBox;
import org.compiere.swing.CDialog;
import org.compiere.swing.CPanel;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;

public class PAttributeInstance
extends CDialog
implements ListSelectionListener {
    private CPanel mainPanel = new CPanel();
    private BorderLayout mainLayout = new BorderLayout();
    private CPanel northPanel = new CPanel();
    private BorderLayout northLayout = new BorderLayout();
    private JScrollPane centerScrollPane = new JScrollPane();
    private ConfirmPanel confirmPanel = new ConfirmPanel(true);
    private CCheckBox showAll = new CCheckBox(Msg.getMsg(Env.getCtx(), "ShowAll"));
    private MiniTable m_table = new MiniTable();
    private DefaultTableModel m_model;
    private int m_M_Warehouse_ID;
    private int m_M_Locator_ID;
    private int m_M_Product_ID;
    private int m_M_AttributeSetInstance_ID = -1;
    private String m_M_AttributeSetInstanceName = null;
    private String m_sql;
    private static CLogger log = CLogger.getCLogger(PAttributeInstance.class);
    private static ColumnInfo[] s_layout = new ColumnInfo[]{new ColumnInfo(" ", "s.M_AttributeSetInstance_ID", IDColumn.class), new ColumnInfo(Msg.translate(Env.getCtx(), "Description"), "asi.Description", String.class), new ColumnInfo(Msg.translate(Env.getCtx(), "Lot"), "asi.Lot", String.class), new ColumnInfo(Msg.translate(Env.getCtx(), "SerNo"), "asi.SerNo", String.class), new ColumnInfo(Msg.translate(Env.getCtx(), "GuaranteeDate"), "asi.GuaranteeDate", Timestamp.class), new ColumnInfo(Msg.translate(Env.getCtx(), "M_Locator_ID"), "l.Value", KeyNamePair.class, "s.M_Locator_ID"), new ColumnInfo(Msg.translate(Env.getCtx(), "QtyOnHand"), "s.QtyOnHand", Double.class), new ColumnInfo(Msg.translate(Env.getCtx(), "QtyReserved"), "s.QtyReserved", Double.class), new ColumnInfo(Msg.translate(Env.getCtx(), "QtyOrdered"), "s.QtyOrdered", Double.class), new ColumnInfo(Msg.translate(Env.getCtx(), "GoodForDays"), "(TRUNC(asi.GuaranteeDate)-TRUNC(SysDate))-p.GuaranteeDaysMin", Integer.class, true, true, null), new ColumnInfo(Msg.translate(Env.getCtx(), "ShelfLifeDays"), "TRUNC(asi.GuaranteeDate)-TRUNC(SysDate)", Integer.class), new ColumnInfo(Msg.translate(Env.getCtx(), "ShelfLifeRemainingPct"), "CASE WHEN p.GuaranteeDays > 0 THEN TRUNC(((TRUNC(asi.GuaranteeDate)-TRUNC(SysDate))/p.GuaranteeDays)*100) ELSE 0 END", Integer.class)};
    private static String s_sqlFrom = "M_Storage s INNER JOIN M_Locator l ON (s.M_Locator_ID=l.M_Locator_ID) INNER JOIN M_Product p ON (s.M_Product_ID=p.M_Product_ID) LEFT OUTER JOIN M_AttributeSetInstance asi ON (s.M_AttributeSetInstance_ID=asi.M_AttributeSetInstance_ID)";
    private static String s_sqlWhere = "l.M_Warehouse_ID=? AND s.M_Product_ID=?";
    private String m_sqlNonZero = " AND (s.QtyOnHand<>0 OR s.QtyReserved<>0 OR s.QtyOrdered<>0)";
    private String m_sqlMinLife = "";

    public PAttributeInstance(JFrame parent, String title, int M_Warehouse_ID, int M_Locator_ID, int M_Product_ID, int C_BPartner_ID) {
        super(parent, Msg.getMsg(Env.getCtx(), "PAttributeInstance") + title, true);
        this.init(M_Warehouse_ID, M_Locator_ID, M_Product_ID, C_BPartner_ID);
        AEnv.showCenterWindow(parent, this);
    }

    public PAttributeInstance(JDialog parent, String title, int M_Warehouse_ID, int M_Locator_ID, int M_Product_ID, int C_BPartner_ID) {
        super(parent, Msg.getMsg(Env.getCtx(), "PAttributeInstance") + title, true);
        this.init(M_Warehouse_ID, M_Locator_ID, M_Product_ID, C_BPartner_ID);
        AEnv.showCenterWindow(parent, this);
    }

    private void init(int M_Warehouse_ID, int M_Locator_ID, int M_Product_ID, int C_BPartner_ID) {
        log.info("M_Warehouse_ID=" + M_Warehouse_ID + ", M_Locator_ID=" + M_Locator_ID + ", M_Product_ID=" + M_Product_ID);
        this.m_M_Warehouse_ID = M_Warehouse_ID;
        this.m_M_Locator_ID = M_Locator_ID;
        this.m_M_Product_ID = M_Product_ID;
        try {
            this.jbInit();
            this.dynInit(C_BPartner_ID);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "", e);
        }
    }

    private void jbInit() throws Exception {
        this.mainPanel.setLayout(this.mainLayout);
        this.getContentPane().add((Component)this.mainPanel, "Center");
        this.northPanel.setLayout(this.northLayout);
        this.northPanel.add((Component)this.showAll, "East");
        this.showAll.addActionListener(this);
        this.mainPanel.add((Component)this.northPanel, "North");
        this.mainPanel.add((Component)this.centerScrollPane, "Center");
        this.centerScrollPane.getViewport().add((Component)this.m_table, null);
        this.mainPanel.add((Component)this.confirmPanel, "South");
        this.confirmPanel.addActionListener(this);
    }

    private void dynInit(int C_BPartner_ID) {
        log.config("C_BPartner_ID=" + C_BPartner_ID);
        if (C_BPartner_ID != 0) {
            int ShelfLifeMinPct = 0;
            int ShelfLifeMinDays = 0;
            String sql = "SELECT bp.ShelfLifeMinPct, bpp.ShelfLifeMinPct, bpp.ShelfLifeMinDays FROM C_BPartner bp  LEFT OUTER JOIN C_BPartner_Product bpp ON (bp.C_BPartner_ID=bpp.C_BPartner_ID AND bpp.M_Product_ID=?) WHERE bp.C_BPartner_ID=?";
            CPreparedStatement pstmt = null;
            try {
                pstmt = DB.prepareStatement(sql, null);
                pstmt.setInt(1, this.m_M_Product_ID);
                pstmt.setInt(2, C_BPartner_ID);
                ResultSet rs = pstmt.executeQuery();
                if (rs.next()) {
                    ShelfLifeMinPct = rs.getInt(1);
                    int pct = rs.getInt(2);
                    if (pct > 0) {
                        ShelfLifeMinDays = pct;
                    }
                    ShelfLifeMinDays = rs.getInt(3);
                }
                rs.close();
                pstmt.close();
                pstmt = null;
            }
            catch (Exception e) {
                log.log(Level.SEVERE, sql, e);
            }
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
                pstmt = null;
            }
            catch (Exception e) {
                pstmt = null;
            }
            if (ShelfLifeMinPct > 0) {
                this.m_sqlMinLife = " AND COALESCE(TRUNC(((TRUNC(asi.GuaranteeDate)-TRUNC(SysDate))/p.GuaranteeDays)*100),0)>=" + ShelfLifeMinPct;
                log.config("PAttributeInstance.dynInit - ShelfLifeMinPct=" + ShelfLifeMinPct);
            }
            if (ShelfLifeMinDays > 0) {
                this.m_sqlMinLife = this.m_sqlMinLife + " AND COALESCE((TRUNC(asi.GuaranteeDate)-TRUNC(SysDate)),0)>=" + ShelfLifeMinDays;
                log.config("PAttributeInstance.dynInit - ShelfLifeMinDays=" + ShelfLifeMinDays);
            }
        }
        this.m_sql = this.m_table.prepareTable(s_layout, s_sqlFrom, s_sqlWhere, false, "s") + " ORDER BY asi.GuaranteeDate, s.QtyOnHand";
        this.m_table.setRowSelectionAllowed(true);
        this.m_table.setMultiSelection(false);
        this.m_table.addMouseListener(this);
        this.m_table.getSelectionModel().addListSelectionListener(this);
        this.refresh();
    }

    private void refresh() {
        String sql = this.m_sql;
        int pos = this.m_sql.lastIndexOf(" ORDER BY ");
        if (!this.showAll.isSelected()) {
            sql = this.m_sql.substring(0, pos) + this.m_sqlNonZero;
            if (this.m_sqlMinLife.length() > 0) {
                sql = sql + this.m_sqlMinLife;
            }
            sql = sql + this.m_sql.substring(pos);
        }
        log.finest(sql);
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, this.m_M_Warehouse_ID);
            pstmt.setInt(2, this.m_M_Product_ID);
            ResultSet rs = pstmt.executeQuery();
            this.m_table.loadTable(rs);
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        this.enableButtons();
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("Ok")) {
            this.dispose();
        } else if (e.getActionCommand().equals("Cancel")) {
            this.dispose();
            this.m_M_AttributeSetInstance_ID = -1;
            this.m_M_AttributeSetInstanceName = null;
        } else if (e.getSource() == this.showAll) {
            this.refresh();
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        this.enableButtons();
    }

    private void enableButtons() {
        Integer ID;
        boolean enabled;
        this.m_M_AttributeSetInstance_ID = -1;
        this.m_M_AttributeSetInstanceName = null;
        this.m_M_Locator_ID = 0;
        int row = this.m_table.getSelectedRow();
        boolean bl = enabled = row != -1;
        if (enabled && (ID = this.m_table.getSelectedRowKey()) != null) {
            this.m_M_AttributeSetInstance_ID = ID;
            this.m_M_AttributeSetInstanceName = (String)this.m_table.getValueAt(row, 1);
            Object oo = this.m_table.getValueAt(row, 5);
            if (oo instanceof KeyNamePair) {
                KeyNamePair pp = (KeyNamePair)oo;
                this.m_M_Locator_ID = pp.getKey();
            }
        }
        this.confirmPanel.getOKButton().setEnabled(enabled);
        log.fine("M_AttributeSetInstance_ID=" + this.m_M_AttributeSetInstance_ID + " - " + this.m_M_AttributeSetInstanceName + "; M_Locator_ID=" + this.m_M_Locator_ID);
    }

    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() > 1 && this.m_table.getSelectedRow() != -1) {
            this.enableButtons();
            this.dispose();
        }
    }

    public int getM_AttributeSetInstance_ID() {
        return this.m_M_AttributeSetInstance_ID;
    }

    public String getM_AttributeSetInstanceName() {
        return this.m_M_AttributeSetInstanceName;
    }

    public int getM_Locator_ID() {
        return this.m_M_Locator_ID;
    }
}

