/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps.search;

import java.awt.Component;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.logging.Level;
import org.adempiere.plaf.AdempierePLAF;
import org.compiere.apps.AEnv;
import org.compiere.apps.ALayout;
import org.compiere.apps.ALayoutConstraint;
import org.compiere.apps.ConfirmPanel;
import org.compiere.apps.search.Info;
import org.compiere.apps.search.InfoPAttribute;
import org.compiere.apps.search.Info_Column;
import org.compiere.apps.search.InvoiceHistory;
import org.compiere.apps.search.PAttributeInstance;
import org.compiere.grid.ed.VComboBox;
import org.compiere.minigrid.IDColumn;
import org.compiere.model.MClient;
import org.compiere.model.MQuery;
import org.compiere.model.MRole;
import org.compiere.swing.CButton;
import org.compiere.swing.CLabel;
import org.compiere.swing.CTextField;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public final class InfoProduct
extends Info
implements ActionListener {
    private static final String s_productFrom = "M_Product p LEFT OUTER JOIN M_ProductPrice pr ON (p.M_Product_ID=pr.M_Product_ID AND pr.IsActive='Y') LEFT OUTER JOIN M_AttributeSet pa ON (p.M_AttributeSet_ID=pa.M_AttributeSet_ID)";
    private static Info_Column[] s_productLayout = null;
    private static int INDEX_NAME = 0;
    private static int INDEX_PATTRIBUTE = 0;
    private CLabel labelValue = new CLabel();
    private CTextField fieldValue = new CTextField(10);
    private CLabel labelName = new CLabel();
    private CTextField fieldName = new CTextField(10);
    private CLabel labelUPC = new CLabel();
    private CTextField fieldUPC = new CTextField(10);
    private CLabel labelSKU = new CLabel();
    private CTextField fieldSKU = new CTextField(10);
    private CLabel labelPriceList = new CLabel();
    private VComboBox pickPriceList = new VComboBox();
    private CLabel labelWarehouse = new CLabel();
    private VComboBox pickWarehouse = new VComboBox();
    private CButton m_InfoPAttributeButton = new CButton(Env.getImageIcon("PAttribute16.gif"));
    private CButton m_PAttributeButton = null;
    private int m_M_AttributeSetInstance_ID = -1;
    private int m_M_Locator_ID = 0;
    private String m_pAttributeWhere = null;
    private int m_C_BPartner_ID = 0;

    public InfoProduct(Frame frame, boolean modal, int WindowNo, int M_Warehouse_ID, int M_PriceList_ID, String value, boolean multiSelection, String whereClause) {
        super(frame, modal, WindowNo, "p", "M_Product_ID", multiSelection, whereClause);
        this.log.info(value + ", Wh=" + M_Warehouse_ID + ", PL=" + M_PriceList_ID + ", WHERE=" + whereClause);
        this.setTitle(Msg.getMsg(Env.getCtx(), "InfoProduct"));
        this.statInit();
        this.initInfo(value, M_Warehouse_ID, M_PriceList_ID);
        this.m_C_BPartner_ID = Env.getContextAsInt(Env.getCtx(), WindowNo, "C_BPartner_ID");
        int no = this.p_table.getRowCount();
        this.setStatusLine(Integer.toString(no) + " " + Msg.getMsg(Env.getCtx(), "SearchRows_EnterQuery"), false);
        this.setStatusDB(Integer.toString(no));
        if (value != null && value.length() > 0) {
            this.executeQuery();
        }
        this.p_loadedOK = true;
        this.fieldValue.requestFocus();
        AEnv.positionCenterWindow(frame, this);
    }

    private void statInit() {
        this.labelValue.setText(Msg.getMsg(Env.getCtx(), "Value"));
        this.fieldValue.setBackground(AdempierePLAF.getInfoBackground());
        this.fieldValue.addActionListener(this);
        this.labelName.setText(Msg.getMsg(Env.getCtx(), "Name"));
        this.fieldName.setBackground(AdempierePLAF.getInfoBackground());
        this.fieldName.addActionListener(this);
        this.labelUPC.setText(Msg.translate(Env.getCtx(), "UPC"));
        this.fieldUPC.setBackground(AdempierePLAF.getInfoBackground());
        this.fieldUPC.addActionListener(this);
        this.labelSKU.setText(Msg.translate(Env.getCtx(), "SKU"));
        this.fieldSKU.setBackground(AdempierePLAF.getInfoBackground());
        this.fieldSKU.addActionListener(this);
        this.labelWarehouse.setText(Msg.getMsg(Env.getCtx(), "Warehouse"));
        this.pickWarehouse.setBackground(AdempierePLAF.getInfoBackground());
        this.labelPriceList.setText(Msg.getMsg(Env.getCtx(), "PriceListVersion"));
        this.pickPriceList.setBackground(AdempierePLAF.getInfoBackground());
        this.m_InfoPAttributeButton.setMargin(new Insets(2, 2, 2, 2));
        this.m_InfoPAttributeButton.setToolTipText(Msg.getMsg(Env.getCtx(), "InfoPAttribute"));
        this.m_InfoPAttributeButton.addActionListener(this);
        this.parameterPanel.setLayout(new ALayout());
        this.parameterPanel.add((Component)this.labelValue, new ALayoutConstraint(0, 0));
        this.parameterPanel.add((Component)this.fieldValue, null);
        this.parameterPanel.add((Component)this.labelUPC, null);
        this.parameterPanel.add((Component)this.fieldUPC, null);
        this.parameterPanel.add((Component)this.labelWarehouse, null);
        this.parameterPanel.add((Component)this.pickWarehouse, null);
        this.parameterPanel.add(this.m_InfoPAttributeButton);
        this.parameterPanel.add((Component)this.labelName, new ALayoutConstraint(1, 0));
        this.parameterPanel.add((Component)this.fieldName, null);
        this.parameterPanel.add((Component)this.labelSKU, null);
        this.parameterPanel.add((Component)this.fieldSKU, null);
        this.parameterPanel.add((Component)this.labelPriceList, null);
        this.parameterPanel.add((Component)this.pickPriceList, null);
        this.m_PAttributeButton = ConfirmPanel.createPAttributeButton(true);
        this.confirmPanel.addButton(this.m_PAttributeButton);
        this.m_PAttributeButton.addActionListener(this);
        this.m_PAttributeButton.setEnabled(false);
    }

    private void initInfo(String value, int M_Warehouse_ID, int M_PriceList_ID) {
        this.fillPicks(M_PriceList_ID);
        int M_PriceList_Version_ID = this.findPLV(M_PriceList_ID);
        if (value.startsWith("@") && value.endsWith("@")) {
            this.fieldName.setText(value.substring(1, value.length() - 1));
        } else {
            this.fieldValue.setText(value);
        }
        if (M_Warehouse_ID == 0) {
            M_Warehouse_ID = Env.getContextAsInt(Env.getCtx(), "#M_Warehouse_ID");
        }
        if (M_Warehouse_ID != 0) {
            this.setWarehouse(M_Warehouse_ID);
        }
        if (M_PriceList_Version_ID != 0) {
            this.setPriceListVersion(M_PriceList_Version_ID);
        }
        StringBuffer where = new StringBuffer();
        where.append("p.IsActive='Y'");
        if (M_Warehouse_ID != 0) {
            where.append(" AND p.IsSummary='N'");
        }
        if (this.p_whereClause != null && this.p_whereClause.length() > 0) {
            where.append(" AND ").append(Util.replace(this.p_whereClause, "M_Product.", "p."));
        }
        this.prepareTable(this.getProductLayout(), s_productFrom, where.toString(), "QtyAvailable DESC, Margin DESC");
        this.pickWarehouse.addActionListener(this);
        this.pickPriceList.addActionListener(this);
    }

    private void fillPicks(int M_PriceList_ID) {
        String SQL = "SELECT M_PriceList_Version.M_PriceList_Version_ID, M_PriceList_Version.Name || ' (' || c.Iso_Code || ')' AS ValueName FROM M_PriceList_Version, M_PriceList pl, C_Currency c WHERE M_PriceList_Version.M_PriceList_ID=pl.M_PriceList_ID AND pl.C_Currency_ID=c.C_Currency_ID AND M_PriceList_Version.IsActive='Y' AND pl.IsActive='Y'";
        if (M_PriceList_ID != 0) {
            SQL = SQL + " AND EXISTS (SELECT * FROM M_PriceList xp WHERE xp.M_PriceList_ID=" + M_PriceList_ID + " AND pl.C_Currency_ID=xp.C_Currency_ID)";
        }
        SQL = MRole.getDefault().addAccessSQL(SQL, "M_PriceList_Version", true, false) + " ORDER BY M_PriceList_Version.Name";
        try {
            KeyNamePair kn;
            this.pickPriceList.addItem(new KeyNamePair(0, ""));
            CPreparedStatement pstmt = DB.prepareStatement(SQL, null);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                kn = new KeyNamePair(rs.getInt(1), rs.getString(2));
                this.pickPriceList.addItem(kn);
            }
            rs.close();
            pstmt.close();
            SQL = MRole.getDefault().addAccessSQL("SELECT M_Warehouse_ID, Value || ' - ' || Name AS ValueName FROM M_Warehouse WHERE IsActive='Y'", "M_Warehouse", false, false) + " ORDER BY Value";
            this.pickWarehouse.addItem(new KeyNamePair(0, ""));
            pstmt = DB.prepareStatement(SQL, null);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                kn = new KeyNamePair(rs.getInt("M_Warehouse_ID"), rs.getString("ValueName"));
                this.pickWarehouse.addItem(kn);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, SQL, e);
            this.setStatusLine(e.getLocalizedMessage(), true);
        }
    }

    private void setWarehouse(int M_Warehouse_ID) {
        for (int i = 0; i < this.pickWarehouse.getItemCount(); ++i) {
            KeyNamePair kn = (KeyNamePair)this.pickWarehouse.getItemAt(i);
            if (kn.getKey() != M_Warehouse_ID) continue;
            this.pickWarehouse.setSelectedIndex(i);
            return;
        }
    }

    private void setPriceListVersion(int M_PriceList_Version_ID) {
        this.log.config("M_PriceList_Version_ID=" + M_PriceList_Version_ID);
        for (int i = 0; i < this.pickPriceList.getItemCount(); ++i) {
            KeyNamePair kn = (KeyNamePair)this.pickPriceList.getItemAt(i);
            if (kn.getKey() != M_PriceList_Version_ID) continue;
            this.pickPriceList.setSelectedIndex(i);
            return;
        }
        this.log.fine("NOT found");
    }

    private int findPLV(int M_PriceList_ID) {
        Timestamp priceDate = null;
        String dateStr = Env.getContext(Env.getCtx(), this.p_WindowNo, "DateOrdered");
        if (dateStr != null && dateStr.length() > 0) {
            priceDate = Env.getContextAsDate(Env.getCtx(), this.p_WindowNo, "DateOrdered");
        } else {
            dateStr = Env.getContext(Env.getCtx(), this.p_WindowNo, "DateInvoiced");
            if (dateStr != null && dateStr.length() > 0) {
                priceDate = Env.getContextAsDate(Env.getCtx(), this.p_WindowNo, "DateInvoiced");
            }
        }
        if (priceDate == null) {
            priceDate = new Timestamp(System.currentTimeMillis());
        }
        this.log.config("M_PriceList_ID=" + M_PriceList_ID + " - " + priceDate);
        int retValue = 0;
        String sql = "SELECT plv.M_PriceList_Version_ID, plv.ValidFrom FROM M_PriceList pl, M_PriceList_Version plv WHERE pl.M_PriceList_ID=plv.M_PriceList_ID AND plv.IsActive='Y' AND pl.M_PriceList_ID=? ORDER BY plv.ValidFrom DESC";
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, M_PriceList_ID);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next() && retValue == 0) {
                Timestamp plDate = rs.getTimestamp(2);
                if (priceDate.before(plDate)) continue;
                retValue = rs.getInt(1);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        Env.setContext(Env.getCtx(), this.p_WindowNo, "M_PriceList_Version_ID", retValue);
        return retValue;
    }

    String getSQLWhere() {
        String sku;
        String upc;
        String name;
        StringBuffer where = new StringBuffer();
        int M_PriceList_Version_ID = 0;
        KeyNamePair pl = (KeyNamePair)this.pickPriceList.getSelectedItem();
        if (pl != null) {
            M_PriceList_Version_ID = pl.getKey();
        }
        if (M_PriceList_Version_ID != 0) {
            where.append(" AND pr.M_PriceList_Version_ID=?");
        }
        if (this.m_pAttributeWhere != null) {
            where.append(this.m_pAttributeWhere);
            return where.toString();
        }
        String value = this.fieldValue.getText().toUpperCase();
        if (!value.equals("") && !value.equals("%")) {
            where.append(" AND UPPER(p.Value) LIKE ?");
        }
        if (!(name = this.fieldName.getText().toUpperCase()).equals("") && !name.equals("%")) {
            where.append(" AND UPPER(p.Name) LIKE ?");
        }
        if (!(upc = this.fieldUPC.getText().toUpperCase()).equals("") && !upc.equals("%")) {
            where.append(" AND UPPER(p.UPC) LIKE ?");
        }
        if (!(sku = this.fieldSKU.getText().toUpperCase()).equals("") && !sku.equals("%")) {
            where.append(" AND UPPER(p.SKU) LIKE ?");
        }
        return where.toString();
    }

    void setParameters(PreparedStatement pstmt, boolean forCount) throws SQLException {
        String sku;
        String upc;
        String name;
        int index = 1;
        int M_Warehouse_ID = 0;
        KeyNamePair wh = (KeyNamePair)this.pickWarehouse.getSelectedItem();
        if (wh != null) {
            M_Warehouse_ID = wh.getKey();
        }
        if (!forCount) {
            for (int i = 0; i < this.p_layout.length; ++i) {
                if (this.p_layout[i].getColSQL().indexOf("?") == -1) continue;
                pstmt.setInt(index++, M_Warehouse_ID);
            }
        }
        this.log.fine("M_Warehouse_ID=" + M_Warehouse_ID + " (" + (index - 1) + "*)");
        int M_PriceList_Version_ID = 0;
        KeyNamePair pl = (KeyNamePair)this.pickPriceList.getSelectedItem();
        if (pl != null) {
            M_PriceList_Version_ID = pl.getKey();
        }
        if (M_PriceList_Version_ID != 0) {
            pstmt.setInt(index++, M_PriceList_Version_ID);
            this.log.fine("M_PriceList_Version_ID=" + M_PriceList_Version_ID);
        }
        if (this.m_pAttributeWhere != null) {
            return;
        }
        String value = this.fieldValue.getText().toUpperCase();
        if (!value.equals("") && !value.equals("%")) {
            if (!value.endsWith("%")) {
                value = value + "%";
            }
            pstmt.setString(index++, value);
            this.log.fine("Value: " + value);
        }
        if (!(name = this.fieldName.getText().toUpperCase()).equals("") && !name.equals("%")) {
            if (!name.endsWith("%")) {
                name = name + "%";
            }
            pstmt.setString(index++, name);
            this.log.fine("Name: " + name);
        }
        if (!(upc = this.fieldUPC.getText().toUpperCase()).equals("") && !upc.equals("%")) {
            if (!upc.endsWith("%")) {
                upc = upc + "%";
            }
            pstmt.setString(index++, upc);
            this.log.fine("UPC: " + upc);
        }
        if (!(sku = this.fieldSKU.getText().toUpperCase()).equals("") && !sku.equals("%")) {
            if (!sku.endsWith("%")) {
                sku = sku + "%";
            }
            pstmt.setString(index++, sku);
            this.log.fine("SKU: " + sku);
        }
    }

    public void actionPerformed(ActionEvent e) {
        if ((e.getSource() == this.pickWarehouse || e.getSource() == this.pickPriceList) && this.fieldValue.getText().length() == 0 && this.fieldName.getText().length() == 0) {
            return;
        }
        if (e.getSource().equals(this.m_InfoPAttributeButton)) {
            this.cmd_InfoPAttribute();
            return;
        }
        this.m_pAttributeWhere = null;
        int row = this.p_table.getSelectedRow();
        if (e.getSource().equals(this.m_PAttributeButton) && row != -1) {
            Integer productInteger = this.getSelectedRowKey();
            String productName = (String)this.p_table.getValueAt(row, INDEX_NAME);
            KeyNamePair warehouse = (KeyNamePair)this.pickWarehouse.getSelectedItem();
            if (productInteger == null || productInteger == 0 || warehouse == null) {
                return;
            }
            String title = warehouse.getName() + " - " + productName;
            PAttributeInstance pai = new PAttributeInstance(this, title, warehouse.getKey(), 0, (int)productInteger, this.m_C_BPartner_ID);
            this.m_M_AttributeSetInstance_ID = pai.getM_AttributeSetInstance_ID();
            this.m_M_Locator_ID = pai.getM_Locator_ID();
            if (this.m_M_AttributeSetInstance_ID != -1) {
                this.dispose(true);
            }
            return;
        }
        super.actionPerformed(e);
    }

    void enableButtons() {
        this.m_M_AttributeSetInstance_ID = -1;
        if (this.m_PAttributeButton != null) {
            int row = this.p_table.getSelectedRow();
            boolean enabled = false;
            if (row >= 0) {
                Object value = this.p_table.getValueAt(row, INDEX_PATTRIBUTE);
                enabled = Boolean.TRUE.equals(value);
            }
            this.m_PAttributeButton.setEnabled(enabled);
        }
        super.enableButtons();
    }

    private void cmd_InfoPAttribute() {
        InfoPAttribute ia = new InfoPAttribute(this);
        this.m_pAttributeWhere = ia.getWhereClause();
        if (this.m_pAttributeWhere != null) {
            this.executeQuery();
        }
    }

    void showHistory() {
        this.log.info("");
        Integer M_Product_ID = this.getSelectedRowKey();
        if (M_Product_ID == null) {
            return;
        }
        KeyNamePair kn = (KeyNamePair)this.pickWarehouse.getSelectedItem();
        int M_Warehouse_ID = kn.getKey();
        int M_AttributeSetInstance_ID = this.m_M_AttributeSetInstance_ID;
        if (this.m_M_AttributeSetInstance_ID < -1) {
            M_AttributeSetInstance_ID = 0;
        }
        InvoiceHistory ih = new InvoiceHistory(this, 0, M_Product_ID, M_Warehouse_ID, M_AttributeSetInstance_ID);
        ih.setVisible(true);
        ih = null;
    }

    boolean hasHistory() {
        return true;
    }

    void zoom() {
        this.log.info("");
        Integer M_Product_ID = this.getSelectedRowKey();
        if (M_Product_ID == null) {
            return;
        }
        MQuery query = new MQuery("M_Product");
        query.addRestriction("M_Product_ID", "=", M_Product_ID);
        query.setRecordCount(1);
        int AD_WindowNo = this.getAD_Window_ID("M_Product", true);
        this.zoom(AD_WindowNo, query);
    }

    boolean hasZoom() {
        return true;
    }

    void customize() {
        this.log.info("");
    }

    boolean hasCustomize() {
        return false;
    }

    void saveSelectionDetail() {
        Integer ID = this.getSelectedRowKey();
        Env.setContext(Env.getCtx(), 1113, 1113, "M_Product_ID", ID == null ? "0" : ID.toString());
        KeyNamePair kn = (KeyNamePair)this.pickPriceList.getSelectedItem();
        Env.setContext(Env.getCtx(), 1113, 1113, "M_PriceList_Version_ID", kn.getID());
        kn = (KeyNamePair)this.pickWarehouse.getSelectedItem();
        Env.setContext(Env.getCtx(), 1113, 1113, "M_Warehouse_ID", kn.getID());
        if (this.m_M_AttributeSetInstance_ID == -1) {
            Env.setContext(Env.getCtx(), 1113, 1113, "M_AttributeSetInstance_ID", "0");
            Env.setContext(Env.getCtx(), 1113, 1113, "M_Locator_ID", "0");
        } else {
            Env.setContext(Env.getCtx(), 1113, 1113, "M_AttributeSetInstance_ID", String.valueOf(this.m_M_AttributeSetInstance_ID));
            Env.setContext(Env.getCtx(), 1113, 1113, "M_Locator_ID", String.valueOf(this.m_M_Locator_ID));
        }
    }

    private Info_Column[] getProductLayout() {
        if (s_productLayout != null) {
            return s_productLayout;
        }
        MClient client = MClient.get(Env.getCtx());
        if ("FRIE".equals(client.getValue())) {
            Info_Column[] frieLayout = new Info_Column[]{new Info_Column(" ", "p.M_Product_ID", IDColumn.class), new Info_Column(Msg.translate(Env.getCtx(), "Name"), "p.Name", String.class), new Info_Column(Msg.translate(Env.getCtx(), "QtyAvailable"), "bomQtyAvailable(p.M_Product_ID,?,0) AS QtyAvailable", Double.class, true, true, null), new Info_Column(Msg.translate(Env.getCtx(), "PriceList"), "bomPriceList(p.M_Product_ID, pr.M_PriceList_Version_ID) AS PriceList", BigDecimal.class), new Info_Column(Msg.translate(Env.getCtx(), "PriceStd"), "bomPriceStd(p.M_Product_ID, pr.M_PriceList_Version_ID) AS PriceStd", BigDecimal.class), new Info_Column("Einzel MWSt", "pr.PriceStd * 1.16", BigDecimal.class), new Info_Column("Einzel kompl", "(pr.PriceStd+13) * 1.16", BigDecimal.class), new Info_Column("Satz kompl", "((pr.PriceStd+13) * 1.16) * 4", BigDecimal.class), new Info_Column(Msg.translate(Env.getCtx(), "QtyOnHand"), "bomQtyOnHand(p.M_Product_ID,?,0) AS QtyOnHand", Double.class), new Info_Column(Msg.translate(Env.getCtx(), "QtyReserved"), "bomQtyReserved(p.M_Product_ID,?,0) AS QtyReserved", Double.class), new Info_Column(Msg.translate(Env.getCtx(), "QtyOrdered"), "bomQtyOrdered(p.M_Product_ID,?,0) AS QtyOrdered", Double.class), new Info_Column(Msg.translate(Env.getCtx(), "Discontinued").substring(0, 1), "p.Discontinued", Boolean.class), new Info_Column(Msg.translate(Env.getCtx(), "Margin"), "bomPriceStd(p.M_Product_ID, pr.M_PriceList_Version_ID)-bomPriceLimit(p.M_Product_ID, pr.M_PriceList_Version_ID) AS Margin", BigDecimal.class), new Info_Column(Msg.translate(Env.getCtx(), "PriceLimit"), "bomPriceLimit(p.M_Product_ID, pr.M_PriceList_Version_ID) AS PriceLimit", BigDecimal.class), new Info_Column(Msg.translate(Env.getCtx(), "IsInstanceAttribute"), "pa.IsInstanceAttribute", Boolean.class)};
            INDEX_NAME = 2;
            INDEX_PATTRIBUTE = frieLayout.length - 1;
            s_productLayout = frieLayout;
            return s_productLayout;
        }
        if (s_productLayout == null) {
            ArrayList<Info_Column> list = new ArrayList<Info_Column>();
            list.add(new Info_Column(" ", "p.M_Product_ID", IDColumn.class));
            list.add(new Info_Column(Msg.translate(Env.getCtx(), "Discontinued").substring(0, 1), "p.Discontinued", Boolean.class));
            list.add(new Info_Column(Msg.translate(Env.getCtx(), "Value"), "p.Value", String.class));
            list.add(new Info_Column(Msg.translate(Env.getCtx(), "Name"), "p.Name", String.class));
            list.add(new Info_Column(Msg.translate(Env.getCtx(), "QtyAvailable"), "bomQtyAvailable(p.M_Product_ID,?,0) AS QtyAvailable", Double.class, true, true, null));
            list.add(new Info_Column(Msg.translate(Env.getCtx(), "PriceList"), "bomPriceList(p.M_Product_ID, pr.M_PriceList_Version_ID) AS PriceList", BigDecimal.class));
            list.add(new Info_Column(Msg.translate(Env.getCtx(), "PriceStd"), "bomPriceStd(p.M_Product_ID, pr.M_PriceList_Version_ID) AS PriceStd", BigDecimal.class));
            list.add(new Info_Column(Msg.translate(Env.getCtx(), "QtyOnHand"), "bomQtyOnHand(p.M_Product_ID,?,0) AS QtyOnHand", Double.class));
            list.add(new Info_Column(Msg.translate(Env.getCtx(), "QtyReserved"), "bomQtyReserved(p.M_Product_ID,?,0) AS QtyReserved", Double.class));
            list.add(new Info_Column(Msg.translate(Env.getCtx(), "QtyOrdered"), "bomQtyOrdered(p.M_Product_ID,?,0) AS QtyOrdered", Double.class));
            if (this.isUnconfirmed()) {
                list.add(new Info_Column(Msg.translate(Env.getCtx(), "QtyUnconfirmed"), "(SELECT SUM(c.TargetQty) FROM M_InOutLineConfirm c INNER JOIN M_InOutLine il ON (c.M_InOutLine_ID=il.M_InOutLine_ID) INNER JOIN M_InOut i ON (il.M_InOut_ID=i.M_InOut_ID) WHERE c.Processed='N' AND i.M_Warehouse_ID=? AND il.M_Product_ID=p.M_Product_ID) AS QtyUnconfirmed", Double.class));
                list.add(new Info_Column(Msg.translate(Env.getCtx(), "QtyUnconfirmedMove"), "(SELECT SUM(c.TargetQty) FROM M_MovementLineConfirm c INNER JOIN M_MovementLine ml ON (c.M_MovementLine_ID=ml.M_MovementLine_ID) INNER JOIN M_Locator l ON (ml.M_LocatorTo_ID=l.M_Locator_ID) WHERE c.Processed='N' AND l.M_Warehouse_ID=? AND ml.M_Product_ID=p.M_Product_ID) AS QtyUnconfirmedMove", Double.class));
            }
            list.add(new Info_Column(Msg.translate(Env.getCtx(), "Margin"), "bomPriceStd(p.M_Product_ID, pr.M_PriceList_Version_ID)-bomPriceLimit(p.M_Product_ID, pr.M_PriceList_Version_ID) AS Margin", BigDecimal.class));
            list.add(new Info_Column(Msg.translate(Env.getCtx(), "PriceLimit"), "bomPriceLimit(p.M_Product_ID, pr.M_PriceList_Version_ID) AS PriceLimit", BigDecimal.class));
            list.add(new Info_Column(Msg.translate(Env.getCtx(), "IsInstanceAttribute"), "pa.IsInstanceAttribute", Boolean.class));
            s_productLayout = new Info_Column[list.size()];
            list.toArray(s_productLayout);
            INDEX_NAME = 3;
            INDEX_PATTRIBUTE = s_productLayout.length - 1;
        }
        return s_productLayout;
    }

    private boolean isUnconfirmed() {
        int no = DB.getSQLValue(null, "SELECT COUNT(*) FROM M_InOutLineConfirm WHERE AD_Client_ID=?", Env.getAD_Client_ID(Env.getCtx()));
        if (no > 0) {
            return true;
        }
        no = DB.getSQLValue(null, "SELECT COUNT(*) FROM M_MovementLineConfirm WHERE AD_Client_ID=?", Env.getAD_Client_ID(Env.getCtx()));
        return no > 0;
    }
}

