/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps.search;

import java.awt.Component;
import java.awt.Frame;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import org.adempiere.plaf.AdempierePLAF;
import org.compiere.apps.ALayout;
import org.compiere.apps.ALayoutConstraint;
import org.compiere.apps.search.Info;
import org.compiere.apps.search.Info_Column;
import org.compiere.grid.ed.VCheckBox;
import org.compiere.grid.ed.VDate;
import org.compiere.grid.ed.VLookup;
import org.compiere.minigrid.IDColumn;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MQuery;
import org.compiere.swing.CLabel;
import org.compiere.swing.CTextField;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public class InfoInOut
extends Info {
    private Info_Column[] m_generalLayout;
    private ArrayList m_queryColumns = new ArrayList();
    private String m_tableName;
    private String m_keyColumn;
    private CLabel lDocumentNo = new CLabel(Msg.translate(Env.getCtx(), "DocumentNo"));
    private CTextField fDocumentNo = new CTextField(10);
    private CLabel lDescription = new CLabel(Msg.translate(Env.getCtx(), "Description"));
    private CTextField fDescription = new CTextField(10);
    private CLabel lPOReference = new CLabel(Msg.translate(Env.getCtx(), "POReference"));
    private CTextField fPOReference = new CTextField(10);
    private CLabel lBPartner_ID = new CLabel(Msg.translate(Env.getCtx(), "BPartner"));
    private VLookup fBPartner_ID;
    private CLabel lDateFrom = new CLabel(Msg.translate(Env.getCtx(), "MovementDate"));
    private VDate fDateFrom = new VDate("DateFrom", false, false, true, 15, Msg.translate(Env.getCtx(), "DateFrom"));
    private CLabel lDateTo = new CLabel("-");
    private VDate fDateTo = new VDate("DateTo", false, false, true, 15, Msg.translate(Env.getCtx(), "DateTo"));
    private VCheckBox fIsSOTrx = new VCheckBox("IsSOTrx", false, false, true, Msg.translate(Env.getCtx(), "IsSOTrx"), "", false);
    private static final Info_Column[] s_invoiceLayout = new Info_Column[]{new Info_Column(" ", "i.M_InOut_ID", IDColumn.class), new Info_Column(Msg.translate(Env.getCtx(), "C_BPartner_ID"), "(SELECT Name FROM C_BPartner bp WHERE bp.C_BPartner_ID=i.C_BPartner_ID)", String.class), new Info_Column(Msg.translate(Env.getCtx(), "MovementDate"), "i.MovementDate", Timestamp.class), new Info_Column(Msg.translate(Env.getCtx(), "DocumentNo"), "i.DocumentNo", String.class), new Info_Column(Msg.translate(Env.getCtx(), "Description"), "i.Description", String.class), new Info_Column(Msg.translate(Env.getCtx(), "POReference"), "i.POReference", String.class), new Info_Column(Msg.translate(Env.getCtx(), "IsSOTrx"), "i.IsSOTrx", Boolean.class)};

    protected InfoInOut(Frame frame, boolean modal, int WindowNo, String value, boolean multiSelection, String whereClause) {
        super(frame, modal, WindowNo, "i", "M_InOut_ID", multiSelection, whereClause);
        this.log.info("InfoInOut");
        this.setTitle(Msg.getMsg(Env.getCtx(), "InfoInOut"));
        try {
            this.statInit();
            this.p_loadedOK = this.initInfo();
        }
        catch (Exception e) {
            return;
        }
        int no = this.p_table.getRowCount();
        this.setStatusLine(Integer.toString(no) + " " + Msg.getMsg(Env.getCtx(), "SearchRows_EnterQuery"), false);
        this.setStatusDB(Integer.toString(no));
        if (value != null && value.length() > 0) {
            this.fDocumentNo.setValue(value);
            this.executeQuery();
        }
        this.pack();
        this.fDocumentNo.requestFocus();
    }

    private void statInit() throws Exception {
        this.lDocumentNo.setLabelFor(this.fDocumentNo);
        this.fDocumentNo.setBackground(AdempierePLAF.getInfoBackground());
        this.fDocumentNo.addActionListener(this);
        this.lDescription.setLabelFor(this.fDescription);
        this.fDescription.setBackground(AdempierePLAF.getInfoBackground());
        this.fDescription.addActionListener(this);
        this.lPOReference.setLabelFor(this.lPOReference);
        this.fPOReference.setBackground(AdempierePLAF.getInfoBackground());
        this.fPOReference.addActionListener(this);
        this.fIsSOTrx.setSelected(!"N".equals(Env.getContext(Env.getCtx(), this.p_WindowNo, "IsSOTrx")));
        this.fIsSOTrx.addActionListener(this);
        this.fBPartner_ID = new VLookup("C_BPartner_ID", false, false, true, MLookupFactory.get(Env.getCtx(), this.p_WindowNo, 0, 3499, 30));
        this.lBPartner_ID.setLabelFor(this.fBPartner_ID);
        this.fBPartner_ID.setBackground(AdempierePLAF.getInfoBackground());
        this.lDateFrom.setLabelFor(this.fDateFrom);
        this.fDateFrom.setBackground(AdempierePLAF.getInfoBackground());
        this.fDateFrom.setToolTipText(Msg.translate(Env.getCtx(), "DateFrom"));
        this.lDateTo.setLabelFor(this.fDateTo);
        this.fDateTo.setBackground(AdempierePLAF.getInfoBackground());
        this.fDateTo.setToolTipText(Msg.translate(Env.getCtx(), "DateTo"));
        this.parameterPanel.setLayout(new ALayout());
        this.parameterPanel.add((Component)this.lDocumentNo, new ALayoutConstraint(0, 0));
        this.parameterPanel.add((Component)this.fDocumentNo, null);
        this.parameterPanel.add((Component)this.lBPartner_ID, null);
        this.parameterPanel.add((Component)this.fBPartner_ID, null);
        this.parameterPanel.add((Component)this.fIsSOTrx, new ALayoutConstraint(0, 5));
        this.parameterPanel.add((Component)this.lDescription, new ALayoutConstraint(1, 0));
        this.parameterPanel.add((Component)this.fDescription, null);
        this.parameterPanel.add((Component)this.lDateFrom, null);
        this.parameterPanel.add((Component)this.fDateFrom, null);
        this.parameterPanel.add((Component)this.lDateTo, null);
        this.parameterPanel.add((Component)this.fDateTo, null);
        this.parameterPanel.add((Component)this.lPOReference, new ALayoutConstraint(2, 0));
        this.parameterPanel.add((Component)this.fPOReference, null);
    }

    private boolean initInfo() {
        String bp = Env.getContext(Env.getCtx(), this.p_WindowNo, "C_BPartner_ID");
        if (bp != null && bp.length() != 0) {
            this.fBPartner_ID.setValue(new Integer(bp));
        }
        StringBuffer where = new StringBuffer("i.IsActive='Y'");
        if (this.p_whereClause.length() > 0) {
            where.append(" AND ").append(Util.replace(this.p_whereClause, "M_InOut.", "i."));
        }
        this.prepareTable(s_invoiceLayout, " M_InOut i", where.toString(), "2,3,4");
        return true;
    }

    String getSQLWhere() {
        StringBuffer sql = new StringBuffer();
        if (this.fDocumentNo.getText().length() > 0) {
            sql.append(" AND UPPER(i.DocumentNo) LIKE ?");
        }
        if (this.fDescription.getText().length() > 0) {
            sql.append(" AND UPPER(i.Description) LIKE ?");
        }
        if (this.fPOReference.getText().length() > 0) {
            sql.append(" AND UPPER(i.POReference) LIKE ?");
        }
        if (this.fBPartner_ID.getValue() != null) {
            sql.append(" AND i.C_BPartner_ID=?");
        }
        if (this.fDateFrom.getValue() != null || this.fDateTo.getValue() != null) {
            Timestamp from = (Timestamp)this.fDateFrom.getValue();
            Timestamp to = (Timestamp)this.fDateTo.getValue();
            if (from == null && to != null) {
                sql.append(" AND TRUNC(i.MovementDate) <= ?");
            } else if (from != null && to == null) {
                sql.append(" AND TRUNC(i.MovementDate) >= ?");
            } else if (from != null && to != null) {
                sql.append(" AND TRUNC(i.MovementDate) BETWEEN ? AND ?");
            }
        }
        sql.append(" AND i.IsSOTrx=?");
        return sql.toString();
    }

    void setParameters(PreparedStatement pstmt, boolean forCount) throws SQLException {
        int index = 1;
        if (this.fDocumentNo.getText().length() > 0) {
            pstmt.setString(index++, this.getSQLText(this.fDocumentNo));
        }
        if (this.fDescription.getText().length() > 0) {
            pstmt.setString(index++, this.getSQLText(this.fDescription));
        }
        if (this.fPOReference.getText().length() > 0) {
            pstmt.setString(index++, this.getSQLText(this.fPOReference));
        }
        if (this.fBPartner_ID.getValue() != null) {
            Integer bp = (Integer)this.fBPartner_ID.getValue();
            pstmt.setInt(index++, bp);
            this.log.fine("BPartner=" + bp);
        }
        if (this.fDateFrom.getValue() != null || this.fDateTo.getValue() != null) {
            Timestamp from = (Timestamp)this.fDateFrom.getValue();
            Timestamp to = (Timestamp)this.fDateTo.getValue();
            this.log.fine("Date From=" + from + ", To=" + to);
            if (from == null && to != null) {
                pstmt.setTimestamp(index++, to);
            } else if (from != null && to == null) {
                pstmt.setTimestamp(index++, from);
            } else if (from != null && to != null) {
                pstmt.setTimestamp(index++, from);
                pstmt.setTimestamp(index++, to);
            }
        }
        pstmt.setString(index++, this.fIsSOTrx.isSelected() ? "Y" : "N");
    }

    private String getSQLText(CTextField f) {
        String s = f.getText().toUpperCase();
        if (!s.endsWith("%")) {
            s = s + "%";
        }
        this.log.fine("String=" + s);
        return s;
    }

    void zoom() {
        this.log.info("InfoInOut.zoom");
        Integer M_InOut_ID = this.getSelectedRowKey();
        if (M_InOut_ID == null) {
            return;
        }
        MQuery query = new MQuery("M_InOut");
        query.addRestriction("M_InOut_ID", "=", M_InOut_ID);
        query.setRecordCount(1);
        int AD_WindowNo = this.getAD_Window_ID("M_InOut", this.fIsSOTrx.isSelected());
        this.zoom(AD_WindowNo, query);
    }

    boolean hasZoom() {
        return true;
    }
}

