/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps.search;

import java.awt.Component;
import java.awt.Frame;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import org.adempiere.plaf.AdempierePLAF;
import org.compiere.apps.ALayout;
import org.compiere.apps.ALayoutConstraint;
import org.compiere.apps.search.Info;
import org.compiere.apps.search.Info_Column;
import org.compiere.grid.ed.VDate;
import org.compiere.grid.ed.VLookup;
import org.compiere.grid.ed.VNumber;
import org.compiere.minigrid.IDColumn;
import org.compiere.model.MLookupFactory;
import org.compiere.swing.CCheckBox;
import org.compiere.swing.CLabel;
import org.compiere.swing.CTextField;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public class InfoCashLine
extends Info {
    private ArrayList m_queryColumns = new ArrayList();
    private String m_tableName;
    private String m_keyColumn;
    private CLabel lName = new CLabel(Msg.translate(Env.getCtx(), "Name"));
    private CTextField fName = new CTextField(10);
    private CLabel lCashBook_ID = new CLabel(Msg.translate(Env.getCtx(), "C_CashBook_ID"));
    private VLookup fCashBook_ID;
    private CLabel lInvoice_ID = new CLabel(Msg.translate(Env.getCtx(), "C_Invoice_ID"));
    private VLookup fInvoice_ID;
    private CLabel lBankAccount_ID = new CLabel(Msg.translate(Env.getCtx(), "C_BankAccount_ID"));
    private VLookup fBankAccount_ID;
    private CCheckBox cbAbsolute = new CCheckBox(Msg.translate(Env.getCtx(), "AbsoluteAmt"));
    private CLabel lDateFrom = new CLabel(Msg.translate(Env.getCtx(), "StatementDate"));
    private VDate fDateFrom = new VDate("DateFrom", false, false, true, 15, Msg.translate(Env.getCtx(), "DateFrom"));
    private CLabel lDateTo = new CLabel("-");
    private VDate fDateTo = new VDate("DateTo", false, false, true, 15, Msg.translate(Env.getCtx(), "DateTo"));
    private CLabel lAmtFrom = new CLabel(Msg.translate(Env.getCtx(), "Amount"));
    private VNumber fAmtFrom = new VNumber("AmtFrom", false, false, true, 12, Msg.translate(Env.getCtx(), "AmtFrom"));
    private CLabel lAmtTo = new CLabel("-");
    private VNumber fAmtTo = new VNumber("AmtTo", false, false, true, 12, Msg.translate(Env.getCtx(), "AmtTo"));
    private static final Info_Column[] s_cashLayout = new Info_Column[]{new Info_Column(" ", "cl.C_CashLine_ID", IDColumn.class), new Info_Column(Msg.translate(Env.getCtx(), "C_CashBook_ID"), "(SELECT cb.Name FROM C_CashBook cb WHERE cb.C_CashBook_ID=c.C_CashBook_ID)", String.class), new Info_Column(Msg.translate(Env.getCtx(), "Name"), "c.Name", String.class), new Info_Column(Msg.translate(Env.getCtx(), "StatementDate"), "c.StatementDate", Timestamp.class), new Info_Column(Msg.translate(Env.getCtx(), "Line"), "cl.Line", Integer.class), new Info_Column(Msg.translate(Env.getCtx(), "Amount"), "cl.Amount", BigDecimal.class, true, true, null), new Info_Column(Msg.translate(Env.getCtx(), "C_Invoice_ID"), "(SELECT i.DocumentNo||'_'||" + DB.TO_CHAR("i.DateInvoiced", 15, Env.getAD_Language(Env.getCtx())) + "||'_'||" + DB.TO_CHAR("i.GrandTotal", 12, Env.getAD_Language(Env.getCtx())) + " FROM C_Invoice i WHERE i.C_Invoice_ID=cl.C_Invoice_ID)", String.class), new Info_Column(Msg.translate(Env.getCtx(), "C_BankAccount_ID"), "(SELECT b.Name||' '||ba.AccountNo FROM C_Bank b, C_BankAccount ba WHERE b.C_Bank_ID=ba.C_Bank_ID AND ba.C_BankAccount_ID=cl.C_BankAccount_ID)", String.class), new Info_Column(Msg.translate(Env.getCtx(), "C_Charge_ID"), "(SELECT ca.Name FROM C_Charge ca WHERE ca.C_Charge_ID=cl.C_Charge_ID)", String.class), new Info_Column(Msg.translate(Env.getCtx(), "DiscountAmt"), "cl.DiscountAmt", BigDecimal.class), new Info_Column(Msg.translate(Env.getCtx(), "WriteOffAmt"), "cl.WriteOffAmt", BigDecimal.class), new Info_Column(Msg.translate(Env.getCtx(), "Description"), "cl.Description", String.class)};

    protected InfoCashLine(Frame frame, boolean modal, int WindowNo, String value, boolean multiSelection, String whereClause) {
        super(frame, modal, WindowNo, "cl", "C_CashLine_ID", multiSelection, whereClause);
        this.log.info("InfoCashLine");
        this.setTitle(Msg.getMsg(Env.getCtx(), "InfoCashLine"));
        try {
            this.statInit();
            this.p_loadedOK = this.initInfo();
        }
        catch (Exception e) {
            return;
        }
        int no = this.p_table.getRowCount();
        this.setStatusLine(Integer.toString(no) + " " + Msg.getMsg(Env.getCtx(), "SearchRows_EnterQuery"), false);
        this.setStatusDB(Integer.toString(no));
        if (value != null && value.length() > 0) {
            this.fName.setValue(value);
            this.executeQuery();
        }
        this.pack();
        this.fName.requestFocus();
    }

    private void statInit() throws Exception {
        this.lName.setLabelFor(this.fName);
        this.fName.setBackground(AdempierePLAF.getInfoBackground());
        this.fName.addActionListener(this);
        this.fCashBook_ID = new VLookup("C_CashBook_ID", false, false, true, MLookupFactory.get(Env.getCtx(), this.p_WindowNo, 0, 5249, 19));
        this.lCashBook_ID.setLabelFor(this.fCashBook_ID);
        this.fCashBook_ID.setBackground(AdempierePLAF.getInfoBackground());
        this.fInvoice_ID = new VLookup("C_Invoice_ID", false, false, true, MLookupFactory.get(Env.getCtx(), this.p_WindowNo, 0, 5354, 30));
        this.lInvoice_ID.setLabelFor(this.fInvoice_ID);
        this.fInvoice_ID.setBackground(AdempierePLAF.getInfoBackground());
        this.fBankAccount_ID = new VLookup("C_BankAccount_ID", false, false, true, MLookupFactory.get(Env.getCtx(), this.p_WindowNo, 0, 5295, 19));
        this.lBankAccount_ID.setLabelFor(this.fBankAccount_ID);
        this.fBankAccount_ID.setBackground(AdempierePLAF.getInfoBackground());
        this.lDateFrom.setLabelFor(this.fDateFrom);
        this.fDateFrom.setBackground(AdempierePLAF.getInfoBackground());
        this.fDateFrom.setToolTipText(Msg.translate(Env.getCtx(), "DateFrom"));
        this.lDateTo.setLabelFor(this.fDateTo);
        this.fDateTo.setBackground(AdempierePLAF.getInfoBackground());
        this.fDateTo.setToolTipText(Msg.translate(Env.getCtx(), "DateTo"));
        this.lAmtFrom.setLabelFor(this.fAmtFrom);
        this.fAmtFrom.setBackground(AdempierePLAF.getInfoBackground());
        this.fAmtFrom.setToolTipText(Msg.translate(Env.getCtx(), "AmtFrom"));
        this.lAmtTo.setLabelFor(this.fAmtTo);
        this.fAmtTo.setBackground(AdempierePLAF.getInfoBackground());
        this.fAmtTo.setToolTipText(Msg.translate(Env.getCtx(), "AmtTo"));
        this.parameterPanel.setLayout(new ALayout());
        this.parameterPanel.add((Component)this.lCashBook_ID, new ALayoutConstraint(0, 0));
        this.parameterPanel.add((Component)this.fCashBook_ID, null);
        this.parameterPanel.add((Component)this.lName, null);
        this.parameterPanel.add((Component)this.fName, null);
        this.parameterPanel.add((Component)this.cbAbsolute, new ALayoutConstraint(0, 5));
        this.parameterPanel.add((Component)this.lInvoice_ID, new ALayoutConstraint(1, 0));
        this.parameterPanel.add((Component)this.fInvoice_ID, null);
        this.parameterPanel.add((Component)this.lDateFrom, null);
        this.parameterPanel.add((Component)this.fDateFrom, null);
        this.parameterPanel.add((Component)this.lDateTo, null);
        this.parameterPanel.add((Component)this.fDateTo, null);
        this.parameterPanel.add((Component)this.lBankAccount_ID, new ALayoutConstraint(2, 0));
        this.parameterPanel.add((Component)this.fBankAccount_ID, null);
        this.parameterPanel.add((Component)this.lAmtFrom, null);
        this.parameterPanel.add((Component)this.fAmtFrom, null);
        this.parameterPanel.add((Component)this.lAmtTo, null);
        this.parameterPanel.add((Component)this.fAmtTo, null);
    }

    private boolean initInfo() {
        StringBuffer where = new StringBuffer("cl.IsActive='Y'");
        if (this.p_whereClause.length() > 0) {
            where.append(" AND ").append(Util.replace(this.p_whereClause, "C_CashLine.", "cl."));
        }
        this.prepareTable(s_cashLayout, "C_CashLine cl INNER JOIN C_Cash c ON (cl.C_Cash_ID=c.C_Cash_ID)", where.toString(), "2,3,cl.Line");
        return true;
    }

    String getSQLWhere() {
        Comparable<Date> to;
        Comparable<Date> from;
        StringBuffer sql = new StringBuffer();
        if (this.fName.getText().length() > 0) {
            sql.append(" AND UPPER(c.Name) LIKE ?");
        }
        if (this.fCashBook_ID.getValue() != null) {
            sql.append(" AND c.C_CashBook_ID=?");
        }
        if (this.fInvoice_ID.getValue() != null) {
            sql.append(" AND cl.C_Invoice_ID=?");
        }
        if (this.fDateFrom.getValue() != null || this.fDateTo.getValue() != null) {
            from = (Timestamp)this.fDateFrom.getValue();
            to = (Timestamp)this.fDateTo.getValue();
            if (from == null && to != null) {
                sql.append(" AND TRUNC(c.StatementDate) <= ?");
            } else if (from != null && to == null) {
                sql.append(" AND TRUNC(c.StatementDate) >= ?");
            } else if (from != null && to != null) {
                sql.append(" AND TRUNC(c.StatementDate) BETWEEN ? AND ?");
            }
        }
        if (this.fAmtFrom.getValue() != null || this.fAmtTo.getValue() != null) {
            from = (BigDecimal)this.fAmtFrom.getValue();
            to = (BigDecimal)this.fAmtTo.getValue();
            if (this.cbAbsolute.isSelected()) {
                sql.append(" AND ABS(cl.Amount)");
            } else {
                sql.append(" AND cl.Amount");
            }
            if (from == null && to != null) {
                sql.append(" <=?");
            } else if (from != null && to == null) {
                sql.append(" >=?");
            } else if (from != null && to != null) {
                if (((BigDecimal)from).compareTo((BigDecimal)to) == 0) {
                    sql.append(" =?");
                } else {
                    sql.append(" BETWEEN ? AND ?");
                }
            }
        }
        this.log.fine(sql.toString());
        return sql.toString();
    }

    void setParameters(PreparedStatement pstmt, boolean forCount) throws SQLException {
        Comparable<Date> to;
        Comparable<Date> from;
        int index = 1;
        if (this.fName.getText().length() > 0) {
            pstmt.setString(index++, this.getSQLText(this.fName));
        }
        if (this.fCashBook_ID.getValue() != null) {
            Integer cb = (Integer)this.fCashBook_ID.getValue();
            pstmt.setInt(index++, cb);
            this.log.fine("CashBook=" + cb);
        }
        if (this.fInvoice_ID.getValue() != null) {
            Integer i = (Integer)this.fInvoice_ID.getValue();
            pstmt.setInt(index++, i);
            this.log.fine("Invoice=" + i);
        }
        if (this.fDateFrom.getValue() != null || this.fDateTo.getValue() != null) {
            from = (Timestamp)this.fDateFrom.getValue();
            to = (Timestamp)this.fDateTo.getValue();
            this.log.fine("Date From=" + from + ", To=" + to);
            if (from == null && to != null) {
                pstmt.setTimestamp(index++, (Timestamp)to);
            } else if (from != null && to == null) {
                pstmt.setTimestamp(index++, (Timestamp)from);
            } else if (from != null && to != null) {
                pstmt.setTimestamp(index++, (Timestamp)from);
                pstmt.setTimestamp(index++, (Timestamp)to);
            }
        }
        if (this.fAmtFrom.getValue() != null || this.fAmtTo.getValue() != null) {
            from = (BigDecimal)this.fAmtFrom.getValue();
            to = (BigDecimal)this.fAmtTo.getValue();
            if (this.cbAbsolute.isSelected()) {
                if (from != null) {
                    from = ((BigDecimal)from).abs();
                }
                if (to != null) {
                    to = ((BigDecimal)to).abs();
                }
            }
            this.log.fine("Amt From=" + from + ", To=" + to + ", Absolute=" + this.cbAbsolute.isSelected());
            if (from == null && to != null) {
                pstmt.setBigDecimal(index++, (BigDecimal)to);
            } else if (from != null && to == null) {
                pstmt.setBigDecimal(index++, (BigDecimal)from);
            } else if (from != null && to != null) {
                if (((BigDecimal)from).compareTo((BigDecimal)to) == 0) {
                    pstmt.setBigDecimal(index++, (BigDecimal)from);
                } else {
                    pstmt.setBigDecimal(index++, (BigDecimal)from);
                    pstmt.setBigDecimal(index++, (BigDecimal)to);
                }
            }
        }
    }

    private String getSQLText(CTextField f) {
        String s = f.getText().toUpperCase();
        if (!s.endsWith("%")) {
            s = s + "%";
        }
        this.log.fine("String=" + s);
        return s;
    }
}

