/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps.search;

import java.awt.Component;
import java.awt.Frame;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.adempiere.plaf.AdempierePLAF;
import org.compiere.apps.AEnv;
import org.compiere.apps.ALayout;
import org.compiere.apps.ALayoutConstraint;
import org.compiere.apps.search.Info;
import org.compiere.apps.search.Info_Column;
import org.compiere.grid.ed.VLookup;
import org.compiere.minigrid.IDColumn;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MQuery;
import org.compiere.swing.CLabel;
import org.compiere.swing.CTextField;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class InfoAsset
extends Info {
    private static String s_assetFROM = "A_ASSET a LEFT OUTER JOIN M_Product p ON (a.M_Product_ID=p.M_Product_ID) LEFT OUTER JOIN C_BPartner bp ON (a.C_BPartner_ID=bp.C_BPartner_ID) LEFT OUTER JOIN AD_User u ON (a.AD_User_ID=u.AD_User_ID)";
    private static final Info_Column[] s_assetLayout = new Info_Column[]{new Info_Column(" ", "a.A_Asset_ID", IDColumn.class), new Info_Column(Msg.translate(Env.getCtx(), "Value"), "a.Value", String.class), new Info_Column(Msg.translate(Env.getCtx(), "Name"), "a.Name", String.class), new Info_Column(Msg.translate(Env.getCtx(), "M_Product_ID"), "p.Name", String.class), new Info_Column(Msg.translate(Env.getCtx(), "C_BPartner_ID"), "bp.Name", String.class), new Info_Column(Msg.translate(Env.getCtx(), "AD_User_ID"), "u.Name", String.class), new Info_Column(Msg.translate(Env.getCtx(), "AssetServiceDate"), "a.AssetServiceDate", Timestamp.class), new Info_Column(Msg.translate(Env.getCtx(), "GuaranteeDate"), "a.GuaranteeDate", Timestamp.class), new Info_Column(Msg.translate(Env.getCtx(), "VersionNo"), "a.VersionNo", String.class)};
    private CLabel labelValue = new CLabel();
    private CTextField fieldValue = new CTextField(10);
    private CLabel labelName = new CLabel();
    private CTextField fieldName = new CTextField(10);
    private CLabel lBPartner_ID = new CLabel(Msg.translate(Env.getCtx(), "BPartner"));
    private VLookup fBPartner_ID;
    private CLabel lProduct_ID = new CLabel(Msg.translate(Env.getCtx(), "Product"));
    private VLookup fProduct_ID;

    public InfoAsset(Frame frame, boolean modal, int WindowNo, int A_Asset_ID, String value, boolean multiSelection, String whereClause) {
        super(frame, modal, WindowNo, "a", "A_Asset_ID", multiSelection, whereClause);
        this.log.info(value + ", ID=" + A_Asset_ID + ", WHERE=" + whereClause);
        this.setTitle(Msg.getMsg(Env.getCtx(), "InfoAsset"));
        this.statInit();
        this.initInfo(value, A_Asset_ID, whereClause);
        int no = this.p_table.getRowCount();
        this.setStatusLine(Integer.toString(no) + " " + Msg.getMsg(Env.getCtx(), "SearchRows_EnterQuery"), false);
        this.setStatusDB(Integer.toString(no));
        if (value != null && value.length() > 0) {
            this.executeQuery();
        }
        this.p_loadedOK = true;
        AEnv.positionCenterWindow(frame, this);
    }

    private void statInit() {
        this.labelValue.setText(Msg.getMsg(Env.getCtx(), "Value"));
        this.fieldValue.setBackground(AdempierePLAF.getInfoBackground());
        this.fieldValue.addActionListener(this);
        this.labelName.setText(Msg.getMsg(Env.getCtx(), "Name"));
        this.fieldName.setBackground(AdempierePLAF.getInfoBackground());
        this.fieldName.addActionListener(this);
        this.fBPartner_ID = new VLookup("C_BPartner_ID", false, false, true, MLookupFactory.get(Env.getCtx(), this.p_WindowNo, 0, 8065, 30));
        this.lBPartner_ID.setLabelFor(this.fBPartner_ID);
        this.fBPartner_ID.setBackground(AdempierePLAF.getInfoBackground());
        this.fProduct_ID = new VLookup("M_Product_ID", false, false, true, MLookupFactory.get(Env.getCtx(), this.p_WindowNo, 0, 8047, 30));
        this.lProduct_ID.setLabelFor(this.fProduct_ID);
        this.fProduct_ID.setBackground(AdempierePLAF.getInfoBackground());
        this.parameterPanel.setLayout(new ALayout());
        this.parameterPanel.add((Component)this.labelValue, new ALayoutConstraint(0, 0));
        this.parameterPanel.add((Component)this.fieldValue, null);
        this.parameterPanel.add((Component)this.lBPartner_ID, null);
        this.parameterPanel.add((Component)this.fBPartner_ID, null);
        this.parameterPanel.add((Component)this.labelName, new ALayoutConstraint(1, 0));
        this.parameterPanel.add((Component)this.fieldName, null);
        this.parameterPanel.add((Component)this.lProduct_ID, null);
        this.parameterPanel.add((Component)this.fProduct_ID, null);
    }

    private void initInfo(String value, int A_Asset_ID, String whereClause) {
        StringBuffer where = new StringBuffer();
        where.append("a.IsActive='Y'");
        if (whereClause != null && whereClause.length() > 0) {
            where.append(" AND ").append(whereClause);
        }
        this.prepareTable(s_assetLayout, s_assetFROM, where.toString(), "a.Value");
        if (value == null) {
            value = "%";
        }
        if (!value.endsWith("%")) {
            value = value + "%";
        }
    }

    String getSQLWhere() {
        Integer M_Product_ID;
        Integer C_BPartner_ID;
        String name;
        StringBuffer sql = new StringBuffer();
        String value = this.fieldValue.getText().toUpperCase();
        if (!value.equals("") && !value.equals("%")) {
            sql.append(" AND UPPER(a.Value) LIKE ?");
        }
        if (!(name = this.fieldName.getText().toUpperCase()).equals("") && !name.equals("%")) {
            sql.append(" AND UPPER(a.Name) LIKE ?");
        }
        if ((C_BPartner_ID = (Integer)this.fBPartner_ID.getValue()) != null) {
            sql.append(" AND a.C_BPartner_ID=").append(C_BPartner_ID);
        }
        if ((M_Product_ID = (Integer)this.fProduct_ID.getValue()) != null) {
            sql.append(" AND a.M_Product_ID=").append(M_Product_ID);
        }
        return sql.toString();
    }

    void setParameters(PreparedStatement pstmt, boolean forCount) throws SQLException {
        String name;
        int index = 1;
        String value = this.fieldValue.getText().toUpperCase();
        if (!value.equals("") && !value.equals("%")) {
            if (!value.endsWith("%")) {
                value = value + "%";
            }
            pstmt.setString(index++, value);
            this.log.fine("Value: " + value);
        }
        if (!(name = this.fieldName.getText().toUpperCase()).equals("") && !name.equals("%")) {
            if (!name.endsWith("%")) {
                name = name + "%";
            }
            pstmt.setString(index++, name);
            this.log.fine("Name: " + name);
        }
    }

    public void saveSelectionDetail() {
        int row = this.p_table.getSelectedRow();
        if (row == -1) {
            return;
        }
        Integer ID = this.getSelectedRowKey();
        Env.setContext(Env.getCtx(), 1113, 1113, "A_Asset_ID", ID == null ? "0" : ID.toString());
    }

    void showHistory() {
        this.log.info("InfoAsset.showHistory");
    }

    boolean hasHistory() {
        return false;
    }

    void zoom() {
        this.log.info("InfoAsset.zoom");
        Integer A_Asset_ID = this.getSelectedRowKey();
        if (A_Asset_ID == null) {
            return;
        }
        MQuery query = new MQuery("A_Asset");
        query.addRestriction("A_Asset_ID", "=", A_Asset_ID);
        query.setRecordCount(1);
        int AD_WindowNo = this.getAD_Window_ID("A_Asset", true);
        this.zoom(AD_WindowNo, query);
    }

    boolean hasZoom() {
        return true;
    }

    void customize() {
        this.log.info("InfoAsset.customize");
    }

    boolean hasCustomize() {
        return false;
    }
}

