/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps.search;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.compiere.Adempiere;
import org.compiere.apps.ADialog;
import org.compiere.apps.AEnv;
import org.compiere.apps.AWindow;
import org.compiere.apps.ConfirmPanel;
import org.compiere.apps.PrintScreenPainter;
import org.compiere.apps.StatusBar;
import org.compiere.apps.search.InfoAsset;
import org.compiere.apps.search.InfoAssignment;
import org.compiere.apps.search.InfoBPartner;
import org.compiere.apps.search.InfoCashLine;
import org.compiere.apps.search.InfoGeneral;
import org.compiere.apps.search.InfoInOut;
import org.compiere.apps.search.InfoInvoice;
import org.compiere.apps.search.InfoOrder;
import org.compiere.apps.search.InfoPayment;
import org.compiere.apps.search.InfoProduct;
import org.compiere.apps.search.Info_Column;
import org.compiere.grid.ed.Calculator;
import org.compiere.minigrid.IDColumn;
import org.compiere.minigrid.MiniTable;
import org.compiere.model.MQuery;
import org.compiere.model.MRole;
import org.compiere.swing.CButton;
import org.compiere.swing.CDialog;
import org.compiere.swing.CMenuItem;
import org.compiere.swing.CPanel;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;

public abstract class Info
extends CDialog
implements ListSelectionListener {
    static final int INFO_WIDTH = 800;
    protected int p_WindowNo;
    protected String p_tableName;
    protected String p_keyColumn;
    protected boolean p_multiSelection;
    protected String p_whereClause = "";
    protected MiniTable p_table = new MiniTable();
    private int m_keyColumnIndex = -1;
    private boolean m_ok = false;
    private boolean m_cancel = false;
    private ArrayList<Integer> m_results = new ArrayList(3);
    protected Info_Column[] p_layout;
    private String m_sqlMain;
    private String m_sqlCount;
    private String m_sqlOrder;
    protected boolean p_loadedOK = false;
    private int m_SO_Window_ID = -1;
    private int m_PO_Window_ID = -1;
    private Worker m_worker = null;
    protected CLogger log = CLogger.getCLogger(this.getClass());
    private CPanel southPanel = new CPanel();
    private BorderLayout southLayout = new BorderLayout();
    ConfirmPanel confirmPanel = new ConfirmPanel(true, true, true, true, true, true, true);
    protected StatusBar statusBar = new StatusBar();
    protected CPanel parameterPanel = new CPanel();
    private JScrollPane scrollPane = new JScrollPane();
    private JPopupMenu popup = new JPopupMenu();
    private CMenuItem calcMenu = new CMenuItem();

    public static Info create(Frame frame, boolean modal, int WindowNo, String tableName, String keyColumn, String value, boolean multiSelection, String whereClause) {
        Info info = null;
        info = tableName.equals("C_BPartner") ? new InfoBPartner(frame, modal, WindowNo, value, !Env.getContext(Env.getCtx(), "IsSOTrx").equals("N"), multiSelection, whereClause) : (tableName.equals("M_Product") ? new InfoProduct(frame, modal, WindowNo, 0, 0, value, multiSelection, whereClause) : (tableName.equals("C_Invoice") ? new InfoInvoice(frame, modal, WindowNo, value, multiSelection, whereClause) : (tableName.equals("A_Asset") ? new InfoAsset(frame, modal, WindowNo, 0, value, multiSelection, whereClause) : (tableName.equals("C_Order") ? new InfoOrder(frame, modal, WindowNo, value, multiSelection, whereClause) : (tableName.equals("M_InOut") ? new InfoInOut(frame, modal, WindowNo, value, multiSelection, whereClause) : (tableName.equals("C_Payment") ? new InfoPayment(frame, modal, WindowNo, value, multiSelection, whereClause) : (tableName.equals("C_CashLine") ? new InfoCashLine(frame, modal, WindowNo, value, multiSelection, whereClause) : (tableName.equals("S_ResourceAssigment") ? new InfoAssignment(frame, modal, WindowNo, value, multiSelection, whereClause) : new InfoGeneral(frame, modal, WindowNo, value, tableName, keyColumn, multiSelection, whereClause)))))))));
        AEnv.positionCenterWindow(frame, info);
        return info;
    }

    public static void showBPartner(Frame frame, int WindowNo) {
        InfoBPartner info = new InfoBPartner(frame, false, WindowNo, "", !Env.getContext(Env.getCtx(), "IsSOTrx").equals("N"), false, "");
        AEnv.showCenterWindow(frame, info);
    }

    public static void showAsset(Frame frame, int WindowNo) {
        InfoAsset info = new InfoAsset(frame, false, WindowNo, 0, "", false, "");
        AEnv.showCenterWindow(frame, info);
    }

    public static void showProduct(Frame frame, int WindowNo) {
        InfoProduct info = new InfoProduct(frame, false, WindowNo, Env.getContextAsInt(Env.getCtx(), WindowNo, "M_Warehouse_ID"), Env.getContextAsInt(Env.getCtx(), WindowNo, "M_PriceList_ID"), "", false, "");
        AEnv.showCenterWindow(frame, info);
    }

    public static void showOrder(Frame frame, int WindowNo, String value) {
        InfoOrder info = new InfoOrder(frame, false, WindowNo, value, false, "");
        AEnv.showCenterWindow(frame, info);
    }

    public static void showInvoice(Frame frame, int WindowNo, String value) {
        InfoInvoice info = new InfoInvoice(frame, false, WindowNo, value, false, "");
        AEnv.showCenterWindow(frame, info);
    }

    public static void showInOut(Frame frame, int WindowNo, String value) {
        InfoInOut info = new InfoInOut(frame, false, WindowNo, value, false, "");
        AEnv.showCenterWindow(frame, info);
    }

    public static void showPayment(Frame frame, int WindowNo, String value) {
        InfoPayment info = new InfoPayment(frame, false, WindowNo, value, false, "");
        AEnv.showCenterWindow(frame, info);
    }

    public static void showCashLine(Frame frame, int WindowNo, String value) {
        InfoCashLine info = new InfoCashLine(frame, false, WindowNo, value, false, "");
        AEnv.showCenterWindow(frame, info);
    }

    public static void showAssignment(Frame frame, int WindowNo, String value) {
        InfoAssignment info = new InfoAssignment(frame, false, WindowNo, value, false, "");
        AEnv.showCenterWindow(frame, info);
    }

    protected Info(Frame frame, boolean modal, int WindowNo, String tableName, String keyColumn, boolean multiSelection, String whereClause) {
        super(frame, modal);
        this.log.info("WinNo=" + this.p_WindowNo + " " + whereClause);
        this.p_WindowNo = WindowNo;
        this.p_tableName = tableName;
        this.p_keyColumn = keyColumn;
        this.p_multiSelection = multiSelection;
        if (whereClause == null || whereClause.indexOf(64) == -1) {
            this.p_whereClause = whereClause;
        } else {
            this.p_whereClause = Env.parseContext(Env.getCtx(), this.p_WindowNo, whereClause, false, false);
            if (this.p_whereClause.length() == 0) {
                this.log.log(Level.SEVERE, "Cannot parse context= " + whereClause);
            }
        }
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            this.log.log(Level.SEVERE, "Info", ex);
        }
    }

    protected void jbInit() throws Exception {
        this.setDefaultCloseOperation(2);
        this.southPanel.setLayout(this.southLayout);
        this.southPanel.add((Component)this.confirmPanel, "Center");
        this.southPanel.add((Component)this.statusBar, "South");
        this.getContentPane().add((Component)this.southPanel, "South");
        this.getContentPane().add((Component)this.parameterPanel, "North");
        this.getContentPane().add((Component)this.scrollPane, "Center");
        this.scrollPane.getViewport().add((Component)this.p_table, null);
        this.confirmPanel.addActionListener(this);
        this.confirmPanel.getResetButton().setVisible(this.hasReset());
        this.confirmPanel.getCustomizeButton().setVisible(this.hasCustomize());
        this.confirmPanel.getHistoryButton().setVisible(this.hasHistory());
        this.confirmPanel.getZoomButton().setVisible(this.hasZoom());
        CButton print = ConfirmPanel.createPrintButton(true);
        print.addActionListener(this);
        this.confirmPanel.addButton(print);
        this.popup.add(this.calcMenu);
        this.calcMenu.setText(Msg.getMsg(Env.getCtx(), "Calculator"));
        this.calcMenu.setIcon(new ImageIcon(Adempiere.class.getResource("images/Calculator16.gif")));
        this.calcMenu.addActionListener(this);
        this.p_table.getSelectionModel().addListSelectionListener(this);
        this.enableButtons();
    }

    public boolean loadedOK() {
        return this.p_loadedOK;
    }

    public void setStatusLine(String text, boolean error) {
        this.statusBar.setStatusLine(text, error);
        Thread.yield();
    }

    public void setStatusDB(String text) {
        this.statusBar.setStatusDB(text);
    }

    protected void prepareTable(Info_Column[] layout, String from, String staticWhere, String orderBy) {
        int i;
        this.p_layout = layout;
        StringBuffer sql = new StringBuffer("SELECT ");
        for (i = 0; i < layout.length; ++i) {
            if (i > 0) {
                sql.append(", ");
            }
            sql.append(layout[i].getColSQL());
            if (layout[i].isIDcol()) {
                sql.append(",").append(layout[i].getIDcolSQL());
            }
            this.p_table.addColumn(layout[i].getColHeader());
            if (layout[i].isColorColumn()) {
                this.p_table.setColorColumn(i);
            }
            if (layout[i].getColClass() != IDColumn.class) continue;
            this.m_keyColumnIndex = i;
        }
        for (i = 0; i < layout.length; ++i) {
            this.p_table.setColumnClass(i, layout[i].getColClass(), layout[i].isReadOnly(), layout[i].getColHeader());
        }
        sql.append(" FROM ").append(from);
        sql.append(" WHERE ").append(staticWhere);
        this.m_sqlMain = sql.toString();
        this.m_sqlCount = "SELECT COUNT(*) FROM " + from + " WHERE " + staticWhere;
        this.m_sqlOrder = "";
        if (orderBy != null && orderBy.length() > 0) {
            this.m_sqlOrder = " ORDER BY " + orderBy;
        }
        if (this.m_keyColumnIndex == -1) {
            this.log.log(Level.SEVERE, "No KeyColumn - " + sql);
        }
        this.p_table.setRowSelectionAllowed(true);
        this.p_table.addMouseListener(this);
        this.p_table.setMultiSelection(this.p_multiSelection);
        this.parameterPanel.setPreferredSize(new Dimension(800, this.parameterPanel.getPreferredSize().height));
        this.scrollPane.setPreferredSize(new Dimension(800, 400));
    }

    void executeQuery() {
        if (this.m_worker != null && this.m_worker.isAlive()) {
            return;
        }
        if (!this.testCount()) {
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.setStatusLine(Msg.getMsg(Env.getCtx(), "StartSearch"), false);
        this.m_worker = new Worker();
        this.m_worker.start();
    }

    private boolean testCount() {
        long start = System.currentTimeMillis();
        String dynWhere = this.getSQLWhere();
        StringBuffer sql = new StringBuffer(this.m_sqlCount);
        if (dynWhere.length() > 0) {
            sql.append(dynWhere);
        }
        String countSql = Msg.parseTranslation(Env.getCtx(), sql.toString());
        countSql = MRole.getDefault().addAccessSQL(countSql, this.getTableName(), true, false);
        this.log.finer(countSql);
        int no = -1;
        try {
            CPreparedStatement pstmt = DB.prepareStatement(countSql, null);
            this.setParameters(pstmt, true);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                no = rs.getInt(1);
            }
            rs.close();
            pstmt.close();
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, countSql, e);
            no = -2;
        }
        this.log.fine("#" + no + " - " + (System.currentTimeMillis() - start) + "ms");
        if (no > 1000) {
            return ADialog.ask(this.p_WindowNo, this, "InfoHighRecordCount", String.valueOf(no));
        }
        return true;
    }

    protected void saveSelection() {
        Integer data;
        if (this.p_table == null) {
            return;
        }
        this.log.config("OK=" + this.m_ok);
        if (!this.m_ok) {
            this.m_results.clear();
            this.p_table.removeAll();
            this.p_table = null;
            return;
        }
        if (!this.p_multiSelection && (data = this.getSelectedRowKey()) != null) {
            this.m_results.add(data);
        }
        this.log.config(this.getSelectedSQL());
        this.saveSelectionDetail();
        this.p_table.removeAll();
        this.p_table = null;
    }

    protected Integer getSelectedRowKey() {
        int row = this.p_table.getSelectedRow();
        if (row != -1 && this.m_keyColumnIndex != -1) {
            Object data = this.p_table.getModel().getValueAt(row, this.m_keyColumnIndex);
            if (data instanceof IDColumn) {
                data = ((IDColumn)data).getRecord_ID();
            }
            if (data instanceof Integer) {
                return (Integer)data;
            }
        }
        return null;
    }

    public Object[] getSelectedKeys() {
        if (!this.m_ok || this.m_results.size() == 0) {
            return null;
        }
        return this.m_results.toArray();
    }

    public Object getSelectedKey() {
        if (!this.m_ok || this.m_results.size() == 0) {
            return null;
        }
        return this.m_results.get(0);
    }

    public boolean isCancelled() {
        return this.m_cancel;
    }

    public String getSelectedSQL() {
        Object[] keys = this.getSelectedKeys();
        if (keys == null || keys.length == 0) {
            this.log.config("No Results - OK=" + this.m_ok + ", Cancel=" + this.m_cancel);
            return "";
        }
        StringBuffer sb = new StringBuffer(this.getKeyColumn());
        if (keys.length > 1) {
            sb.append(" IN (");
        } else {
            sb.append("=");
        }
        for (int i = 0; i < keys.length; ++i) {
            if (this.getKeyColumn().endsWith("_ID")) {
                sb.append(keys[i].toString()).append(",");
                continue;
            }
            sb.append("'").append(keys[i].toString()).append("',");
        }
        sb.replace(sb.length() - 1, sb.length(), "");
        if (keys.length > 1) {
            sb.append(")");
        }
        return sb.toString();
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.calcMenu)) {
            BigDecimal number = null;
            Object data = this.p_table.getSelectedValue();
            try {
                if (data != null) {
                    number = data instanceof BigDecimal ? (BigDecimal)data : new BigDecimal(data.toString());
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            Calculator c = new Calculator(null, number);
            c.setVisible(true);
            return;
        }
        String cmd = e.getActionCommand();
        if (cmd.equals("Ok")) {
            this.dispose(true);
        } else if (cmd.equals("Cancel")) {
            this.m_cancel = true;
            this.dispose(false);
        } else if (cmd.equals("History")) {
            this.showHistory();
        } else if (cmd.equals("Customize")) {
            this.customize();
        } else if (cmd.equals("Zoom")) {
            this.zoom();
        } else if (cmd.equals("Reset")) {
            this.doReset();
        } else if (cmd.equals("Print")) {
            PrintScreenPainter.printScreen(this);
        } else {
            this.executeQuery();
        }
    }

    void zoom(int AD_Window_ID, MQuery zoomQuery) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        final AWindow frame = new AWindow();
        if (!frame.initWindow(AD_Window_ID, zoomQuery)) {
            return;
        }
        AEnv.addToWindowManager(frame);
        if (this.isModal()) {
            this.setModal(false);
            this.dispose();
        } else {
            this.setCursor(Cursor.getDefaultCursor());
        }
        new Thread(){

            public void run() {
                try {
                    1.sleep(50L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                AEnv.showCenterScreen(frame);
            }
        }.start();
    }

    public void dispose() {
        this.dispose(false);
    }

    public void dispose(boolean ok) {
        this.log.config("OK=" + ok);
        this.m_ok = ok;
        if (this.m_worker != null) {
            if (this.m_worker.isAlive()) {
                this.m_worker.interrupt();
            }
            this.log.config("Worker alive=" + this.m_worker.isAlive());
        }
        this.m_worker = null;
        this.saveSelection();
        this.removeAll();
        super.dispose();
    }

    String getTableName() {
        return this.p_tableName;
    }

    String getKeyColumn() {
        return this.p_keyColumn;
    }

    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        this.enableButtons();
    }

    void enableButtons() {
        boolean enable = this.p_table.getSelectedRow() != -1;
        this.confirmPanel.getOKButton().setEnabled(enable);
        if (this.hasHistory()) {
            this.confirmPanel.getHistoryButton().setEnabled(enable);
        }
        if (this.hasZoom()) {
            this.confirmPanel.getZoomButton().setEnabled(enable);
        }
    }

    abstract String getSQLWhere();

    abstract void setParameters(PreparedStatement var1, boolean var2) throws SQLException;

    void doReset() {
    }

    boolean hasReset() {
        return false;
    }

    void showHistory() {
    }

    boolean hasHistory() {
        return false;
    }

    void customize() {
    }

    boolean hasCustomize() {
        return false;
    }

    void zoom() {
    }

    boolean hasZoom() {
        return false;
    }

    void saveSelectionDetail() {
    }

    protected int getAD_Window_ID(String tableName, boolean isSOTrx) {
        if (!isSOTrx && this.m_PO_Window_ID > 0) {
            return this.m_PO_Window_ID;
        }
        if (this.m_SO_Window_ID > 0) {
            return this.m_SO_Window_ID;
        }
        String sql = "SELECT AD_Window_ID, PO_Window_ID FROM AD_Table WHERE TableName=?";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setString(1, tableName);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                this.m_SO_Window_ID = rs.getInt(1);
                this.m_PO_Window_ID = rs.getInt(2);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        if (!isSOTrx && this.m_PO_Window_ID > 0) {
            return this.m_PO_Window_ID;
        }
        return this.m_SO_Window_ID;
    }

    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() > 1 && this.p_table.getSelectedRow() != -1) {
            this.dispose(true);
        } else if (SwingUtilities.isRightMouseButton(e)) {
            this.popup.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    class Worker
    extends Thread {
        Worker() {
        }

        public void run() {
            long start = System.currentTimeMillis();
            Info.this.p_table.setRowCount(0);
            String dynWhere = Info.this.getSQLWhere();
            StringBuffer sql = new StringBuffer(Info.this.m_sqlMain);
            if (dynWhere.length() > 0) {
                sql.append(dynWhere);
            }
            sql.append(Info.this.m_sqlOrder);
            String dataSql = Msg.parseTranslation(Env.getCtx(), sql.toString());
            dataSql = MRole.getDefault().addAccessSQL(dataSql, Info.this.getTableName(), true, false);
            Info.this.log.finer(dataSql);
            try {
                CPreparedStatement pstmt = DB.prepareStatement(dataSql, null);
                Info.this.setParameters(pstmt, false);
                Info.this.log.fine("Start query - " + (System.currentTimeMillis() - start) + "ms");
                ResultSet rs = pstmt.executeQuery();
                Info.this.log.fine("End query - " + (System.currentTimeMillis() - start) + "ms");
                while (!this.isInterrupted() & rs.next()) {
                    int row = Info.this.p_table.getRowCount();
                    Info.this.p_table.setRowCount(row + 1);
                    int colOffset = 1;
                    for (int col = 0; col < Info.this.p_layout.length; ++col) {
                        Object data = null;
                        Class c = Info.this.p_layout[col].getColClass();
                        int colIndex = col + colOffset;
                        if (c == IDColumn.class) {
                            data = new IDColumn(rs.getInt(colIndex));
                        } else if (c == Boolean.class) {
                            data = new Boolean("Y".equals(rs.getString(colIndex)));
                        } else if (c == Timestamp.class) {
                            data = rs.getTimestamp(colIndex);
                        } else if (c == BigDecimal.class) {
                            data = rs.getBigDecimal(colIndex);
                        } else if (c == Double.class) {
                            data = new Double(rs.getDouble(colIndex));
                        } else if (c == Integer.class) {
                            data = new Integer(rs.getInt(colIndex));
                        } else if (c == KeyNamePair.class) {
                            String display = rs.getString(colIndex);
                            int key = rs.getInt(colIndex + 1);
                            data = new KeyNamePair(key, display);
                            ++colOffset;
                        } else {
                            data = rs.getString(colIndex);
                        }
                        Info.this.p_table.setValueAt(data, row, col);
                    }
                }
                if (this.isInterrupted()) {
                    Info.this.log.finer("Interrupted");
                }
                rs.close();
                pstmt.close();
            }
            catch (SQLException e) {
                Info.this.log.log(Level.SEVERE, dataSql, e);
            }
            int no = Info.this.p_table.getRowCount();
            Info.this.log.fine("#" + no + " - " + (System.currentTimeMillis() - start) + "ms");
            Info.this.p_table.autoSize();
            Info.this.setCursor(Cursor.getDefaultCursor());
            Info.this.setStatusLine(Integer.toString(no) + " " + Msg.getMsg(Env.getCtx(), "SearchRows_EnterQuery"), false);
            Info.this.setStatusDB(Integer.toString(no));
            if (no == 0) {
                Info.this.log.fine(dataSql);
            } else {
                Info.this.p_table.getSelectionModel().setSelectionInterval(0, 0);
                Info.this.p_table.requestFocus();
            }
        }
    }
}

