/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps.search;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.logging.Level;
import javax.swing.Box;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import org.compiere.Adempiere;
import org.compiere.apps.ADialog;
import org.compiere.apps.AEnv;
import org.compiere.apps.ConfirmPanel;
import org.compiere.apps.StatusBar;
import org.compiere.apps.search.FindValueEditor;
import org.compiere.apps.search.FindValueRenderer;
import org.compiere.grid.ed.VEditor;
import org.compiere.grid.ed.VEditorFactory;
import org.compiere.grid.ed.VLookup;
import org.compiere.model.DataStatusEvent;
import org.compiere.model.DataStatusListener;
import org.compiere.model.GridField;
import org.compiere.model.MQuery;
import org.compiere.model.MRole;
import org.compiere.swing.CButton;
import org.compiere.swing.CComboBox;
import org.compiere.swing.CDialog;
import org.compiere.swing.CLabel;
import org.compiere.swing.CPanel;
import org.compiere.swing.CTabbedPane;
import org.compiere.swing.CTable;
import org.compiere.swing.CTextField;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.ValueNamePair;

public final class Find
extends CDialog
implements ActionListener,
ChangeListener,
DataStatusListener {
    private int m_targetWindowNo;
    private int m_AD_Table_ID;
    private String m_tableName;
    private String m_whereExtended;
    private GridField[] m_findFields;
    private MQuery m_query = null;
    private static CLogger log = CLogger.getCLogger(Find.class);
    private int m_total;
    private PreparedStatement m_pstmt;
    private boolean hasValue = false;
    private boolean hasDocNo = false;
    private boolean hasName = false;
    private boolean hasDescription = false;
    private int m_sLine = 6;
    private ArrayList<VEditor> m_sEditors = new ArrayList();
    private Hashtable<Integer, GridField> m_targetFields = new Hashtable();
    public static final int TABNO = 99;
    public static final int FIELDLENGTH = 20;
    private CPanel southPanel = new CPanel();
    private BorderLayout southLayout = new BorderLayout();
    private StatusBar statusBar = new StatusBar();
    private CTabbedPane tabbedPane = new CTabbedPane();
    private CPanel advancedPanel = new CPanel();
    private BorderLayout advancedLayout = new BorderLayout();
    private ConfirmPanel confirmPanelA = new ConfirmPanel(true, true, false, false, false, false, true);
    private CButton bIgnore = new CButton();
    private JToolBar toolBar = new JToolBar();
    private CButton bSave = new CButton();
    private CButton bNew = new CButton();
    private CButton bDelete = new CButton();
    private GridLayout gridLayout1 = new GridLayout();
    private ConfirmPanel confirmPanelS = new ConfirmPanel(true);
    private BorderLayout simpleLayout = new BorderLayout();
    private CPanel scontentPanel = new CPanel();
    private GridBagLayout scontentLayout = new GridBagLayout();
    private CPanel simplePanel = new CPanel();
    private CLabel valueLabel = new CLabel();
    private CLabel nameLabel = new CLabel();
    private CLabel descriptionLabel = new CLabel();
    private CTextField valueField = new CTextField();
    private CTextField nameField = new CTextField();
    private CTextField descriptionField = new CTextField();
    private CLabel docNoLabel = new CLabel();
    private CTextField docNoField = new CTextField();
    private Component spaceE;
    private Component spaceN;
    private Component spaceW;
    private Component spaceS;
    private JScrollPane advancedScrollPane = new JScrollPane();
    private CTable advancedTable = new CTable();
    public static final int INDEX_COLUMNNAME = 0;
    public static final int INDEX_OPERATOR = 1;
    public static final int INDEX_VALUE = 2;
    public static final int INDEX_VALUE2 = 3;
    public CComboBox columns = null;
    public CComboBox operators = null;

    public Find(Frame owner, int targetWindowNo, String title, int AD_Table_ID, String tableName, String whereExtended, GridField[] findFields, int minRecords) {
        super(owner, Msg.getMsg(Env.getCtx(), "Find") + ": " + title, true);
        log.info(title);
        this.m_targetWindowNo = targetWindowNo;
        this.m_AD_Table_ID = AD_Table_ID;
        this.m_tableName = tableName;
        this.m_whereExtended = whereExtended;
        this.m_findFields = findFields;
        this.m_query = new MQuery(tableName);
        this.m_query.addRestriction(whereExtended);
        Env.setContext(Env.getCtx(), this.m_targetWindowNo, "Find_Table_ID", this.m_AD_Table_ID);
        Env.setContext(Env.getCtx(), 1110, "Find_Table_ID", this.m_AD_Table_ID);
        try {
            this.jbInit();
            this.initFind();
            if (this.m_total < minRecords) {
                this.dispose();
                return;
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Find", e);
        }
        this.getRootPane().setDefaultButton(this.confirmPanelS.getOKButton());
        AEnv.showCenterWindow(owner, this);
    }

    private void jbInit() throws Exception {
        this.spaceE = Box.createHorizontalStrut(8);
        this.spaceN = Box.createVerticalStrut(8);
        this.spaceW = Box.createHorizontalStrut(8);
        this.spaceS = Box.createVerticalStrut(8);
        this.bIgnore.setIcon(new ImageIcon(Adempiere.class.getResource("images/Ignore24.gif")));
        this.bIgnore.setMargin(new Insets(2, 2, 2, 2));
        this.bIgnore.setToolTipText(Msg.getMsg(Env.getCtx(), "Ignore"));
        this.bIgnore.addActionListener(this);
        this.bSave.setIcon(new ImageIcon(Adempiere.class.getResource("images/Save24.gif")));
        this.bSave.setMargin(new Insets(2, 2, 2, 2));
        this.bSave.setToolTipText(Msg.getMsg(Env.getCtx(), "Save"));
        this.bSave.addActionListener(this);
        this.bNew.setIcon(new ImageIcon(Adempiere.class.getResource("images/New24.gif")));
        this.bNew.setMargin(new Insets(2, 2, 2, 2));
        this.bNew.setToolTipText(Msg.getMsg(Env.getCtx(), "New"));
        this.bNew.addActionListener(this);
        this.bDelete.setIcon(new ImageIcon(Adempiere.class.getResource("images/Delete24.gif")));
        this.bDelete.setMargin(new Insets(2, 2, 2, 2));
        this.bDelete.setToolTipText(Msg.getMsg(Env.getCtx(), "Delete"));
        this.bDelete.addActionListener(this);
        this.southPanel.setLayout(this.southLayout);
        this.valueLabel.setLabelFor(this.valueField);
        this.valueLabel.setText(Msg.translate(Env.getCtx(), "Value"));
        this.nameLabel.setLabelFor(this.nameField);
        this.nameLabel.setText(Msg.translate(Env.getCtx(), "Name"));
        this.descriptionLabel.setLabelFor(this.descriptionField);
        this.descriptionLabel.setText(Msg.translate(Env.getCtx(), "Description"));
        this.valueField.setText("%");
        this.valueField.setColumns(20);
        this.nameField.setText("%");
        this.nameField.setColumns(20);
        this.descriptionField.setText("%");
        this.descriptionField.setColumns(20);
        this.scontentPanel.setToolTipText(Msg.getMsg(Env.getCtx(), "FindTip"));
        this.docNoLabel.setLabelFor(this.docNoField);
        this.docNoLabel.setText(Msg.translate(Env.getCtx(), "DocumentNo"));
        this.docNoField.setText("%");
        this.docNoField.setColumns(20);
        this.advancedScrollPane.setPreferredSize(new Dimension(450, 150));
        this.southPanel.add((Component)this.statusBar, "South");
        this.getContentPane().add((Component)this.southPanel, "South");
        this.scontentPanel.setLayout(this.scontentLayout);
        this.simplePanel.setLayout(this.simpleLayout);
        this.simplePanel.add((Component)this.confirmPanelS, "South");
        this.simplePanel.add((Component)this.scontentPanel, "Center");
        this.scontentPanel.add((Component)this.valueLabel, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 12, 0, new Insets(7, 5, 0, 5), 0, 0));
        this.scontentPanel.add((Component)this.nameLabel, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 12, 0, new Insets(7, 5, 0, 5), 0, 0));
        this.scontentPanel.add((Component)this.descriptionLabel, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 12, 0, new Insets(7, 5, 5, 5), 0, 0));
        this.scontentPanel.add((Component)this.valueField, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 0, 5), 0, 0));
        this.scontentPanel.add((Component)this.descriptionField, new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 5, 5), 0, 0));
        this.scontentPanel.add((Component)this.docNoLabel, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 12, 0, new Insets(7, 5, 0, 5), 0, 0));
        this.scontentPanel.add((Component)this.nameField, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 0, 5), 0, 0));
        this.scontentPanel.add((Component)this.docNoField, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 0, 5), 0, 0));
        this.scontentPanel.add(this.spaceE, new GridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 10, 10, 10), 0, 0));
        this.scontentPanel.add(this.spaceN, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 10, 10, 10), 0, 0));
        this.scontentPanel.add(this.spaceW, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 10, 10, 10), 0, 0));
        this.scontentPanel.add(this.spaceS, new GridBagConstraints(2, 15, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 10, 10, 10), 0, 0));
        this.tabbedPane.add((Component)this.simplePanel, Msg.getMsg(Env.getCtx(), "Find"));
        this.toolBar.add((Component)this.bIgnore, null);
        this.toolBar.addSeparator();
        this.toolBar.add((Component)this.bNew, null);
        this.toolBar.add((Component)this.bSave, null);
        this.toolBar.add((Component)this.bDelete, null);
        this.advancedPanel.setLayout(this.advancedLayout);
        this.advancedPanel.add((Component)this.toolBar, "North");
        this.advancedPanel.add((Component)this.confirmPanelA, "South");
        this.advancedPanel.add((Component)this.advancedScrollPane, "Center");
        this.advancedScrollPane.getViewport().add((Component)this.advancedTable, null);
        this.tabbedPane.add((Component)this.advancedPanel, Msg.getMsg(Env.getCtx(), "Advanced"));
        this.getContentPane().add((Component)this.tabbedPane, "Center");
        this.confirmPanelA.addActionListener(this);
        this.confirmPanelS.addActionListener(this);
        CButton b = ConfirmPanel.createNewButton(true);
        this.confirmPanelS.addComponent(b);
        b.addActionListener(this);
    }

    private void initFind() {
        log.config("");
        for (int i = 0; i < this.m_findFields.length; ++i) {
            GridField mField = this.m_findFields[i];
            String columnName = mField.getColumnName();
            if (columnName.equals("Value")) {
                this.hasValue = true;
            } else if (columnName.equals("Name")) {
                this.hasName = true;
            } else if (columnName.equals("DocumentNo")) {
                this.hasDocNo = true;
            } else if (columnName.equals("Description")) {
                this.hasDescription = true;
            } else if (mField.isSelectionColumn()) {
                this.addSelectionColumn(mField);
            } else if (columnName.indexOf("Name") != -1) {
                this.addSelectionColumn(mField);
            }
            this.m_targetFields.put(new Integer(mField.getAD_Column_ID()), mField);
        }
        this.valueLabel.setVisible(this.hasValue);
        this.valueField.setVisible(this.hasValue);
        if (this.hasValue) {
            this.valueField.addActionListener(this);
        }
        this.docNoLabel.setVisible(this.hasDocNo);
        this.docNoField.setVisible(this.hasDocNo);
        if (this.hasDocNo) {
            this.docNoField.addActionListener(this);
        }
        this.nameLabel.setVisible(this.hasName);
        this.nameField.setVisible(this.hasName);
        if (this.hasName) {
            this.nameField.addActionListener(this);
        }
        this.descriptionLabel.setVisible(this.hasDescription);
        this.descriptionField.setVisible(this.hasDescription);
        if (this.hasDescription) {
            this.descriptionField.addActionListener(this);
        }
        this.m_total = this.getNoOfRecords(null, false);
        this.setStatusDB(this.m_total);
        this.statusBar.setStatusLine("");
        this.tabbedPane.addChangeListener(this);
        this.confirmPanelA.getOKButton().setToolTipText(Msg.getMsg(Env.getCtx(), "QueryEnter"));
        this.confirmPanelA.getCancelButton().setToolTipText(Msg.getMsg(Env.getCtx(), "QueryCancel"));
        this.confirmPanelS.getOKButton().setToolTipText(Msg.getMsg(Env.getCtx(), "QueryEnter"));
        this.confirmPanelS.getCancelButton().setToolTipText(Msg.getMsg(Env.getCtx(), "QueryCancel"));
    }

    private void addSelectionColumn(GridField mField) {
        log.config(mField.getHeader());
        int displayLength = mField.getDisplayLength();
        if (displayLength > 20) {
            mField.setDisplayLength(20);
        } else {
            displayLength = 0;
        }
        VEditor editor = null;
        if (mField.isLookup()) {
            VLookup vl = new VLookup(mField.getColumnName(), false, false, true, mField.getLookup());
            vl.setName(mField.getColumnName());
            editor = vl;
        } else {
            editor = VEditorFactory.getEditor(mField, false);
            editor.setMandatory(false);
            editor.setReadWrite(true);
        }
        CLabel label = VEditorFactory.getLabel(mField);
        if (displayLength > 0) {
            mField.setDisplayLength(displayLength);
        }
        ++this.m_sLine;
        if (label != null) {
            this.scontentPanel.add((Component)label, new GridBagConstraints(1, this.m_sLine, 1, 1, 0.0, 0.0, 12, 0, new Insets(7, 5, 5, 5), 0, 0));
        }
        this.scontentPanel.add((Component)((Object)editor), new GridBagConstraints(2, this.m_sLine, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 5, 5), 0, 0));
        this.m_sEditors.add(editor);
    }

    private void initFindAdvanced() {
        log.config("");
        this.advancedTable.setModel(new DefaultTableModel(0, 4));
        this.advancedTable.setAutoResizeMode(2);
        ArrayList<ValueNamePair> items = new ArrayList<ValueNamePair>();
        for (int c = 0; c < this.m_findFields.length; ++c) {
            GridField field = this.m_findFields[c];
            String columnName = field.getColumnName();
            String header = field.getHeader();
            if ((header == null || header.length() == 0) && ((header = Msg.translate(Env.getCtx(), columnName)) == null || header.length() == 0)) continue;
            if (field.isKey()) {
                header = header + " (ID)";
            }
            ValueNamePair pp = new ValueNamePair(columnName, header);
            items.add(pp);
        }
        Object[] cols = new ValueNamePair[items.size()];
        items.toArray(cols);
        Arrays.sort(cols);
        this.columns = new CComboBox(cols);
        this.columns.addActionListener(this);
        TableColumn tc = this.advancedTable.getColumnModel().getColumn(0);
        tc.setPreferredWidth(150);
        tc.setCellEditor(new DefaultCellEditor(this.columns));
        tc.setHeaderValue(Msg.translate(Env.getCtx(), "AD_Column_ID"));
        this.operators = new CComboBox(MQuery.OPERATORS);
        tc = this.advancedTable.getColumnModel().getColumn(1);
        tc.setPreferredWidth(40);
        tc.setCellEditor(new DefaultCellEditor(this.operators));
        tc.setHeaderValue(Msg.getMsg(Env.getCtx(), "Operator"));
        tc = this.advancedTable.getColumnModel().getColumn(2);
        tc.setCellEditor(new FindValueEditor(this, false));
        tc.setCellRenderer(new FindValueRenderer(this, false));
        tc.setHeaderValue(Msg.getMsg(Env.getCtx(), "QueryValue"));
        tc = this.advancedTable.getColumnModel().getColumn(3);
        tc.setPreferredWidth(50);
        tc.setCellEditor(new FindValueEditor(this, true));
        tc.setCellRenderer(new FindValueRenderer(this, true));
        tc.setHeaderValue(Msg.getMsg(Env.getCtx(), "QueryValue2"));
        this.cmd_new();
    }

    public void dispose() {
        log.config("");
        if (this.m_pstmt != null) {
            try {
                this.m_pstmt.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        this.m_pstmt = null;
        if (this.m_targetFields != null) {
            this.m_targetFields.clear();
        }
        this.m_targetFields = null;
        this.removeAll();
        super.dispose();
    }

    public void actionPerformed(ActionEvent e) {
        log.info(e.getActionCommand());
        if (e.getActionCommand() == "Cancel") {
            this.cmd_cancel();
        } else if (e.getActionCommand() == "Refresh") {
            this.cmd_refresh();
        } else if (e.getActionCommand() == "New") {
            this.m_query = MQuery.getNoRecordQuery(this.m_tableName, true);
            this.m_total = 0;
            this.dispose();
        } else if (e.getSource() == this.bIgnore) {
            this.cmd_ignore();
        } else if (e.getSource() == this.bNew) {
            this.cmd_new();
        } else if (e.getSource() == this.bSave) {
            this.cmd_save();
        } else if (e.getSource() == this.bDelete) {
            this.cmd_delete();
        } else if (e.getSource() == this.columns) {
            ValueNamePair column = (ValueNamePair)this.columns.getSelectedItem();
            if (column != null) {
                String columnName = column.getValue();
                log.config("Column: " + columnName);
                if (columnName.endsWith("_ID") || columnName.endsWith("_Acct")) {
                    this.operators.setModel(new DefaultComboBoxModel<ValueNamePair>(MQuery.OPERATORS_ID));
                } else if (columnName.startsWith("Is")) {
                    this.operators.setModel(new DefaultComboBoxModel<ValueNamePair>(MQuery.OPERATORS_YN));
                } else {
                    this.operators.setModel(new DefaultComboBoxModel<ValueNamePair>(MQuery.OPERATORS));
                }
            }
        } else if (e.getSource() == this.confirmPanelA.getOKButton()) {
            this.cmd_ok_Advanced();
        } else {
            this.cmd_ok_Simple();
        }
    }

    public void stateChanged(ChangeEvent e) {
        if (this.tabbedPane.getSelectedIndex() == 0) {
            this.getRootPane().setDefaultButton(this.confirmPanelS.getOKButton());
        } else {
            this.initFindAdvanced();
            this.getRootPane().setDefaultButton(this.confirmPanelA.getOKButton());
        }
    }

    private void cmd_ok_Simple() {
        String value;
        this.m_query = new MQuery(this.m_tableName);
        if (this.hasValue && !this.valueField.getText().equals("%") && this.valueField.getText().length() != 0) {
            value = DB.isFyracle() ? this.valueField.getText() : this.valueField.getText().toUpperCase();
            if (!value.endsWith("%")) {
                value = value + "%";
            }
            this.m_query.addRestriction(DB.isFyracle() ? "Value" : "UPPER(Value)", " LIKE ", value, this.valueLabel.getText(), value);
        }
        if (this.hasDocNo && !this.docNoField.getText().equals("%") && this.docNoField.getText().length() != 0) {
            value = DB.isFyracle() ? this.docNoField.getText() : this.docNoField.getText().toUpperCase();
            if (!value.endsWith("%")) {
                value = value + "%";
            }
            this.m_query.addRestriction(DB.isFyracle() ? "DocumentNo" : "UPPER(DocumentNo)", " LIKE ", value, this.docNoLabel.getText(), value);
        }
        if (this.hasName && !this.nameField.getText().equals("%") && this.nameField.getText().length() != 0) {
            value = DB.isFyracle() ? this.nameField.getText() : this.nameField.getText().toUpperCase();
            if (!value.endsWith("%")) {
                value = value + "%";
            }
            this.m_query.addRestriction(DB.isFyracle() ? "Name" : "UPPER(Name)", " LIKE ", value, this.nameLabel.getText(), value);
        }
        if (this.hasDescription && !this.descriptionField.getText().equals("%") && this.descriptionField.getText().length() != 0) {
            value = this.descriptionField.getText().toUpperCase();
            if (!value.endsWith("%")) {
                value = value + "%";
            }
            this.m_query.addRestriction("UPPER(Description)", " LIKE ", value, this.descriptionLabel.getText(), value);
        }
        for (int i = 0; i < this.m_sEditors.size(); ++i) {
            VEditor ved = this.m_sEditors.get(i);
            Object value2 = ved.getValue();
            if (value2 == null || value2.toString().length() <= 0) continue;
            String ColumnName = ((Component)((Object)ved)).getName();
            log.fine(ColumnName + "=" + value2);
            if (value2.toString().indexOf("%") != -1) {
                this.m_query.addRestriction(ColumnName, " LIKE ", value2, ColumnName, ved.getDisplay());
                continue;
            }
            this.m_query.addRestriction(ColumnName, "=", value2, ColumnName, ved.getDisplay());
        }
        if (this.getNoOfRecords(this.m_query, true) != 0) {
            this.dispose();
        }
    }

    private void cmd_ok_Advanced() {
        if (this.bSave.isEnabled()) {
            this.cmd_save();
        }
        if (this.getNoOfRecords(this.m_query, true) != 0) {
            this.dispose();
        }
    }

    private void cmd_cancel() {
        log.info("");
        this.m_query = null;
        this.m_total = 999999;
        this.dispose();
    }

    private void cmd_ignore() {
        log.info("");
    }

    private void cmd_new() {
        log.info("");
        DefaultTableModel model = (DefaultTableModel)this.advancedTable.getModel();
        model.addRow(new Object[]{null, MQuery.OPERATORS[0], null, null});
    }

    private void cmd_save() {
        log.info("");
        this.advancedTable.stopEditor(true);
        this.m_query = new MQuery(this.m_tableName);
        for (int row = 0; row < this.advancedTable.getRowCount(); ++row) {
            Object parsedValue;
            Object column = this.advancedTable.getValueAt(row, 0);
            if (column == null) continue;
            String ColumnName = ((ValueNamePair)column).getValue();
            String infoName = column.toString();
            GridField field = this.getTargetMField(ColumnName);
            String ColumnSQL = field.getColumnSQL(false);
            Object op = this.advancedTable.getValueAt(row, 1);
            if (op == null) continue;
            String Operator = ((ValueNamePair)op).getValue();
            Object value = this.advancedTable.getValueAt(row, 2);
            if (value == null || (parsedValue = this.parseValue(field, value)) == null) continue;
            String infoDisplay = value.toString();
            if (field.isLookup()) {
                infoDisplay = field.getLookup().getDisplay(value);
            } else if (field.getDisplayType() == 20) {
                infoDisplay = Msg.getMsg(Env.getCtx(), infoDisplay);
            }
            if (MQuery.OPERATORS[8].equals(op)) {
                Object value2 = this.advancedTable.getValueAt(row, 3);
                if (value2 == null) continue;
                Object parsedValue2 = this.parseValue(field, value2);
                String infoDisplay_to = value2.toString();
                if (parsedValue2 == null) continue;
                this.m_query.addRangeRestriction(ColumnSQL, parsedValue, parsedValue2, infoName, infoDisplay, infoDisplay_to);
                continue;
            }
            this.m_query.addRestriction(ColumnSQL, Operator, parsedValue, infoName, infoDisplay);
        }
    }

    private Object parseValue(GridField field, Object in) {
        if (in == null) {
            return null;
        }
        int dt = field.getDisplayType();
        try {
            if (dt == 11 || DisplayType.isID(dt) && field.getColumnName().endsWith("_ID")) {
                if (in instanceof Integer) {
                    return in;
                }
                int i = Integer.parseInt(in.toString());
                return new Integer(i);
            }
            if (DisplayType.isNumeric(dt)) {
                if (in instanceof BigDecimal) {
                    return in;
                }
                return DisplayType.getNumberFormat(dt).parse(in.toString());
            }
            if (DisplayType.isDate(dt)) {
                if (in instanceof Timestamp) {
                    return in;
                }
                long time = 0L;
                try {
                    time = DisplayType.getDateFormat_JDBC().parse(in.toString()).getTime();
                    return new Timestamp(time);
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, in + "(" + in.getClass() + ")" + e);
                    time = DisplayType.getDateFormat(dt).parse(in.toString()).getTime();
                    return new Timestamp(time);
                }
            }
            if (in instanceof Boolean) {
                return (Boolean)in != false ? "Y" : "N";
            }
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "Object=" + in, ex);
            String error = ex.getLocalizedMessage();
            if (error == null || error.length() == 0) {
                error = ex.toString();
            }
            StringBuffer errMsg = new StringBuffer();
            errMsg.append(field.getColumnName()).append(" = ").append(in).append(" - ").append(error);
            ADialog.error(0, this, "ValidationError", errMsg.toString());
            return null;
        }
        return in;
    }

    private void cmd_delete() {
        log.info("");
        DefaultTableModel model = (DefaultTableModel)this.advancedTable.getModel();
        int row = this.advancedTable.getSelectedRow();
        if (row >= 0) {
            model.removeRow(row);
        }
        this.cmd_refresh();
    }

    private void cmd_refresh() {
        log.info("");
        int records = this.getNoOfRecords(this.m_query, true);
        this.setStatusDB(records);
        this.statusBar.setStatusLine("");
    }

    public MQuery getQuery() {
        MRole role = MRole.getDefault();
        if (role.isQueryMax(this.getTotalRecords())) {
            this.m_query = MQuery.getNoRecordQuery(this.m_tableName, false);
            this.m_total = 0;
            log.warning("Query - over max");
        } else {
            log.info("Query=" + this.m_query);
        }
        return this.m_query;
    }

    public int getTotalRecords() {
        return this.m_total;
    }

    private int getNoOfRecords(MQuery query, boolean alertZeroRecords) {
        log.config("" + query);
        StringBuffer sql = new StringBuffer("SELECT COUNT(*) FROM ");
        sql.append(this.m_tableName);
        boolean hasWhere = false;
        if (this.m_whereExtended != null && this.m_whereExtended.length() > 0) {
            sql.append(" WHERE ").append(this.m_whereExtended);
            hasWhere = true;
        }
        if (query != null && query.isActive()) {
            if (hasWhere) {
                sql.append(" AND ");
            } else {
                sql.append(" WHERE ");
            }
            sql.append(query.getWhereClause());
        }
        String finalSQL = MRole.getDefault().addAccessSQL(sql.toString(), this.m_tableName, false, false);
        finalSQL = Env.parseContext(Env.getCtx(), this.m_targetWindowNo, finalSQL, false);
        Env.setContext(Env.getCtx(), this.m_targetWindowNo, 99, "FindSQL", finalSQL);
        this.m_total = 999999;
        try {
            Statement stmt = DB.createStatement();
            ResultSet rs = stmt.executeQuery(finalSQL);
            if (rs.next()) {
                this.m_total = rs.getInt(1);
            }
            rs.close();
            stmt.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, finalSQL, e);
        }
        MRole role = MRole.getDefault();
        if (this.m_total == 0 && alertZeroRecords) {
            ADialog.info(this.m_targetWindowNo, this, "FindZeroRecords");
        } else if (query != null && role.isQueryMax(this.m_total)) {
            ADialog.error(this.m_targetWindowNo, this, "FindOverMax", this.m_total + " > " + role.getMaxQueryRecords());
        } else {
            log.config("#" + this.m_total);
        }
        if (query != null) {
            this.statusBar.setStatusToolTip(query.getWhereClause());
        }
        return this.m_total;
    }

    private void setStatusDB(int currentCount) {
        String text = " " + currentCount + " / " + this.m_total + " ";
        this.statusBar.setStatusDB(text);
    }

    public void dataStatusChanged(DataStatusEvent e) {
        log.config(e.getMessage());
        boolean changed = e.isChanged();
        this.bIgnore.setEnabled(changed);
        this.bNew.setEnabled(!changed);
        this.bSave.setEnabled(changed);
        this.bDelete.setEnabled(!changed);
    }

    public GridField getTargetMField(String columnName) {
        if (columnName == null) {
            return null;
        }
        for (int c = 0; c < this.m_findFields.length; ++c) {
            GridField field = this.m_findFields[c];
            if (!columnName.equals(field.getColumnName())) continue;
            return field;
        }
        return null;
    }
}

