/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps.graph;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Level;
import javax.swing.BoxLayout;
import org.compiere.apps.ConfirmPanel;
import org.compiere.apps.form.FormFrame;
import org.compiere.apps.form.FormPanel;
import org.compiere.apps.graph.PerformanceDetail;
import org.compiere.apps.graph.PerformanceIndicator;
import org.compiere.model.MGoal;
import org.compiere.swing.CPanel;
import org.compiere.swing.CScrollPane;
import org.compiere.util.CLogger;
import org.compiere.util.Env;

public class ViewPI
extends CPanel
implements FormPanel,
ActionListener {
    private int m_WindowNo = 0;
    private FormFrame m_frame;
    private static CLogger log = CLogger.getCLogger(ViewPI.class);
    private ConfirmPanel confirmPanel = new ConfirmPanel();

    public void init(int WindowNo, FormFrame frame) {
        log.fine("");
        this.m_WindowNo = WindowNo;
        this.m_frame = frame;
        try {
            this.initPanel();
            CScrollPane scroll = new CScrollPane(this);
            this.m_frame.getContentPane().add((Component)scroll, "Center");
            this.confirmPanel.addActionListener(this);
            this.m_frame.getContentPane().add((Component)this.confirmPanel, "South");
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "", e);
        }
        this.sizeIt();
    }

    private void sizeIt() {
        this.m_frame.pack();
    }

    public void dispose() {
        if (this.m_frame != null) {
            this.m_frame.dispose();
        }
        this.m_frame = null;
        this.removeAll();
    }

    private void initPanel() {
        BoxLayout layout = new BoxLayout(this, 3);
        MGoal[] goals = MGoal.getGoals(Env.getCtx());
        for (int i = 0; i < goals.length; ++i) {
            PerformanceIndicator pi = new PerformanceIndicator(goals[i]);
            pi.addActionListener(this);
            this.add(pi);
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("Ok")) {
            this.dispose();
        } else if (e.getSource() instanceof PerformanceIndicator) {
            PerformanceIndicator pi = (PerformanceIndicator)e.getSource();
            log.info(pi.getName());
            MGoal goal = pi.getGoal();
            if (goal.getMeasure() != null) {
                new PerformanceDetail(goal);
            }
        }
    }
}

