/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps.graph;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import org.compiere.apps.graph.PerformanceDetail;
import org.compiere.apps.graph.PerformanceIndicator;
import org.compiere.model.MGoal;
import org.compiere.swing.CPanel;
import org.compiere.util.CLogger;
import org.compiere.util.Env;

public class PAPanel
extends CPanel
implements ActionListener {
    private MGoal[] m_goals = null;
    private static CLogger log = CLogger.getCLogger(PAPanel.class);

    public static PAPanel get() {
        int AD_User_ID = Env.getAD_User_ID(Env.getCtx());
        MGoal[] goals = MGoal.getUserGoals(Env.getCtx(), AD_User_ID);
        if (goals.length == 0) {
            return null;
        }
        return new PAPanel(goals);
    }

    private PAPanel(MGoal[] goals) {
        this.m_goals = goals;
        this.init();
    }

    private void init() {
        BoxLayout layout = new BoxLayout(this, 3);
        for (int i = 0; i < this.m_goals.length; ++i) {
            PerformanceIndicator pi = new PerformanceIndicator(this.m_goals[i]);
            pi.addActionListener(this);
            this.add(pi);
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof PerformanceIndicator) {
            PerformanceIndicator pi = (PerformanceIndicator)e.getSource();
            log.info(pi.getName());
            MGoal goal = pi.getGoal();
            if (goal.getMeasure() != null) {
                new PerformanceDetail(goal);
            }
        }
    }
}

