/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps.graph;

import java.awt.Color;
import java.util.ArrayList;
import org.compiere.util.CLogger;

public class GraphUtil {
    private static CLogger log = CLogger.getCLogger(GraphUtil.class);
    private static ArrayList<Color> s_colors = new ArrayList();

    public static Color getForeground(Color background) {
        if (background != null && GraphUtil.isDark(background)) {
            return Color.white;
        }
        return Color.black;
    }

    public static Color getBackground(int index) {
        while (s_colors.size() <= index) {
            int rr = (index + 1) * 47;
            int gg = 100;
            while (rr > 255) {
                rr -= 255;
                gg += 50;
            }
            while (gg > 255) {
                gg -= 255;
            }
            s_colors.add(new Color(255 - rr, gg, rr));
        }
        return s_colors.get(index);
    }

    public static boolean isDark(Color color) {
        boolean dark;
        float r = (float)color.getRed() / 255.0f;
        float g = (float)color.getGreen() / 255.0f;
        float b = (float)color.getBlue() / 255.0f;
        double whiteDistance = GraphUtil.colorDistance(r, g, b, 1.0, 1.0, 1.0);
        double blackDistance = GraphUtil.colorDistance(r, g, b, 0.0, 0.0, 0.0);
        boolean bl = dark = blackDistance < whiteDistance;
        if ((double)(r + g + b) == 1.0) {
            dark = false;
        }
        return dark;
    }

    public static boolean isDark(double r, double g, double b) {
        double whiteDistance = GraphUtil.colorDistance(r, g, b, 1.0, 1.0, 1.0);
        double blackDistance = GraphUtil.colorDistance(r, g, b, 0.0, 0.0, 0.0);
        boolean dark = blackDistance < whiteDistance;
        return dark;
    }

    public static double colorDistance(double r1, double g1, double b1, double r2, double g2, double b2) {
        double a = r2 - r1 + 0.1;
        double b = g2 - g1 + 0.1;
        double c = b2 - b1 + 0.1;
        return Math.sqrt(a * a + b * b + c * c);
    }

    public static Color darker(Color color, double factor) {
        if (factor < 0.0) {
            factor = 0.7;
        } else if (factor > 1.0) {
            factor = 0.7;
        }
        return new Color(Math.max((int)((double)color.getRed() * factor), 0), Math.max((int)((double)color.getGreen() * factor), 0), Math.max((int)((double)color.getBlue() * factor), 0));
    }

    public static Color brighter(Color color, double factor) {
        if (factor < 0.0) {
            factor = 0.7;
        } else if (factor > 1.0) {
            factor = 0.7;
        }
        return new Color(Math.min((int)((double)color.getRed() / factor), 255), Math.min((int)((double)color.getGreen() / factor), 255), Math.min((int)((double)color.getBlue() / factor), 255));
    }
}

