/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps.form;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.VetoableChangeListener;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.logging.Level;
import javax.swing.JLabel;
import org.compiere.apps.AEnv;
import org.compiere.apps.AWindow;
import org.compiere.apps.ConfirmPanel;
import org.compiere.apps.StatusBar;
import org.compiere.apps.form.FormFrame;
import org.compiere.apps.form.FormPanel;
import org.compiere.grid.GridController;
import org.compiere.grid.ed.VDate;
import org.compiere.grid.ed.VLocator;
import org.compiere.grid.ed.VLookup;
import org.compiere.model.GridTab;
import org.compiere.model.GridWindow;
import org.compiere.model.GridWindowVO;
import org.compiere.model.MLocatorLookup;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MQuery;
import org.compiere.plaf.CompiereColor;
import org.compiere.swing.CPanel;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class VTrxMaterial
extends CPanel
implements FormPanel,
ActionListener,
VetoableChangeListener {
    private int m_WindowNo = 0;
    private FormFrame m_frame;
    private GridController m_gridController = null;
    private GridWindow m_mWindow = null;
    private GridTab m_mTab = null;
    private MQuery m_staticQuery = null;
    private static CLogger log = CLogger.getCLogger(VTrxMaterial.class);
    private CPanel mainPanel = new CPanel();
    private BorderLayout mainLayout = new BorderLayout();
    private CPanel parameterPanel = new CPanel();
    private JLabel orgLabel = new JLabel();
    private VLookup orgField;
    private JLabel locatorLabel = new JLabel();
    private VLocator locatorField;
    private JLabel productLabel = new JLabel();
    private VLookup productField;
    private JLabel dateFLabel = new JLabel();
    private VDate dateFField;
    private JLabel dateTLabel = new JLabel();
    private VDate dateTField;
    private JLabel mtypeLabel = new JLabel();
    private VLookup mtypeField;
    private GridBagLayout parameterLayout = new GridBagLayout();
    private CPanel southPanel = new CPanel();
    private BorderLayout southLayout = new BorderLayout();
    private ConfirmPanel confirmPanel = new ConfirmPanel(true, true, false, false, false, true, true);
    private StatusBar statusBar = new StatusBar();

    public void init(int WindowNo, FormFrame frame) {
        log.info("");
        this.m_WindowNo = WindowNo;
        this.m_frame = frame;
        try {
            this.dynParameter();
            this.jbInit();
            this.dynInit();
            frame.getContentPane().add((Component)this.mainPanel, "Center");
            frame.getContentPane().add((Component)this.statusBar, "South");
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "", ex);
        }
    }

    void jbInit() throws Exception {
        CompiereColor.setBackground(this);
        this.mainPanel.setLayout(this.mainLayout);
        this.mainLayout.setVgap(10);
        this.parameterPanel.setLayout(this.parameterLayout);
        this.orgLabel.setText(Msg.translate(Env.getCtx(), "AD_Org_ID"));
        this.locatorLabel.setText(Msg.translate(Env.getCtx(), "M_Locator_ID"));
        this.productLabel.setText(Msg.translate(Env.getCtx(), "Product"));
        this.dateFLabel.setText(Msg.translate(Env.getCtx(), "DateFrom"));
        this.dateTLabel.setText(Msg.translate(Env.getCtx(), "DateTo"));
        this.mtypeLabel.setText(Msg.translate(Env.getCtx(), "MovementType"));
        this.mainPanel.add((Component)this.parameterPanel, "North");
        this.parameterPanel.add((Component)this.orgLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.parameterPanel.add((Component)this.orgField, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 5), 0, 0));
        this.parameterPanel.add((Component)this.mtypeLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.parameterPanel.add((Component)this.mtypeField, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 5), 0, 0));
        this.parameterPanel.add((Component)this.dateFLabel, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.parameterPanel.add((Component)this.dateFField, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 5), 0, 0));
        this.parameterPanel.add((Component)this.locatorLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.parameterPanel.add((Component)this.locatorField, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 5), 0, 0));
        this.parameterPanel.add((Component)this.productLabel, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.parameterPanel.add((Component)this.productField, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 5), 0, 0));
        this.parameterPanel.add((Component)this.dateTLabel, new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.parameterPanel.add((Component)this.dateTField, new GridBagConstraints(5, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 5), 0, 0));
        this.southPanel.setLayout(this.southLayout);
        this.southPanel.add((Component)this.confirmPanel, "North");
        this.southPanel.add((Component)this.statusBar, "South");
        this.mainPanel.add((Component)this.southPanel, "South");
    }

    private void dynParameter() throws Exception {
        Properties ctx = Env.getCtx();
        MLookup orgLookup = MLookupFactory.get(ctx, this.m_WindowNo, 0, 3660, 19);
        this.orgField = new VLookup("AD_Org_ID", false, false, true, orgLookup);
        MLocatorLookup locatorLookup = new MLocatorLookup(ctx, this.m_WindowNo);
        this.locatorField = new VLocator("M_Locator_ID", false, false, true, locatorLookup, this.m_WindowNo);
        MLookup productLookup = MLookupFactory.get(ctx, this.m_WindowNo, 0, 3668, 30);
        this.productField = new VLookup("M_Product_ID", false, false, true, productLookup);
        this.productField.addVetoableChangeListener(this);
        MLookup mtypeLookup = MLookupFactory.get(ctx, this.m_WindowNo, 0, 3666, 17);
        this.mtypeField = new VLookup("MovementType", false, false, true, mtypeLookup);
        this.dateFField = new VDate("DateFrom", false, false, true, 15, Msg.getMsg(Env.getCtx(), "DateFrom"));
        this.dateTField = new VDate("DateTo", false, false, true, 15, Msg.getMsg(Env.getCtx(), "DateTo"));
        this.confirmPanel.addActionListener(this);
        this.statusBar.setStatusLine("");
    }

    private void dynInit() {
        this.m_staticQuery = new MQuery();
        this.m_staticQuery.addRestriction("AD_Client_ID", "=", Env.getAD_Client_ID(Env.getCtx()));
        int AD_Window_ID = 223;
        GridWindowVO wVO = AEnv.getMWindowVO(this.m_WindowNo, AD_Window_ID, 0);
        if (wVO == null) {
            return;
        }
        this.m_mWindow = new GridWindow(wVO);
        this.m_mTab = this.m_mWindow.getTab(0);
        this.m_gridController = new GridController();
        this.m_gridController.initGrid(this.m_mTab, true, this.m_WindowNo, null, null);
        this.mainPanel.add((Component)this.m_gridController, "Center");
        this.m_mTab.setQuery(MQuery.getEqualQuery("1", "2"));
        this.m_mTab.query(false);
        this.statusBar.setStatusLine(" ", false);
        this.statusBar.setStatusDB(" ");
    }

    public void dispose() {
        if (this.m_gridController != null) {
            this.m_gridController.dispose();
        }
        this.m_gridController = null;
        this.m_mTab = null;
        if (this.m_mWindow != null) {
            this.m_mWindow.dispose();
        }
        this.m_mWindow = null;
        this.orgField = null;
        this.locatorField = null;
        this.productField = null;
        this.mtypeField = null;
        this.dateFField = null;
        this.dateTField = null;
        if (this.m_frame != null) {
            this.m_frame.dispose();
        }
        this.m_frame = null;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("Cancel")) {
            this.dispose();
        } else if (e.getActionCommand().equals("Refresh") || e.getActionCommand().equals("Ok")) {
            this.refresh();
        } else if (e.getActionCommand().equals("Zoom")) {
            this.zoom();
        }
    }

    public void vetoableChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("M_Product_ID")) {
            this.productField.setValue(e.getNewValue());
        }
    }

    private void refresh() {
        Timestamp ts;
        MQuery query = this.m_staticQuery.deepCopy();
        Object value = this.orgField.getValue();
        if (value != null && value.toString().length() > 0) {
            query.addRestriction("AD_Org_ID", "=", value);
        }
        if ((value = this.locatorField.getValue()) != null && value.toString().length() > 0) {
            query.addRestriction("M_Locator_ID", "=", value);
        }
        if ((value = this.productField.getValue()) != null && value.toString().length() > 0) {
            query.addRestriction("M_Product_ID", "=", value);
        }
        if ((value = this.mtypeField.getValue()) != null && value.toString().length() > 0) {
            query.addRestriction("MovementType", "=", value);
        }
        if ((ts = (Timestamp)this.dateFField.getValue()) != null) {
            query.addRestriction("TRUNC(MovementDate)", ">=", ts);
        }
        if ((ts = (Timestamp)this.dateTField.getValue()) != null) {
            query.addRestriction("TRUNC(MovementDate)", "<=", ts);
        }
        log.info("VTrxMaterial.refresh query=" + query.toString());
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.statusBar.setStatusLine(Msg.getMsg(Env.getCtx(), "StartSearch"), false);
        this.m_mTab.setQuery(query);
        this.m_mTab.query(false);
        this.setCursor(Cursor.getDefaultCursor());
        int no = this.m_mTab.getRowCount();
        this.statusBar.setStatusLine(" ", false);
        this.statusBar.setStatusDB(Integer.toString(no));
    }

    private void zoom() {
        log.info("");
        int AD_Window_ID = 0;
        String ColumnName = null;
        String SQL = null;
        int lineID = Env.getContextAsInt(Env.getCtx(), this.m_WindowNo, "M_InOutLine_ID");
        if (lineID != 0) {
            log.fine("M_InOutLine_ID=" + lineID);
            AD_Window_ID = Env.getContext(Env.getCtx(), this.m_WindowNo, "MovementType").startsWith("C") ? 169 : 184;
            ColumnName = "M_InOut_ID";
            SQL = "SELECT M_InOut_ID FROM M_InOutLine WHERE M_InOutLine_ID=?";
        } else {
            lineID = Env.getContextAsInt(Env.getCtx(), this.m_WindowNo, "M_InventoryLine_ID");
            if (lineID != 0) {
                log.fine("M_InventoryLine_ID=" + lineID);
                AD_Window_ID = 168;
                ColumnName = "M_Inventory_ID";
                SQL = "SELECT M_Inventory_ID FROM M_InventoryLine WHERE M_InventoryLine_ID=?";
            } else {
                lineID = Env.getContextAsInt(Env.getCtx(), this.m_WindowNo, "M_MovementLine_ID");
                if (lineID != 0) {
                    log.fine("M_MovementLine_ID=" + lineID);
                    AD_Window_ID = 170;
                    ColumnName = "M_Movement_ID";
                    SQL = "SELECT M_Movement_ID FROM M_MovementLine WHERE M_MovementLine_ID=?";
                } else {
                    lineID = Env.getContextAsInt(Env.getCtx(), this.m_WindowNo, "M_ProductionLine_ID");
                    if (lineID != 0) {
                        log.fine("M_ProductionLine_ID=" + lineID);
                        AD_Window_ID = 191;
                        ColumnName = "M_Production_ID";
                        SQL = "SELECT M_Production_ID FROM M_ProductionLine WHERE M_ProductionLine_ID=?";
                    } else {
                        log.fine("Not found WindowNo=" + this.m_WindowNo);
                    }
                }
            }
        }
        if (AD_Window_ID == 0) {
            return;
        }
        int parentID = 0;
        try {
            CPreparedStatement pstmt = DB.prepareStatement(SQL, null);
            pstmt.setInt(1, lineID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                parentID = rs.getInt(1);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, SQL, e);
        }
        MQuery query = MQuery.getEqualQuery(ColumnName, parentID);
        log.config("AD_Window_ID=" + AD_Window_ID + " - " + query);
        if (parentID == 0) {
            log.log(Level.SEVERE, "No ParentValue - " + SQL + " - " + lineID);
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        AWindow frame = new AWindow();
        if (!frame.initWindow(AD_Window_ID, query)) {
            this.setCursor(Cursor.getDefaultCursor());
            return;
        }
        AEnv.addToWindowManager(frame);
        AEnv.showCenterScreen(frame);
        frame = null;
        this.setCursor(Cursor.getDefaultCursor());
    }
}

