/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps.form;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.ResultSet;
import java.util.logging.Level;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.compiere.apps.form.FormFrame;
import org.compiere.apps.form.FormPanel;
import org.compiere.grid.tree.VTreePanel;
import org.compiere.model.MRole;
import org.compiere.model.MTree;
import org.compiere.model.MTreeNode;
import org.compiere.model.MTree_Node;
import org.compiere.model.MTree_NodeBP;
import org.compiere.model.MTree_NodeMM;
import org.compiere.model.MTree_NodePR;
import org.compiere.swing.CButton;
import org.compiere.swing.CCheckBox;
import org.compiere.swing.CComboBox;
import org.compiere.swing.CLabel;
import org.compiere.swing.CPanel;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;

public class VTreeMaintenance
extends CPanel
implements FormPanel,
ActionListener,
ListSelectionListener,
PropertyChangeListener {
    private int m_WindowNo = 0;
    private FormFrame m_frame;
    private MTree m_tree;
    private static CLogger log = CLogger.getCLogger(VTreeMaintenance.class);
    private BorderLayout mainLayout = new BorderLayout();
    private CPanel northPanel = new CPanel();
    private FlowLayout northLayout = new FlowLayout();
    private CLabel treeLabel = new CLabel();
    private CComboBox treeField;
    private CButton bAddAll = new CButton(Env.getImageIcon("FastBack24.gif"));
    private CButton bAdd = new CButton(Env.getImageIcon("StepBack24.gif"));
    private CButton bDelete = new CButton(Env.getImageIcon("StepForward24.gif"));
    private CButton bDeleteAll = new CButton(Env.getImageIcon("FastForward24.gif"));
    private CCheckBox cbAllNodes = new CCheckBox();
    private CLabel treeInfo = new CLabel();
    private JSplitPane splitPane = new JSplitPane();
    private VTreePanel centerTree;
    private JList centerList = new JList();

    public void init(int WindowNo, FormFrame frame) {
        this.m_WindowNo = WindowNo;
        this.m_frame = frame;
        log.info("VMerge.init - WinNo=" + this.m_WindowNo);
        try {
            this.preInit();
            this.jbInit();
            frame.getContentPane().add((Component)this, "Center");
            this.action_loadTree();
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "VTreeMaintenance.init", ex);
        }
    }

    private void preInit() {
        Object[] trees = DB.getKeyNamePairs(MRole.getDefault().addAccessSQL("SELECT AD_Tree_ID, Name FROM AD_Tree WHERE TreeType NOT IN ('BB','PC') ORDER BY 2", "AD_Tree", false, true), false);
        this.treeField = new CComboBox(trees);
        this.treeField.addActionListener(this);
        this.centerTree = new VTreePanel(this.m_WindowNo, false, true);
        this.centerTree.addPropertyChangeListener("NodeSelected", this);
    }

    private void jbInit() throws Exception {
        this.setLayout(this.mainLayout);
        this.treeLabel.setText(Msg.translate(Env.getCtx(), "AD_Tree_ID"));
        this.cbAllNodes.setEnabled(false);
        this.cbAllNodes.setText(Msg.translate(Env.getCtx(), "IsAllNodes"));
        this.treeInfo.setText(" ");
        this.bAdd.setToolTipText("Add to Tree");
        this.bAddAll.setToolTipText("Add ALL to Tree");
        this.bDelete.setToolTipText("Delete from Tree");
        this.bDeleteAll.setToolTipText("Delete ALL from Tree");
        this.bAdd.addActionListener(this);
        this.bAddAll.addActionListener(this);
        this.bDelete.addActionListener(this);
        this.bDeleteAll.addActionListener(this);
        this.northPanel.setLayout(this.northLayout);
        this.northLayout.setAlignment(0);
        this.add((Component)this.northPanel, "North");
        this.northPanel.add((Component)this.treeLabel, null);
        this.northPanel.add((Component)this.treeField, null);
        this.northPanel.add((Component)this.cbAllNodes, null);
        this.northPanel.add((Component)this.treeInfo, null);
        this.northPanel.add((Component)this.bAddAll, null);
        this.northPanel.add((Component)this.bAdd, null);
        this.northPanel.add((Component)this.bDelete, null);
        this.northPanel.add((Component)this.bDeleteAll, null);
        this.add((Component)this.splitPane, "Center");
        this.splitPane.add((Component)this.centerTree, "left");
        this.splitPane.add((Component)new JScrollPane(this.centerList), "right");
        this.centerList.setSelectionMode(0);
        this.centerList.addListSelectionListener(this);
    }

    public void dispose() {
        if (this.m_frame != null) {
            this.m_frame.dispose();
        }
        this.m_frame = null;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.treeField) {
            this.action_loadTree();
        } else if (e.getSource() == this.bAddAll) {
            this.action_treeAddAll();
        } else if (e.getSource() == this.bAdd) {
            this.action_treeAdd((ListItem)this.centerList.getSelectedValue());
        } else if (e.getSource() == this.bDelete) {
            this.action_treeDelete((ListItem)this.centerList.getSelectedValue());
        } else if (e.getSource() == this.bDeleteAll) {
            this.action_treeDeleteAll();
        }
    }

    private void action_loadTree() {
        KeyNamePair tree = (KeyNamePair)this.treeField.getSelectedItem();
        log.info("Tree=" + tree);
        if (tree.getKey() <= 0) {
            this.centerList.setModel(new DefaultListModel());
            return;
        }
        this.m_tree = new MTree(Env.getCtx(), tree.getKey(), null);
        this.cbAllNodes.setSelected(this.m_tree.isAllNodes());
        this.bAddAll.setEnabled(!this.m_tree.isAllNodes());
        this.bAdd.setEnabled(!this.m_tree.isAllNodes());
        this.bDelete.setEnabled(!this.m_tree.isAllNodes());
        this.bDeleteAll.setEnabled(!this.m_tree.isAllNodes());
        String fromClause = this.m_tree.getSourceTableName(false);
        String columnNameX = this.m_tree.getSourceTableName(true);
        String actionColor = this.m_tree.getActionColorName();
        DefaultListModel<ListItem> model = new DefaultListModel<ListItem>();
        String sql = "SELECT t." + columnNameX + "_ID,t.Name,t.Description,t.IsSummary," + actionColor + " FROM " + fromClause + " ORDER BY 2";
        sql = MRole.getDefault().addAccessSQL(sql, "t", true, false);
        log.config(sql);
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                ListItem item = new ListItem(rs.getInt(1), rs.getString(2), rs.getString(3), "Y".equals(rs.getString(4)), rs.getString(5));
                model.addElement(item);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        log.config("#" + model.getSize());
        this.centerList.setModel(model);
        this.centerTree.initTree(this.m_tree.getAD_Tree_ID());
    }

    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        ListItem selected = null;
        try {
            selected = (ListItem)this.centerList.getSelectedValue();
        }
        catch (Exception exception) {
            // empty catch block
        }
        log.info("Selected=" + selected);
        if (selected != null) {
            this.bAdd.setEnabled(!this.centerTree.setSelectedNode(selected.id));
        }
    }

    public void propertyChange(PropertyChangeEvent e) {
        MTreeNode tn = (MTreeNode)e.getNewValue();
        log.info(tn.toString());
        if (tn == null) {
            return;
        }
        ListModel model = this.centerList.getModel();
        int size = model.getSize();
        int index = -1;
        for (index = 0; index < size; ++index) {
            ListItem item = (ListItem)model.getElementAt(index);
            if (item.id == tn.getNode_ID()) break;
        }
        this.centerList.setSelectedIndex(index);
    }

    private void action_treeAdd(ListItem item) {
        log.info("Item=" + item);
        if (item != null) {
            this.centerTree.nodeChanged(true, item.id, item.name, item.description, item.isSummary, item.imageIndicator);
            if (this.m_tree.isProduct()) {
                MTree_NodePR node = new MTree_NodePR(this.m_tree, item.id);
                node.save();
            } else if (this.m_tree.isBPartner()) {
                MTree_NodeBP node = new MTree_NodeBP(this.m_tree, item.id);
                node.save();
            } else if (this.m_tree.isMenu()) {
                MTree_NodeMM node = new MTree_NodeMM(this.m_tree, item.id);
                node.save();
            } else {
                MTree_Node node = new MTree_Node(this.m_tree, item.id);
                node.save();
            }
        }
    }

    private void action_treeDelete(ListItem item) {
        log.info("Item=" + item);
        if (item != null) {
            this.centerTree.nodeChanged(false, item.id, item.name, item.description, item.isSummary, item.imageIndicator);
            if (this.m_tree.isProduct()) {
                MTree_NodePR node = MTree_NodePR.get(this.m_tree, item.id);
                if (node != null) {
                    node.delete(true);
                }
            } else if (this.m_tree.isBPartner()) {
                MTree_NodeBP node = MTree_NodeBP.get(this.m_tree, item.id);
                if (node != null) {
                    node.delete(true);
                }
            } else if (this.m_tree.isMenu()) {
                MTree_NodeMM node = MTree_NodeMM.get(this.m_tree, item.id);
                if (node != null) {
                    node.delete(true);
                }
            } else {
                MTree_Node node = MTree_Node.get(this.m_tree, item.id);
                if (node != null) {
                    node.delete(true);
                }
            }
        }
    }

    private void action_treeAddAll() {
        log.info("");
        ListModel model = this.centerList.getModel();
        int size = model.getSize();
        int index = -1;
        for (index = 0; index < size; ++index) {
            ListItem item = (ListItem)model.getElementAt(index);
            this.action_treeAdd(item);
        }
    }

    private void action_treeDeleteAll() {
        log.info("");
        ListModel model = this.centerList.getModel();
        int size = model.getSize();
        int index = -1;
        for (index = 0; index < size; ++index) {
            ListItem item = (ListItem)model.getElementAt(index);
            this.action_treeDelete(item);
        }
    }

    class ListItem {
        public int id;
        public String name;
        public String description;
        public boolean isSummary;
        public String imageIndicator;

        public ListItem(int ID, String Name, String Description, boolean summary, String ImageIndicator) {
            this.id = ID;
            this.name = Name;
            this.description = Description;
            this.isSummary = summary;
            this.imageIndicator = ImageIndicator;
        }

        public String toString() {
            String retValue = this.name;
            if (this.description != null && this.description.length() > 0) {
                retValue = retValue + " (" + this.description + ")";
            }
            return retValue;
        }
    }
}

