/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps.form;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.util.Properties;
import java.util.logging.Level;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.compiere.apps.ADialog;
import org.compiere.apps.AEnv;
import org.compiere.apps.ConfirmPanel;
import org.compiere.apps.ProcessCtl;
import org.compiere.apps.form.FormFrame;
import org.compiere.apps.form.FormPanel;
import org.compiere.apps.form.VPayPrint;
import org.compiere.grid.ed.VCheckBox;
import org.compiere.grid.ed.VComboBox;
import org.compiere.grid.ed.VDate;
import org.compiere.minigrid.ColumnInfo;
import org.compiere.minigrid.IDColumn;
import org.compiere.minigrid.MiniTable;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MLookupInfo;
import org.compiere.model.MPaySelection;
import org.compiere.model.MPaySelectionLine;
import org.compiere.model.MRole;
import org.compiere.plaf.CompiereColor;
import org.compiere.process.ProcessInfo;
import org.compiere.swing.CLabel;
import org.compiere.swing.CPanel;
import org.compiere.util.ASyncProcess;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Language;
import org.compiere.util.Msg;
import org.compiere.util.Trx;
import org.compiere.util.ValueNamePair;

public class VPaySelect
extends CPanel
implements FormPanel,
ActionListener,
TableModelListener,
ASyncProcess {
    private int m_WindowNo = 0;
    private FormFrame m_frame;
    private DecimalFormat m_format = DisplayType.getNumberFormat(12);
    private BigDecimal m_bankBalance = new BigDecimal(0.0);
    private String m_sql;
    private int m_noSelected = 0;
    private int m_AD_Client_ID = 0;
    private boolean m_isLocked = false;
    private MPaySelection m_ps = null;
    private static CLogger log = CLogger.getCLogger(VPaySelect.class);
    private CPanel mainPanel = new CPanel();
    private BorderLayout mainLayout = new BorderLayout();
    private CPanel parameterPanel = new CPanel();
    private CLabel labelBankAccount = new CLabel();
    private VComboBox fieldBankAccount = new VComboBox();
    private GridBagLayout parameterLayout = new GridBagLayout();
    private CLabel labelBankBalance = new CLabel();
    private CLabel labelCurrency = new CLabel();
    private CLabel labelBalance = new CLabel();
    private VCheckBox onlyDue = new VCheckBox();
    private CLabel labelBPartner = new CLabel();
    private VComboBox fieldBPartner = new VComboBox();
    private JLabel dataStatus = new JLabel();
    private JScrollPane dataPane = new JScrollPane();
    private MiniTable miniTable = new MiniTable();
    private CPanel commandPanel = new CPanel();
    private JButton bCancel = ConfirmPanel.createCancelButton(true);
    private JButton bGenerate = ConfirmPanel.createProcessButton(true);
    private FlowLayout commandLayout = new FlowLayout();
    private JButton bRefresh = ConfirmPanel.createRefreshButton(true);
    private CLabel labelPayDate = new CLabel();
    private VDate fieldPayDate = new VDate();
    private CLabel labelPaymentRule = new CLabel();
    private VComboBox fieldPaymentRule = new VComboBox();

    public void init(int WindowNo, FormFrame frame) {
        log.info("");
        this.m_WindowNo = WindowNo;
        this.m_frame = frame;
        try {
            this.jbInit();
            this.dynInit();
            frame.getContentPane().add((Component)this.commandPanel, "South");
            frame.getContentPane().add((Component)this.mainPanel, "Center");
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "", e);
        }
    }

    private void jbInit() throws Exception {
        CompiereColor.setBackground(this);
        this.mainPanel.setLayout(this.mainLayout);
        this.parameterPanel.setLayout(this.parameterLayout);
        this.labelBankAccount.setText(Msg.translate(Env.getCtx(), "C_BankAccount_ID"));
        this.fieldBankAccount.addActionListener(this);
        this.labelBPartner.setText(Msg.translate(Env.getCtx(), "C_BPartner_ID"));
        this.fieldBPartner.addActionListener(this);
        this.bRefresh.addActionListener(this);
        this.labelPayDate.setText(Msg.translate(Env.getCtx(), "PayDate"));
        this.labelPaymentRule.setText(Msg.translate(Env.getCtx(), "PaymentRule"));
        this.fieldPaymentRule.addActionListener(this);
        this.labelBankBalance.setText(Msg.translate(Env.getCtx(), "CurrentBalance"));
        this.labelBalance.setText("0");
        this.onlyDue.setText(Msg.getMsg(Env.getCtx(), "OnlyDue"));
        this.dataStatus.setText(" ");
        this.bGenerate.addActionListener(this);
        this.bCancel.addActionListener(this);
        this.mainPanel.add((Component)this.parameterPanel, "North");
        this.parameterPanel.add((Component)this.labelBankAccount, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.fieldBankAccount, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.labelBankBalance, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.labelCurrency, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.labelBalance, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.labelBPartner, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.fieldBPartner, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.bRefresh, new GridBagConstraints(4, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.labelPayDate, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.fieldPayDate, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.labelPaymentRule, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.fieldPaymentRule, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.onlyDue, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.mainPanel.add((Component)this.dataStatus, "South");
        this.mainPanel.add((Component)this.dataPane, "Center");
        this.dataPane.getViewport().add((Component)this.miniTable, null);
        this.commandPanel.setLayout(this.commandLayout);
        this.commandLayout.setAlignment(2);
        this.commandLayout.setHgap(10);
        this.commandPanel.add((Component)this.bCancel, null);
        this.commandPanel.add((Component)this.bGenerate, null);
    }

    private void dynInit() {
        Properties ctx = Env.getCtx();
        String sql = MRole.getDefault().addAccessSQL("SELECT ba.C_BankAccount_ID,b.Name || ' ' || ba.AccountNo AS Name,ba.C_Currency_ID, c.ISO_Code,ba.CurrentBalance FROM C_Bank b, C_BankAccount ba, C_Currency c WHERE b.C_Bank_ID=ba.C_Bank_ID AND ba.C_Currency_ID=c.C_Currency_ID  AND EXISTS (SELECT * FROM C_BankAccountDoc d WHERE d.C_BankAccount_ID=ba.C_BankAccount_ID) ORDER BY 2", "b", true, true);
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql, null);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                boolean transfers = false;
                BankInfo bi = new BankInfo(rs.getInt(1), rs.getInt(3), rs.getString(2), rs.getString(4), rs.getBigDecimal(5), transfers);
                this.fieldBankAccount.addItem(bi);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, sql, e);
        }
        if (this.fieldBankAccount.getItemCount() == 0) {
            ADialog.error(this.m_WindowNo, this, "VPaySelectNoBank");
        } else {
            this.fieldBankAccount.setSelectedIndex(0);
        }
        KeyNamePair pp = new KeyNamePair(0, "");
        this.fieldBPartner.addItem(pp);
        sql = MRole.getDefault().addAccessSQL("SELECT bp.C_BPartner_ID, bp.Name FROM C_BPartner bp", "bp", true, false) + " AND EXISTS (SELECT * FROM C_Invoice i WHERE bp.C_BPartner_ID=i.C_BPartner_ID" + " AND (i.IsSOTrx='N' OR (i.IsSOTrx='Y' AND i.PaymentRule='D'))" + " AND i.IsPaid<>'Y') " + "ORDER BY 2";
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql, null);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                pp = new KeyNamePair(rs.getInt(1), rs.getString(2));
                this.fieldBPartner.addItem(pp);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, sql, e);
        }
        this.fieldBPartner.setSelectedIndex(0);
        this.m_sql = this.miniTable.prepareTable(new ColumnInfo[]{new ColumnInfo(" ", "i.C_Invoice_ID", IDColumn.class, false, false, null), new ColumnInfo(Msg.translate(ctx, "DueDate"), "i.DateInvoiced+p.NetDays AS DateDue", Timestamp.class, true, true, null), new ColumnInfo(Msg.translate(ctx, "C_BPartner_ID"), "bp.Name", KeyNamePair.class, true, false, "i.C_BPartner_ID"), new ColumnInfo(Msg.translate(ctx, "DocumentNo"), "i.DocumentNo", String.class), new ColumnInfo(Msg.translate(ctx, "C_Currency_ID"), "c.ISO_Code", KeyNamePair.class, true, false, "i.C_Currency_ID"), new ColumnInfo(Msg.translate(ctx, "GrandTotal"), "i.GrandTotal", BigDecimal.class), new ColumnInfo(Msg.translate(ctx, "DiscountAmt"), "paymentTermDiscount(i.GrandTotal,i.C_Currency_ID,i.C_PaymentTerm_ID,i.DateInvoiced, ?)", BigDecimal.class), new ColumnInfo(Msg.getMsg(ctx, "DiscountDate"), "SysDate-paymentTermDueDays(i.C_PaymentTerm_ID,i.DateInvoiced,SysDate)", Timestamp.class), new ColumnInfo(Msg.getMsg(ctx, "AmountDue"), "currencyConvert(invoiceOpen(i.C_Invoice_ID,i.C_InvoicePaySchedule_ID),i.C_Currency_ID, ?,?,i.C_ConversionType_ID, i.AD_Client_ID,i.AD_Org_ID)", BigDecimal.class), new ColumnInfo(Msg.getMsg(ctx, "AmountPay"), "currencyConvert(invoiceOpen(i.C_Invoice_ID,i.C_InvoicePaySchedule_ID)-paymentTermDiscount(i.GrandTotal,i.C_Currency_ID,i.C_PaymentTerm_ID,i.DateInvoiced, ?),i.C_Currency_ID, ?,?,i.C_ConversionType_ID, i.AD_Client_ID,i.AD_Org_ID)", BigDecimal.class)}, "C_Invoice_v i INNER JOIN C_BPartner bp ON (i.C_BPartner_ID=bp.C_BPartner_ID) INNER JOIN C_Currency c ON (i.C_Currency_ID=c.C_Currency_ID) INNER JOIN C_PaymentTerm p ON (i.C_PaymentTerm_ID=p.C_PaymentTerm_ID)", "i.IsSOTrx=? AND IsPaid='N' AND NOT EXISTS (SELECT * FROM C_PaySelectionLine psl WHERE i.C_Invoice_ID=psl.C_Invoice_ID AND psl.C_PaySelectionCheck_ID IS NOT NULL) AND i.DocStatus IN ('CO','CL') AND i.AD_Client_ID=?", true, "i");
        this.miniTable.getModel().addTableModelListener(this);
        this.fieldPayDate.setMandatory(true);
        this.fieldPayDate.setValue(new Timestamp(System.currentTimeMillis()));
        this.m_AD_Client_ID = Env.getAD_Client_ID(Env.getCtx());
    }

    private void loadBankInfo() {
        BankInfo bi = (BankInfo)this.fieldBankAccount.getSelectedItem();
        if (bi == null) {
            return;
        }
        this.labelCurrency.setText(bi.Currency);
        this.labelBalance.setText(this.m_format.format(bi.Balance));
        this.m_bankBalance = bi.Balance;
        this.fieldPaymentRule.removeAllItems();
        int AD_Reference_ID = 195;
        Language language = Env.getLanguage(Env.getCtx());
        MLookupInfo info = MLookupFactory.getLookup_List(language, AD_Reference_ID);
        String sql = info.Query.substring(0, info.Query.indexOf(" ORDER BY")) + " AND " + info.KeyColumn + " IN (SELECT PaymentRule FROM C_BankAccountDoc WHERE C_BankAccount_ID=?) " + info.Query.substring(info.Query.indexOf(" ORDER BY"));
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, bi.C_BankAccount_ID);
            ResultSet rs = pstmt.executeQuery();
            ValueNamePair vp = null;
            while (rs.next()) {
                vp = new ValueNamePair(rs.getString(2), rs.getString(3));
                this.fieldPaymentRule.addItem(vp);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, sql, e);
        }
        this.fieldPaymentRule.setSelectedIndex(0);
    }

    private void loadTableInfo() {
        KeyNamePair pp;
        int C_BPartner_ID;
        log.config("");
        if (this.m_sql == null) {
            return;
        }
        String sql = this.m_sql;
        Timestamp payDate = (Timestamp)this.fieldPayDate.getValue();
        this.miniTable.setColorCompare(payDate);
        log.config("PayDate=" + payDate);
        BankInfo bi = (BankInfo)this.fieldBankAccount.getSelectedItem();
        String isSOTrx = "N";
        ValueNamePair vp = (ValueNamePair)this.fieldPaymentRule.getSelectedItem();
        if (vp != null && "D".equals(vp.getValue())) {
            isSOTrx = "Y";
            sql = sql + " AND i.PaymentRule='D'";
        }
        if (this.onlyDue.isSelected()) {
            sql = sql + " AND i.DateInvoiced+p.NetDays <= ?";
        }
        if ((C_BPartner_ID = (pp = (KeyNamePair)this.fieldBPartner.getSelectedItem()).getKey()) != 0) {
            sql = sql + " AND i.C_BPartner_ID=?";
        }
        sql = sql + " ORDER BY 2,3";
        log.finest(sql + " - C_Currecny_ID=" + bi.C_Currency_ID + ", C_BPartner_ID=" + C_BPartner_ID);
        try {
            int index = 1;
            CPreparedStatement pstmt = DB.prepareStatement(sql, null);
            pstmt.setTimestamp(index++, payDate);
            pstmt.setInt(index++, bi.C_Currency_ID);
            pstmt.setTimestamp(index++, payDate);
            pstmt.setTimestamp(index++, payDate);
            pstmt.setInt(index++, bi.C_Currency_ID);
            pstmt.setTimestamp(index++, payDate);
            pstmt.setString(index++, isSOTrx);
            pstmt.setInt(index++, this.m_AD_Client_ID);
            if (this.onlyDue.isSelected()) {
                pstmt.setTimestamp(index++, payDate);
            }
            if (C_BPartner_ID != 0) {
                pstmt.setInt(index++, C_BPartner_ID);
            }
            ResultSet rs = pstmt.executeQuery();
            this.miniTable.loadTable(rs);
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, sql, e);
        }
        this.calculateSelection();
    }

    public void dispose() {
        if (this.m_frame != null) {
            this.m_frame.dispose();
        }
        this.m_frame = null;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.fieldBankAccount) {
            this.loadBankInfo();
        } else if (e.getSource() == this.bGenerate) {
            this.generatePaySelect();
            this.dispose();
        } else if (e.getSource() == this.bCancel) {
            this.dispose();
        } else if (e.getSource() == this.fieldBPartner || e.getSource() == this.bRefresh) {
            this.loadTableInfo();
        }
    }

    public void tableChanged(TableModelEvent e) {
        if (e.getColumn() == 0) {
            this.calculateSelection();
        }
    }

    public void calculateSelection() {
        this.m_noSelected = 0;
        BigDecimal invoiceAmt = new BigDecimal(0.0);
        int rows = this.miniTable.getRowCount();
        for (int i = 0; i < rows; ++i) {
            IDColumn id = (IDColumn)this.miniTable.getModel().getValueAt(i, 0);
            if (!id.isSelected()) continue;
            BigDecimal amt = (BigDecimal)this.miniTable.getModel().getValueAt(i, 9);
            invoiceAmt = invoiceAmt.add(amt);
            ++this.m_noSelected;
        }
        BigDecimal remaining = this.m_bankBalance.subtract(invoiceAmt);
        StringBuffer info = new StringBuffer();
        info.append(this.m_noSelected).append(" ").append(Msg.getMsg(Env.getCtx(), "Selected")).append(" - ");
        info.append(this.m_format.format(invoiceAmt)).append(", ");
        info.append(Msg.getMsg(Env.getCtx(), "Remaining")).append(" ").append(this.m_format.format(remaining));
        this.dataStatus.setText(info.toString());
        this.bGenerate.setEnabled(this.m_noSelected != 0);
    }

    private void generatePaySelect() {
        log.info("");
        String trxName = null;
        Trx trx = null;
        this.miniTable.stopEditor(true);
        if (this.miniTable.getRowCount() == 0) {
            return;
        }
        this.miniTable.setRowSelectionInterval(0, 0);
        this.calculateSelection();
        if (this.m_noSelected == 0) {
            return;
        }
        String PaymentRule = ((ValueNamePair)this.fieldPaymentRule.getSelectedItem()).getValue();
        this.m_ps = new MPaySelection(Env.getCtx(), 0, trxName);
        this.m_ps.setName(Msg.getMsg(Env.getCtx(), "VPaySelect") + " - " + ((ValueNamePair)this.fieldPaymentRule.getSelectedItem()).getName() + " - " + this.fieldPayDate.getTimestamp());
        this.m_ps.setPayDate(this.fieldPayDate.getTimestamp());
        BankInfo bi = (BankInfo)this.fieldBankAccount.getSelectedItem();
        this.m_ps.setC_BankAccount_ID(bi.C_BankAccount_ID);
        this.m_ps.setIsApproved(true);
        if (!this.m_ps.save()) {
            ADialog.error(this.m_WindowNo, this, "SaveError", Msg.translate(Env.getCtx(), "C_PaySelection_ID"));
            this.m_ps = null;
            return;
        }
        log.config(this.m_ps.toString());
        int rows = this.miniTable.getRowCount();
        int line = 0;
        for (int i = 0; i < rows; ++i) {
            IDColumn id = (IDColumn)this.miniTable.getModel().getValueAt(i, 0);
            if (!id.isSelected()) continue;
            MPaySelectionLine psl = new MPaySelectionLine(this.m_ps, line += 10, PaymentRule);
            int C_Invoice_ID = id.getRecord_ID();
            BigDecimal OpenAmt = (BigDecimal)this.miniTable.getModel().getValueAt(i, 8);
            BigDecimal PayAmt = (BigDecimal)this.miniTable.getModel().getValueAt(i, 9);
            boolean isSOTrx = false;
            psl.setInvoice(C_Invoice_ID, isSOTrx, OpenAmt, PayAmt, OpenAmt.subtract(PayAmt));
            if (!psl.save(trxName)) {
                ADialog.error(this.m_WindowNo, this, "SaveError", Msg.translate(Env.getCtx(), "C_PaySelectionLine_ID"));
                return;
            }
            log.fine("C_Invoice_ID=" + C_Invoice_ID + ", PayAmt=" + PayAmt);
        }
        if (!ADialog.ask(this.m_WindowNo, this, "VPaySelectGenerate?", "(" + this.m_ps.getName() + ")")) {
            return;
        }
        int AD_Proces_ID = 155;
        ProcessInfo pi = new ProcessInfo(this.m_frame.getTitle(), AD_Proces_ID, 426, this.m_ps.getC_PaySelection_ID());
        pi.setAD_User_ID(Env.getAD_User_ID(Env.getCtx()));
        pi.setAD_Client_ID(Env.getAD_Client_ID(Env.getCtx()));
        ProcessCtl.process(this, this.m_WindowNo, pi, trx);
    }

    public void lockUI(ProcessInfo pi) {
        this.setEnabled(false);
        this.m_isLocked = true;
    }

    public void unlockUI(ProcessInfo pi) {
        if (!ADialog.ask(0, this, "VPaySelectPrint?", "(" + pi.getSummary() + ")")) {
            return;
        }
        int AD_Form_ID = 106;
        FormFrame ff = new FormFrame();
        ff.openForm(AD_Form_ID);
        if (this.m_ps != null) {
            VPayPrint pp = (VPayPrint)ff.getFormPanel();
            pp.setPaySelection(this.m_ps.getC_PaySelection_ID());
        }
        ff.pack();
        this.setVisible(false);
        AEnv.addToWindowManager(ff);
        AEnv.showCenterScreen(ff);
        this.dispose();
    }

    public boolean isUILocked() {
        return this.m_isLocked;
    }

    public void executeASync(ProcessInfo pi) {
        log.config("-");
    }

    public class BankInfo {
        int C_BankAccount_ID;
        int C_Currency_ID;
        String Name;
        String Currency;
        BigDecimal Balance;
        boolean Transfers;

        public BankInfo(int newC_BankAccount_ID, int newC_Currency_ID, String newName, String newCurrency, BigDecimal newBalance, boolean newTransfers) {
            this.C_BankAccount_ID = newC_BankAccount_ID;
            this.C_Currency_ID = newC_Currency_ID;
            this.Name = newName;
            this.Currency = newCurrency;
            this.Balance = newBalance;
        }

        public String toString() {
            return this.Name;
        }
    }
}

