/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps.form;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import org.compiere.apps.ADialog;
import org.compiere.apps.ConfirmPanel;
import org.compiere.apps.form.FormFrame;
import org.compiere.apps.form.FormPanel;
import org.compiere.grid.ed.VNumber;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MLookupInfo;
import org.compiere.model.MPaySelectionCheck;
import org.compiere.model.MPaymentBatch;
import org.compiere.plaf.CompiereColor;
import org.compiere.print.ReportCtl;
import org.compiere.swing.CComboBox;
import org.compiere.swing.CLabel;
import org.compiere.swing.CPanel;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Ini;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Language;
import org.compiere.util.Msg;
import org.compiere.util.ValueNamePair;

public class VPayPrint
extends CPanel
implements FormPanel,
ActionListener {
    private int m_WindowNo = 0;
    private FormFrame m_frame;
    private int m_C_BankAccount_ID = -1;
    private MPaySelectionCheck[] m_checks = null;
    private MPaymentBatch m_batch = null;
    private static CLogger log = CLogger.getCLogger(VPayPrint.class);
    private CPanel centerPanel = new CPanel();
    private CPanel southPanel = new CPanel();
    private FlowLayout southLayout = new FlowLayout();
    private GridBagLayout centerLayout = new GridBagLayout();
    private JButton bPrint = ConfirmPanel.createPrintButton(true);
    private JButton bExport = ConfirmPanel.createExportButton(true);
    private JButton bCancel = ConfirmPanel.createCancelButton(true);
    private JButton bProcess = ConfirmPanel.createProcessButton(Msg.getMsg(Env.getCtx(), "VPayPrintProcess"));
    private CLabel lPaySelect = new CLabel();
    private CComboBox fPaySelect = new CComboBox();
    private CLabel lBank = new CLabel();
    private CLabel fBank = new CLabel();
    private CLabel lPaymentRule = new CLabel();
    private CComboBox fPaymentRule = new CComboBox();
    private CLabel lDocumentNo = new CLabel();
    private VNumber fDocumentNo = new VNumber();
    private CLabel lNoPayments = new CLabel();
    private CLabel fNoPayments = new CLabel();
    private CLabel lBalance = new CLabel();
    private VNumber fBalance = new VNumber();
    private CLabel lCurrency = new CLabel();
    private CLabel fCurrency = new CLabel();

    public void init(int WindowNo, FormFrame frame) {
        log.info("");
        this.m_WindowNo = WindowNo;
        this.m_frame = frame;
        try {
            this.jbInit();
            this.dynInit();
            frame.getContentPane().add((Component)this.centerPanel, "Center");
            frame.getContentPane().add((Component)this.southPanel, "South");
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "", e);
        }
    }

    private void jbInit() throws Exception {
        CompiereColor.setBackground(this);
        this.southPanel.setLayout(this.southLayout);
        this.southLayout.setAlignment(2);
        this.centerPanel.setLayout(this.centerLayout);
        this.bPrint.addActionListener(this);
        this.bExport.addActionListener(this);
        this.bCancel.addActionListener(this);
        this.bProcess.setText(Msg.getMsg(Env.getCtx(), "EFT"));
        this.bProcess.setEnabled(false);
        this.bProcess.addActionListener(this);
        this.lPaySelect.setText(Msg.translate(Env.getCtx(), "C_PaySelection_ID"));
        this.fPaySelect.addActionListener(this);
        this.lBank.setText(Msg.translate(Env.getCtx(), "C_BankAccount_ID"));
        this.lPaymentRule.setText(Msg.translate(Env.getCtx(), "PaymentRule"));
        this.fPaymentRule.addActionListener(this);
        this.lDocumentNo.setText(Msg.translate(Env.getCtx(), "DocumentNo"));
        this.fDocumentNo.setDisplayType(11);
        this.lNoPayments.setText(Msg.getMsg(Env.getCtx(), "NoOfPayments"));
        this.fNoPayments.setText("0");
        this.lBalance.setText(Msg.translate(Env.getCtx(), "CurrentBalance"));
        this.fBalance.setReadWrite(false);
        this.fBalance.setDisplayType(12);
        this.lCurrency.setText(Msg.translate(Env.getCtx(), "C_Currency_ID"));
        this.southPanel.add((Component)this.bCancel, null);
        this.southPanel.add((Component)this.bExport, null);
        this.southPanel.add((Component)this.bPrint, null);
        this.southPanel.add((Component)this.bProcess, null);
        this.centerPanel.add((Component)this.lPaySelect, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(12, 12, 5, 5), 0, 0));
        this.centerPanel.add((Component)this.fPaySelect, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(12, 0, 5, 12), 0, 0));
        this.centerPanel.add((Component)this.lBank, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 12, 5, 5), 0, 0));
        this.centerPanel.add((Component)this.fBank, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 5, 12), 0, 0));
        this.centerPanel.add((Component)this.lPaymentRule, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 12, 5, 5), 0, 0));
        this.centerPanel.add((Component)this.fPaymentRule, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 5, 12), 0, 0));
        this.centerPanel.add((Component)this.lDocumentNo, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 12, 5, 5), 0, 0));
        this.centerPanel.add((Component)this.fDocumentNo, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 5, 12), 0, 0));
        this.centerPanel.add((Component)this.lNoPayments, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 12, 5, 5), 0, 0));
        this.centerPanel.add((Component)this.fNoPayments, new GridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 5, 12), 0, 0));
        this.centerPanel.add((Component)this.lBalance, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 12, 5, 5), 0, 0));
        this.centerPanel.add((Component)this.fBalance, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 5, 12), 0, 0));
        this.centerPanel.add((Component)this.lCurrency, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 12, 12, 5), 0, 0));
        this.centerPanel.add((Component)this.fCurrency, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 12, 12), 0, 0));
    }

    private void dynInit() {
        log.config("");
        int AD_Client_ID = Env.getAD_Client_ID(Env.getCtx());
        String sql = "SELECT C_PaySelection_ID, Name || ' - ' || TotalAmt FROM C_PaySelection WHERE AD_Client_ID=? AND Processed='Y' AND IsActive='Y'ORDER BY PayDate DESC";
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, AD_Client_ID);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                KeyNamePair pp = new KeyNamePair(rs.getInt(1), rs.getString(2));
                this.fPaySelect.addItem(pp);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, sql, e);
        }
        if (this.fPaySelect.getItemCount() == 0) {
            ADialog.info(this.m_WindowNo, this, "VPayPrintNoRecords");
        }
    }

    public void dispose() {
        if (this.m_frame != null) {
            this.m_frame.dispose();
        }
        this.m_frame = null;
    }

    public void setPaySelection(int C_PaySelection_ID) {
        if (C_PaySelection_ID == 0) {
            return;
        }
        for (int i = 0; i < this.fPaySelect.getItemCount(); ++i) {
            KeyNamePair pp = (KeyNamePair)this.fPaySelect.getItemAt(i);
            if (pp.getKey() != C_PaySelection_ID) continue;
            this.fPaySelect.setSelectedIndex(i);
            return;
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.fPaySelect) {
            this.loadPaySelectInfo();
        } else if (e.getSource() == this.fPaymentRule) {
            this.loadPaymentRuleInfo();
        } else if (e.getSource() == this.bCancel) {
            this.dispose();
        } else if (e.getSource() == this.bExport) {
            this.cmd_export();
        } else if (e.getSource() == this.bProcess) {
            this.cmd_EFT();
        } else if (e.getSource() == this.bPrint) {
            this.cmd_print();
        }
    }

    private void loadPaySelectInfo() {
        log.info("VPayPrint.loadPaySelectInfo");
        if (this.fPaySelect.getSelectedIndex() == -1) {
            return;
        }
        int C_PaySelection_ID = ((KeyNamePair)this.fPaySelect.getSelectedItem()).getKey();
        this.m_C_BankAccount_ID = -1;
        String sql = "SELECT ps.C_BankAccount_ID, b.Name || ' ' || ba.AccountNo, c.ISO_Code, CurrentBalance FROM C_PaySelection ps INNER JOIN C_BankAccount ba ON (ps.C_BankAccount_ID=ba.C_BankAccount_ID) INNER JOIN C_Bank b ON (ba.C_Bank_ID=b.C_Bank_ID) INNER JOIN C_Currency c ON (ba.C_Currency_ID=c.C_Currency_ID) WHERE ps.C_PaySelection_ID=? AND ps.Processed='Y' AND ba.IsActive='Y'";
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, C_PaySelection_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                this.m_C_BankAccount_ID = rs.getInt(1);
                this.fBank.setText(rs.getString(2));
                this.fCurrency.setText(rs.getString(3));
                this.fBalance.setValue(rs.getBigDecimal(4));
            } else {
                this.m_C_BankAccount_ID = -1;
                this.fBank.setText("");
                this.fCurrency.setText("");
                this.fBalance.setValue(Env.ZERO);
                log.log(Level.SEVERE, "No active BankAccount for C_PaySelection_ID=" + C_PaySelection_ID);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, sql, e);
        }
        this.loadPaymentRule();
    }

    private void loadPaymentRule() {
        log.info("");
        if (this.m_C_BankAccount_ID == -1) {
            return;
        }
        int C_PaySelection_ID = ((KeyNamePair)this.fPaySelect.getSelectedItem()).getKey();
        this.fPaymentRule.removeAllItems();
        int AD_Reference_ID = 195;
        Language language = Language.getLanguage(Env.getAD_Language(Env.getCtx()));
        MLookupInfo info = MLookupFactory.getLookup_List(language, AD_Reference_ID);
        String sql = info.Query.substring(0, info.Query.indexOf(" ORDER BY")) + " AND " + info.KeyColumn + " IN (SELECT PaymentRule FROM C_PaySelectionCheck WHERE C_PaySelection_ID=?) " + info.Query.substring(info.Query.indexOf(" ORDER BY"));
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, C_PaySelection_ID);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                ValueNamePair pp = new ValueNamePair(rs.getString(2), rs.getString(3));
                this.fPaymentRule.addItem(pp);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, sql, e);
        }
        if (this.fPaymentRule.getItemCount() == 0) {
            log.config("PaySel=" + C_PaySelection_ID + ", BAcct=" + this.m_C_BankAccount_ID + " - " + sql);
        }
        this.loadPaymentRuleInfo();
    }

    private void loadPaymentRuleInfo() {
        ResultSet rs;
        CPreparedStatement pstmt;
        ValueNamePair pp = (ValueNamePair)this.fPaymentRule.getSelectedItem();
        if (pp == null) {
            return;
        }
        String PaymentRule = pp.getValue();
        log.info("PaymentRule=" + PaymentRule);
        this.fNoPayments.setText(" ");
        int C_PaySelection_ID = ((KeyNamePair)this.fPaySelect.getSelectedItem()).getKey();
        String sql = "SELECT COUNT(*) FROM C_PaySelectionCheck WHERE C_PaySelection_ID=?";
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, C_PaySelection_ID);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                this.fNoPayments.setText(String.valueOf(rs.getInt(1)));
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, sql, e);
        }
        this.bProcess.setEnabled(PaymentRule.equals("T"));
        sql = "SELECT CurrentNext FROM C_BankAccountDoc WHERE C_BankAccount_ID=? AND PaymentRule=? AND IsActive='Y'";
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, this.m_C_BankAccount_ID);
            pstmt.setString(2, PaymentRule);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                this.fDocumentNo.setValue(new Integer(rs.getInt(1)));
            } else {
                log.log(Level.SEVERE, "VPayPrint.loadPaymentRuleInfo - No active BankAccountDoc for C_BankAccount_ID=" + this.m_C_BankAccount_ID + " AND PaymentRule=" + PaymentRule);
                ADialog.error(this.m_WindowNo, this, "VPayPrintNoDoc");
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, sql, e);
        }
    }

    private void cmd_export() {
        String PaymentRule = ((ValueNamePair)this.fPaymentRule.getSelectedItem()).getValue();
        log.info(PaymentRule);
        if (!this.getChecks(PaymentRule)) {
            return;
        }
        JFileChooser fc = new JFileChooser();
        fc.setDialogTitle(Msg.getMsg(Env.getCtx(), "Export"));
        fc.setFileSelectionMode(0);
        fc.setMultiSelectionEnabled(false);
        fc.setSelectedFile(new File("paymentExport.txt"));
        if (fc.showSaveDialog(this) != 0) {
            return;
        }
        int no = MPaySelectionCheck.exportToFile(this.m_checks, fc.getSelectedFile());
        ADialog.info(this.m_WindowNo, this, "Saved", fc.getSelectedFile().getAbsolutePath() + "\n" + Msg.getMsg(Env.getCtx(), "NoOfLines") + "=" + no);
        if (ADialog.ask(this.m_WindowNo, this, "VPayPrintSuccess?")) {
            MPaySelectionCheck.confirmPrint(this.m_checks, this.m_batch);
        }
        this.dispose();
    }

    private void cmd_EFT() {
        String PaymentRule = ((ValueNamePair)this.fPaymentRule.getSelectedItem()).getValue();
        log.info(PaymentRule);
        if (!this.getChecks(PaymentRule)) {
            return;
        }
        this.dispose();
    }

    private void cmd_print() {
        int lastDocumentNo;
        MPaySelectionCheck check;
        int i;
        String PaymentRule = ((ValueNamePair)this.fPaymentRule.getSelectedItem()).getValue();
        log.info(PaymentRule);
        if (!this.getChecks(PaymentRule)) {
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        boolean somethingPrinted = false;
        boolean directPrint = !Ini.isPropertyBool("PrintPreview");
        for (i = 0; i < this.m_checks.length; ++i) {
            check = this.m_checks[i];
            boolean ok = ReportCtl.startDocumentPrint(6, check.get_ID(), directPrint);
            if (somethingPrinted || !ok) continue;
            somethingPrinted = true;
        }
        if (somethingPrinted && ADialog.ask(this.m_WindowNo, this, "VPayPrintSuccess?") && (lastDocumentNo = MPaySelectionCheck.confirmPrint(this.m_checks, this.m_batch)) != 0) {
            StringBuffer sb = new StringBuffer();
            sb.append("UPDATE C_BankAccountDoc SET CurrentNext=").append(++lastDocumentNo).append(" WHERE C_BankAccount_ID=").append(this.m_C_BankAccount_ID).append(" AND PaymentRule='").append(PaymentRule).append("'");
            DB.executeUpdate(sb.toString(), null);
        }
        if (ADialog.ask(this.m_WindowNo, this, "VPayPrintPrintRemittance")) {
            for (i = 0; i < this.m_checks.length; ++i) {
                check = this.m_checks[i];
                ReportCtl.startDocumentPrint(5, check.get_ID(), directPrint);
            }
        }
        this.setCursor(Cursor.getDefaultCursor());
        this.dispose();
    }

    private boolean getChecks(String PaymentRule) {
        if (this.fPaySelect.getSelectedIndex() == -1 || this.m_C_BankAccount_ID == -1 || this.fPaymentRule.getSelectedIndex() == -1 || this.fDocumentNo.getValue() == null) {
            ADialog.error(this.m_WindowNo, this, "VPayPrintNoRecords", "(" + Msg.translate(Env.getCtx(), "C_PaySelectionLine_ID") + "=0)");
            return false;
        }
        int C_PaySelection_ID = ((KeyNamePair)this.fPaySelect.getSelectedItem()).getKey();
        int startDocumentNo = ((Number)this.fDocumentNo.getValue()).intValue();
        log.config("C_PaySelection_ID=" + C_PaySelection_ID + ", PaymentRule=" + PaymentRule + ", DocumentNo=" + startDocumentNo);
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.m_checks = MPaySelectionCheck.get(C_PaySelection_ID, PaymentRule, startDocumentNo, null);
        this.setCursor(Cursor.getDefaultCursor());
        if (this.m_checks == null || this.m_checks.length == 0) {
            ADialog.error(this.m_WindowNo, this, "VPayPrintNoRecords", "(" + Msg.translate(Env.getCtx(), "C_PaySelectionLine_ID") + " #0");
            return false;
        }
        this.m_batch = MPaymentBatch.getForPaySelection(Env.getCtx(), C_PaySelection_ID, null);
        return true;
    }
}

