/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps.form;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.logging.Level;
import org.compiere.apps.ADialog;
import org.compiere.apps.ConfirmPanel;
import org.compiere.apps.form.FormFrame;
import org.compiere.apps.form.FormPanel;
import org.compiere.grid.ed.VLookup;
import org.compiere.model.MBPartner;
import org.compiere.model.MInvoice;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MPayment;
import org.compiere.swing.CLabel;
import org.compiere.swing.CPanel;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class VMerge
extends CPanel
implements FormPanel,
ActionListener {
    private int m_WindowNo = 0;
    private FormFrame m_frame;
    private int m_totalCount = 0;
    private StringBuffer m_errorLog = new StringBuffer();
    private Connection m_con = null;
    private static CLogger log = CLogger.getCLogger(VMerge.class);
    private static String AD_ORG_ID = "AD_Org_ID";
    private static String C_BPARTNER_ID = "C_BPartner_ID";
    private static String AD_USER_ID = "AD_User_ID";
    private static String M_PRODUCT_ID = "M_Product_ID";
    private static String[] s_delete_Org = new String[]{"AD_OrgInfo"};
    private static String[] s_delete_User = new String[]{"AD_User_Roles"};
    private static String[] s_delete_BPartner = new String[]{"C_BP_Employee_Acct", "C_BP_Vendor_Acct", "C_BP_Customer_Acct", "T_Aging"};
    private static String[] s_delete_Product = new String[]{"M_Product_PO", "M_Replenish", "T_Replenish", "M_ProductPrice", "M_Product_Costing", "M_Product_Trl", "M_Product_Acct"};
    private String[] m_columnName = null;
    private CLabel[] m_label = null;
    private VLookup[] m_from = null;
    private VLookup[] m_to = null;
    private String[] m_deleteTables = null;
    private BorderLayout mainLayout = new BorderLayout();
    private CPanel CenterPanel = new CPanel();
    private GridLayout centerLayout = new GridLayout();
    private CLabel mergeFromLabel = new CLabel();
    private CLabel mergeToLabel = new CLabel();
    private ConfirmPanel confirmPanel = new ConfirmPanel(true);

    public void init(int WindowNo, FormFrame frame) {
        this.m_WindowNo = WindowNo;
        this.m_frame = frame;
        log.info("VMerge.init - WinNo=" + this.m_WindowNo);
        try {
            this.preInit();
            this.jbInit();
            frame.getContentPane().add((Component)this, "Center");
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "", ex);
        }
    }

    private void preInit() {
        int count = 4;
        this.m_columnName = new String[count];
        this.m_label = new CLabel[count];
        this.m_from = new VLookup[count];
        this.m_to = new VLookup[count];
        this.preInit(0, 2163, 19, AD_ORG_ID);
        this.preInit(1, 2762, 30, C_BPARTNER_ID);
        this.preInit(2, 971, 30, AD_USER_ID);
        this.preInit(3, 2221, 30, M_PRODUCT_ID);
    }

    private void preInit(int index, int AD_Column_ID, int displayType, String ColumnName) {
        this.m_columnName[index] = ColumnName;
        String what = Msg.translate(Env.getCtx(), ColumnName);
        this.m_label[index] = new CLabel(what);
        this.m_from[index] = new VLookup(ColumnName, false, false, true, MLookupFactory.get(Env.getCtx(), this.m_WindowNo, 0, AD_Column_ID, displayType));
        this.m_to[index] = new VLookup(ColumnName, false, false, true, MLookupFactory.get(Env.getCtx(), this.m_WindowNo, 0, AD_Column_ID, displayType));
    }

    void jbInit() throws Exception {
        this.setLayout(this.mainLayout);
        this.mainLayout.setHgap(5);
        this.mainLayout.setVgap(5);
        this.add((Component)this.confirmPanel, "South");
        this.confirmPanel.addActionListener(this);
        this.centerLayout.setHgap(5);
        this.centerLayout.setVgap(5);
        this.centerLayout.setColumns(3);
        this.centerLayout.setRows(this.m_label.length + 1);
        this.CenterPanel.setLayout(this.centerLayout);
        this.add((Component)this.CenterPanel, "Center");
        this.CenterPanel.add((Component)new CLabel(), null);
        this.CenterPanel.add((Component)this.mergeFromLabel, null);
        this.CenterPanel.add((Component)this.mergeToLabel, null);
        Font heading = this.mergeFromLabel.getFont();
        heading = new Font(heading.getName(), 1, heading.getSize());
        this.mergeFromLabel.setFont(heading);
        this.mergeFromLabel.setRequestFocusEnabled(false);
        this.mergeFromLabel.setText(Msg.getMsg(Env.getCtx(), "MergeFrom"));
        this.mergeToLabel.setFont(heading);
        this.mergeToLabel.setText(Msg.getMsg(Env.getCtx(), "MergeTo"));
        for (int i = 0; i < this.m_label.length; ++i) {
            this.CenterPanel.add((Component)this.m_label[i], null);
            this.CenterPanel.add((Component)this.m_from[i], null);
            this.CenterPanel.add((Component)this.m_to[i], null);
        }
    }

    public void dispose() {
        if (this.m_frame != null) {
            this.m_frame.dispose();
        }
        this.m_frame = null;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("Cancel")) {
            this.dispose();
            return;
        }
        String columnName = null;
        String from_Info = null;
        String to_Info = null;
        int from_ID = 0;
        int to_ID = 0;
        for (int i = 0; i < this.m_columnName.length && from_ID == 0 && to_ID == 0; ++i) {
            Object value = this.m_from[i].getValue();
            if (value == null || !(value instanceof Integer)) continue;
            from_ID = (Integer)value;
            value = this.m_to[i].getValue();
            if (value != null && value instanceof Integer) {
                to_ID = (Integer)value;
            } else {
                from_ID = 0;
            }
            if (from_ID == 0) continue;
            columnName = this.m_columnName[i];
            from_Info = this.m_from[i].getDisplay();
            to_Info = this.m_to[i].getDisplay();
        }
        if (from_ID == 0 || from_ID == to_ID) {
            return;
        }
        String msg = Msg.getMsg(Env.getCtx(), "MergeFrom") + " = " + from_Info + "\n" + Msg.getMsg(Env.getCtx(), "MergeTo") + " = " + to_Info;
        if (!ADialog.ask(this.m_WindowNo, this, "MergeQuestion", msg)) {
            return;
        }
        if (columnName.equals(AD_ORG_ID)) {
            this.m_deleteTables = s_delete_Org;
        } else if (columnName.equals(AD_USER_ID)) {
            this.m_deleteTables = s_delete_User;
        } else if (columnName.equals(C_BPARTNER_ID)) {
            this.m_deleteTables = s_delete_BPartner;
        } else if (columnName.equals(M_PRODUCT_ID)) {
            this.m_deleteTables = s_delete_Product;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.confirmPanel.getOKButton().setEnabled(false);
        boolean success = this.merge(columnName, from_ID, to_ID);
        this.postMerge(columnName, to_ID);
        this.confirmPanel.getOKButton().setEnabled(true);
        this.setCursor(Cursor.getDefaultCursor());
        if (!success) {
            ADialog.error(this.m_WindowNo, this, "MergeError", this.m_errorLog.toString());
            return;
        }
        ADialog.info(this.m_WindowNo, this, "MergeSuccess", msg + " #" + this.m_totalCount);
        this.dispose();
    }

    private boolean merge(String ColumnName, int from_ID, int to_ID) {
        String TableName = ColumnName.substring(0, ColumnName.length() - 3);
        log.config(ColumnName + " - From=" + from_ID + ",To=" + to_ID);
        boolean success = true;
        this.m_totalCount = 0;
        this.m_errorLog = new StringBuffer();
        String sql = "SELECT t.TableName, c.ColumnName FROM AD_Table t INNER JOIN AD_Column c ON (t.AD_Table_ID=c.AD_Table_ID) WHERE t.IsView='N' AND t.TableName NOT IN ('C_TaxDeclarationAcct') AND ((c.ColumnName=? AND c.IsKey='N') OR c.AD_Reference_Value_ID IN (SELECT rt.AD_Reference_ID FROM AD_Ref_Table rt INNER JOIN AD_Column cc ON (rt.AD_Table_ID=cc.AD_Table_ID AND rt.AD_Key=cc.AD_Column_ID) WHERE cc.IsKey='Y' AND cc.ColumnName=?)) ORDER BY t.LoadSeq DESC";
        Statement pstmt = null;
        Savepoint sp = null;
        try {
            this.m_con = DB.createConnection(false, 2);
            sp = this.m_con.setSavepoint("merge");
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setString(1, ColumnName);
            pstmt.setString(2, ColumnName);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                String tName = rs.getString(1);
                String cName = rs.getString(2);
                if (TableName.equals(tName)) continue;
                int count = this.mergeTable(tName, cName, from_ID, to_ID);
                if (count < 0) {
                    success = false;
                    continue;
                }
                this.m_totalCount += count;
            }
            rs.close();
            pstmt.close();
            pstmt = null;
            log.config("Success=" + success + " - " + ColumnName + " - From=" + from_ID + ",To=" + to_ID);
            if (success) {
                sql = "DELETE " + TableName + " WHERE " + ColumnName + "=" + from_ID;
                Statement stmt = this.m_con.createStatement();
                int count = 0;
                try {
                    count = stmt.executeUpdate(sql);
                    if (count != 1) {
                        this.m_errorLog.append(Env.NL).append("DELETE ").append(TableName).append(" - Count=").append(count);
                        success = false;
                    }
                }
                catch (SQLException ex1) {
                    this.m_errorLog.append(Env.NL).append("DELETE ").append(TableName).append(" - ").append(ex1.toString());
                    success = false;
                }
                stmt.close();
                stmt = null;
            }
            if (success) {
                this.m_con.commit();
            } else {
                this.m_con.rollback(sp);
            }
            this.m_con.close();
            this.m_con = null;
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, ColumnName, ex);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            if (this.m_con != null) {
                this.m_con.close();
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        pstmt = null;
        this.m_con = null;
        return success;
    }

    private int mergeTable(String TableName, String ColumnName, int from_ID, int to_ID) {
        log.fine(TableName + "." + ColumnName + " - From=" + from_ID + ",To=" + to_ID);
        String sql = "UPDATE " + TableName + " SET " + ColumnName + "=" + to_ID + " WHERE " + ColumnName + "=" + from_ID;
        boolean delete = false;
        for (int i = 0; i < this.m_deleteTables.length; ++i) {
            if (!this.m_deleteTables[i].equals(TableName)) continue;
            delete = true;
            sql = "DELETE " + TableName + " WHERE " + ColumnName + "=" + from_ID;
        }
        int count = -1;
        try {
            Statement stmt = this.m_con.createStatement();
            try {
                count = stmt.executeUpdate(sql);
                log.fine(count + (delete ? " -Delete- " : " -Update- ") + TableName);
            }
            catch (SQLException ex1) {
                count = -1;
                this.m_errorLog.append(Env.NL).append(delete ? "DELETE " : "UPDATE ").append(TableName).append(" - ").append(ex1.toString()).append(" - ").append(sql);
            }
            stmt.close();
            stmt = null;
        }
        catch (SQLException ex) {
            count = -1;
            this.m_errorLog.append(Env.NL).append(delete ? "DELETE " : "UPDATE ").append(TableName).append(" - ").append(ex.toString()).append(" - ").append(sql);
        }
        return count;
    }

    private void postMerge(String ColumnName, int to_ID) {
        if (!ColumnName.equals(AD_ORG_ID) && !ColumnName.equals(AD_USER_ID)) {
            if (ColumnName.equals(C_BPARTNER_ID)) {
                MBPartner bp = new MBPartner(Env.getCtx(), to_ID, null);
                if (bp.get_ID() != 0) {
                    MPayment[] payments = MPayment.getOfBPartner(Env.getCtx(), bp.getC_BPartner_ID(), null);
                    for (int i = 0; i < payments.length; ++i) {
                        MPayment payment = payments[i];
                        if (!payment.testAllocation()) continue;
                        payment.save();
                    }
                    MInvoice[] invoices = MInvoice.getOfBPartner(Env.getCtx(), bp.getC_BPartner_ID(), null);
                    for (int i = 0; i < invoices.length; ++i) {
                        MInvoice invoice = invoices[i];
                        if (!invoice.testAllocation()) continue;
                        invoice.save();
                    }
                    bp.setTotalOpenBalance();
                    bp.setActualLifeTimeValue();
                    bp.save();
                }
            } else if (ColumnName.equals(M_PRODUCT_ID)) {
                // empty if block
            }
        }
    }
}

