/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps.form;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Vector;
import java.util.logging.Level;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.compiere.apps.StatusBar;
import org.compiere.apps.form.FormFrame;
import org.compiere.apps.form.FormPanel;
import org.compiere.grid.ed.VDate;
import org.compiere.grid.ed.VLookup;
import org.compiere.grid.ed.VNumber;
import org.compiere.minigrid.ColumnInfo;
import org.compiere.minigrid.IDColumn;
import org.compiere.minigrid.MiniTable;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MMatchInv;
import org.compiere.model.MMatchPO;
import org.compiere.model.MOrderLine;
import org.compiere.model.MRole;
import org.compiere.model.MStorage;
import org.compiere.plaf.CompiereColor;
import org.compiere.swing.CButton;
import org.compiere.swing.CComboBox;
import org.compiere.swing.CLabel;
import org.compiere.swing.CPanel;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;

public class VMatch
extends CPanel
implements FormPanel,
ActionListener,
TableModelListener,
ListSelectionListener {
    private int m_WindowNo = 0;
    private FormFrame m_frame;
    private static CLogger log = CLogger.getCLogger(VMatch.class);
    private int m_AD_Client_ID = Env.getAD_Client_ID(Env.getCtx());
    private int m_AD_Org_ID = Env.getAD_Org_ID(Env.getCtx());
    private int m_by = Env.getAD_User_ID(Env.getCtx());
    private String[] m_matchOptions = new String[]{Msg.getElement(Env.getCtx(), "C_Invoice_ID", false), Msg.getElement(Env.getCtx(), "M_InOut_ID", false), Msg.getElement(Env.getCtx(), "C_Order_ID", false)};
    private static final int MATCH_INVOICE = 0;
    private static final int MATCH_SHIPMENT = 1;
    private static final int MATCH_ORDER = 2;
    private String[] m_matchMode = new String[]{Msg.translate(Env.getCtx(), "NotMatched"), Msg.translate(Env.getCtx(), "Matched")};
    private static final int MODE_NOTMATCHED = 0;
    private static final int MODE_MATCHED = 1;
    private static final int I_BPartner = 3;
    private static final int I_Line = 4;
    private static final int I_Product = 5;
    private static final int I_QTY = 6;
    private static final int I_MATCHED = 7;
    private StringBuffer m_sql = null;
    private String m_dateColumn = "";
    private String m_qtyColumn = "";
    private String m_groupBy = "";
    private BigDecimal m_xMatched = Env.ZERO;
    private BigDecimal m_xMatchedTo = Env.ZERO;
    private CPanel mainPanel = new CPanel();
    private StatusBar statusBar = new StatusBar();
    private BorderLayout mainLayout = new BorderLayout();
    private CPanel northPanel = new CPanel();
    private GridBagLayout northLayout = new GridBagLayout();
    private CLabel matchFromLabel = new CLabel();
    private CComboBox matchFrom = new CComboBox(this.m_matchOptions);
    private CLabel matchToLabel = new CLabel();
    private CComboBox matchTo = new CComboBox();
    private CLabel matchModeLabel = new CLabel();
    private CComboBox matchMode = new CComboBox(this.m_matchMode);
    private VLookup onlyVendor = null;
    private VLookup onlyProduct = null;
    private CLabel onlyVendorLabel = new CLabel();
    private CLabel onlyProductLabel = new CLabel();
    private CLabel dateFromLabel = new CLabel();
    private CLabel dateToLabel = new CLabel();
    private VDate dateFrom = new VDate("DateFrom", false, false, true, 15, "DateFrom");
    private VDate dateTo = new VDate("DateTo", false, false, true, 15, "DateTo");
    private CButton bSearch = new CButton();
    private CPanel southPanel = new CPanel();
    private GridBagLayout southLayout = new GridBagLayout();
    private CLabel xMatchedLabel = new CLabel();
    private CLabel xMatchedToLabel = new CLabel();
    private CLabel differenceLabel = new CLabel();
    private VNumber xMatched = new VNumber("xMatched", false, true, false, 29, "xMatched");
    private VNumber xMatchedTo = new VNumber("xMatchedTo", false, true, false, 29, "xMatchedTo");
    private VNumber difference = new VNumber("Difference", false, true, false, 29, "Difference");
    private CButton bProcess = new CButton();
    private CPanel centerPanel = new CPanel();
    private BorderLayout centerLayout = new BorderLayout(5, 5);
    private JScrollPane xMatchedScrollPane = new JScrollPane();
    private TitledBorder xMatchedBorder = new TitledBorder("xMatched");
    private MiniTable xMatchedTable = new MiniTable();
    private JScrollPane xMatchedToScrollPane = new JScrollPane();
    private TitledBorder xMatchedToBorder = new TitledBorder("xMatchedTo");
    private MiniTable xMatchedToTable = new MiniTable();
    private CPanel xPanel = new CPanel();
    private JCheckBox sameProduct = new JCheckBox();
    private JCheckBox sameBPartner = new JCheckBox();
    private JCheckBox sameQty = new JCheckBox();
    private FlowLayout xLayout = new FlowLayout(1, 10, 0);

    public void init(int WindowNo, FormFrame frame) {
        this.m_WindowNo = WindowNo;
        this.m_frame = frame;
        log.info("WinNo=" + this.m_WindowNo + " - AD_Client_ID=" + this.m_AD_Client_ID + ", AD_Org_ID=" + this.m_AD_Org_ID + ", By=" + this.m_by);
        Env.setContext(Env.getCtx(), this.m_WindowNo, "IsSOTrx", "N");
        try {
            this.onlyVendor = VLookup.createBPartner(this.m_WindowNo);
            this.onlyProduct = VLookup.createProduct(this.m_WindowNo);
            this.jbInit();
            this.dynInit();
            frame.getContentPane().add((Component)this.mainPanel, "Center");
            frame.getContentPane().add((Component)this.statusBar, "South");
            new Thread(){

                public void run() {
                    log.info("Starting ...");
                    MMatchPO.consolidate(Env.getCtx());
                    log.info("... Done");
                }
            }.start();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "", e);
        }
    }

    private void jbInit() throws Exception {
        this.mainPanel.setLayout(this.mainLayout);
        this.northPanel.setLayout(this.northLayout);
        this.matchFromLabel.setText(Msg.translate(Env.getCtx(), "MatchFrom"));
        this.matchToLabel.setText(Msg.translate(Env.getCtx(), "MatchTo"));
        this.matchModeLabel.setText(Msg.translate(Env.getCtx(), "MatchMode"));
        this.onlyVendorLabel.setText(Msg.translate(Env.getCtx(), "C_BPartner_ID"));
        this.onlyProductLabel.setText(Msg.translate(Env.getCtx(), "M_Product_ID"));
        this.dateFromLabel.setText(Msg.translate(Env.getCtx(), "DateFrom"));
        this.dateToLabel.setText(Msg.translate(Env.getCtx(), "DateTo"));
        this.bSearch.setText(Msg.translate(Env.getCtx(), "Search"));
        this.southPanel.setLayout(this.southLayout);
        this.xMatchedLabel.setText(Msg.translate(Env.getCtx(), "ToBeMatched"));
        this.xMatchedToLabel.setText(Msg.translate(Env.getCtx(), "Matching"));
        this.differenceLabel.setText(Msg.translate(Env.getCtx(), "Difference"));
        this.bProcess.setText(Msg.translate(Env.getCtx(), "Process"));
        this.centerPanel.setLayout(this.centerLayout);
        this.xMatchedScrollPane.setBorder(this.xMatchedBorder);
        this.xMatchedScrollPane.setPreferredSize(new Dimension(450, 200));
        this.xMatchedToScrollPane.setBorder(this.xMatchedToBorder);
        this.xMatchedToScrollPane.setPreferredSize(new Dimension(450, 200));
        this.sameProduct.setSelected(true);
        this.sameProduct.setText(Msg.translate(Env.getCtx(), "SameProduct"));
        this.sameBPartner.setSelected(true);
        this.sameBPartner.setText(Msg.translate(Env.getCtx(), "SameBPartner"));
        this.sameQty.setSelected(false);
        this.sameQty.setText(Msg.translate(Env.getCtx(), "SameQty"));
        this.xPanel.setLayout(this.xLayout);
        this.mainPanel.add((Component)this.northPanel, "North");
        this.northPanel.add((Component)this.matchFromLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(12, 12, 5, 5), 0, 0));
        this.northPanel.add((Component)this.matchFrom, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(12, 0, 5, 0), 0, 0));
        this.northPanel.add((Component)this.matchToLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(12, 5, 5, 5), 0, 0));
        this.northPanel.add((Component)this.matchTo, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(12, 0, 5, 0), 0, 0));
        this.northPanel.add((Component)this.matchModeLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 12, 5, 5), 0, 0));
        this.northPanel.add((Component)this.matchMode, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 5, 0), 0, 0));
        this.northPanel.add((Component)this.onlyVendor, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 5, 0), 0, 0));
        this.northPanel.add((Component)this.onlyProduct, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 5, 0), 0, 0));
        this.northPanel.add((Component)this.onlyVendorLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 12, 5, 5), 0, 0));
        this.northPanel.add((Component)this.onlyProductLabel, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.northPanel.add((Component)this.dateFromLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 12, 5, 5), 0, 0));
        this.northPanel.add((Component)this.dateToLabel, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 5, 5), 0, 0));
        this.northPanel.add((Component)this.dateFrom, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 5, 0), 0, 0));
        this.northPanel.add((Component)this.dateTo, new GridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 5, 0), 0, 0));
        this.northPanel.add((Component)this.bSearch, new GridBagConstraints(4, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 12, 5, 12), 0, 0));
        this.mainPanel.add((Component)this.southPanel, "South");
        this.southPanel.add((Component)this.xMatchedLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 12, 5, 5), 0, 0));
        this.southPanel.add((Component)this.xMatched, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 5, 0), 0, 0));
        this.southPanel.add((Component)this.xMatchedToLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 10, 5, 5), 0, 0));
        this.southPanel.add((Component)this.bProcess, new GridBagConstraints(6, 0, 1, 1, 0.0, 0.0, 12, 0, new Insets(5, 12, 5, 12), 0, 0));
        this.southPanel.add((Component)this.differenceLabel, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 10, 5, 5), 0, 0));
        this.mainPanel.add((Component)this.centerPanel, "Center");
        this.centerPanel.add((Component)this.xMatchedScrollPane, "North");
        this.xMatchedScrollPane.getViewport().add((Component)this.xMatchedTable, null);
        this.centerPanel.add((Component)this.xMatchedToScrollPane, "South");
        this.centerPanel.add((Component)this.xPanel, "Center");
        this.xPanel.add((Component)this.sameBPartner, null);
        this.xPanel.add((Component)this.sameProduct, null);
        this.xPanel.add((Component)this.sameQty, null);
        this.xMatchedToScrollPane.getViewport().add((Component)this.xMatchedToTable, null);
        this.southPanel.add((Component)this.difference, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 5, 0), 0, 0));
        this.southPanel.add((Component)this.xMatchedTo, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 5, 0), 0, 0));
    }

    private void dynInit() {
        ColumnInfo[] layout = new ColumnInfo[]{new ColumnInfo(" ", ".", IDColumn.class, false, false, ""), new ColumnInfo(Msg.translate(Env.getCtx(), "DocumentNo"), ".", String.class), new ColumnInfo(Msg.translate(Env.getCtx(), "Date"), ".", Timestamp.class), new ColumnInfo(Msg.translate(Env.getCtx(), "C_BPartner_ID"), ".", KeyNamePair.class, "."), new ColumnInfo(Msg.translate(Env.getCtx(), "Line"), ".", KeyNamePair.class, "."), new ColumnInfo(Msg.translate(Env.getCtx(), "M_Product_ID"), ".", KeyNamePair.class, "."), new ColumnInfo(Msg.translate(Env.getCtx(), "Qty"), ".", Double.class), new ColumnInfo(Msg.translate(Env.getCtx(), "Matched"), ".", Double.class)};
        this.xMatchedTable.prepareTable(layout, "", "", false, "");
        this.xMatchedToTable.prepareTable(layout, "", "", true, "");
        CompiereColor.setBackground(this);
        this.matchFrom.addActionListener(this);
        this.matchTo.addActionListener(this);
        this.bSearch.addActionListener(this);
        this.xMatchedTable.getSelectionModel().addListSelectionListener(this);
        this.xMatchedToTable.getModel().addTableModelListener(this);
        this.bProcess.addActionListener(this);
        this.sameBPartner.addActionListener(this);
        this.sameProduct.addActionListener(this);
        this.sameQty.addActionListener(this);
        this.cmd_matchFrom();
        this.statusBar.setStatusLine("");
        this.statusBar.setStatusDB(0);
    }

    public void dispose() {
        if (this.m_frame != null) {
            this.m_frame.dispose();
        }
        this.m_frame = null;
    }

    public void actionPerformed(ActionEvent e) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        if (e.getSource() == this.matchFrom) {
            this.cmd_matchFrom();
        } else if (e.getSource() == this.matchTo) {
            this.cmd_matchTo();
        } else if (e.getSource() == this.bSearch) {
            this.cmd_search();
        } else if (e.getSource() == this.bProcess) {
            this.cmd_process();
        } else if (e.getSource() == this.sameBPartner || e.getSource() == this.sameProduct || e.getSource() == this.sameQty) {
            this.cmd_searchTo();
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    private void cmd_matchFrom() {
        String selection = (String)this.matchFrom.getSelectedItem();
        Vector<String> vector = new Vector<String>(2);
        if (selection.equals(this.m_matchOptions[0])) {
            vector.add(this.m_matchOptions[1]);
        } else if (selection.equals(this.m_matchOptions[2])) {
            vector.add(this.m_matchOptions[1]);
        } else {
            vector.add(this.m_matchOptions[0]);
            vector.add(this.m_matchOptions[2]);
        }
        this.matchTo.setModel(new DefaultComboBoxModel(vector));
        this.xMatchedBorder.setTitle(selection);
        this.xMatchedScrollPane.repaint();
        this.xMatchedTable.setRowCount(0);
        this.cmd_matchTo();
    }

    private void cmd_matchTo() {
        String selection = (String)this.matchTo.getSelectedItem();
        this.xMatchedToBorder.setTitle(selection);
        this.xMatchedToScrollPane.repaint();
        this.xMatchedToTable.setRowCount(0);
    }

    private void cmd_search() {
        int display = this.matchFrom.getSelectedIndex();
        String matchToString = (String)this.matchTo.getSelectedItem();
        int matchToType = 0;
        if (matchToString.equals(this.m_matchOptions[1])) {
            matchToType = 1;
        } else if (matchToString.equals(this.m_matchOptions[2])) {
            matchToType = 2;
        }
        this.tableInit(display, matchToType);
        if (this.onlyProduct.getValue() != null) {
            Integer Product = (Integer)this.onlyProduct.getValue();
            this.m_sql.append(" AND lin.M_Product_ID=").append(Product);
        }
        if (this.onlyVendor.getValue() != null) {
            Integer Vendor = (Integer)this.onlyVendor.getValue();
            this.m_sql.append(" AND hdr.C_BPartner_ID=").append(Vendor);
        }
        Timestamp from = (Timestamp)this.dateFrom.getValue();
        Timestamp to = (Timestamp)this.dateTo.getValue();
        if (from != null && to != null) {
            this.m_sql.append(" AND ").append(this.m_dateColumn).append(" BETWEEN ").append(DB.TO_DATE(from)).append(" AND ").append(DB.TO_DATE(to));
        } else if (from != null) {
            this.m_sql.append(" AND ").append(this.m_dateColumn).append(" >= ").append(DB.TO_DATE(from));
        } else if (to != null) {
            this.m_sql.append(" AND ").append(this.m_dateColumn).append(" <= ").append(DB.TO_DATE(to));
        }
        this.tableLoad(this.xMatchedTable);
        this.xMatched.setValue(Env.ZERO);
        this.statusBar.setStatusLine(this.matchFrom.getSelectedItem().toString() + "# = " + this.xMatchedTable.getRowCount(), this.xMatchedTable.getRowCount() == 0);
        this.statusBar.setStatusDB(0);
    }

    private void cmd_process() {
        log.config("");
        int matchedRow = this.xMatchedTable.getSelectedRow();
        if (matchedRow < 0) {
            return;
        }
        KeyNamePair lineMatched = (KeyNamePair)this.xMatchedTable.getValueAt(matchedRow, 4);
        KeyNamePair Product = (KeyNamePair)this.xMatchedTable.getValueAt(matchedRow, 5);
        int M_Product_ID = Product.getKey();
        double totalQty = this.m_xMatched.doubleValue();
        for (int row = 0; row < this.xMatchedToTable.getRowCount(); ++row) {
            IDColumn id = (IDColumn)this.xMatchedToTable.getValueAt(row, 0);
            if (id == null || !id.isSelected()) continue;
            KeyNamePair ProductCompare = (KeyNamePair)this.xMatchedToTable.getValueAt(row, 5);
            if (Product.getKey() != ProductCompare.getKey()) continue;
            KeyNamePair lineMatchedTo = (KeyNamePair)this.xMatchedToTable.getValueAt(row, 4);
            double qty = 0.0;
            if (this.matchMode.getSelectedIndex() == 0) {
                qty = (Double)this.xMatchedToTable.getValueAt(row, 6);
            }
            if ((qty -= ((Double)this.xMatchedToTable.getValueAt(row, 7)).doubleValue()) > totalQty) {
                qty = totalQty;
            }
            totalQty -= qty;
            boolean invoice = true;
            if (this.matchFrom.getSelectedIndex() == 2 || this.matchTo.getSelectedItem().equals(this.m_matchOptions[2])) {
                invoice = false;
            }
            int M_InOutLine_ID = 0;
            int Line_ID = 0;
            if (this.matchFrom.getSelectedIndex() == 1) {
                M_InOutLine_ID = lineMatched.getKey();
                Line_ID = lineMatchedTo.getKey();
            } else {
                M_InOutLine_ID = lineMatchedTo.getKey();
                Line_ID = lineMatched.getKey();
            }
            this.createMatchRecord(invoice, M_InOutLine_ID, Line_ID, new BigDecimal(qty));
        }
        this.cmd_search();
    }

    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.cmd_searchTo();
        this.setCursor(Cursor.getDefaultCursor());
    }

    private void cmd_searchTo() {
        int row = this.xMatchedTable.getSelectedRow();
        log.config("Row=" + row);
        double qty = 0.0;
        if (row < 0) {
            this.xMatchedToTable.setRowCount(0);
        } else {
            String displayString = (String)this.matchTo.getSelectedItem();
            int display = 0;
            if (displayString.equals(this.m_matchOptions[1])) {
                display = 1;
            } else if (displayString.equals(this.m_matchOptions[2])) {
                display = 2;
            }
            int matchToType = this.matchFrom.getSelectedIndex();
            this.tableInit(display, matchToType);
            KeyNamePair BPartner = (KeyNamePair)this.xMatchedTable.getValueAt(row, 3);
            KeyNamePair Product = (KeyNamePair)this.xMatchedTable.getValueAt(row, 5);
            log.fine("BPartner=" + BPartner + " - Product=" + Product);
            if (this.sameBPartner.isSelected()) {
                this.m_sql.append(" AND hdr.C_BPartner_ID=").append(BPartner.getKey());
            }
            if (this.sameProduct.isSelected()) {
                this.m_sql.append(" AND lin.M_Product_ID=").append(Product.getKey());
            }
            double docQty = (Double)this.xMatchedTable.getValueAt(row, 6);
            double matchedQty = (Double)this.xMatchedTable.getValueAt(row, 7);
            qty = docQty - matchedQty;
            if (this.sameQty.isSelected()) {
                this.m_sql.append(" AND ").append(this.m_qtyColumn).append("=").append(docQty);
            }
            this.tableLoad(this.xMatchedToTable);
        }
        this.m_xMatched = new BigDecimal(qty);
        this.xMatched.setValue(this.m_xMatched);
        this.xMatchedTo.setValue(Env.ZERO);
        this.difference.setValue(this.m_xMatched);
        this.statusBar.setStatusLine(this.matchFrom.getSelectedItem().toString() + "# = " + this.xMatchedTable.getRowCount() + " - " + this.matchTo.getSelectedItem().toString() + "# = " + this.xMatchedToTable.getRowCount(), this.xMatchedToTable.getRowCount() == 0);
        this.statusBar.setStatusDB(0);
    }

    public void tableChanged(TableModelEvent e) {
        if (e.getColumn() != 0) {
            return;
        }
        log.config("Row=" + e.getFirstRow() + "-" + e.getLastRow() + ", Col=" + e.getColumn() + ", Type=" + e.getType());
        this.setCursor(Cursor.getPredefinedCursor(3));
        int matchedRow = this.xMatchedTable.getSelectedRow();
        KeyNamePair Product = (KeyNamePair)this.xMatchedTable.getValueAt(matchedRow, 5);
        double qty = 0.0;
        int noRows = 0;
        for (int row = 0; row < this.xMatchedToTable.getRowCount(); ++row) {
            IDColumn id = (IDColumn)this.xMatchedToTable.getValueAt(row, 0);
            if (id == null || !id.isSelected()) continue;
            KeyNamePair ProductCompare = (KeyNamePair)this.xMatchedToTable.getValueAt(row, 5);
            if (Product.getKey() != ProductCompare.getKey()) {
                id.setSelected(false);
                continue;
            }
            if (this.matchMode.getSelectedIndex() == 0) {
                qty += ((Double)this.xMatchedToTable.getValueAt(row, 6)).doubleValue();
            }
            qty -= ((Double)this.xMatchedToTable.getValueAt(row, 7)).doubleValue();
            ++noRows;
        }
        this.m_xMatchedTo = new BigDecimal(qty);
        this.xMatchedTo.setValue(this.m_xMatchedTo);
        this.difference.setValue(this.m_xMatched.subtract(this.m_xMatchedTo));
        this.bProcess.setEnabled(noRows != 0);
        this.setCursor(Cursor.getDefaultCursor());
        this.statusBar.setStatusDB(noRows);
    }

    private void tableInit(int display, int matchToType) {
        boolean matched = this.matchMode.getSelectedIndex() == 1;
        log.config("Display=" + this.m_matchOptions[display] + ", MatchTo=" + this.m_matchOptions[matchToType] + ", Matched=" + matched);
        this.m_sql = new StringBuffer();
        if (display == 0) {
            this.m_dateColumn = "hdr.DateInvoiced";
            this.m_qtyColumn = "lin.QtyInvoiced";
            this.m_sql.append("SELECT hdr.C_Invoice_ID,hdr.DocumentNo, hdr.DateInvoiced, bp.Name,hdr.C_BPartner_ID, lin.Line,lin.C_InvoiceLine_ID, p.Name,lin.M_Product_ID, lin.QtyInvoiced,SUM(NVL(mi.Qty,0)) FROM C_Invoice hdr INNER JOIN C_BPartner bp ON (hdr.C_BPartner_ID=bp.C_BPartner_ID) INNER JOIN C_InvoiceLine lin ON (hdr.C_Invoice_ID=lin.C_Invoice_ID) INNER JOIN M_Product p ON (lin.M_Product_ID=p.M_Product_ID) INNER JOIN C_DocType dt ON (hdr.C_DocType_ID=dt.C_DocType_ID AND dt.DocBaseType IN ('API','APC')) FULL JOIN M_MatchInv mi ON (lin.C_InvoiceLine_ID=mi.C_InvoiceLine_ID) WHERE hdr.DocStatus IN ('CO','CL')");
            this.m_groupBy = " GROUP BY hdr.C_Invoice_ID,hdr.DocumentNo,hdr.DateInvoiced,bp.Name,hdr.C_BPartner_ID, lin.Line,lin.C_InvoiceLine_ID,p.Name,lin.M_Product_ID,lin.QtyInvoiced HAVING " + (matched ? "0" : "lin.QtyInvoiced") + "<>SUM(NVL(mi.Qty,0))";
        } else if (display == 2) {
            this.m_dateColumn = "hdr.DateOrdered";
            this.m_qtyColumn = "lin.QtyOrdered";
            this.m_sql.append("SELECT hdr.C_Order_ID,hdr.DocumentNo, hdr.DateOrdered, bp.Name,hdr.C_BPartner_ID, lin.Line,lin.C_OrderLine_ID, p.Name,lin.M_Product_ID, lin.QtyOrdered,SUM(COALESCE(mo.Qty,0)) FROM C_Order hdr INNER JOIN C_BPartner bp ON (hdr.C_BPartner_ID=bp.C_BPartner_ID) INNER JOIN C_OrderLine lin ON (hdr.C_Order_ID=lin.C_Order_ID) INNER JOIN M_Product p ON (lin.M_Product_ID=p.M_Product_ID) INNER JOIN C_DocType dt ON (hdr.C_DocType_ID=dt.C_DocType_ID AND dt.DocBaseType='POO') FULL JOIN M_MatchPO mo ON (lin.C_OrderLine_ID=mo.C_OrderLine_ID) WHERE mo.").append(matchToType == 1 ? "M_InOutLine_ID" : "C_InvoiceLine_ID").append(matched ? " IS NOT NULL" : " IS NULL AND hdr.DocStatus IN ('CO','CL')");
            this.m_groupBy = " GROUP BY hdr.C_Order_ID,hdr.DocumentNo,hdr.DateOrdered,bp.Name,hdr.C_BPartner_ID, lin.Line,lin.C_OrderLine_ID,p.Name,lin.M_Product_ID,lin.QtyOrdered HAVING " + (matched ? "0" : "lin.QtyOrdered") + "<>SUM(COALESCE(mo.Qty,0))";
        } else {
            this.m_dateColumn = "hdr.MovementDate";
            this.m_qtyColumn = "lin.MovementQty";
            this.m_sql.append("SELECT hdr.M_InOut_ID,hdr.DocumentNo, hdr.MovementDate, bp.Name,hdr.C_BPartner_ID, lin.Line,lin.M_InOutLine_ID, p.Name,lin.M_Product_ID, lin.MovementQty,SUM(NVL(m.Qty,0)) FROM M_InOut hdr INNER JOIN C_BPartner bp ON (hdr.C_BPartner_ID=bp.C_BPartner_ID) INNER JOIN M_InOutLine lin ON (hdr.M_InOut_ID=lin.M_InOut_ID) INNER JOIN M_Product p ON (lin.M_Product_ID=p.M_Product_ID) INNER JOIN C_DocType dt ON (hdr.C_DocType_ID = dt.C_DocType_ID AND dt.DocBaseType='MMR') FULL JOIN ").append(matchToType == 2 ? "M_MatchPO" : "M_MatchInv").append(" m ON (lin.M_InOutLine_ID=m.M_InOutLine_ID) WHERE hdr.DocStatus IN ('CO','CL')");
            this.m_groupBy = " GROUP BY hdr.M_InOut_ID,hdr.DocumentNo,hdr.MovementDate,bp.Name,hdr.C_BPartner_ID, lin.Line,lin.M_InOutLine_ID,p.Name,lin.M_Product_ID,lin.MovementQty HAVING " + (matched ? "0" : "lin.MovementQty") + "<>SUM(NVL(m.Qty,0))";
        }
    }

    private void tableLoad(MiniTable table2) {
        String sql = MRole.getDefault().addAccessSQL(this.m_sql.toString(), "hdr", true, false) + this.m_groupBy;
        log.finest(sql);
        try {
            Statement stmt = DB.createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            table2.loadTable(rs);
            stmt.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, sql, e);
        }
    }

    private boolean createMatchRecord(boolean invoice, int M_InOutLine_ID, int Line_ID, BigDecimal qty) {
        if (qty.compareTo(Env.ZERO) == 0) {
            return true;
        }
        log.fine("IsInvoice=" + invoice + ", M_InOutLine_ID=" + M_InOutLine_ID + ", Line_ID=" + Line_ID + ", Qty=" + qty);
        boolean success = false;
        MInOutLine sLine = new MInOutLine(Env.getCtx(), M_InOutLine_ID, null);
        if (invoice) {
            MInvoiceLine iLine = new MInvoiceLine(Env.getCtx(), Line_ID, null);
            iLine.setM_InOutLine_ID(M_InOutLine_ID);
            if (sLine.getC_OrderLine_ID() != 0) {
                iLine.setC_OrderLine_ID(sLine.getC_OrderLine_ID());
            }
            iLine.save();
            if (iLine.getM_Product_ID() != 0) {
                MMatchInv match = new MMatchInv(iLine, null, qty);
                match.setM_InOutLine_ID(M_InOutLine_ID);
                if (match.save()) {
                    success = true;
                } else {
                    log.log(Level.SEVERE, "Inv Match not created: " + match);
                }
            } else {
                success = true;
            }
            if (iLine.getC_OrderLine_ID() != 0 && iLine.getM_Product_ID() != 0) {
                MMatchPO matchPO = MMatchPO.create(iLine, sLine, null, qty);
                matchPO.setC_InvoiceLine_ID(iLine);
                matchPO.setM_InOutLine_ID(M_InOutLine_ID);
                if (!matchPO.save()) {
                    log.log(Level.SEVERE, "PO(Inv) Match not created: " + matchPO);
                }
            }
        } else {
            sLine.setC_OrderLine_ID(Line_ID);
            sLine.save();
            MOrderLine oLine = new MOrderLine(Env.getCtx(), Line_ID, null);
            if (oLine.get_ID() != 0) {
                oLine.setQtyReserved(oLine.getQtyReserved().subtract(qty));
                if (!oLine.save()) {
                    log.severe("QtyReserved not updated - C_OrderLine_ID=" + Line_ID);
                }
            }
            if (sLine.getM_Product_ID() != 0) {
                MMatchPO match = new MMatchPO(sLine, null, qty);
                if (!match.save()) {
                    log.log(Level.SEVERE, "PO Match not created: " + match);
                } else {
                    success = true;
                    if (sLine.getProduct() != null && sLine.getProduct().isStocked()) {
                        success = MStorage.add(Env.getCtx(), sLine.getM_Warehouse_ID(), sLine.getM_Locator_ID(), sLine.getM_Product_ID(), sLine.getM_AttributeSetInstance_ID(), oLine.getM_AttributeSetInstance_ID(), null, null, qty.negate(), null);
                    }
                }
            } else {
                success = true;
            }
        }
        return success;
    }
}

