/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps.form;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.VetoableChangeListener;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.adempiere.plaf.AdempierePLAF;
import org.compiere.apps.ADialog;
import org.compiere.apps.ADialogDialog;
import org.compiere.apps.ConfirmPanel;
import org.compiere.apps.ProcessCtl;
import org.compiere.apps.StatusBar;
import org.compiere.apps.form.FormFrame;
import org.compiere.apps.form.FormPanel;
import org.compiere.grid.ed.VLookup;
import org.compiere.minigrid.IDColumn;
import org.compiere.minigrid.MiniTable;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MPInstance;
import org.compiere.model.MPInstancePara;
import org.compiere.plaf.CompiereColor;
import org.compiere.print.ReportCtl;
import org.compiere.process.ProcessInfo;
import org.compiere.process.ProcessInfoUtil;
import org.compiere.swing.CLabel;
import org.compiere.swing.CPanel;
import org.compiere.swing.CTabbedPane;
import org.compiere.swing.CTextPane;
import org.compiere.util.ASyncProcess;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Trx;

public class VInOutGen
extends CPanel
implements FormPanel,
ActionListener,
VetoableChangeListener,
ChangeListener,
TableModelListener,
ASyncProcess {
    private int m_WindowNo = 0;
    private FormFrame m_frame;
    private boolean m_selectionActive = true;
    private String m_whereClause;
    private Object m_M_Warehouse_ID = null;
    private Object m_C_BPartner_ID = null;
    private static CLogger log = CLogger.getCLogger(VInOutGen.class);
    private CTabbedPane tabbedPane = new CTabbedPane();
    private CPanel selPanel = new CPanel();
    private CPanel selNorthPanel = new CPanel();
    private BorderLayout selPanelLayout = new BorderLayout();
    private CLabel lWarehouse = new CLabel();
    private VLookup fWarehouse;
    private CLabel lBPartner = new CLabel();
    private VLookup fBPartner;
    private FlowLayout northPanelLayout = new FlowLayout();
    private ConfirmPanel confirmPanelSel = new ConfirmPanel(true);
    private ConfirmPanel confirmPanelGen = new ConfirmPanel(false, true, false, false, false, false, true);
    private StatusBar statusBar = new StatusBar();
    private CPanel genPanel = new CPanel();
    private BorderLayout genLayout = new BorderLayout();
    private CTextPane info = new CTextPane();
    private JScrollPane scrollPane = new JScrollPane();
    private MiniTable miniTable = new MiniTable();

    public void init(int WindowNo, FormFrame frame) {
        log.info("");
        this.m_WindowNo = WindowNo;
        this.m_frame = frame;
        Env.setContext(Env.getCtx(), this.m_WindowNo, "IsSOTrx", "Y");
        try {
            this.fillPicks();
            this.jbInit();
            this.dynInit();
            frame.getContentPane().add((Component)this.tabbedPane, "Center");
            frame.getContentPane().add((Component)this.statusBar, "South");
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "init", ex);
        }
    }

    void jbInit() throws Exception {
        CompiereColor.setBackground(this);
        this.selPanel.setLayout(this.selPanelLayout);
        this.lWarehouse.setLabelFor(this.fWarehouse);
        this.lBPartner.setLabelFor(this.fBPartner);
        this.lBPartner.setText("BPartner");
        this.selNorthPanel.setLayout(this.northPanelLayout);
        this.northPanelLayout.setAlignment(0);
        this.tabbedPane.add((Component)this.selPanel, Msg.getMsg(Env.getCtx(), "Select"));
        this.selPanel.add((Component)this.selNorthPanel, "North");
        this.selNorthPanel.add((Component)this.lWarehouse, null);
        this.selNorthPanel.add((Component)this.fWarehouse, null);
        this.selNorthPanel.add((Component)this.lBPartner, null);
        this.selNorthPanel.add((Component)this.fBPartner, null);
        this.selPanel.setName("selPanel");
        this.selPanel.add((Component)this.confirmPanelSel, "South");
        this.selPanel.add((Component)this.scrollPane, "Center");
        this.scrollPane.getViewport().add((Component)this.miniTable, null);
        this.confirmPanelSel.addActionListener(this);
        this.tabbedPane.add((Component)this.genPanel, Msg.getMsg(Env.getCtx(), "Generate"));
        this.genPanel.setLayout(this.genLayout);
        this.genPanel.add((Component)this.info, "Center");
        this.genPanel.setEnabled(false);
        this.info.setBackground(AdempierePLAF.getFieldBackground_Inactive());
        this.info.setEditable(false);
        this.genPanel.add((Component)this.confirmPanelGen, "South");
        this.confirmPanelGen.addActionListener(this);
    }

    private void fillPicks() throws Exception {
        MLookup orgL = MLookupFactory.get(Env.getCtx(), this.m_WindowNo, 0, 2223, 19);
        this.fWarehouse = new VLookup("M_Warehouse_ID", true, false, true, orgL);
        this.lWarehouse.setText(Msg.translate(Env.getCtx(), "M_Warehouse_ID"));
        this.fWarehouse.addVetoableChangeListener(this);
        this.m_M_Warehouse_ID = this.fWarehouse.getValue();
        MLookup bpL = MLookupFactory.get(Env.getCtx(), this.m_WindowNo, 0, 2762, 30);
        this.fBPartner = new VLookup("C_BPartner_ID", false, false, true, bpL);
        this.lBPartner.setText(Msg.translate(Env.getCtx(), "C_BPartner_ID"));
        this.fBPartner.addVetoableChangeListener(this);
    }

    private void dynInit() {
        this.miniTable.addColumn("C_Order_ID");
        this.miniTable.addColumn("AD_Org_ID");
        this.miniTable.addColumn("C_DocType_ID");
        this.miniTable.addColumn("DocumentNo");
        this.miniTable.addColumn("C_BPartner_ID");
        this.miniTable.addColumn("DateOrdered");
        this.miniTable.addColumn("TotalLines");
        this.miniTable.setMultiSelection(true);
        this.miniTable.setRowSelectionAllowed(true);
        this.miniTable.setColumnClass(0, IDColumn.class, false, " ");
        this.miniTable.setColumnClass(1, String.class, true, Msg.translate(Env.getCtx(), "AD_Org_ID"));
        this.miniTable.setColumnClass(2, String.class, true, Msg.translate(Env.getCtx(), "C_DocType_ID"));
        this.miniTable.setColumnClass(3, String.class, true, Msg.translate(Env.getCtx(), "DocumentNo"));
        this.miniTable.setColumnClass(4, String.class, true, Msg.translate(Env.getCtx(), "C_BPartner_ID"));
        this.miniTable.setColumnClass(5, Timestamp.class, true, Msg.translate(Env.getCtx(), "DateOrdered"));
        this.miniTable.setColumnClass(6, BigDecimal.class, true, Msg.translate(Env.getCtx(), "TotalLines"));
        this.miniTable.autoSize();
        this.miniTable.getModel().addTableModelListener(this);
        this.statusBar.setStatusLine(Msg.getMsg(Env.getCtx(), "InOutGenerateSel"));
        this.statusBar.setStatusDB(" ");
        this.tabbedPane.addChangeListener(this);
    }

    private void executeQuery() {
        log.info("");
        int AD_Client_ID = Env.getAD_Client_ID(Env.getCtx());
        StringBuffer sql = new StringBuffer("SELECT C_Order_ID, o.Name, dt.Name, DocumentNo, bp.Name, DateOrdered, TotalLines FROM M_InOut_Candidate_v ic, AD_Org o, C_BPartner bp, C_DocType dt WHERE ic.AD_Org_ID=o.AD_Org_ID AND ic.C_BPartner_ID=bp.C_BPartner_ID AND ic.C_DocType_ID=dt.C_DocType_ID AND ic.AD_Client_ID=?");
        if (this.m_M_Warehouse_ID != null) {
            sql.append(" AND ic.M_Warehouse_ID=").append(this.m_M_Warehouse_ID);
        }
        if (this.m_C_BPartner_ID != null) {
            sql.append(" AND ic.C_BPartner_ID=").append(this.m_C_BPartner_ID);
        }
        sql.append(" ORDER BY o.Name,bp.Name,DateOrdered");
        log.fine(sql.toString());
        int row = 0;
        this.miniTable.setRowCount(row);
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql.toString(), null);
            pstmt.setInt(1, AD_Client_ID);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                this.miniTable.setRowCount(row + 1);
                this.miniTable.setValueAt(new IDColumn(rs.getInt(1)), row, 0);
                this.miniTable.setValueAt(rs.getString(2), row, 1);
                this.miniTable.setValueAt(rs.getString(3), row, 2);
                this.miniTable.setValueAt(rs.getString(4), row, 3);
                this.miniTable.setValueAt(rs.getString(5), row, 4);
                this.miniTable.setValueAt(rs.getTimestamp(6), row, 5);
                this.miniTable.setValueAt(rs.getBigDecimal(7), row, 6);
                ++row;
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, sql.toString(), e);
        }
        this.miniTable.autoSize();
    }

    public void dispose() {
        if (this.m_frame != null) {
            this.m_frame.dispose();
        }
        this.m_frame = null;
    }

    public void actionPerformed(ActionEvent e) {
        log.info("Cmd=" + e.getActionCommand());
        if (e.getActionCommand().equals("Cancel")) {
            this.dispose();
            return;
        }
        this.m_whereClause = this.saveSelection();
        if (this.m_whereClause.length() > 0 && this.m_selectionActive && this.m_M_Warehouse_ID != null) {
            this.generateShipments();
        } else {
            this.dispose();
        }
    }

    public void vetoableChange(PropertyChangeEvent e) {
        log.info(e.getPropertyName() + "=" + e.getNewValue());
        if (e.getPropertyName().equals("M_Warehouse_ID")) {
            this.m_M_Warehouse_ID = e.getNewValue();
        }
        if (e.getPropertyName().equals("C_BPartner_ID")) {
            this.m_C_BPartner_ID = e.getNewValue();
            this.fBPartner.setValue(this.m_C_BPartner_ID);
        }
        this.executeQuery();
    }

    public void stateChanged(ChangeEvent e) {
        int index = this.tabbedPane.getSelectedIndex();
        this.m_selectionActive = index == 0;
    }

    public void tableChanged(TableModelEvent e) {
        int rowsSelected = 0;
        int rows = this.miniTable.getRowCount();
        for (int i = 0; i < rows; ++i) {
            IDColumn id = (IDColumn)this.miniTable.getValueAt(i, 0);
            if (id == null || !id.isSelected()) continue;
            ++rowsSelected;
        }
        this.statusBar.setStatusDB(" " + rowsSelected + " ");
    }

    private String saveSelection() {
        log.info("");
        this.miniTable.editingStopped(new ChangeEvent(this));
        ArrayList<Integer> results = new ArrayList<Integer>();
        int rows = this.miniTable.getRowCount();
        for (int i = 0; i < rows; ++i) {
            IDColumn id = (IDColumn)this.miniTable.getValueAt(i, 0);
            if (id == null || !id.isSelected()) continue;
            results.add(id.getRecord_ID());
        }
        if (results.size() == 0) {
            return "";
        }
        log.config("Selected #" + results.size());
        String keyColumn = "C_Order_ID";
        StringBuffer sb = new StringBuffer(keyColumn);
        if (results.size() > 1) {
            sb.append(" IN (");
        } else {
            sb.append("=");
        }
        for (int i = 0; i < results.size(); ++i) {
            if (i > 0) {
                sb.append(",");
            }
            if (keyColumn.endsWith("_ID")) {
                sb.append(((Integer)results.get(i)).toString());
                continue;
            }
            sb.append("'").append(((Integer)results.get(i)).toString());
        }
        if (results.size() > 1) {
            sb.append(")");
        }
        log.config(sb.toString());
        return sb.toString();
    }

    private void generateShipments() {
        log.info("M_Warehouse_ID=" + this.m_M_Warehouse_ID);
        String trxName = null;
        Trx trx = null;
        String sql = "UPDATE C_Order SET IsSelected = 'N' WHERE IsSelected='Y' AND AD_Client_ID=" + Env.getAD_Client_ID(Env.getCtx());
        int no = DB.executeUpdate(sql, trxName);
        log.config("Reset=" + no);
        sql = "UPDATE C_Order SET IsSelected='Y' WHERE " + this.m_whereClause;
        no = DB.executeUpdate(sql, trxName);
        log.fine(sql);
        if (no == 0) {
            String msg = "No Shipments";
            log.config(msg);
            this.info.setText(msg);
            return;
        }
        log.info("Set Selection #" + no);
        this.m_selectionActive = false;
        this.statusBar.setStatusLine(Msg.getMsg(Env.getCtx(), "InOutGenerateGen"));
        this.statusBar.setStatusDB(String.valueOf(no));
        int AD_Process_ID = 199;
        MPInstance instance = new MPInstance(Env.getCtx(), AD_Process_ID, 0);
        if (!instance.save()) {
            this.info.setText(Msg.getMsg(Env.getCtx(), "ProcessNoInstance"));
            return;
        }
        ProcessInfo pi = new ProcessInfo("VInOutGen", AD_Process_ID);
        pi.setAD_PInstance_ID(instance.getAD_PInstance_ID());
        MPInstancePara ip = new MPInstancePara(instance, 10);
        ip.setParameter("Selection", "Y");
        if (!ip.save()) {
            String msg = "No Parameter added";
            this.info.setText(msg);
            log.log(Level.SEVERE, msg);
            return;
        }
        ip = new MPInstancePara(instance, 20);
        ip.setParameter("M_Warehouse_ID", Integer.parseInt(this.m_M_Warehouse_ID.toString()));
        if (!ip.save()) {
            String msg = "No Parameter added";
            this.info.setText(msg);
            log.log(Level.SEVERE, msg);
            return;
        }
        ProcessCtl worker = new ProcessCtl(this, pi, trx);
        worker.start();
    }

    private void generateShipments_complete(ProcessInfo pi) {
        this.tabbedPane.setSelectedIndex(1);
        ProcessInfoUtil.setLogFromDB(pi);
        StringBuffer iText = new StringBuffer();
        iText.append("<b>").append(pi.getSummary()).append("</b><br>(").append(Msg.getMsg(Env.getCtx(), "InOutGenerateInfo")).append(")<br>").append(pi.getLogInfo(true));
        this.info.setText(iText.toString());
        String sql = "UPDATE C_Order SET IsSelected='N' WHERE " + this.m_whereClause;
        int no = DB.executeUpdate(sql, null);
        log.config("Reset=" + no);
        int[] ids = pi.getIDs();
        if (ids == null || ids.length == 0) {
            return;
        }
        log.config("PrintItems=" + ids.length);
        this.confirmPanelGen.getOKButton().setEnabled(false);
        if (ADialog.ask(this.m_WindowNo, this, "PrintShipments")) {
            ADialogDialog d;
            this.setCursor(Cursor.getPredefinedCursor(3));
            int retValue = ADialogDialog.A_CANCEL;
            do {
                for (int i = 0; i < ids.length; ++i) {
                    int M_InOut_ID = ids[i];
                    ReportCtl.startDocumentPrint(1, M_InOut_ID, true);
                }
            } while ((retValue = (d = new ADialogDialog((Frame)this.m_frame, Env.getHeader(Env.getCtx(), this.m_WindowNo), Msg.getMsg(Env.getCtx(), "PrintoutOK?"), 3)).getReturnCode()) == ADialogDialog.A_CANCEL);
            this.setCursor(Cursor.getDefaultCursor());
        }
        this.confirmPanelGen.getOKButton().setEnabled(true);
    }

    public void lockUI(ProcessInfo pi) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.setEnabled(false);
    }

    public void unlockUI(ProcessInfo pi) {
        this.setEnabled(true);
        this.setCursor(Cursor.getDefaultCursor());
        this.generateShipments_complete(pi);
    }

    public boolean isUILocked() {
        return this.isEnabled();
    }

    public void executeASync(ProcessInfo pi) {
    }
}

