/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps.form;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.compiere.Adempiere;
import org.compiere.apps.ADialog;
import org.compiere.apps.ConfirmPanel;
import org.compiere.apps.SwingWorker;
import org.compiere.apps.form.FormFrame;
import org.compiere.apps.form.FormPanel;
import org.compiere.impexp.ImpFormat;
import org.compiere.impexp.ImpFormatRow;
import org.compiere.plaf.CompiereColor;
import org.compiere.swing.CPanel;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class VFileImport
extends CPanel
implements FormPanel,
ActionListener {
    private int m_WindowNo = 0;
    private FormFrame m_frame;
    private ArrayList<String> m_data = new ArrayList();
    private ImpFormat m_format;
    private JLabel[] m_labels;
    private JTextField[] m_fields;
    private int m_record = -1;
    private static CLogger log = CLogger.getCLogger(VFileImport.class);
    private static final String s_none = "----";
    private CPanel northPanel = new CPanel();
    private JButton bFile = new JButton();
    private JComboBox pickFormat = new JComboBox();
    private CPanel centerPanel = new CPanel();
    private BorderLayout centerLayout = new BorderLayout();
    private JScrollPane rawDataPane = new JScrollPane();
    private JTextArea rawData = new JTextArea();
    private JScrollPane previewPane = new JScrollPane();
    private CPanel previewPanel = new CPanel();
    private ConfirmPanel confirmPanel = new ConfirmPanel(true);
    private JLabel info = new JLabel();
    private JLabel labelFormat = new JLabel();
    private GridBagLayout previewLayout = new GridBagLayout();
    private JButton bNext = new JButton();
    private JButton bPrevious = new JButton();
    private JLabel record = new JLabel();

    public void init(int WindowNo, FormFrame frame) {
        log.info("");
        this.m_WindowNo = WindowNo;
        this.m_frame = frame;
        try {
            this.jbInit();
            this.dynInit();
            frame.getContentPane().add((Component)this.northPanel, "North");
            frame.getContentPane().add((Component)this.centerPanel, "Center");
            frame.getContentPane().add((Component)this.confirmPanel, "South");
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "init", e);
        }
    }

    private void jbInit() throws Exception {
        CompiereColor.setBackground(this);
        this.bFile.setText(Msg.getMsg(Env.getCtx(), "FileImportFile"));
        this.bFile.setToolTipText(Msg.getMsg(Env.getCtx(), "FileImportFileInfo"));
        this.bFile.addActionListener(this);
        this.info.setText("   ");
        this.labelFormat.setText(Msg.translate(Env.getCtx(), "AD_ImpFormat_ID"));
        this.bNext.setToolTipText(Msg.getMsg(Env.getCtx(), "Next"));
        this.bNext.setMargin(new Insets(2, 2, 2, 2));
        this.bNext.setText(">");
        this.bNext.addActionListener(this);
        this.record.setText("-");
        this.bPrevious.setToolTipText(Msg.getMsg(Env.getCtx(), "Previous"));
        this.bPrevious.setMargin(new Insets(2, 2, 2, 2));
        this.bPrevious.setText("<");
        this.bPrevious.addActionListener(this);
        this.northPanel.setBorder(BorderFactory.createEtchedBorder());
        this.northPanel.add((Component)this.bFile, null);
        this.northPanel.add((Component)this.info, null);
        this.northPanel.add((Component)this.labelFormat, null);
        this.northPanel.add((Component)this.pickFormat, null);
        this.northPanel.add((Component)this.bPrevious, null);
        this.northPanel.add((Component)this.record, null);
        this.northPanel.add((Component)this.bNext, null);
        this.centerPanel.setLayout(this.centerLayout);
        this.rawData.setFont(new Font("Monospaced", 0, 10));
        this.rawData.setColumns(80);
        this.rawData.setRows(5);
        this.rawDataPane.getViewport().add((Component)this.rawData, null);
        this.centerPanel.add((Component)this.rawDataPane, "North");
        this.centerPanel.add((Component)this.previewPane, "Center");
        this.previewPanel.setLayout(this.previewLayout);
        this.previewPane.getViewport().add((Component)this.previewPanel, null);
        this.previewPane.setPreferredSize(new Dimension(700, 80));
        this.confirmPanel.addActionListener(this);
    }

    public void dispose() {
        if (this.m_frame != null) {
            this.m_frame.dispose();
        }
        this.m_frame = null;
    }

    private void dynInit() {
        this.pickFormat.addItem(s_none);
        String sql = "SELECT Name from AD_ImpFormat";
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql, null);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                this.pickFormat.addItem(rs.getString(1));
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, sql, e);
        }
        this.pickFormat.setSelectedIndex(0);
        this.pickFormat.addActionListener(this);
        this.confirmPanel.getOKButton().setEnabled(false);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.bFile) {
            this.cmd_loadFile();
            this.invalidate();
            this.m_frame.pack();
        } else if (e.getSource() == this.pickFormat) {
            this.cmd_loadFormat();
            this.invalidate();
            this.m_frame.pack();
        } else if (e.getSource() == this.bNext) {
            this.cmd_applyFormat(true);
        } else if (e.getSource() == this.bPrevious) {
            this.cmd_applyFormat(false);
        } else if (e.getActionCommand().equals("Ok")) {
            this.m_frame.setCursor(Cursor.getPredefinedCursor(3));
            this.confirmPanel.setEnabled(false);
            this.m_frame.setBusy(true);
            SwingWorker worker = new SwingWorker(){

                public Object construct() {
                    VFileImport.this.cmd_process();
                    return Boolean.TRUE;
                }
            };
            worker.start();
        } else if (e.getActionCommand().equals("Cancel")) {
            this.dispose();
        }
        if (this.m_data != null && this.m_data.size() > 0 && this.m_format != null && this.m_format.getRowCount() > 0) {
            this.confirmPanel.getOKButton().setEnabled(true);
        } else {
            this.confirmPanel.getOKButton().setEnabled(false);
        }
    }

    private void cmd_loadFile() {
        String directory = Adempiere.getAdempiereHome() + File.separator + "data" + File.separator + "import";
        log.config(directory);
        JFileChooser chooser = new JFileChooser(directory);
        chooser.setFileSelectionMode(0);
        chooser.setMultiSelectionEnabled(false);
        chooser.setDialogTitle(Msg.getMsg(Env.getCtx(), "FileImportFileInfo"));
        if (chooser.showOpenDialog(this) != 0) {
            return;
        }
        String fileName = chooser.getSelectedFile().getName();
        log.config(fileName);
        this.bFile.setText(fileName);
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.m_data.clear();
        this.rawData.setText("");
        try {
            BufferedReader in = new BufferedReader(new FileReader(chooser.getSelectedFile()), 10240);
            String s = null;
            while ((s = in.readLine()) != null) {
                this.m_data.add(s);
                if (this.m_data.size() >= 100) continue;
                this.rawData.append(s);
                this.rawData.append("\n");
            }
            in.close();
            this.rawData.setCaretPosition(0);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "", e);
            this.bFile.setText(Msg.getMsg(Env.getCtx(), "FileImportFile"));
        }
        int index = 1;
        if (this.m_data.size() == 1) {
            index = 0;
        }
        int length = 0;
        if (this.m_data.size() > 0) {
            length = this.m_data.get(index).toString().length();
        }
        this.info.setText(Msg.getMsg(Env.getCtx(), "Records") + "=" + this.m_data.size() + ", " + Msg.getMsg(Env.getCtx(), "Length") + "=" + length + "   ");
        this.setCursor(Cursor.getDefaultCursor());
        log.config("Records=" + this.m_data.size() + ", Length=" + length);
    }

    private void cmd_loadFormat() {
        this.previewPanel.removeAll();
        String formatName = this.pickFormat.getSelectedItem().toString();
        if (formatName.equals(s_none)) {
            return;
        }
        this.m_format = ImpFormat.load(formatName);
        if (this.m_format == null) {
            ADialog.error(this.m_WindowNo, this, "FileImportNoFormat", formatName);
            return;
        }
        int size = this.m_format.getRowCount();
        this.m_labels = new JLabel[size];
        this.m_fields = new JTextField[size];
        for (int i = 0; i < size; ++i) {
            ImpFormatRow row = this.m_format.getRow(i);
            this.m_labels[i] = new JLabel(row.getColumnName());
            this.previewPanel.add((Component)this.m_labels[i], new GridBagConstraints(i, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(2, 2, 2, 2), 0, 0));
            int length = row.getEndNo() - row.getStartNo();
            if (length <= 5) {
                length = 5;
            } else if (length > 20) {
                length = 20;
            }
            this.m_fields[i] = new JTextField(length);
            this.previewPanel.add((Component)this.m_fields[i], new GridBagConstraints(i, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(2, 2, 2, 2), 0, 0));
        }
        this.m_record = -1;
        this.record.setText("-");
        this.previewPanel.invalidate();
        this.previewPanel.repaint();
    }

    private void cmd_applyFormat(boolean next) {
        if (this.m_format == null) {
            return;
        }
        this.m_record = next ? ++this.m_record : --this.m_record;
        if (this.m_record < 0) {
            this.m_record = 0;
        } else if (this.m_record >= this.m_data.size()) {
            this.m_record = this.m_data.size() - 1;
        }
        this.record.setText(" " + String.valueOf(this.m_record + 1) + " ");
        String[] lInfo = this.m_format.parseLine(this.m_data.get(this.m_record).toString(), false, true, false);
        int size = this.m_format.getRowCount();
        if (lInfo.length != size) {
            log.log(Level.SEVERE, "FormatElements=" + size + " != Fields=" + lInfo.length);
        }
        for (int i = 0; i < size; ++i) {
            this.m_fields[i].setText(lInfo[i]);
            this.m_fields[i].setCaretPosition(0);
        }
    }

    private void cmd_process() {
        if (this.m_format == null) {
            ADialog.error(this.m_WindowNo, this, "FileImportNoFormat");
            return;
        }
        log.config(this.m_format.getName());
        int row = 0;
        int imported = 0;
        for (row = 0; row < this.m_data.size(); ++row) {
            if (!this.m_format.updateDB(Env.getCtx(), this.m_data.get(row).toString(), null)) continue;
            ++imported;
        }
        ADialog.info(this.m_WindowNo, this, "FileImportR/I", row + " / " + imported + "#");
        this.dispose();
    }
}

