/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps.form;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import java.util.logging.Level;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.adempiere.plaf.AdempierePLAF;
import org.compiere.apps.ADialog;
import org.compiere.apps.ConfirmPanel;
import org.compiere.apps.form.FormFrame;
import org.compiere.apps.form.FormPanel;
import org.compiere.minigrid.MiniTable;
import org.compiere.model.MAccount;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MCharge;
import org.compiere.model.MElementValue;
import org.compiere.plaf.CompiereColor;
import org.compiere.swing.CPanel;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;

public class VCharge
extends CPanel
implements FormPanel,
ActionListener {
    private int m_WindowNo = 0;
    private FormFrame m_frame;
    private int m_C_Element_ID = 0;
    private int m_C_AcctSchema_ID = 0;
    private int m_C_TaxCategory_ID = 0;
    private int m_AD_Client_ID = 0;
    private int m_AD_Org_ID = 0;
    private int m_CreatedBy = 0;
    private MAcctSchema m_acctSchema = null;
    private static CLogger log = CLogger.getCLogger(VCharge.class);
    private CPanel mainPanel = new CPanel();
    private BorderLayout mainLayout = new BorderLayout();
    private CPanel newPanel = new CPanel();
    private TitledBorder newBorder;
    private GridBagLayout newLayout = new GridBagLayout();
    private JLabel valueLabel = new JLabel();
    private JTextField valueField = new JTextField();
    private JCheckBox isExpense = new JCheckBox();
    private JLabel nameLabel = new JLabel();
    private JTextField nameField = new JTextField();
    private JButton newButton = new JButton();
    private CPanel accountPanel = new CPanel();
    private TitledBorder accountBorder;
    private BorderLayout accountLayout = new BorderLayout();
    private CPanel accountOKPanel = new CPanel();
    private JButton accountButton = new JButton();
    private FlowLayout accountOKLayout = new FlowLayout();
    private JScrollPane dataPane = new JScrollPane();
    private MiniTable dataTable = new MiniTable();
    private ConfirmPanel confirmPanel = new ConfirmPanel();

    public void init(int WindowNo, FormFrame frame) {
        log.info("");
        this.m_WindowNo = WindowNo;
        this.m_frame = frame;
        try {
            this.jbInit();
            this.dynInit();
            frame.getContentPane().add((Component)this.mainPanel, "Center");
            frame.getContentPane().add((Component)this.confirmPanel, "South");
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "", e);
        }
    }

    private void jbInit() throws Exception {
        CompiereColor.setBackground(this);
        this.newBorder = new TitledBorder("");
        this.accountBorder = new TitledBorder("");
        this.mainPanel.setLayout(this.mainLayout);
        this.newPanel.setBorder(this.newBorder);
        this.newPanel.setLayout(this.newLayout);
        this.newBorder.setTitle(Msg.getMsg(Env.getCtx(), "ChargeNewAccount"));
        this.valueLabel.setText(Msg.translate(Env.getCtx(), "Value"));
        this.isExpense.setSelected(true);
        this.isExpense.setText(Msg.getMsg(Env.getCtx(), "Expense"));
        this.nameLabel.setText(Msg.translate(Env.getCtx(), "Name"));
        this.nameField.setColumns(20);
        this.valueField.setColumns(10);
        this.newButton.setText(Msg.getMsg(Env.getCtx(), "Create"));
        this.newButton.addActionListener(this);
        this.accountPanel.setBorder(this.accountBorder);
        this.accountPanel.setLayout(this.accountLayout);
        this.accountBorder.setTitle(Msg.getMsg(Env.getCtx(), "ChargeFromAccount"));
        this.accountButton.setText(Msg.getMsg(Env.getCtx(), "Create"));
        this.accountButton.addActionListener(this);
        this.accountOKPanel.setLayout(this.accountOKLayout);
        this.accountOKLayout.setAlignment(2);
        this.confirmPanel.addActionListener(this);
        this.mainPanel.add((Component)this.newPanel, "North");
        this.newPanel.add((Component)this.valueLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.newPanel.add((Component)this.valueField, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.newPanel.add((Component)this.nameLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.newPanel.add((Component)this.nameField, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.newPanel.add((Component)this.isExpense, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.newPanel.add((Component)this.newButton, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.mainPanel.add((Component)this.accountPanel, "Center");
        this.accountPanel.add((Component)this.accountOKPanel, "South");
        this.accountOKPanel.add((Component)this.accountButton, null);
        this.accountPanel.add((Component)this.dataPane, "Center");
        this.dataPane.getViewport().add((Component)this.dataTable, null);
    }

    private void dynInit() {
        this.m_C_AcctSchema_ID = Env.getContextAsInt(Env.getCtx(), "$C_AcctSchema_ID");
        String sql = "SELECT C_Element_ID FROM C_AcctSchema_Element WHERE ElementType='AC' AND C_AcctSchema_ID=?";
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, this.m_C_AcctSchema_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                this.m_C_Element_ID = rs.getInt(1);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, sql, e);
        }
        if (this.m_C_Element_ID == 0) {
            return;
        }
        Vector data = new Vector();
        sql = "SELECT C_ElementValue_ID,Value, Name, AccountType FROM C_ElementValue WHERE AccountType IN ('R','E') AND IsSummary='N' AND C_Element_ID=? ORDER BY 2";
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, this.m_C_Element_ID);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                Vector<Object> line = new Vector<Object>(4);
                line.add(new Boolean(false));
                KeyNamePair pp = new KeyNamePair(rs.getInt(1), rs.getString(2));
                line.add(pp);
                line.add(rs.getString(3));
                boolean isExpenseType = rs.getString(4).equals("E");
                line.add(new Boolean(isExpenseType));
                data.add(line);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, sql, e);
        }
        Vector<String> columnNames = new Vector<String>(4);
        columnNames.add(Msg.getMsg(Env.getCtx(), "Select"));
        columnNames.add(Msg.translate(Env.getCtx(), "Value"));
        columnNames.add(Msg.translate(Env.getCtx(), "Name"));
        columnNames.add(Msg.getMsg(Env.getCtx(), "Expense"));
        DefaultTableModel model = new DefaultTableModel(data, columnNames);
        this.dataTable.setModel(model);
        this.dataTable.setColumnClass(0, Boolean.class, false);
        this.dataTable.setColumnClass(1, String.class, true);
        this.dataTable.setColumnClass(2, String.class, true);
        this.dataTable.setColumnClass(3, Boolean.class, true);
        this.dataTable.autoSize();
        this.m_AD_Client_ID = Env.getAD_Client_ID(Env.getCtx());
        this.m_AD_Org_ID = Env.getAD_Org_ID(Env.getCtx());
        this.m_CreatedBy = Env.getAD_User_ID(Env.getCtx());
        sql = "SELECT C_TaxCategory_ID FROM C_TaxCategory WHERE IsDefault='Y' AND AD_Client_ID=?";
        this.m_C_TaxCategory_ID = 0;
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, this.m_AD_Client_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                this.m_C_TaxCategory_ID = rs.getInt(1);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, sql, e);
        }
    }

    public void dispose() {
        if (this.m_frame != null) {
            this.m_frame.dispose();
        }
        this.m_frame = null;
    }

    public void actionPerformed(ActionEvent e) {
        log.info(e.getActionCommand());
        if (e.getActionCommand().equals("Ok") || this.m_C_Element_ID == 0) {
            this.dispose();
        } else if (e.getSource().equals(this.newButton)) {
            this.createNew();
        } else if (e.getSource().equals(this.accountButton)) {
            this.createAccount();
        }
    }

    private void createNew() {
        log.config("");
        String value = this.valueField.getText();
        if (value.length() == 0) {
            this.valueField.setBackground(AdempierePLAF.getFieldBackground_Error());
            return;
        }
        String name = this.nameField.getText();
        if (name.length() == 0) {
            this.nameField.setBackground(AdempierePLAF.getFieldBackground_Error());
            return;
        }
        int C_ElementValue_ID = this.create_ElementValue(value, name, this.isExpense.isSelected());
        if (C_ElementValue_ID == 0) {
            ADialog.error(this.m_WindowNo, this, "ChargeNotCreated", name);
            return;
        }
        int C_Charge_ID = this.create_Charge(name, C_ElementValue_ID);
        if (C_Charge_ID == 0) {
            ADialog.error(this.m_WindowNo, this, "ChargeNotCreated", name);
            return;
        }
        ADialog.info(this.m_WindowNo, this, "ChargeCreated", name);
    }

    private void createAccount() {
        log.config("");
        StringBuffer listCreated = new StringBuffer();
        StringBuffer listRejected = new StringBuffer();
        TableModel model = this.dataTable.getModel();
        int rows = model.getRowCount();
        for (int i = 0; i < rows; ++i) {
            if (!((Boolean)model.getValueAt(i, 0)).booleanValue()) continue;
            KeyNamePair pp = (KeyNamePair)model.getValueAt(i, 1);
            int C_ElementValue_ID = pp.getKey();
            String name = (String)model.getValueAt(i, 2);
            int C_Charge_ID = this.create_Charge(name, C_ElementValue_ID);
            if (C_Charge_ID == 0) {
                if (listRejected.length() > 0) {
                    listRejected.append(", ");
                }
                listRejected.append(name);
            } else {
                if (listCreated.length() > 0) {
                    listCreated.append(", ");
                }
                listCreated.append(name);
            }
            model.setValueAt(new Boolean(false), i, 0);
        }
        if (listCreated.length() > 0) {
            ADialog.info(this.m_WindowNo, this, "ChargeCreated", listCreated.toString());
        }
        if (listRejected.length() > 0) {
            ADialog.error(this.m_WindowNo, this, "ChargeNotCreated", listRejected.toString());
        }
    }

    private int create_ElementValue(String value, String name, boolean isExpenseType) {
        log.config(name);
        MElementValue ev = new MElementValue(Env.getCtx(), value, name, null, isExpenseType ? "E" : "R", "N", false, false, null);
        ev.setAD_Org_ID(this.m_AD_Org_ID);
        if (!ev.save()) {
            log.log(Level.WARNING, "C_ElementValue_ID not created");
        }
        return ev.getC_ElementValue_ID();
    }

    private int create_Charge(String name, int C_ElementValue_ID) {
        log.config(name + " - ");
        MCharge charge = new MCharge(Env.getCtx(), 0, null);
        charge.setName(name);
        charge.setC_TaxCategory_ID(this.m_C_TaxCategory_ID);
        if (!charge.save()) {
            log.log(Level.SEVERE, name + " not created");
            return 0;
        }
        if (this.m_acctSchema == null) {
            this.m_acctSchema = new MAcctSchema(Env.getCtx(), this.m_C_AcctSchema_ID, null);
        }
        if (this.m_acctSchema == null || this.m_acctSchema.getC_AcctSchema_ID() == 0) {
            return 0;
        }
        MAccount defaultAcct = MAccount.getDefault(this.m_acctSchema, true);
        MAccount acct = MAccount.get(Env.getCtx(), charge.getAD_Client_ID(), charge.getAD_Org_ID(), this.m_acctSchema.getC_AcctSchema_ID(), C_ElementValue_ID, defaultAcct.getC_SubAcct_ID(), defaultAcct.getM_Product_ID(), defaultAcct.getC_BPartner_ID(), defaultAcct.getAD_OrgTrx_ID(), defaultAcct.getC_LocFrom_ID(), defaultAcct.getC_LocTo_ID(), defaultAcct.getC_SalesRegion_ID(), defaultAcct.getC_Project_ID(), defaultAcct.getC_Campaign_ID(), defaultAcct.getC_Activity_ID(), defaultAcct.getUser1_ID(), defaultAcct.getUser2_ID(), defaultAcct.getUserElement1_ID(), defaultAcct.getUserElement2_ID());
        if (acct == null) {
            return 0;
        }
        StringBuffer sql = new StringBuffer("UPDATE C_Charge_Acct ");
        sql.append("SET CH_Expense_Acct=").append(acct.getC_ValidCombination_ID());
        sql.append(", CH_Revenue_Acct=").append(acct.getC_ValidCombination_ID());
        sql.append(" WHERE C_Charge_ID=").append(charge.getC_Charge_ID());
        sql.append(" AND C_AcctSchema_ID=").append(this.m_C_AcctSchema_ID);
        int no = DB.executeUpdate(sql.toString(), null);
        if (no != 1) {
            log.log(Level.SEVERE, "Update #" + no + "\n" + sql.toString());
        }
        return charge.getC_Charge_ID();
    }
}

