/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps.form;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.Vector;
import java.util.logging.Level;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.compiere.Adempiere;
import org.compiere.apps.AEnv;
import org.compiere.apps.ALayout;
import org.compiere.apps.ALayoutConstraint;
import org.compiere.apps.ConfirmPanel;
import org.compiere.apps.form.FormFrame;
import org.compiere.apps.form.FormPanel;
import org.compiere.grid.ed.VComboBox;
import org.compiere.model.MAttribute;
import org.compiere.model.MAttributeValue;
import org.compiere.model.MProduct;
import org.compiere.model.MProductPrice;
import org.compiere.model.MRole;
import org.compiere.model.MStorage;
import org.compiere.swing.CComboBox;
import org.compiere.swing.CLabel;
import org.compiere.swing.CPanel;
import org.compiere.swing.CScrollPane;
import org.compiere.swing.CTabbedPane;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;

public class VAttributeGrid
extends CPanel
implements FormPanel,
ChangeListener,
ActionListener {
    private int m_WindowNo = 0;
    private FormFrame m_frame;
    private MAttribute[] m_attributes = null;
    private boolean m_setting = false;
    private static CLogger log = CLogger.getCLogger(VAttributeGrid.class);
    private static String[] MODES = new String[]{Msg.getMsg(Env.getCtx(), "ModeView")};
    private static final int MODE_VIEW = 0;
    private static final int MODE_PO = 0;
    private static final int MODE_PRICE = 0;
    private int m_M_PriceList_Version_ID = 0;
    private DecimalFormat m_price = DisplayType.getNumberFormat(37);
    private int m_M_Warehouse_ID = 0;
    private DecimalFormat m_qty = DisplayType.getNumberFormat(29);
    private CTabbedPane tabbedPane = new CTabbedPane();
    private CPanel selectPanel = new CPanel(new ALayout());
    private CLabel attributeLabel1 = new CLabel(Msg.getElement(Env.getCtx(), "M_Attribute_ID") + " 1");
    private CComboBox attributeCombo1 = null;
    private CLabel attributeLabel2 = new CLabel(Msg.getElement(Env.getCtx(), "M_Attribute_ID") + " 2");
    private CComboBox attributeCombo2 = null;
    private CLabel labelPriceList = new CLabel(Msg.getElement(Env.getCtx(), "M_PriceList_ID"));
    private VComboBox pickPriceList = new VComboBox();
    private CLabel labelWarehouse = new CLabel(Msg.getElement(Env.getCtx(), "M_Warehouse_ID"));
    private VComboBox pickWarehouse = new VComboBox();
    private ConfirmPanel confirmPanel = new ConfirmPanel(true);
    private CPanel gridPanel = new CPanel(new BorderLayout());
    private CPanel modePanel = new CPanel();
    private CLabel modeLabel = new CLabel(Msg.getMsg(Env.getCtx(), "Mode"));
    private CComboBox modeCombo = new CComboBox(MODES);

    public void init(int WindowNo, FormFrame frame) {
        this.m_WindowNo = WindowNo;
        this.m_frame = frame;
        frame.getContentPane().add((Component)this, "Center");
        this.setLayout(new BorderLayout());
        this.add((Component)this.tabbedPane, "Center");
        this.add((Component)this.confirmPanel, "South");
        this.tabbedPane.addChangeListener(this);
        this.confirmPanel.addActionListener(this);
        this.tabbedPane.add((Component)this.selectPanel, Msg.getMsg(Env.getCtx(), "Selection"));
        this.selectPanel.add((Component)this.attributeLabel1, new ALayoutConstraint(0, 0));
        this.m_attributes = MAttribute.getOfClient(Env.getCtx(), true, true);
        Vector<KeyNamePair> vector = new Vector<KeyNamePair>();
        vector.add(new KeyNamePair(0, ""));
        for (int i = 0; i < this.m_attributes.length; ++i) {
            vector.add(this.m_attributes[i].getKeyNamePair());
        }
        this.attributeCombo1 = new CComboBox((Vector)vector);
        this.selectPanel.add((Component)this.attributeCombo1, null);
        this.selectPanel.add((Component)this.attributeLabel2, new ALayoutConstraint(1, 0));
        this.attributeCombo2 = new CComboBox((Vector)vector);
        this.selectPanel.add((Component)this.attributeCombo2, null);
        this.fillPicks();
        this.selectPanel.add((Component)this.labelPriceList, new ALayoutConstraint(2, 0));
        this.selectPanel.add(this.pickPriceList);
        this.selectPanel.add((Component)this.labelWarehouse, new ALayoutConstraint(3, 0));
        this.selectPanel.add(this.pickWarehouse);
        this.selectPanel.setPreferredSize(new Dimension(300, 200));
        this.tabbedPane.add((Component)this.gridPanel, "AttributeGrid");
        this.modePanel.add(this.modeLabel);
        this.modePanel.add(this.modeCombo);
        this.modeCombo.addActionListener(this);
    }

    public void dispose() {
        if (this.m_frame != null) {
            this.m_frame.dispose();
        }
        this.m_frame = null;
    }

    private void fillPicks() {
        String sql = "SELECT M_PriceList_Version.M_PriceList_Version_ID, M_PriceList_Version.Name || ' (' || c.Iso_Code || ')' AS ValueName FROM M_PriceList_Version, M_PriceList pl, C_Currency c WHERE M_PriceList_Version.M_PriceList_ID=pl.M_PriceList_ID AND pl.C_Currency_ID=c.C_Currency_ID AND M_PriceList_Version.IsActive='Y' AND pl.IsActive='Y'";
        sql = MRole.getDefault().addAccessSQL(sql, "M_PriceList_Version", true, false) + " ORDER BY M_PriceList_Version.Name";
        try {
            KeyNamePair kn;
            this.pickPriceList.addItem(new KeyNamePair(0, ""));
            CPreparedStatement pstmt = DB.prepareStatement(sql, null);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                kn = new KeyNamePair(rs.getInt(1), rs.getString(2));
                this.pickPriceList.addItem(kn);
            }
            rs.close();
            pstmt.close();
            sql = "SELECT M_Warehouse_ID, Value || ' - ' || Name AS ValueName FROM M_Warehouse WHERE IsActive='Y'";
            sql = MRole.getDefault().addAccessSQL(sql, "M_Warehouse", false, false) + " ORDER BY Value";
            this.pickWarehouse.addItem(new KeyNamePair(0, ""));
            pstmt = DB.prepareStatement(sql, null);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                kn = new KeyNamePair(rs.getInt("M_Warehouse_ID"), rs.getString("ValueName"));
                this.pickWarehouse.addItem(kn);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, sql, e);
        }
    }

    public void stateChanged(ChangeEvent e) {
        if (e.getSource() != this.tabbedPane) {
            return;
        }
        if (this.tabbedPane.getSelectedIndex() == 1) {
            this.createGrid();
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.modeCombo) {
            this.createGrid();
        } else if (e.getActionCommand().equals("Ok")) {
            if (this.tabbedPane.getSelectedIndex() == 0) {
                this.createGrid();
            } else {
                this.gridOK();
            }
        } else if (e.getActionCommand().equals("Cancel")) {
            this.m_frame.dispose();
        }
    }

    private void gridOK() {
        int mode = this.modeCombo.getSelectedIndex();
        if (mode == 0) {
            this.createPO();
            this.modeCombo.setSelectedIndex(0);
            return;
        }
        if (mode == 0) {
            this.updatePrices();
            this.modeCombo.setSelectedIndex(0);
            return;
        }
        if (mode == 0) {
            // empty if block
        }
        this.m_frame.dispose();
    }

    private void createPO() {
    }

    private void updatePrices() {
    }

    private void createGrid() {
        int indexAttr2;
        if (this.attributeCombo1 == null || this.m_setting) {
            return;
        }
        int indexAttr1 = this.attributeCombo1.getSelectedIndex();
        if (indexAttr1 == (indexAttr2 = this.attributeCombo2.getSelectedIndex())) {
            log.warning("Same Attribute Selected");
            this.tabbedPane.setSelectedIndex(0);
            return;
        }
        this.m_setting = true;
        this.m_M_PriceList_Version_ID = 0;
        KeyNamePair pl = (KeyNamePair)this.pickPriceList.getSelectedItem();
        if (pl != null) {
            this.m_M_PriceList_Version_ID = pl.getKey();
        }
        this.m_M_Warehouse_ID = 0;
        KeyNamePair wh = (KeyNamePair)this.pickWarehouse.getSelectedItem();
        if (wh != null) {
            this.m_M_Warehouse_ID = wh.getKey();
        }
        int cols = 2;
        MAttributeValue[] xValues = null;
        if (indexAttr1 > 0) {
            xValues = this.m_attributes[indexAttr1 - 1].getMAttributeValues();
        }
        if (xValues != null) {
            cols = xValues.length;
            log.info("X - " + this.m_attributes[indexAttr1 - 1].getName() + " #" + xValues.length);
        }
        int rows = 2;
        MAttributeValue[] yValues = null;
        if (indexAttr2 > 0) {
            yValues = this.m_attributes[indexAttr2 - 1].getMAttributeValues();
        }
        if (yValues != null) {
            rows = yValues.length;
            log.info("Y - " + this.m_attributes[indexAttr2 - 1].getName() + " #" + yValues.length);
        }
        this.gridPanel.removeAll();
        CPanel grid = new CPanel(new GridLayout(rows, cols, 5, 5));
        this.gridPanel.add((Component)this.modePanel, "North");
        this.gridPanel.add((Component)new CScrollPane(grid), "Center");
        log.info("Rows=" + rows + " - Cols=" + cols);
        for (int row = 0; row < rows; ++row) {
            for (int col = 0; col < cols; ++col) {
                MAttributeValue xValue = null;
                if (xValues != null) {
                    xValue = xValues[col];
                }
                MAttributeValue yValue = null;
                if (yValues != null) {
                    yValue = yValues[row];
                }
                if (row == 0 && col == 0) {
                    CPanel descr = new CPanel(new GridLayout(2, 1, 0, 0));
                    if (xValues != null) {
                        descr.add(new JLabel(this.m_attributes[indexAttr1 - 1].getName(), 11));
                    }
                    if (yValues != null) {
                        descr.add(new JLabel(this.m_attributes[indexAttr2 - 1].getName()));
                    }
                    grid.add(descr);
                    continue;
                }
                if (row == 0) {
                    if (xValue != null) {
                        grid.add(new JLabel(xValue.getName(), 11));
                        continue;
                    }
                    grid.add(new JLabel());
                    continue;
                }
                if (col == 0) {
                    if (yValue != null) {
                        grid.add(new JLabel(yValue.getName()));
                        continue;
                    }
                    grid.add(new JLabel());
                    continue;
                }
                grid.add(this.getGridElement(xValue, yValue));
            }
        }
        this.tabbedPane.setSelectedIndex(1);
        this.m_setting = false;
        this.m_frame.pack();
    }

    private CPanel getGridElement(MAttributeValue xValue, MAttributeValue yValue) {
        CPanel element = new CPanel();
        element.setBorder(BorderFactory.createLineBorder(Color.BLACK, 2));
        element.setLayout(new BoxLayout(element, 1));
        String sql = "SELECT * FROM M_Product WHERE IsActive='Y'";
        if (xValue != null) {
            sql = sql + " AND M_AttributeSetInstance_ID IN (SELECT M_AttributeSetInstance_ID FROM M_AttributeInstance WHERE M_Attribute_ID=" + xValue.getM_Attribute_ID() + " AND M_AttributeValue_ID=" + xValue.getM_AttributeValue_ID() + ")";
        }
        if (yValue != null) {
            sql = sql + " AND M_AttributeSetInstance_ID IN (SELECT M_AttributeSetInstance_ID FROM M_AttributeInstance WHERE M_Attribute_ID=" + yValue.getM_Attribute_ID() + " AND M_AttributeValue_ID=" + yValue.getM_AttributeValue_ID() + ")";
        }
        sql = MRole.getDefault().addAccessSQL(sql, "M_Product", false, false);
        CPreparedStatement pstmt = null;
        int noProducts = 0;
        try {
            pstmt = DB.prepareStatement(sql, null);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                MProduct product = new MProduct(Env.getCtx(), rs, null);
                this.addProduct(element, product);
                ++noProducts;
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        int mode = this.modeCombo.getSelectedIndex();
        if (noProducts == 0 && mode == 0 || mode == 0 || mode == 0) {
            // empty if block
        }
        return element;
    }

    private void addProduct(CPanel element, MProduct product) {
        Insets ii = new Insets(2, 4, 2, 4);
        int M_Product_ID = product.getM_Product_ID();
        CPanel pe = new CPanel();
        pe.setBorder(BorderFactory.createLineBorder(Color.BLUE, 1));
        pe.setLayout(new GridBagLayout());
        pe.add((Component)new JLabel(product.getValue()), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, ii, 0, 0));
        String formatted = "";
        if (this.m_M_PriceList_Version_ID != 0) {
            MProductPrice pp = MProductPrice.get(Env.getCtx(), this.m_M_PriceList_Version_ID, M_Product_ID, null);
            if (pp != null) {
                BigDecimal price = pp.getPriceStd();
                formatted = this.m_price.format(price);
            } else {
                formatted = "-";
            }
        }
        pe.add((Component)new JLabel(formatted, 4), new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 13, 2, ii, 0, 0));
        pe.add((Component)new JLabel(product.getName()), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 2, ii, 0, 0));
        formatted = "";
        if (this.m_M_Warehouse_ID != 0) {
            BigDecimal qty = MStorage.getQtyAvailable(this.m_M_Warehouse_ID, M_Product_ID, 0, null);
            formatted = qty == null ? "-" : this.m_qty.format(qty);
        }
        pe.add((Component)new JLabel(formatted, 4), new GridBagConstraints(1, 1, 1, 1, 0.5, 0.0, 13, 2, ii, 0, 0));
        element.add(pe);
    }

    public static void main(String[] args) {
        Adempiere.startup(true);
        Env.setContext(Env.getCtx(), "#AD_Client_ID", 11);
        FormFrame ff = new FormFrame();
        ff.openForm(1111, "org.compiere.apps.form.VAttributeGrid", "Attribute Table");
        ff.pack();
        AEnv.showCenterScreen(ff);
    }
}

