/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps.form;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.VetoableChangeListener;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Vector;
import java.util.logging.Level;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.adempiere.plaf.AdempierePLAF;
import org.compiere.apps.ADialog;
import org.compiere.apps.StatusBar;
import org.compiere.apps.form.FormFrame;
import org.compiere.apps.form.FormPanel;
import org.compiere.grid.ed.VDate;
import org.compiere.grid.ed.VLookup;
import org.compiere.minigrid.MiniTable;
import org.compiere.model.MAllocationHdr;
import org.compiere.model.MAllocationLine;
import org.compiere.model.MInvoice;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MPayment;
import org.compiere.plaf.CompiereColor;
import org.compiere.swing.CPanel;
import org.compiere.swing.CTextField;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.compiere.util.TimeUtil;
import org.compiere.util.Trx;

public class VAllocation
extends CPanel
implements FormPanel,
ActionListener,
TableModelListener,
VetoableChangeListener {
    private int m_WindowNo = 0;
    private FormFrame m_frame;
    private static CLogger log = CLogger.getCLogger(VAllocation.class);
    private boolean m_calculating = false;
    private int m_C_Currency_ID = 0;
    private int m_C_BPartner_ID = 0;
    private int m_noInvoices = 0;
    private int m_noPayments = 0;
    private int i_payment = 7;
    private int i_open = 6;
    private int i_discount = 7;
    private int i_writeOff = 8;
    private int i_applied = 9;
    private CPanel mainPanel = new CPanel();
    private BorderLayout mainLayout = new BorderLayout();
    private CPanel parameterPanel = new CPanel();
    private CPanel allocationPanel = new CPanel();
    private GridBagLayout parameterLayout = new GridBagLayout();
    private JLabel bpartnerLabel = new JLabel();
    private VLookup bpartnerSearch = null;
    private MiniTable invoiceTable = new MiniTable();
    private MiniTable paymentTable = new MiniTable();
    private JSplitPane infoPanel = new JSplitPane();
    private CPanel paymentPanel = new CPanel();
    private CPanel invoicePanel = new CPanel();
    private JLabel paymentLabel = new JLabel();
    private JLabel invoiceLabel = new JLabel();
    private BorderLayout paymentLayout = new BorderLayout();
    private BorderLayout invoiceLayout = new BorderLayout();
    private JLabel paymentInfo = new JLabel();
    private JLabel invoiceInfo = new JLabel();
    private JScrollPane paymentScrollPane = new JScrollPane();
    private JScrollPane invoiceScrollPane = new JScrollPane();
    private GridBagLayout allocationLayout = new GridBagLayout();
    private JLabel differenceLabel = new JLabel();
    private CTextField differenceField = new CTextField();
    private JButton allocateButton = new JButton();
    private JLabel currencyLabel = new JLabel();
    private VLookup currencyPick = null;
    private JCheckBox multiCurrency = new JCheckBox();
    private JLabel allocCurrencyLabel = new JLabel();
    private StatusBar statusBar = new StatusBar();
    private JLabel dateLabel = new JLabel();
    private VDate dateField = new VDate();
    private JCheckBox autoWriteOff = new JCheckBox();
    private ArrayList<Integer> m_bpartnerCheck = new ArrayList();

    public void init(int WindowNo, FormFrame frame) {
        this.m_WindowNo = WindowNo;
        this.m_frame = frame;
        Env.setContext(Env.getCtx(), this.m_WindowNo, "IsSOTrx", "Y");
        this.m_C_Currency_ID = Env.getContextAsInt(Env.getCtx(), "$C_Currency_ID");
        log.info("Currency=" + this.m_C_Currency_ID);
        try {
            this.dynInit();
            this.jbInit();
            this.calculate();
            frame.getContentPane().add((Component)this.mainPanel, "Center");
            frame.getContentPane().add((Component)this.statusBar, "South");
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "", e);
        }
    }

    private void jbInit() throws Exception {
        CompiereColor.setBackground(this);
        this.mainPanel.setLayout(this.mainLayout);
        this.dateLabel.setText(Msg.getMsg(Env.getCtx(), "Date"));
        this.autoWriteOff.setSelected(false);
        this.autoWriteOff.setText(Msg.getMsg(Env.getCtx(), "AutoWriteOff", true));
        this.autoWriteOff.setToolTipText(Msg.getMsg(Env.getCtx(), "AutoWriteOff", false));
        this.parameterPanel.setLayout(this.parameterLayout);
        this.allocationPanel.setLayout(this.allocationLayout);
        this.bpartnerLabel.setText(Msg.translate(Env.getCtx(), "C_BPartner_ID"));
        this.paymentLabel.setRequestFocusEnabled(false);
        this.paymentLabel.setText(" " + Msg.translate(Env.getCtx(), "C_Payment_ID"));
        this.invoiceLabel.setRequestFocusEnabled(false);
        this.invoiceLabel.setText(" " + Msg.translate(Env.getCtx(), "C_Invoice_ID"));
        this.paymentPanel.setLayout(this.paymentLayout);
        this.invoicePanel.setLayout(this.invoiceLayout);
        this.invoiceInfo.setHorizontalAlignment(4);
        this.invoiceInfo.setHorizontalTextPosition(4);
        this.invoiceInfo.setText(".");
        this.paymentInfo.setHorizontalAlignment(4);
        this.paymentInfo.setHorizontalTextPosition(4);
        this.paymentInfo.setText(".");
        this.differenceLabel.setText(Msg.getMsg(Env.getCtx(), "Difference"));
        this.differenceField.setBackground(AdempierePLAF.getFieldBackground_Inactive());
        this.differenceField.setEditable(false);
        this.differenceField.setText("0");
        this.differenceField.setColumns(8);
        this.differenceField.setHorizontalAlignment(4);
        this.allocateButton.setText(Msg.getMsg(Env.getCtx(), "Process"));
        this.allocateButton.addActionListener(this);
        this.currencyLabel.setText(Msg.translate(Env.getCtx(), "C_Currency_ID"));
        this.multiCurrency.setText(Msg.getMsg(Env.getCtx(), "MultiCurrency"));
        this.multiCurrency.addActionListener(this);
        this.allocCurrencyLabel.setText(".");
        this.invoiceScrollPane.setPreferredSize(new Dimension(200, 200));
        this.paymentScrollPane.setPreferredSize(new Dimension(200, 200));
        this.mainPanel.add((Component)this.parameterPanel, "North");
        this.parameterPanel.add((Component)this.bpartnerLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.bpartnerSearch, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.dateLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.dateField, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.currencyLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.currencyPick, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.multiCurrency, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.mainPanel.add((Component)this.allocationPanel, "South");
        this.allocationPanel.add((Component)this.differenceLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.allocationPanel.add((Component)this.differenceField, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.allocationPanel.add((Component)this.allocateButton, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.allocationPanel.add((Component)this.allocCurrencyLabel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.allocationPanel.add((Component)this.autoWriteOff, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.paymentPanel.add((Component)this.paymentLabel, "North");
        this.paymentPanel.add((Component)this.paymentInfo, "South");
        this.paymentPanel.add((Component)this.paymentScrollPane, "Center");
        this.paymentScrollPane.getViewport().add((Component)this.paymentTable, null);
        this.invoicePanel.add((Component)this.invoiceLabel, "North");
        this.invoicePanel.add((Component)this.invoiceInfo, "South");
        this.invoicePanel.add((Component)this.invoiceScrollPane, "Center");
        this.invoiceScrollPane.getViewport().add((Component)this.invoiceTable, null);
        this.mainPanel.add((Component)this.infoPanel, "Center");
        this.infoPanel.setOrientation(0);
        this.infoPanel.setBorder(BorderFactory.createEtchedBorder());
        this.infoPanel.setTopComponent(this.paymentPanel);
        this.infoPanel.setBottomComponent(this.invoicePanel);
        this.infoPanel.add((Component)this.paymentPanel, "top");
        this.infoPanel.add((Component)this.invoicePanel, "bottom");
        this.infoPanel.setContinuousLayout(true);
        this.infoPanel.setPreferredSize(new Dimension(670, 250));
        this.infoPanel.setDividerLocation(110);
    }

    public void dispose() {
        if (this.m_frame != null) {
            this.m_frame.dispose();
        }
        this.m_frame = null;
    }

    private void dynInit() throws Exception {
        int AD_Column_ID = 3505;
        MLookup lookupCur = MLookupFactory.get(Env.getCtx(), this.m_WindowNo, 0, AD_Column_ID, 19);
        this.currencyPick = new VLookup("C_Currency_ID", true, false, true, lookupCur);
        this.currencyPick.setValue(new Integer(this.m_C_Currency_ID));
        this.currencyPick.addVetoableChangeListener(this);
        AD_Column_ID = 3499;
        MLookup lookupBP = MLookupFactory.get(Env.getCtx(), this.m_WindowNo, 0, AD_Column_ID, 30);
        this.bpartnerSearch = new VLookup("C_BPartner_ID", true, false, true, lookupBP);
        this.bpartnerSearch.addVetoableChangeListener(this);
        this.statusBar.setStatusLine(Msg.getMsg(Env.getCtx(), "AllocateStatus"));
        this.statusBar.setStatusDB("");
        this.dateField.setValue(Env.getContextAsDate(Env.getCtx(), "#Date"));
        this.dateField.addVetoableChangeListener(this);
    }

    private void loadBPartner() {
        log.config("BPartner=" + this.m_C_BPartner_ID + ", Cur=" + this.m_C_Currency_ID);
        if (this.m_C_BPartner_ID == 0 || this.m_C_Currency_ID == 0) {
            return;
        }
        Integer key = new Integer(this.m_C_BPartner_ID);
        if (!this.m_bpartnerCheck.contains(key)) {
            new Thread(){

                public void run() {
                    MPayment.setIsAllocated(Env.getCtx(), VAllocation.this.m_C_BPartner_ID, null);
                    MInvoice.setIsPaid(Env.getCtx(), VAllocation.this.m_C_BPartner_ID, null);
                }
            }.start();
            this.m_bpartnerCheck.add(key);
        }
        Vector data = new Vector();
        StringBuffer sql = new StringBuffer("SELECT p.DateTrx,p.DocumentNo,p.C_Payment_ID,c.ISO_Code,p.PayAmt,currencyConvert(p.PayAmt,p.C_Currency_ID,?,p.DateTrx,p.C_ConversionType_ID,p.AD_Client_ID,p.AD_Org_ID),currencyConvert(paymentAvailable(C_Payment_ID),p.C_Currency_ID,?,p.DateTrx,p.C_ConversionType_ID,p.AD_Client_ID,p.AD_Org_ID),p.MultiplierAP FROM C_Payment_v p INNER JOIN C_Currency c ON (p.C_Currency_ID=c.C_Currency_ID) WHERE p.IsAllocated='N' AND p.Processed='Y' AND p.C_Charge_ID IS NULL AND p.C_BPartner_ID=?");
        if (!this.multiCurrency.isSelected()) {
            sql.append(" AND p.C_Currency_ID=?");
        }
        sql.append(" ORDER BY p.DateTrx,p.DocumentNo");
        log.fine("PaySQL=" + sql.toString());
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql.toString(), null);
            pstmt.setInt(1, this.m_C_Currency_ID);
            pstmt.setInt(2, this.m_C_Currency_ID);
            pstmt.setInt(3, this.m_C_BPartner_ID);
            if (!this.multiCurrency.isSelected()) {
                pstmt.setInt(4, this.m_C_Currency_ID);
            }
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                Vector<Object> line = new Vector<Object>();
                line.add(new Boolean(false));
                line.add(rs.getTimestamp(1));
                KeyNamePair pp = new KeyNamePair(rs.getInt(3), rs.getString(2));
                line.add(pp);
                if (this.multiCurrency.isSelected()) {
                    line.add(rs.getString(4));
                    line.add(rs.getBigDecimal(5));
                }
                line.add(rs.getBigDecimal(6));
                BigDecimal available = rs.getBigDecimal(7);
                if (available == null || available.signum() == 0) continue;
                line.add(available);
                line.add(Env.ZERO);
                data.add(line);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, sql.toString(), e);
        }
        this.paymentTable.getModel().removeTableModelListener(this);
        Vector<String> columnNames = new Vector<String>();
        columnNames.add(Msg.getMsg(Env.getCtx(), "Select"));
        columnNames.add(Msg.translate(Env.getCtx(), "Date"));
        columnNames.add(Msg.translate(Env.getCtx(), "DocumentNo"));
        if (this.multiCurrency.isSelected()) {
            columnNames.add(Msg.getMsg(Env.getCtx(), "TrxCurrency"));
            columnNames.add(Msg.translate(Env.getCtx(), "Amount"));
        }
        columnNames.add(Msg.getMsg(Env.getCtx(), "ConvertedAmount"));
        columnNames.add(Msg.getMsg(Env.getCtx(), "OpenAmt"));
        columnNames.add(Msg.getMsg(Env.getCtx(), "AppliedAmt"));
        DefaultTableModel modelP = new DefaultTableModel(data, columnNames);
        modelP.addTableModelListener(this);
        this.paymentTable.setModel(modelP);
        int i = 0;
        this.paymentTable.setColumnClass(i++, Boolean.class, false);
        this.paymentTable.setColumnClass(i++, Timestamp.class, true);
        this.paymentTable.setColumnClass(i++, String.class, true);
        if (this.multiCurrency.isSelected()) {
            this.paymentTable.setColumnClass(i++, String.class, true);
            this.paymentTable.setColumnClass(i++, BigDecimal.class, true);
        }
        this.paymentTable.setColumnClass(i++, BigDecimal.class, true);
        this.paymentTable.setColumnClass(i++, BigDecimal.class, true);
        this.paymentTable.setColumnClass(i++, BigDecimal.class, false);
        this.i_payment = this.multiCurrency.isSelected() ? 7 : 5;
        this.paymentTable.autoSize();
        data = new Vector();
        sql = new StringBuffer("SELECT i.DateInvoiced,i.DocumentNo,i.C_Invoice_ID,c.ISO_Code,i.GrandTotal*i.MultiplierAP, currencyConvert(i.GrandTotal*i.MultiplierAP,i.C_Currency_ID,?,i.DateInvoiced,i.C_ConversionType_ID,i.AD_Client_ID,i.AD_Org_ID), currencyConvert(invoiceOpen(C_Invoice_ID,C_InvoicePaySchedule_ID),i.C_Currency_ID,?,i.DateInvoiced,i.C_ConversionType_ID,i.AD_Client_ID,i.AD_Org_ID)*i.MultiplierAP, currencyConvert(invoiceDiscount(i.C_Invoice_ID,?,C_InvoicePaySchedule_ID),i.C_Currency_ID,?,i.DateInvoiced,i.C_ConversionType_ID,i.AD_Client_ID,i.AD_Org_ID)*i.Multiplier*i.MultiplierAP,i.MultiplierAP FROM C_Invoice_v i INNER JOIN C_Currency c ON (i.C_Currency_ID=c.C_Currency_ID) WHERE i.IsPaid='N' AND i.Processed='Y' AND i.C_BPartner_ID=?");
        if (!this.multiCurrency.isSelected()) {
            sql.append(" AND i.C_Currency_ID=?");
        }
        sql.append(" ORDER BY i.DateInvoiced, i.DocumentNo");
        log.fine("InvSQL=" + sql.toString());
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql.toString(), null);
            pstmt.setInt(1, this.m_C_Currency_ID);
            pstmt.setInt(2, this.m_C_Currency_ID);
            pstmt.setTimestamp(3, (Timestamp)this.dateField.getValue());
            pstmt.setInt(4, this.m_C_Currency_ID);
            pstmt.setInt(5, this.m_C_BPartner_ID);
            if (!this.multiCurrency.isSelected()) {
                pstmt.setInt(6, this.m_C_Currency_ID);
            }
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                Vector<Object> line = new Vector<Object>();
                line.add(new Boolean(false));
                line.add(rs.getTimestamp(1));
                KeyNamePair pp = new KeyNamePair(rs.getInt(3), rs.getString(2));
                line.add(pp);
                if (this.multiCurrency.isSelected()) {
                    line.add(rs.getString(4));
                    line.add(rs.getBigDecimal(5));
                }
                line.add(rs.getBigDecimal(6));
                BigDecimal open = rs.getBigDecimal(7);
                if (open == null) {
                    open = Env.ZERO;
                }
                line.add(open);
                BigDecimal discount = rs.getBigDecimal(8);
                if (discount == null) {
                    discount = Env.ZERO;
                }
                line.add(discount);
                line.add(Env.ZERO);
                line.add(Env.ZERO);
                if (Env.ZERO.compareTo(open) == 0) continue;
                data.add(line);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, sql.toString(), e);
        }
        this.invoiceTable.getModel().removeTableModelListener(this);
        columnNames = new Vector();
        columnNames.add(Msg.getMsg(Env.getCtx(), "Select"));
        columnNames.add(Msg.translate(Env.getCtx(), "Date"));
        columnNames.add(Msg.translate(Env.getCtx(), "DocumentNo"));
        if (this.multiCurrency.isSelected()) {
            columnNames.add(Msg.getMsg(Env.getCtx(), "TrxCurrency"));
            columnNames.add(Msg.translate(Env.getCtx(), "Amount"));
        }
        columnNames.add(Msg.getMsg(Env.getCtx(), "ConvertedAmount"));
        columnNames.add(Msg.getMsg(Env.getCtx(), "OpenAmt"));
        columnNames.add(Msg.getMsg(Env.getCtx(), "Discount"));
        columnNames.add(Msg.getMsg(Env.getCtx(), "WriteOff"));
        columnNames.add(Msg.getMsg(Env.getCtx(), "AppliedAmt"));
        DefaultTableModel modelI = new DefaultTableModel(data, columnNames);
        modelI.addTableModelListener(this);
        this.invoiceTable.setModel(modelI);
        i = 0;
        this.invoiceTable.setColumnClass(i++, Boolean.class, false);
        this.invoiceTable.setColumnClass(i++, Timestamp.class, true);
        this.invoiceTable.setColumnClass(i++, String.class, true);
        if (this.multiCurrency.isSelected()) {
            this.invoiceTable.setColumnClass(i++, String.class, true);
            this.invoiceTable.setColumnClass(i++, BigDecimal.class, true);
        }
        this.invoiceTable.setColumnClass(i++, BigDecimal.class, true);
        this.invoiceTable.setColumnClass(i++, BigDecimal.class, true);
        this.invoiceTable.setColumnClass(i++, BigDecimal.class, false);
        this.invoiceTable.setColumnClass(i++, BigDecimal.class, false);
        this.invoiceTable.setColumnClass(i++, BigDecimal.class, false);
        this.invoiceTable.autoSize();
        this.i_open = this.multiCurrency.isSelected() ? 6 : 4;
        this.i_discount = this.multiCurrency.isSelected() ? 7 : 5;
        this.i_writeOff = this.multiCurrency.isSelected() ? 8 : 6;
        this.i_applied = this.multiCurrency.isSelected() ? 9 : 7;
        this.calculate();
    }

    public void actionPerformed(ActionEvent e) {
        log.config("");
        if (e.getSource().equals(this.multiCurrency)) {
            this.loadBPartner();
        } else if (e.getSource().equals(this.allocateButton)) {
            this.allocateButton.setEnabled(false);
            this.saveData();
            this.loadBPartner();
            this.allocateButton.setEnabled(true);
        }
    }

    public void tableChanged(TableModelEvent e) {
        boolean isUpdate;
        boolean bl = isUpdate = e.getType() == 0;
        if (!isUpdate) {
            this.calculate();
            return;
        }
        if (this.m_calculating) {
            return;
        }
        this.m_calculating = true;
        int row = e.getFirstRow();
        int col = e.getColumn();
        boolean isInvoice = e.getSource().equals(this.invoiceTable.getModel());
        log.config("Row=" + row + ", Col=" + col + ", InvoiceTable=" + isInvoice);
        if (!isInvoice) {
            TableModel payment = this.paymentTable.getModel();
            if (col == 0) {
                if (((Boolean)payment.getValueAt(row, col)).booleanValue()) {
                    BigDecimal amount = (BigDecimal)payment.getValueAt(row, this.i_open);
                    payment.setValueAt(amount, row, this.i_payment);
                } else {
                    payment.setValueAt(Env.ZERO, row, this.i_payment);
                }
            }
        } else if (col == 0) {
            TableModel invoice = this.invoiceTable.getModel();
            if (((Boolean)invoice.getValueAt(row, col)).booleanValue()) {
                BigDecimal amount = (BigDecimal)invoice.getValueAt(row, this.i_open);
                amount = amount.subtract((BigDecimal)invoice.getValueAt(row, this.i_discount));
                invoice.setValueAt(Env.ZERO, row, this.i_writeOff);
                invoice.setValueAt(amount, row, this.i_applied);
            } else {
                invoice.setValueAt(Env.ZERO, row, this.i_writeOff);
                invoice.setValueAt(Env.ZERO, row, this.i_applied);
            }
            this.invoiceTable.repaint();
        } else if (this.autoWriteOff.isSelected()) {
            TableModel invoice = this.invoiceTable.getModel();
            if (col == this.i_applied) {
                BigDecimal openAmount = (BigDecimal)invoice.getValueAt(row, this.i_open);
                BigDecimal amount = openAmount.subtract((BigDecimal)invoice.getValueAt(row, this.i_discount));
                amount = amount.subtract((BigDecimal)invoice.getValueAt(row, this.i_applied));
                invoice.setValueAt(amount, row, this.i_writeOff);
                if (amount.doubleValue() / openAmount.doubleValue() > 0.3) {
                    ADialog.warn(this.m_WindowNo, this, "AllocationWriteOffWarn");
                }
            } else {
                BigDecimal amount = (BigDecimal)invoice.getValueAt(row, this.i_open);
                amount = amount.subtract((BigDecimal)invoice.getValueAt(row, this.i_discount));
                amount = amount.subtract((BigDecimal)invoice.getValueAt(row, this.i_writeOff));
                invoice.setValueAt(amount, row, this.i_applied);
            }
        }
        this.m_calculating = false;
        this.calculate();
    }

    private void calculate() {
        log.config("");
        DecimalFormat format = DisplayType.getNumberFormat(12);
        Timestamp allocDate = null;
        TableModel payment = this.paymentTable.getModel();
        BigDecimal totalPay = new BigDecimal(0.0);
        int rows = payment.getRowCount();
        this.m_noPayments = 0;
        for (int i = 0; i < rows; ++i) {
            if (!((Boolean)payment.getValueAt(i, 0)).booleanValue()) continue;
            Timestamp ts = (Timestamp)payment.getValueAt(i, 1);
            allocDate = TimeUtil.max(allocDate, ts);
            BigDecimal bd = (BigDecimal)payment.getValueAt(i, this.i_payment);
            totalPay = totalPay.add(bd);
            ++this.m_noPayments;
            log.fine("Payment_" + i + " = " + bd + " - Total=" + totalPay);
        }
        this.paymentInfo.setText(String.valueOf(this.m_noPayments) + " - " + Msg.getMsg(Env.getCtx(), "Sum") + "  " + format.format(totalPay) + " ");
        TableModel invoice = this.invoiceTable.getModel();
        BigDecimal totalInv = new BigDecimal(0.0);
        rows = invoice.getRowCount();
        this.m_noInvoices = 0;
        for (int i = 0; i < rows; ++i) {
            if (!((Boolean)invoice.getValueAt(i, 0)).booleanValue()) continue;
            Timestamp ts = (Timestamp)invoice.getValueAt(i, 1);
            allocDate = TimeUtil.max(allocDate, ts);
            BigDecimal bd = (BigDecimal)invoice.getValueAt(i, this.i_applied);
            totalInv = totalInv.add(bd);
            ++this.m_noInvoices;
            log.fine("Invoice_" + i + " = " + bd + " - Total=" + totalPay);
        }
        this.invoiceInfo.setText(String.valueOf(this.m_noInvoices) + " - " + Msg.getMsg(Env.getCtx(), "Sum") + "  " + format.format(totalInv) + " ");
        if (allocDate != null) {
            this.dateField.setValue(allocDate);
        }
        this.allocCurrencyLabel.setText(this.currencyPick.getDisplay());
        BigDecimal difference = totalPay.subtract(totalInv);
        this.differenceField.setText(format.format(difference));
        if (difference.compareTo(new BigDecimal(0.0)) == 0) {
            this.allocateButton.setEnabled(true);
        } else {
            this.allocateButton.setEnabled(false);
        }
    }

    public void vetoableChange(PropertyChangeEvent e) {
        String name = e.getPropertyName();
        Object value = e.getNewValue();
        log.config(name + "=" + value);
        if (value == null) {
            return;
        }
        if (name.equals("C_BPartner_ID")) {
            this.bpartnerSearch.setValue(value);
            this.m_C_BPartner_ID = (Integer)value;
            this.loadBPartner();
        } else if (name.equals("C_Currency_ID")) {
            this.m_C_Currency_ID = (Integer)value;
            this.loadBPartner();
        } else if (name.equals("Date") && this.multiCurrency.isSelected()) {
            this.loadBPartner();
        }
    }

    private void saveData() {
        int C_Invoice_ID;
        KeyNamePair pp;
        int i;
        if (this.m_noInvoices + this.m_noPayments == 0) {
            return;
        }
        int AD_Client_ID = Env.getContextAsInt(Env.getCtx(), this.m_WindowNo, "AD_Client_ID");
        int AD_Org_ID = Env.getContextAsInt(Env.getCtx(), this.m_WindowNo, "AD_Org_ID");
        int C_BPartner_ID = this.m_C_BPartner_ID;
        int C_Order_ID = 0;
        int C_CashLine_ID = 0;
        Timestamp DateTrx = (Timestamp)this.dateField.getValue();
        int C_Currency_ID = this.m_C_Currency_ID;
        if (AD_Org_ID == 0) {
            ADialog.error(this.m_WindowNo, this, "Org0NotAllowed", null);
            return;
        }
        log.config("Client=" + AD_Client_ID + ", Org=" + AD_Org_ID + ", BPartner=" + C_BPartner_ID + ", Date=" + DateTrx);
        Trx trx = Trx.get(Trx.createTrxName("AL"), true);
        int pRows = this.paymentTable.getRowCount();
        TableModel payment = this.paymentTable.getModel();
        ArrayList<Integer> paymentList = new ArrayList<Integer>(pRows);
        ArrayList<BigDecimal> amountList = new ArrayList<BigDecimal>(pRows);
        BigDecimal paymentAppliedAmt = Env.ZERO;
        for (int i2 = 0; i2 < pRows; ++i2) {
            if (!((Boolean)payment.getValueAt(i2, 0)).booleanValue()) continue;
            KeyNamePair pp2 = (KeyNamePair)payment.getValueAt(i2, 2);
            int C_Payment_ID = pp2.getKey();
            paymentList.add(new Integer(C_Payment_ID));
            BigDecimal PaymentAmt = (BigDecimal)payment.getValueAt(i2, this.i_payment);
            amountList.add(PaymentAmt);
            paymentAppliedAmt = paymentAppliedAmt.add(PaymentAmt);
            log.fine("C_Payment_ID=" + C_Payment_ID + " - PaymentAmt=" + PaymentAmt);
        }
        log.config("Number of Payments=" + paymentList.size() + " - Total=" + paymentAppliedAmt);
        int iRows = this.invoiceTable.getRowCount();
        TableModel invoice = this.invoiceTable.getModel();
        BigDecimal totalAppliedAmt = Env.ZERO;
        MAllocationHdr alloc = new MAllocationHdr(Env.getCtx(), true, DateTrx, C_Currency_ID, Env.getContext(Env.getCtx(), "#AD_User_Name"), trx.getTrxName());
        alloc.setAD_Org_ID(AD_Org_ID);
        int invoiceLines = 0;
        for (i = 0; i < iRows; ++i) {
            if (!((Boolean)invoice.getValueAt(i, 0)).booleanValue()) continue;
            ++invoiceLines;
            pp = (KeyNamePair)invoice.getValueAt(i, 2);
            C_Invoice_ID = pp.getKey();
            BigDecimal AppliedAmt = (BigDecimal)invoice.getValueAt(i, this.i_applied);
            BigDecimal DiscountAmt = (BigDecimal)invoice.getValueAt(i, this.i_discount);
            BigDecimal WriteOffAmt = (BigDecimal)invoice.getValueAt(i, this.i_writeOff);
            BigDecimal OverUnderAmt = ((BigDecimal)invoice.getValueAt(i, this.i_open)).subtract(AppliedAmt).subtract(DiscountAmt).subtract(WriteOffAmt);
            log.config("Invoice #" + i + " - AppliedAmt=" + AppliedAmt);
            int noPayments = 0;
            for (int j = 0; j < paymentList.size() && AppliedAmt.signum() != 0; ++j) {
                int C_Payment_ID = (Integer)paymentList.get(j);
                BigDecimal PaymentAmt = (BigDecimal)amountList.get(j);
                if (PaymentAmt.signum() == 0) continue;
                log.config(".. with payment #" + j + ", Amt=" + PaymentAmt);
                ++noPayments;
                BigDecimal amount = AppliedAmt;
                log.fine("C_Payment_ID=" + C_Payment_ID + ", C_Invoice_ID=" + C_Invoice_ID + ", Amount=" + amount + ", Discount=" + DiscountAmt + ", WriteOff=" + WriteOffAmt);
                if (alloc.get_ID() == 0 && !alloc.save()) {
                    log.log(Level.SEVERE, "Allocation not created");
                    return;
                }
                MAllocationLine aLine = new MAllocationLine(alloc, amount, DiscountAmt, WriteOffAmt, OverUnderAmt);
                aLine.setDocInfo(C_BPartner_ID, C_Order_ID, C_Invoice_ID);
                aLine.setPaymentInfo(C_Payment_ID, C_CashLine_ID);
                if (!aLine.save()) {
                    log.log(Level.SEVERE, "Allocation Line not written - Invoice=" + C_Invoice_ID);
                }
                DiscountAmt = Env.ZERO;
                WriteOffAmt = Env.ZERO;
                AppliedAmt = AppliedAmt.subtract(amount);
                PaymentAmt = PaymentAmt.subtract(amount);
                log.fine("Allocation Amount=" + amount + " - Remaining  Applied=" + AppliedAmt + ", Payment=" + PaymentAmt);
                amountList.set(j, PaymentAmt);
            }
            if (noPayments == 0 && paymentList.size() == 0) {
                int C_Payment_ID = 0;
                log.config(" ... no payment - TotalApplied=" + totalAppliedAmt);
                log.fine("C_Payment_ID=" + C_Payment_ID + ", C_Invoice_ID=" + C_Invoice_ID + ", Amount=" + AppliedAmt + ", Discount=" + DiscountAmt + ", WriteOff=" + WriteOffAmt);
                if (alloc.get_ID() == 0 && !alloc.save()) {
                    log.log(Level.SEVERE, "Allocation not created");
                    return;
                }
                MAllocationLine aLine = new MAllocationLine(alloc, AppliedAmt, DiscountAmt, WriteOffAmt, OverUnderAmt);
                aLine.setDocInfo(C_BPartner_ID, C_Order_ID, C_Invoice_ID);
                aLine.setPaymentInfo(C_Payment_ID, C_CashLine_ID);
                if (!aLine.save(trx.getTrxName())) {
                    log.log(Level.SEVERE, "Allocation Line not written - Invoice=" + C_Invoice_ID);
                }
                log.fine("Allocation Amount=" + AppliedAmt);
            }
            totalAppliedAmt = totalAppliedAmt.add(AppliedAmt);
            log.config("TotalRemaining=" + totalAppliedAmt);
        }
        if (invoiceLines == 0 && paymentList.size() > 0 && paymentAppliedAmt.signum() == 0) {
            for (i = 0; i < paymentList.size(); ++i) {
                int C_Payment_ID = (Integer)paymentList.get(i);
                BigDecimal PaymentAmt = (BigDecimal)amountList.get(i);
                log.fine("Payment=" + C_Payment_ID + ", Amount=" + PaymentAmt);
                if (alloc.get_ID() == 0 && !alloc.save()) {
                    log.log(Level.SEVERE, "Allocation not created");
                    return;
                }
                MAllocationLine aLine = new MAllocationLine(alloc, PaymentAmt, Env.ZERO, Env.ZERO, Env.ZERO);
                aLine.setDocInfo(C_BPartner_ID, 0, 0);
                aLine.setPaymentInfo(C_Payment_ID, 0);
                if (aLine.save(trx.getTrxName())) continue;
                log.log(Level.SEVERE, "Allocation Line not saved - Payment=" + C_Payment_ID);
            }
        }
        if (totalAppliedAmt.signum() != 0) {
            log.log(Level.SEVERE, "Remaining TotalAppliedAmt=" + totalAppliedAmt);
        }
        if (alloc.get_ID() != 0) {
            alloc.processIt("CO");
            alloc.save();
        }
        for (i = 0; i < iRows; ++i) {
            if (!((Boolean)invoice.getValueAt(i, 0)).booleanValue()) continue;
            pp = (KeyNamePair)invoice.getValueAt(i, 2);
            C_Invoice_ID = pp.getKey();
            String sql = "SELECT invoiceOpen(C_Invoice_ID, 0) FROM C_Invoice WHERE C_Invoice_ID=?";
            BigDecimal open = DB.getSQLValueBD(trx.getTrxName(), sql, C_Invoice_ID);
            if (open != null && open.signum() == 0) {
                sql = "UPDATE C_Invoice SET IsPaid='Y' WHERE C_Invoice_ID=" + C_Invoice_ID;
                int no = DB.executeUpdate(sql, trx.getTrxName());
                log.config("Invoice #" + i + " is paid");
                continue;
            }
            log.config("Invoice #" + i + " is not paid - " + open);
        }
        for (i = 0; i < paymentList.size(); ++i) {
            int C_Payment_ID = (Integer)paymentList.get(i);
            MPayment pay = new MPayment(Env.getCtx(), C_Payment_ID, trx.getTrxName());
            if (pay.testAllocation()) {
                pay.save();
            }
            log.config("Payment #" + i + (pay.isAllocated() ? " not" : " is") + " fully allocated");
        }
        paymentList.clear();
        amountList.clear();
        trx.commit();
        trx.close();
    }
}

