/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps.form;

import com.qoppa.pdf.Document;
import com.qoppa.pdfViewer.PDFViewerBean;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.InputStream;
import java.sql.Timestamp;
import java.util.logging.Level;
import org.compiere.apps.ConfirmPanel;
import org.compiere.apps.form.FormFrame;
import org.compiere.apps.form.FormPanel;
import org.compiere.grid.ed.VDate;
import org.compiere.grid.ed.VLookup;
import org.compiere.grid.ed.VString;
import org.compiere.grid.ed.VText;
import org.compiere.model.MArchive;
import org.compiere.model.MRole;
import org.compiere.swing.CButton;
import org.compiere.swing.CCheckBox;
import org.compiere.swing.CComboBox;
import org.compiere.swing.CLabel;
import org.compiere.swing.CPanel;
import org.compiere.swing.CTabbedPane;
import org.compiere.swing.CTextField;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.compiere.util.TimeUtil;

public class ArchiveViewer
extends CTabbedPane
implements FormPanel,
ActionListener,
VetoableChangeListener {
    private int m_WindowNo = 0;
    private FormFrame m_frame;
    private MArchive[] m_archives = new MArchive[0];
    private int m_index = 0;
    private int m_AD_Table_ID = 0;
    private int m_Record_ID = 0;
    private static CLogger log = CLogger.getCLogger(ArchiveViewer.class);
    private CPanel queryPanel = new CPanel(new GridBagLayout());
    private CCheckBox reportField = new CCheckBox(Msg.translate(Env.getCtx(), "IsReport"));
    private CLabel processLabel = new CLabel(Msg.translate(Env.getCtx(), "AD_Process_ID"));
    private CComboBox processField = null;
    private CLabel tableLabel = new CLabel(Msg.translate(Env.getCtx(), "AD_Table_ID"));
    private CComboBox tableField = null;
    private CLabel bPartnerLabel = new CLabel(Msg.translate(Env.getCtx(), "C_BPartner_ID"));
    private VLookup bPartnerField = null;
    private CLabel nameQLabel = new CLabel(Msg.translate(Env.getCtx(), "Name"));
    private CTextField nameQField = new CTextField(15);
    private CLabel descriptionQLabel = new CLabel(Msg.translate(Env.getCtx(), "Description"));
    private CTextField descriptionQField = new CTextField(15);
    private CLabel helpQLabel = new CLabel(Msg.translate(Env.getCtx(), "Help"));
    private CTextField helpQField = new CTextField(15);
    private CLabel createdByQLabel = new CLabel(Msg.translate(Env.getCtx(), "CreatedBy"));
    private CComboBox createdByQField = null;
    private CLabel createdQLabel = new CLabel(Msg.translate(Env.getCtx(), "Created"));
    private VDate createdQFrom = new VDate();
    private VDate createdQTo = new VDate();
    private CPanel viewPanel = new CPanel(new BorderLayout(5, 5));
    private PDFViewerBean pdfViewer = Document.getViewer();
    private CPanel viewEnterPanel = new CPanel(new GridBagLayout());
    private CButton bBack = new CButton(Env.getImageIcon("wfBack24.gif"));
    private CButton bNext = new CButton(Env.getImageIcon("wfNext24.gif"));
    private CLabel positionInfo = new CLabel(".");
    private CLabel createdByLabel = new CLabel(Msg.translate(Env.getCtx(), "CreatedBy"));
    private CTextField createdByField = new CTextField(20);
    private CLabel createdLabel = new CLabel(Msg.translate(Env.getCtx(), "Created"));
    private VDate createdField = new VDate();
    private CLabel nameLabel = new CLabel(Msg.translate(Env.getCtx(), "Name"));
    private VString nameField = new VString("Name", true, false, true, 20, 60, null, null);
    private CLabel descriptionLabel = new CLabel(Msg.translate(Env.getCtx(), "Description"));
    private VText descriptionField = new VText("Description", false, false, true, 20, 255);
    private CLabel helpLabel = new CLabel(Msg.translate(Env.getCtx(), "Help"));
    private VText helpField = new VText("Help", false, false, true, 20, 2000);
    private CButton updateArchive = ConfirmPanel.createOKButton(Msg.getMsg(Env.getCtx(), "Update"));
    private ConfirmPanel confirmPanel = new ConfirmPanel(true);

    public void init(int WindowNo, FormFrame frame) {
        log.info("");
        this.m_WindowNo = WindowNo;
        this.m_frame = frame;
        try {
            this.dynInit();
            this.jbInit();
            frame.getContentPane().add((Component)this, "Center");
            frame.getContentPane().add((Component)this.confirmPanel, "South");
            this.m_frame.setIconImage(Env.getImage("Archive16.gif"));
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "init", e);
        }
    }

    private void dynInit() {
        int AD_Role_ID = Env.getAD_Role_ID(Env.getCtx());
        String sql = "SELECT DISTINCT p.AD_Process_ID, p.Name FROM AD_Process p INNER JOIN AD_Process_Access pa ON (p.AD_Process_ID=pa.AD_Process_ID) WHERE pa.AD_Role_ID=" + AD_Role_ID + " AND p.IsReport='Y' AND p.IsActive='Y' AND pa.IsActive='Y' " + "ORDER BY 2";
        this.processField = new CComboBox(DB.getKeyNamePairs(sql, true));
        sql = "SELECT DISTINCT t.AD_Table_ID, t.Name FROM AD_Table t INNER JOIN AD_Tab tab ON (tab.AD_Table_ID=t.AD_Table_ID) INNER JOIN AD_Window_Access wa ON (tab.AD_Window_ID=wa.AD_Window_ID) WHERE wa.AD_Role_ID=" + AD_Role_ID + " AND t.IsActive='Y' AND tab.IsActive='Y' " + "ORDER BY 2";
        this.tableField = new CComboBox(DB.getKeyNamePairs(sql, true));
        sql = "SELECT AD_User_ID, Name FROM AD_User u WHERE EXISTS (SELECT * FROM AD_User_Roles ur WHERE u.AD_User_ID=ur.AD_User_ID) ORDER BY 2";
        this.createdByQField = new CComboBox(DB.getKeyNamePairs(sql, true));
        this.bPartnerField = VLookup.createBPartner(this.m_WindowNo);
    }

    private void jbInit() throws Exception {
        int line = 0;
        this.queryPanel.add((Component)this.reportField, new GridBagConstraints(0, line, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.reportField.addActionListener(this);
        this.queryPanel.add((Component)this.processLabel, new GridBagConstraints(0, ++line, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 0, 5), 0, 0));
        this.queryPanel.add((Component)this.processField, new GridBagConstraints(1, line, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.queryPanel.add((Component)this.bPartnerLabel, new GridBagConstraints(0, ++line, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 0, 5), 0, 0));
        this.queryPanel.add((Component)this.bPartnerField, new GridBagConstraints(1, line, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.queryPanel.add((Component)this.tableLabel, new GridBagConstraints(0, ++line, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 0, 5), 0, 0));
        this.queryPanel.add((Component)this.tableField, new GridBagConstraints(1, line, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.queryPanel.add((Component)this.nameQLabel, new GridBagConstraints(0, ++line, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 0, 0, 5), 0, 0));
        this.queryPanel.add((Component)this.nameQField, new GridBagConstraints(1, line, 1, 1, 0.0, 0.0, 17, 2, new Insets(10, 0, 0, 0), 0, 0));
        this.queryPanel.add((Component)this.descriptionQLabel, new GridBagConstraints(0, ++line, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 0, 5), 0, 0));
        this.queryPanel.add((Component)this.descriptionQField, new GridBagConstraints(1, line, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.queryPanel.add((Component)this.helpQLabel, new GridBagConstraints(0, ++line, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 0, 5), 0, 0));
        this.queryPanel.add((Component)this.helpQField, new GridBagConstraints(1, line, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.queryPanel.add((Component)this.createdByQLabel, new GridBagConstraints(0, ++line, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 0, 0, 5), 0, 0));
        this.queryPanel.add((Component)this.createdByQField, new GridBagConstraints(1, line, 1, 1, 0.0, 0.0, 17, 2, new Insets(10, 0, 0, 0), 0, 0));
        this.queryPanel.add((Component)this.createdQLabel, new GridBagConstraints(0, ++line, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 0, 5), 0, 0));
        this.queryPanel.add((Component)this.createdQFrom, new GridBagConstraints(1, line, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.queryPanel.add((Component)this.createdQTo, new GridBagConstraints(2, line, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.add((Component)this.queryPanel, "Query");
        line = 0;
        this.viewPanel.add((Component)this.pdfViewer, "West");
        this.bBack.addActionListener(this);
        this.bNext.addActionListener(this);
        this.positionInfo.setFontBold(true);
        this.positionInfo.setHorizontalAlignment(0);
        this.viewEnterPanel.add((Component)this.bBack, new GridBagConstraints(0, line, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.viewEnterPanel.add((Component)this.positionInfo, new GridBagConstraints(1, line, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.viewEnterPanel.add((Component)this.bNext, new GridBagConstraints(2, line, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.createdByField.setReadWrite(false);
        this.createdField.setReadWrite(false);
        this.nameField.addVetoableChangeListener(this);
        this.descriptionField.addVetoableChangeListener(this);
        this.helpField.addVetoableChangeListener(this);
        this.viewEnterPanel.add((Component)this.createdByLabel, new GridBagConstraints(0, ++line, 3, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 5), 0, 0));
        this.viewEnterPanel.add((Component)this.createdByField, new GridBagConstraints(0, ++line, 3, 1, 0.0, 0.0, 17, 2, new Insets(2, 0, 0, 5), 0, 0));
        this.viewEnterPanel.add((Component)this.createdField, new GridBagConstraints(0, ++line, 3, 1, 0.0, 0.0, 13, 0, new Insets(2, 0, 0, 5), 0, 0));
        this.viewEnterPanel.add((Component)this.nameLabel, new GridBagConstraints(0, ++line, 3, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 5), 0, 0));
        this.viewEnterPanel.add((Component)this.nameField, new GridBagConstraints(0, ++line, 3, 1, 1.0, 0.0, 17, 2, new Insets(2, 0, 0, 5), 0, 0));
        this.viewEnterPanel.add((Component)this.descriptionLabel, new GridBagConstraints(0, ++line, 3, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 5), 0, 0));
        this.viewEnterPanel.add((Component)this.descriptionField, new GridBagConstraints(0, ++line, 3, 1, 1.0, 0.0, 17, 2, new Insets(2, 0, 0, 5), 0, 0));
        this.viewEnterPanel.add((Component)this.helpLabel, new GridBagConstraints(0, ++line, 3, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 5), 0, 0));
        this.viewEnterPanel.add((Component)this.helpField, new GridBagConstraints(0, ++line, 3, 1, 1.0, 0.0, 17, 2, new Insets(2, 0, 0, 5), 0, 0));
        this.viewEnterPanel.add((Component)this.updateArchive, new GridBagConstraints(0, ++line, 3, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 0, 5), 0, 0));
        this.viewEnterPanel.setPreferredSize(new Dimension(220, 500));
        this.updateArchive.addActionListener(this);
        this.viewPanel.add((Component)this.viewEnterPanel, "Center");
        this.add((Component)this.viewPanel, "View");
        this.confirmPanel.addActionListener(this);
        this.updateQDisplay();
        this.setPreferredSize(new Dimension(720, 500));
    }

    public void dispose() {
        if (this.m_frame != null) {
            this.m_frame.dispose();
        }
        this.m_frame = null;
    }

    public void actionPerformed(ActionEvent e) {
        log.info(e.getActionCommand());
        if (e.getSource() == this.updateArchive) {
            this.cmd_updateArchive();
        } else if (e.getActionCommand().equals("Cancel")) {
            this.dispose();
        } else if (e.getActionCommand().equals("Ok")) {
            if (this.getSelectedIndex() == 1) {
                this.dispose();
            } else {
                this.cmd_query();
            }
        } else if (e.getSource() == this.reportField) {
            this.updateQDisplay();
        } else if (e.getSource() == this.bBack) {
            this.updateVDisplay(false);
        } else if (e.getSource() == this.bNext) {
            this.updateVDisplay(true);
        }
    }

    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        if (this.m_archives.length > 0) {
            this.updateArchive.setEnabled(true);
        }
    }

    private void updateQDisplay() {
        boolean reports = this.reportField.isSelected();
        log.config("Reports=" + reports);
        this.processLabel.setVisible(reports);
        this.processField.setVisible(reports);
        this.bPartnerLabel.setVisible(!reports);
        this.bPartnerField.setVisible(!reports);
    }

    private void updateVDisplay(boolean next) {
        if (this.m_archives == null) {
            this.m_archives = new MArchive[0];
        }
        this.m_index = next ? ++this.m_index : --this.m_index;
        if (this.m_index >= this.m_archives.length - 1) {
            this.m_index = this.m_archives.length - 1;
        }
        if (this.m_index < 0) {
            this.m_index = 0;
        }
        this.bBack.setEnabled(this.m_index > 0);
        this.bNext.setEnabled(this.m_index < this.m_archives.length - 1);
        this.updateArchive.setEnabled(false);
        log.info("Index=" + this.m_index + ", Length=" + this.m_archives.length);
        if (this.m_archives.length == 0) {
            this.positionInfo.setText("No Record Found");
            this.createdByField.setText("");
            this.createdField.setValue(null);
            this.nameField.setText("");
            this.descriptionField.setText("");
            this.helpField.setText("");
            this.pdfViewer.clearDocument();
            return;
        }
        this.positionInfo.setText(this.m_index + 1 + " of " + this.m_archives.length);
        MArchive ar = this.m_archives[this.m_index];
        this.createdByField.setText(ar.getCreatedByName());
        this.createdField.setValue(ar.getCreated());
        this.nameField.setText(ar.getName());
        this.descriptionField.setText(ar.getDescription());
        this.helpField.setText(ar.getHelp());
        try {
            InputStream in = ar.getInputStream();
            this.pdfViewer.setScale(this.reportField.isSelected() ? 50 : 75);
            if (in != null) {
                this.pdfViewer.loadPDF(in);
            } else {
                this.pdfViewer.clearDocument();
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "pdf", e);
            this.pdfViewer.clearDocument();
        }
    }

    private void cmd_updateArchive() {
        String newText;
        MArchive ar = this.m_archives[this.m_index];
        boolean update = false;
        if (!this.isSame(this.nameField.getText(), ar.getName()) && (newText = this.nameField.getText()) != null && newText.length() > 0) {
            ar.setName(newText);
            update = true;
        }
        if (!this.isSame(this.descriptionField.getText(), ar.getDescription())) {
            ar.setDescription(this.descriptionField.getText());
            update = true;
        }
        if (!this.isSame(this.helpField.getText(), ar.getHelp())) {
            ar.setHelp(this.helpField.getText());
            update = true;
        }
        log.info("Update=" + update);
        if (update) {
            ar.save();
        }
        ++this.m_index;
        this.updateVDisplay(false);
    }

    private boolean isSame(String s1, String s2) {
        if (s1 == null) {
            return s2 == null;
        }
        if (s2 == null) {
            return false;
        }
        return s1.equals(s2);
    }

    public void query(boolean isReport, int AD_Table_ID, int Record_ID) {
        log.config("Report=" + isReport + ", AD_Table_ID=" + AD_Table_ID + ",Record_ID=" + Record_ID);
        this.reportField.setSelected(isReport);
        this.m_AD_Table_ID = AD_Table_ID;
        this.m_Record_ID = Record_ID;
        this.cmd_query();
    }

    private void cmd_query() {
        Timestamp tt;
        KeyNamePair nn;
        String ss;
        KeyNamePair nn2;
        StringBuffer sql = new StringBuffer();
        boolean reports = this.reportField.isSelected();
        MRole role = MRole.getDefault();
        if (!role.isCanReport()) {
            log.warning("User/Role cannot Report AD_User_ID=" + Env.getAD_User_ID(Env.getCtx()));
            return;
        }
        sql.append(" AND IsReport=").append(reports ? "'Y'" : "'N'");
        if (reports && (nn2 = (KeyNamePair)this.processField.getSelectedItem()) != null && nn2.getKey() > 0) {
            sql.append(" AND AD_Process_ID=").append(nn2.getKey());
        }
        if (this.m_AD_Table_ID > 0) {
            sql.append(" AND ((AD_Table_ID=").append(this.m_AD_Table_ID);
            if (this.m_Record_ID > 0) {
                sql.append(" AND Record_ID=").append(this.m_Record_ID);
            }
            sql.append(")");
            if (this.m_AD_Table_ID == 291 && this.m_Record_ID > 0) {
                sql.append(" OR C_BPartner_ID=").append(this.m_Record_ID);
            }
            sql.append(")");
            this.m_AD_Table_ID = 0;
            this.m_Record_ID = 0;
        } else {
            nn2 = (KeyNamePair)this.tableField.getSelectedItem();
            if (nn2 != null && nn2.getKey() > 0) {
                sql.append(" AND AD_Table_ID=").append(nn2.getKey());
            }
        }
        if (!reports) {
            Integer ii = (Integer)this.bPartnerField.getValue();
            if (ii != null) {
                sql.append(" AND C_BPartner_ID=").append(ii);
            } else {
                sql.append(" AND C_BPartner_ID IS NOT NULL");
            }
        }
        if ((ss = this.nameQField.getText()) != null && ss.length() > 0) {
            if (ss.indexOf("%") != -1 || ss.indexOf("_") != -1) {
                sql.append(" AND Name LIKE ").append(DB.TO_STRING(ss));
            } else {
                sql.append(" AND Name=").append(DB.TO_STRING(ss));
            }
        }
        if ((ss = this.descriptionQField.getText()) != null && ss.length() > 0) {
            if (ss.indexOf("%") != -1 || ss.indexOf("_") != -1) {
                sql.append(" AND Description LIKE ").append(DB.TO_STRING(ss));
            } else {
                sql.append(" AND Description=").append(DB.TO_STRING(ss));
            }
        }
        if ((ss = this.helpQField.getText()) != null && ss.length() > 0) {
            if (ss.indexOf("%") != -1 || ss.indexOf("_") != -1) {
                sql.append(" AND Help LIKE ").append(DB.TO_STRING(ss));
            } else {
                sql.append(" AND Help=").append(DB.TO_STRING(ss));
            }
        }
        if ((nn = (KeyNamePair)this.createdByQField.getSelectedItem()) != null && nn.getKey() > 0) {
            sql.append(" AND CreatedBy=").append(nn.getKey());
        }
        if ((tt = this.createdQFrom.getTimestamp()) != null) {
            sql.append(" AND Created>=").append(DB.TO_DATE(tt, true));
        }
        if ((tt = this.createdQTo.getTimestamp()) != null) {
            sql.append(" AND Created<").append(DB.TO_DATE(TimeUtil.addDays(tt, 1), true));
        }
        log.fine(sql.toString());
        sql.append(" AND (AD_Process_ID IS NULL OR AD_Process_ID IN (SELECT AD_Process_ID FROM AD_Process_Access WHERE AD_Role_ID=").append(role.getAD_Role_ID()).append("))");
        sql.append(" AND (AD_Table_ID IS NULL OR (AD_Table_ID IS NOT NULL AND AD_Process_ID IS NOT NULL) OR AD_Table_ID IN (SELECT t.AD_Table_ID FROM AD_Tab t INNER JOIN AD_Window_Access wa ON (t.AD_Window_ID=wa.AD_Window_ID) WHERE wa.AD_Role_ID=").append(role.getAD_Role_ID()).append("))");
        log.finest(sql.toString());
        this.m_archives = MArchive.get(Env.getCtx(), sql.toString());
        log.info("Length=" + this.m_archives.length);
        this.setSelectedIndex(1);
        this.m_index = 1;
        this.updateVDisplay(false);
    }
}

