/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import org.compiere.apps.AMenu;
import org.compiere.apps.AWindow;
import org.compiere.apps.WindowManager;
import org.compiere.swing.CFrame;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class WindowMenu
extends JMenu {
    private WindowManager windowManager;
    private JFrame frame;
    private JMenuItem closeAll = new JMenuItem("Close All Windows");
    private JMenuItem closeOthers = new JMenuItem("Close Other Windows");

    private void setEnvText(JMenu menu, String msg) {
        char ch;
        String text = Msg.getMsg(Env.getCtx(), msg);
        int pos = text.indexOf("&");
        if (pos != -1 && text.length() > pos && (ch = text.toUpperCase().charAt(pos + 1)) != ' ') {
            text = text.substring(0, pos) + text.substring(pos + 1);
            menu.setMnemonic(ch);
        }
        menu.setText(text);
    }

    private void setEnvText(JMenuItem menu, String msg) {
        char ch;
        String text = Msg.getMsg(Env.getCtx(), msg);
        int pos = text.indexOf("&");
        if (pos != -1 && text.length() > pos && (ch = text.toUpperCase().charAt(pos + 1)) != ' ') {
            text = text.substring(0, pos) + text.substring(pos + 1);
            menu.setMnemonic(ch);
        }
        menu.setText(text);
    }

    public WindowMenu(WindowManager windowManager, JFrame frame) {
        this.windowManager = windowManager;
        this.frame = frame;
        this.setEnvText(this, "Window");
        this.closeAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                WindowMenu.this.windowManager.close();
            }
        });
        this.setEnvText(this.closeAll, "CloseAllWindows");
        this.closeOthers.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                WindowMenu.this.windowManager.closeOthers((AWindow)WindowMenu.this.frame);
            }
        });
        this.setEnvText(this.closeOthers, "CloseOtherWindows");
        this.addMenuListener(new MenuListener(){

            public void menuCanceled(MenuEvent e) {
            }

            public void menuDeselected(MenuEvent e) {
                WindowMenu.this.removeAll();
            }

            public void menuSelected(MenuEvent e) {
                WindowMenu.this.buildChildMenus();
            }
        });
    }

    private void buildChildMenus() {
        this.removeAll();
        CFrame[] array = this.windowManager.getWindows();
        if (!(this.frame instanceof AMenu)) {
            this.add(this.closeOthers);
        }
        this.add(this.closeAll);
        if (array.length > 0) {
            this.closeAll.setEnabled(true);
            if (array.length > 1) {
                this.closeOthers.setEnabled(true);
            } else {
                this.closeOthers.setEnabled(false);
            }
            this.addSeparator();
        } else {
            this.closeAll.setEnabled(false);
            this.closeOthers.setEnabled(false);
        }
        for (int i = 0; i < array.length; ++i) {
            ChildMenuItem menu = new ChildMenuItem(array[i]);
            menu.setState(array[i].equals(this.frame));
            menu.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    CFrame frame = ((ChildMenuItem)ae.getSource()).getWindow();
                    frame.toFront();
                }
            });
            this.add(menu);
        }
    }

    class ChildMenuItem
    extends JCheckBoxMenuItem {
        private CFrame window;

        public ChildMenuItem(CFrame window) {
            super(window.getTitle());
            this.window = window;
        }

        public CFrame getWindow() {
            return this.window;
        }
    }
}

