/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Level;
import javax.swing.Box;
import javax.swing.JProgressBar;
import javax.swing.Timer;
import org.compiere.apps.AEnv;
import org.compiere.swing.CButton;
import org.compiere.swing.CDialog;
import org.compiere.swing.CLabel;
import org.compiere.swing.CPanel;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class Waiting
extends CDialog
implements ActionListener {
    private int m_timervalue = 0;
    private Timer m_timer;
    private static CLogger log = CLogger.getCLogger(Waiting.class);
    private CPanel southPanel = new CPanel();
    private CButton bDoNotWait = new CButton();
    private CLabel infoLabel = new CLabel();
    private FlowLayout southLayout = new FlowLayout();
    private CPanel mainPanel = new CPanel();
    private JProgressBar progressBar = new JProgressBar();

    public Waiting(Frame owner, String text, boolean canNotWait, int timer) {
        super(owner, Msg.getMsg(Env.getCtx(), "Processing"));
        this.init(text, canNotWait, timer);
    }

    public Waiting(Dialog owner, String text, boolean canNotWait, int timer) {
        super(owner, Msg.getMsg(Env.getCtx(), "Processing"));
        this.init(text, canNotWait, timer);
    }

    private void init(String text, boolean canNotWait, int timer) {
        log.fine(text + " - Sec=" + timer);
        if (timer == 1) {
            return;
        }
        try {
            this.jbInit();
            this.setText(text);
            if (!canNotWait) {
                this.bDoNotWait.setVisible(false);
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Waiting", e);
        }
        this.progressBar.setMinimum(0);
        this.progressBar.setMaximum(timer < 5 ? 10 : timer);
        this.m_timer = new Timer(1000, this);
        this.m_timer.start();
        AEnv.showCenterWindow(this.getOwner(), this);
    }

    private void jbInit() throws Exception {
        this.setDefaultCloseOperation(0);
        this.setResizable(false);
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.getContentPane().add(Box.createVerticalStrut(8), "North");
        this.getContentPane().add(Box.createHorizontalStrut(8), "West");
        this.getContentPane().add(Box.createVerticalStrut(8), "South");
        this.getContentPane().add(Box.createHorizontalStrut(8), "East");
        this.mainPanel.setLayout(new BorderLayout(5, 5));
        this.getContentPane().add((Component)this.mainPanel, "Center");
        this.infoLabel.setFont(new Font("Dialog", 3, 14));
        this.infoLabel.setHorizontalAlignment(0);
        this.infoLabel.setHorizontalTextPosition(4);
        this.infoLabel.setIcon(Env.getImageIcon("C10030.gif"));
        this.infoLabel.setIconTextGap(10);
        this.mainPanel.add((Component)this.infoLabel, "North");
        this.mainPanel.add((Component)this.progressBar, "Center");
    }

    public void setText(String text) {
        this.infoLabel.setText(text);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.bDoNotWait) {
            this.doNotWait();
        }
        this.progressBar.setValue(this.m_timervalue++);
        if (this.m_timervalue > this.progressBar.getMaximum()) {
            this.m_timervalue = this.progressBar.getMinimum();
        }
    }

    public void setTimerEstimate(int max) {
        this.progressBar.setMaximum(max);
    }

    public void doNotWait() {
        this.dispose();
    }

    public void dispose() {
        if (this.m_timer != null) {
            this.m_timer.stop();
        }
        this.m_timer = null;
        super.dispose();
    }
}

