/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.HashMap;
import java.util.logging.Level;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.border.TitledBorder;
import org.compiere.apps.ADialog;
import org.compiere.apps.AEnv;
import org.compiere.apps.ConfirmPanel;
import org.compiere.apps.Help;
import org.compiere.model.MUser;
import org.compiere.model.Scriptlet;
import org.compiere.swing.CFrame;
import org.compiere.swing.CPanel;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class ScriptEditor
extends CFrame
implements ActionListener {
    private Scriptlet m_script;
    private int m_WindowNo;
    private String m_origScript;
    private static CLogger log = CLogger.getCLogger(ScriptEditor.class);
    private CPanel mainPanel = new CPanel();
    private BorderLayout borderLayout1 = new BorderLayout();
    private JScrollPane editorPane = new JScrollPane();
    private JTextArea editor = new JTextArea();
    private JScrollPane variablesPane = new JScrollPane();
    private JTextPane variables = new JTextPane();
    private TitledBorder titledBorder1;
    private TitledBorder titledBorder2;
    private CPanel northPanel = new CPanel();
    private CPanel southPanel = new CPanel();
    private BorderLayout southLayout = new BorderLayout();
    private CPanel okPanel = new CPanel();
    private JButton bOK = ConfirmPanel.createOKButton(true);
    private JButton bCancel = ConfirmPanel.createCancelButton(true);
    private CPanel resultPanel = new CPanel();
    private JButton bProcess = ConfirmPanel.createProcessButton(true);
    private JLabel lResult = new JLabel();
    private JTextField fResult = new JTextField();
    private CPanel resultVariablePanel = new CPanel();
    private BorderLayout northLayout = new BorderLayout();
    private JLabel lResultVariable = new JLabel();
    private JTextField fResultVariable = new JTextField();
    private CPanel helpPanel = new CPanel();
    private JButton bHelp = ConfirmPanel.createHelpButton(true);
    private GridBagLayout resultVariableLayout = new GridBagLayout();
    private FlowLayout okLayout = new FlowLayout();
    private GridBagLayout resultLayout = new GridBagLayout();
    private JSplitPane centerPane = new JSplitPane();

    public ScriptEditor() {
        this(Msg.getMsg(Env.getCtx(), "Script"), null, 0);
    }

    public ScriptEditor(String title, Scriptlet script, int WindowNo) {
        super(title);
        this.m_WindowNo = WindowNo;
        if (this.m_WindowNo == 0) {
            this.m_WindowNo = Env.createWindowNo(this);
        }
        log.info("Window=" + this.m_WindowNo);
        try {
            this.jbInit();
            this.setScript(script);
            this.dynInit();
            AEnv.showCenterScreen(this);
            this.toFront();
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "", ex);
        }
    }

    void jbInit() throws Exception {
        this.setIconImage(Env.getImage("Bean16.gif"));
        this.setDefaultCloseOperation(2);
        this.titledBorder1 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(148, 145, 140)), Msg.getMsg(Env.getCtx(), "ScriptVariables"));
        this.titledBorder2 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(148, 145, 140)), Msg.getMsg(Env.getCtx(), "ScriptEditor"));
        this.mainPanel.setLayout(this.borderLayout1);
        this.editor.setLineWrap(true);
        this.editor.setTabSize(4);
        this.editor.setWrapStyleWord(true);
        this.bOK.addActionListener(this);
        this.bCancel.addActionListener(this);
        this.bHelp.addActionListener(this);
        this.bProcess.addActionListener(this);
        this.variables.setBackground(Color.lightGray);
        this.variables.setEditable(false);
        this.variables.setContentType("text/html");
        this.variablesPane.setBorder(this.titledBorder1);
        this.editorPane.setBorder(this.titledBorder2);
        this.centerPane.setPreferredSize(new Dimension(500, 500));
        this.centerPane.setLeftComponent(this.editorPane);
        this.centerPane.setRightComponent(this.variablesPane);
        this.southPanel.setLayout(this.southLayout);
        this.resultPanel.setLayout(this.resultLayout);
        this.lResult.setText(Msg.getMsg(Env.getCtx(), "ScriptResult"));
        this.fResult.setBackground(Color.lightGray);
        this.fResult.setEditable(false);
        this.fResult.setText("");
        this.northPanel.setLayout(this.northLayout);
        this.lResultVariable.setText(Msg.getMsg(Env.getCtx(), "ScriptResultVariable"));
        this.fResultVariable.setBackground(Color.lightGray);
        this.fResultVariable.setEditable(false);
        this.resultVariablePanel.setLayout(this.resultVariableLayout);
        this.okPanel.setLayout(this.okLayout);
        this.northPanel.add((Component)this.resultVariablePanel, "Center");
        this.getContentPane().add(this.mainPanel);
        this.editorPane.getViewport().add((Component)this.editor, null);
        this.variablesPane.getViewport().add((Component)this.variables, null);
        this.mainPanel.add((Component)this.northPanel, "North");
        this.mainPanel.add((Component)this.southPanel, "South");
        this.southPanel.add((Component)this.okPanel, "East");
        this.okPanel.add((Component)this.bCancel, null);
        this.okPanel.add((Component)this.bOK, null);
        this.southPanel.add((Component)this.resultPanel, "Center");
        this.resultPanel.add((Component)this.bProcess, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.resultPanel.add((Component)this.lResult, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.resultPanel.add((Component)this.fResult, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.mainPanel.add((Component)this.centerPane, "Center");
        this.resultVariablePanel.add((Component)this.lResultVariable, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.resultVariablePanel.add((Component)this.fResultVariable, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.northPanel.add((Component)this.helpPanel, "East");
        this.helpPanel.add((Component)this.bHelp, null);
        this.centerPane.setDividerLocation(350);
    }

    public void setScript(Scriptlet script) {
        this.m_script = script == null ? new Scriptlet("result", ";", Env.getCtx(), this.m_WindowNo) : script;
        this.fResultVariable.setText(this.m_script.getVariable());
        this.m_origScript = this.m_script.getScript();
        this.editor.setText(this.m_script.getScript());
        StringBuffer sb = new StringBuffer("<HTML><BODY>");
        HashMap<String, Object> ctx = this.m_script.getEnvironment();
        Object[] pp = new String[ctx.size()];
        ctx.keySet().toArray(pp);
        Arrays.sort(pp);
        for (int i = 0; i < pp.length; ++i) {
            String key = ((String)pp[i]).toString();
            Object value = ctx.get(key);
            sb.append("<font color=").append('\"').append(this.getColor(value)).append('\"').append(">").append(key).append(" (").append(value).append(")</font><br>");
        }
        sb.append("</BODY></HTML>");
        this.variables.setText(sb.toString());
        this.variables.setCaretPosition(0);
    }

    private String getColor(Object value) {
        if (value instanceof String) {
            return "#009900";
        }
        if (value instanceof Integer) {
            return "#0000FF";
        }
        if (value instanceof Double) {
            return "#00FFFF";
        }
        if (value instanceof Timestamp) {
            return "#FF00FF";
        }
        if (value instanceof Boolean) {
            return "#FF9900";
        }
        return "#FF0000";
    }

    private void dynInit() {
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.bOK) {
            this.dispose();
        } else if (e.getSource() == this.bCancel) {
            this.m_script.setScript(this.m_origScript);
            this.dispose();
        } else if (e.getSource() == this.bProcess) {
            this.actionProcess();
        } else if (e.getSource() == this.bHelp) {
            Help h = new Help((Frame)this, Msg.getMsg(Env.getCtx(), "ScriptHelp"), this.getClass().getResource("Script.html"));
            h.setVisible(true);
        }
    }

    private void actionProcess() {
        Object result;
        MUser user = MUser.get(Env.getCtx());
        if (!user.isAdministrator()) {
            this.fResult.setText("Not Administrator");
            return;
        }
        this.m_script.setScript(this.editor.getText());
        Exception e = this.m_script.execute();
        if (e != null) {
            ADialog.error(this.m_WindowNo, this, "ScriptError", e.toString());
        }
        this.fResult.setText((result = this.m_script.getResult(false)) == null ? "" : result.toString());
    }

    public static String start(String header, String script, boolean editable, int WindowNo) {
        Scriptlet scr = new Scriptlet("result", script, Env.getCtx(), WindowNo);
        ScriptEditor se = new ScriptEditor(header, scr, WindowNo);
        return scr.getScript();
    }
}

