/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.logging.Level;
import javax.swing.BorderFactory;
import javax.swing.JScrollPane;
import org.adempiere.plaf.AdempierePLAF;
import org.compiere.apps.AEnv;
import org.compiere.apps.ConfirmPanel;
import org.compiere.apps.OnlineHelp;
import org.compiere.model.GridWindow;
import org.compiere.swing.CDialog;
import org.compiere.swing.CPanel;
import org.compiere.util.CLogger;
import org.compiere.util.WebDoc;

public class Help
extends CDialog
implements ActionListener {
    private static CLogger log = CLogger.getCLogger(Help.class);
    private CPanel mainPanel = new CPanel();
    private BorderLayout mainLayout = new BorderLayout();
    private OnlineHelp info = new OnlineHelp();
    private JScrollPane infoPane = new JScrollPane();
    private ConfirmPanel confirmPanel = new ConfirmPanel();

    public Help(Frame frame, String title, GridWindow mWindow) {
        super(frame, title, false);
        try {
            this.jbInit();
            this.loadInfo(mWindow);
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "", ex);
        }
        AEnv.positionCenterWindow(frame, this);
    }

    public Help(Frame frame, String title, URL url) {
        super(frame, title, false);
        try {
            this.jbInit();
            this.info.setPage(url);
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "", ex);
        }
        AEnv.positionCenterWindow(frame, this);
    }

    public Help(Frame frame, String title, String helpHtml) {
        super(frame, title, false);
        try {
            this.jbInit();
            this.info.setContentType("text/html");
            this.info.setEditable(false);
            this.info.setBackground(AdempierePLAF.getFieldBackground_Inactive());
            this.info.setText(helpHtml);
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "Help", ex);
        }
        AEnv.positionCenterWindow(frame, this);
    }

    void jbInit() throws Exception {
        this.mainPanel.setLayout(this.mainLayout);
        this.mainLayout.setHgap(2);
        this.mainLayout.setVgap(2);
        this.infoPane.setBorder(BorderFactory.createLoweredBevelBorder());
        this.infoPane.setPreferredSize(new Dimension(500, 400));
        this.getContentPane().add(this.mainPanel);
        this.mainPanel.add((Component)this.infoPane, "Center");
        this.mainPanel.add((Component)this.confirmPanel, "South");
        this.infoPane.getViewport().add((Component)this.info, null);
        this.confirmPanel.addActionListener(this);
    }

    private void loadInfo(GridWindow mWindow) {
        WebDoc doc = mWindow.getHelpDoc(true);
        this.info.setText(doc.toString());
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("Ok")) {
            this.dispose();
        }
    }
}

