/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps;

import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import org.compiere.apps.ADialog;
import org.compiere.apps.AEnv;
import org.compiere.apps.AWindow;
import org.compiere.model.MQuery;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;

public class AZoomAcross
implements ActionListener {
    private MQuery m_query;
    private JPopupMenu m_popup = new JPopupMenu("ZoomMenu");
    private ArrayList<KeyNamePair> m_list = new ArrayList();
    private static CLogger log = CLogger.getCLogger(AZoomAcross.class);

    public AZoomAcross(JComponent invoker, String tableName, MQuery query) {
        log.config("TableName=" + tableName + " - " + query);
        this.m_query = query;
        this.getZoomTargets(invoker, tableName);
    }

    private void getZoomTargets(JComponent invoker, String tableName) {
        String sql = "SELECT DISTINCT ws.AD_Window_ID,ws.Name, wp.AD_Window_ID,wp.Name, t.TableName FROM AD_Table t ";
        boolean baseLanguage = Env.isBaseLanguage(Env.getCtx(), "AD_Window");
        sql = baseLanguage ? sql + "INNER JOIN AD_Window ws ON (t.AD_Window_ID=ws.AD_Window_ID) LEFT OUTER JOIN AD_Window wp ON (t.PO_Window_ID=wp.AD_Window_ID) " : sql + "INNER JOIN AD_Window_Trl ws ON (t.AD_Window_ID=ws.AD_Window_ID AND ws.AD_Language=?) LEFT OUTER JOIN AD_Window_Trl wp ON (t.PO_Window_ID=wp.AD_Window_ID AND wp.AD_Language=?) ";
        sql = sql + "WHERE t.TableName NOT LIKE 'I%' AND EXISTS (SELECT * FROM AD_Tab tt WHERE (tt.AD_Window_ID=ws.AD_Window_ID OR tt.AD_Window_ID=wp.AD_Window_ID) AND tt.AD_Table_ID=t.AD_Table_ID AND tt.SeqNo=10) AND t.AD_Table_ID IN (SELECT AD_Table_ID FROM AD_Column WHERE ColumnName=? AND IsKey='N' AND IsParent='N') ORDER BY 2";
        Object pp = null;
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql, null);
            int index = 1;
            if (!baseLanguage) {
                pstmt.setString(index++, Env.getAD_Language(Env.getCtx()));
                pstmt.setString(index++, Env.getAD_Language(Env.getCtx()));
            }
            pstmt.setString(index++, tableName + "_ID");
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                int AD_Window_ID = rs.getInt(1);
                String Name = rs.getString(2);
                int PO_Window_ID = rs.getInt(3);
                String targetTableName = rs.getString(5);
                if (PO_Window_ID == 0) {
                    this.addTarget(targetTableName, AD_Window_ID, Name, null);
                } else {
                    this.addTarget(targetTableName, AD_Window_ID, Name, Boolean.TRUE);
                }
                if (PO_Window_ID == 0) continue;
                Name = rs.getString(4);
                this.addTarget(targetTableName, PO_Window_ID, Name, Boolean.FALSE);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, sql, e);
        }
        if (this.m_list.size() == 0) {
            ADialog.info(0, invoker, "NoZoomTarget");
            log.info("BaseLanguage=" + baseLanguage);
        } else if (invoker.isShowing()) {
            this.m_popup.show(invoker, 0, invoker.getHeight());
        }
    }

    private boolean addTarget(String targetTableName, int AD_Window_ID, String Name, Boolean isSO) {
        int count;
        String sql = "SELECT COUNT(*) FROM " + targetTableName + " WHERE " + this.m_query.getWhereClause(false);
        String sqlAdd = "";
        if (isSO != null) {
            sqlAdd = " AND IsSOTrx=" + (isSO != false ? "'Y'" : "'N'");
        }
        if ((count = DB.getSQLValue(null, sql + sqlAdd)) < 0 && isSO != null) {
            DB.getSQLValue(null, sql);
        }
        if (count <= 0) {
            return false;
        }
        KeyNamePair pp = new KeyNamePair(AD_Window_ID, Name);
        this.m_list.add(pp);
        this.m_popup.add(pp.toString()).addActionListener(this);
        return true;
    }

    public void actionPerformed(ActionEvent e) {
        this.m_popup.setCursor(Cursor.getPredefinedCursor(3));
        String cmd = e.getActionCommand();
        for (int i = 0; i < this.m_list.size(); ++i) {
            KeyNamePair pp = this.m_list.get(i);
            if (!cmd.equals(pp.getName())) continue;
            this.launchZoom(pp);
            return;
        }
    }

    private void launchZoom(KeyNamePair pp) {
        int AD_Window_ID = pp.getKey();
        log.info("AD_Window_ID=" + AD_Window_ID + " - " + this.m_query);
        AWindow frame = new AWindow();
        if (!frame.initWindow(AD_Window_ID, this.m_query)) {
            return;
        }
        AEnv.addToWindowManager(frame);
        AEnv.showCenterScreen(frame);
        frame = null;
    }
}

