/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps;

import org.compiere.process.ProcessInfo;
import org.compiere.util.ASyncProcess;
import org.compiere.util.ASyncWorker;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Splash;

public abstract class ASyncProcessBase
implements ASyncProcess {
    private ProcessInfo m_pi;
    private boolean m_isLocked = false;
    private Splash m_splash;

    public ASyncProcessBase(ProcessInfo pi) {
        this.m_pi = pi;
    }

    void start() {
        if (this.isUILocked()) {
            return;
        }
        ASyncWorker worker = new ASyncWorker(this, this.m_pi);
        worker.start();
    }

    public void lockUI(ProcessInfo pi) {
        this.m_isLocked = true;
        this.m_splash = new Splash(Msg.getMsg(Env.getCtx(), "Processing"));
        this.m_splash.toFront();
    }

    public void unlockUI(ProcessInfo pi) {
        this.m_isLocked = false;
        this.m_splash.dispose();
        this.m_splash = null;
    }

    public boolean isUILocked() {
        return this.m_isLocked;
    }

    public abstract void executeASync(ProcessInfo var1);
}

