/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps;

import java.awt.Component;
import java.util.HashMap;
import org.compiere.apps.ALayoutConstraint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ALayoutCollection
extends HashMap<Object, Object> {
    @Override
    public Object put(Object constraint, Object component) {
        if (!(component instanceof Component)) {
            throw new IllegalArgumentException("ALayoutCollection can only add Component values");
        }
        if (constraint != null && !this.containsKey(constraint) && constraint instanceof ALayoutConstraint) {
            return super.put(constraint, component);
        }
        if (super.size() == 0) {
            return super.put(new ALayoutConstraint(0, 0), component);
        }
        int row = this.getMaxRow();
        if (row == -1) {
            row = 0;
        }
        int col = this.getMaxCol(row) + 1;
        ALayoutConstraint next = new ALayoutConstraint(row, col);
        return super.put(next, component);
    }

    public int getMaxRow() {
        int maxRow = -1;
        for (ALayoutConstraint c : this.keySet()) {
            maxRow = Math.max(maxRow, c.getRow());
        }
        return maxRow;
    }

    public int getMaxCol() {
        int maxCol = -1;
        for (ALayoutConstraint c : this.keySet()) {
            maxCol = Math.max(maxCol, c.getCol());
        }
        return maxCol;
    }

    public int getMaxCol(int row) {
        int maxCol = -1;
        for (ALayoutConstraint c : this.keySet()) {
            if (c.getRow() != row) continue;
            maxCol = Math.max(maxCol, c.getCol());
        }
        return maxCol;
    }
}

