/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.ResultSet;
import java.util.logging.Level;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import org.compiere.apps.AEnv;
import org.compiere.apps.form.ArchiveViewer;
import org.compiere.apps.form.FormFrame;
import org.compiere.swing.CMenuItem;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class AArchive
implements ActionListener {
    private int m_AD_Table_ID;
    private int m_Record_ID;
    private JPopupMenu m_popup = new JPopupMenu("ArchiveMenu");
    private CMenuItem m_reports = null;
    private CMenuItem m_reportsAll = null;
    private CMenuItem m_documents = null;
    StringBuffer m_where = null;
    private static CLogger log = CLogger.getCLogger(AArchive.class);

    public AArchive(JComponent invoker, int AD_Table_ID, int Record_ID) {
        log.config("AD_Table_ID=" + AD_Table_ID + ", Record_ID=" + Record_ID);
        this.m_AD_Table_ID = AD_Table_ID;
        this.m_Record_ID = Record_ID;
        this.getArchives(invoker);
    }

    private void getArchives(JComponent invoker) {
        String sql1;
        int allReports;
        int reportCount = 0;
        int documentCount = 0;
        this.m_where = new StringBuffer();
        this.m_where.append("(AD_Table_ID=").append(this.m_AD_Table_ID).append(" AND Record_ID=").append(this.m_Record_ID).append(")");
        if (this.m_AD_Table_ID == 291) {
            this.m_where.append(" OR C_BPartner_ID=").append(this.m_Record_ID);
        }
        StringBuffer sql = new StringBuffer("SELECT IsReport, COUNT(*) FROM AD_Archive ").append("WHERE (AD_Table_ID=? AND Record_ID=?) ");
        if (this.m_AD_Table_ID == 291) {
            sql.append(" OR C_BPartner_ID=?");
        }
        sql.append(" GROUP BY IsReport");
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql.toString(), null);
            pstmt.setInt(1, this.m_AD_Table_ID);
            pstmt.setInt(2, this.m_Record_ID);
            if (this.m_AD_Table_ID == 291) {
                pstmt.setInt(3, this.m_Record_ID);
            }
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                if ("Y".equals(rs.getString(1))) {
                    reportCount += rs.getInt(2);
                    continue;
                }
                documentCount += rs.getInt(2);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, sql.toString(), e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        if (documentCount > 0) {
            this.m_documents = new CMenuItem(Msg.getMsg(Env.getCtx(), "ArchivedDocuments") + " (" + documentCount + ")");
            this.m_popup.add(this.m_documents).addActionListener(this);
        }
        if (reportCount > 0) {
            this.m_reports = new CMenuItem(Msg.getMsg(Env.getCtx(), "ArchivedReports") + " (" + reportCount + ")");
            this.m_popup.add(this.m_reports).addActionListener(this);
        }
        if ((allReports = DB.getSQLValue(null, sql1 = "SELECT COUNT(*) FROM AD_Archive WHERE AD_Table_ID=? AND IsReport='Y'", this.m_AD_Table_ID)) > 0) {
            this.m_reportsAll = new CMenuItem(Msg.getMsg(Env.getCtx(), "ArchivedReportsAll") + " (" + reportCount + ")");
            this.m_popup.add(this.m_reportsAll).addActionListener(this);
        }
        if (documentCount == 0 && reportCount == 0 && allReports == 0) {
            this.m_popup.add(Msg.getMsg(Env.getCtx(), "ArchivedNone"));
        }
        if (invoker.isShowing()) {
            this.m_popup.show(invoker, 0, invoker.getHeight());
        }
    }

    public void actionPerformed(ActionEvent e) {
        int AD_Form_ID = 118;
        FormFrame ff = new FormFrame();
        ff.openForm(AD_Form_ID);
        ArchiveViewer av = (ArchiveViewer)ff.getFormPanel();
        if (e.getSource() == this.m_documents) {
            av.query(false, this.m_AD_Table_ID, this.m_Record_ID);
        } else if (e.getSource() == this.m_reports) {
            av.query(true, this.m_AD_Table_ID, this.m_Record_ID);
        } else {
            av.query(true, this.m_AD_Table_ID, 0);
        }
        AEnv.addToWindowManager(ff);
        ff.pack();
        AEnv.showCenterScreen(ff);
        ff = null;
    }
}

