/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.plaf;

import com.jgoodies.looks.plastic.PlasticTheme;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalTheme;
import org.adempiere.plaf.AdempiereLookAndFeel;
import org.compiere.plaf.CompiereLookAndFeel;
import org.compiere.swing.CButton;
import org.compiere.swing.ColorBlind;
import org.compiere.swing.ExtendedTheme;
import org.compiere.util.Ini;
import org.compiere.util.ValueNamePair;

public final class AdempierePLAF {
    private static Logger log = Logger.getLogger(AdempierePLAF.class.getName());
    private static ValueNamePair[] s_looks = null;
    private static ValueNamePair s_defaultPLAF = null;
    private static ValueNamePair[] s_metalThemes = null;
    private static ValueNamePair[] s_plasticThemes = null;
    private static ValueNamePair s_vp_compiereTheme = null;
    private static ValueNamePair s_vp_metalTheme = null;
    private static ValueNamePair s_vp_adempiereTheme = null;
    static ResourceBundle s_res;

    public static Color getFieldBackground_Normal() {
        return ColorBlind.getDichromatColor(UIManager.getColor("text"));
    }

    public static Color getFieldBackground_Error() {
        Color c = UIManager.getColor("TextField.errorBackground");
        if (c == null) {
            c = ExtendedTheme.DEFAULT_ERROR_BG;
        }
        return ColorBlind.getDichromatColor(c);
    }

    public static Color getFieldBackground_Mandatory() {
        Color c = UIManager.getColor("TextField.mandatoryBackground");
        if (c == null) {
            c = ExtendedTheme.DEFAULT_MANDATORY_BG;
        }
        return ColorBlind.getDichromatColor(c);
    }

    public static Color getFieldBackground_Inactive() {
        Color c = UIManager.getColor("TextField.inactiveBackground");
        if (c != null) {
            return ColorBlind.getDichromatColor(c);
        }
        return AdempierePLAF.getFieldBackground_Normal();
    }

    public static Color getFormBackground() {
        return ColorBlind.getDichromatColor(UIManager.getColor("control"));
    }

    public static Color getInfoBackground() {
        Color c = UIManager.getColor("Info.background");
        if (c == null) {
            c = UIManager.getColor("info");
        }
        return ColorBlind.getDichromatColor(c);
    }

    public static Color getTextColor_Normal() {
        return ColorBlind.getDichromatColor(UIManager.getColor("textText"));
    }

    public static Color getTextColor_OK() {
        return AdempierePLAF.getTextColor_Normal();
    }

    public static Color getTextColor_Issue() {
        Color c = UIManager.getColor("TextField.errorForeground");
        if (c == null) {
            c = ExtendedTheme.DEFAULT_ERROR_FG;
        }
        return ColorBlind.getDichromatColor(c);
    }

    public static Color getTextColor_Label() {
        return ColorBlind.getDichromatColor(UIManager.getColor("controlText"));
    }

    public static Color getPrimary1() {
        return ColorBlind.getDichromatColor(MetalLookAndFeel.getCurrentTheme().getPrimaryControlDarkShadow());
    }

    public static Color getPrimary2() {
        return ColorBlind.getDichromatColor(MetalLookAndFeel.getCurrentTheme().getPrimaryControlShadow());
    }

    public static Color getPrimary3() {
        return ColorBlind.getDichromatColor(MetalLookAndFeel.getCurrentTheme().getPrimaryControl());
    }

    public static Color getSecondary1() {
        return ColorBlind.getDichromatColor(MetalLookAndFeel.getCurrentTheme().getControlDarkShadow());
    }

    public static Color getSecondary2() {
        return ColorBlind.getDichromatColor(MetalLookAndFeel.getCurrentTheme().getControlShadow());
    }

    public static Color getSecondary3() {
        return ColorBlind.getDichromatColor(MetalLookAndFeel.getCurrentTheme().getControl());
    }

    public static Font getFont_Header() {
        return MetalLookAndFeel.getWindowTitleFont();
    }

    public static Font getFont_Field() {
        return UIManager.getFont("TextField.font");
    }

    public static Font getFont_Label() {
        return UIManager.getFont("Label.font");
    }

    public static Font getFont_Small() {
        return MetalLookAndFeel.getSubTextFont();
    }

    public static ValueNamePair[] getPLAFs() {
        return s_looks;
    }

    public static ValueNamePair[] getThemes() {
        LookAndFeel l = UIManager.getLookAndFeel();
        if (l instanceof AdempiereLookAndFeel) {
            return s_plasticThemes;
        }
        if (l instanceof MetalLookAndFeel) {
            return s_metalThemes;
        }
        return new ValueNamePair[0];
    }

    public static void setPLAF() {
        int i;
        String look = Ini.getProperty("UILookFeel");
        String lookTheme = Ini.getProperty("UITheme");
        ValueNamePair plaf = null;
        for (int i2 = 0; i2 < s_looks.length; ++i2) {
            if (!s_looks[i2].getName().equals(look)) continue;
            plaf = s_looks[i2];
            break;
        }
        ValueNamePair theme = null;
        for (i = 0; i < s_metalThemes.length; ++i) {
            if (!s_metalThemes[i].getName().equals(lookTheme)) continue;
            theme = s_metalThemes[i];
            break;
        }
        if (theme == null) {
            for (i = 0; i < s_plasticThemes.length; ++i) {
                if (!s_plasticThemes[i].getName().equals(lookTheme)) continue;
                theme = s_plasticThemes[i];
                break;
            }
        }
        AdempierePLAF.setPLAF(plaf == null ? s_defaultPLAF : plaf, theme, true);
    }

    public static void setPLAF(ValueNamePair plaf, ValueNamePair theme, boolean updateIni) {
        if (plaf == null) {
            return;
        }
        log.config(plaf + (theme == null ? "" : " - " + theme));
        Class<?> lafClass = null;
        try {
            lafClass = Class.forName(plaf.getValue());
        }
        catch (Exception e) {
            log.severe(e.getMessage());
            return;
        }
        if (updateIni) {
            Ini.setProperty("UILookFeel", plaf.getName());
            Ini.setProperty("UITheme", "");
        }
        boolean metal = MetalLookAndFeel.class.isAssignableFrom(lafClass);
        boolean adempiere = AdempiereLookAndFeel.class.isAssignableFrom(lafClass);
        boolean compiere = CompiereLookAndFeel.class.isAssignableFrom(lafClass);
        if (theme == null && metal) {
            theme = compiere ? s_vp_compiereTheme : (adempiere ? s_vp_adempiereTheme : s_vp_metalTheme);
        }
        if (theme != null && metal && theme.getValue().length() > 0) {
            try {
                Class<?> c = Class.forName(theme.getValue());
                MetalTheme t = (MetalTheme)c.newInstance();
                if (compiere) {
                    CompiereLookAndFeel.setCurrentTheme(t);
                } else if (adempiere && t instanceof PlasticTheme) {
                    AdempiereLookAndFeel.setCurrentTheme((PlasticTheme)t);
                } else {
                    MetalLookAndFeel.setCurrentTheme(t);
                }
                if (updateIni) {
                    Ini.setProperty("UITheme", theme.getName());
                }
            }
            catch (Exception e) {
                log.severe("Theme - " + e.getMessage());
            }
        }
        try {
            UIManager.setLookAndFeel((LookAndFeel)lafClass.newInstance());
        }
        catch (Exception e) {
            log.severe(e.getMessage());
        }
        log.config(plaf + " - " + theme);
    }

    public static void updateUI(Window win) {
        if (win == null) {
            return;
        }
        Window c = win;
        do {
            SwingUtilities.updateComponentTreeUI(c);
            c.invalidate();
            c.pack();
            c.validate();
            c.repaint();
        } while ((c = c.getOwner()) != null);
    }

    public static void reset() {
        AdempierePLAF.setPLAF();
    }

    public static void printPLAFDefaults() {
        System.out.println(UIManager.getLookAndFeel());
        Object[] keys = UIManager.getLookAndFeelDefaults().keySet().toArray();
        Arrays.sort(keys);
        char lastStart = ' ';
        for (int i = 0; i < keys.length; ++i) {
            StringBuffer sb = new StringBuffer();
            sb.append(keys[i]).append(" = ").append(UIManager.get(keys[i]));
            if (keys[i].toString().charAt(0) != lastStart) {
                System.out.println();
                lastStart = keys[i].toString().charAt(0);
            }
            System.out.println(sb);
        }
    }

    public static boolean isActive() {
        return UIManager.getLookAndFeel() instanceof AdempiereLookAndFeel;
    }

    public static CButton getOKButton() {
        CButton b = new CButton();
        b.setIcon(new ImageIcon(AdempierePLAF.class.getResource("icons/Ok24.gif")));
        b.setMargin(new Insets(0, 10, 0, 10));
        b.setToolTipText(s_res.getString("OK"));
        return b;
    }

    public static CButton getCancelButton() {
        CButton b = new CButton();
        b.setIcon(new ImageIcon(AdempierePLAF.class.getResource("icons/Cancel24.gif")));
        b.setMargin(new Insets(0, 10, 0, 10));
        b.setToolTipText(s_res.getString("Cancel"));
        return b;
    }

    public static void showCenterScreen(Window window) {
        window.pack();
        Dimension sSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension wSize = window.getSize();
        window.setLocation((sSize.width - wSize.width) / 2, (sSize.height - wSize.height) / 2);
        window.toFront();
        window.setVisible(true);
    }

    public static void setCurrentMetalTheme(MetalLookAndFeel laf, MetalTheme theme) {
        if (laf instanceof CompiereLookAndFeel) {
            CompiereLookAndFeel.setCurrentTheme(theme);
        } else if (laf instanceof AdempiereLookAndFeel && theme instanceof PlasticTheme) {
            AdempiereLookAndFeel.setCurrentTheme((PlasticTheme)theme);
        } else {
            MetalLookAndFeel.setCurrentTheme(theme);
        }
    }

    public static void main(String[] args) {
        String jVersion = System.getProperty("java.version");
        if (!jVersion.startsWith("1.5")) {
            JOptionPane.showMessageDialog(null, "Require Java Version 1.5 or up - Not " + jVersion, "AdempierePLAF - Version Conflict", 0);
            System.exit(1);
        }
        Ini.loadProperties(true);
        AdempierePLAF.setPLAF();
        if (args.length == 0) {
            return;
        }
        String className = args[0];
        Class<?> startClass = null;
        try {
            startClass = Class.forName(className);
        }
        catch (Exception e) {
            log.severe("Did not find: " + className);
            e.printStackTrace();
            System.exit(1);
        }
        try {
            Method[] methods = startClass.getMethods();
            int i = 0;
            if (i < methods.length) {
                if (Modifier.isStatic(methods[i].getModifiers()) && methods[i].getName().equals("main")) {
                    String[] startArgs = new String[args.length - 1];
                    for (int ii = 1; ii < args.length; ++ii) {
                        startArgs[ii - i] = args[ii];
                    }
                    methods[i].invoke(null, new Object[]{startArgs});
                }
                return;
            }
        }
        catch (Exception ee) {
            log.severe("Problems invoking main");
            ee.printStackTrace();
        }
        try {
            startClass.newInstance();
        }
        catch (Exception e) {
            log.severe("Cannot start: " + className);
            e.printStackTrace();
            System.exit(1);
        }
    }

    static {
        ArrayList<ValueNamePair> plafList = new ArrayList<ValueNamePair>();
        ValueNamePair vp = null;
        ArrayList<ValueNamePair> metalThemes = new ArrayList<ValueNamePair>();
        ArrayList<ValueNamePair> plasticThemes = new ArrayList<ValueNamePair>();
        try {
            Class.forName("com.jgoodies.looks.plastic.Plastic3DLookAndFeel");
            vp = new ValueNamePair("org.adempiere.plaf.AdempiereLookAndFeel", "Adempiere");
            plafList.add(vp);
            s_vp_adempiereTheme = new ValueNamePair("org.adempiere.plaf.AdempiereTheme", "Adempiere Theme");
            plasticThemes.add(s_vp_adempiereTheme);
            List installedThemes = AdempiereLookAndFeel.getInstalledThemes();
            for (Object t : installedThemes) {
                MetalTheme theme = (MetalTheme)t;
                vp = new ValueNamePair(theme.getClass().getName(), theme.getName());
                plasticThemes.add(vp);
            }
        }
        catch (Exception e) {
            log.severe("Plastic look and feel not found");
        }
        vp = new ValueNamePair("org.compiere.plaf.CompiereLookAndFeel", "Compiere");
        plafList.add(vp);
        s_vp_compiereTheme = new ValueNamePair("org.compiere.plaf.CompiereThemeBlueMetal", "Compiere Theme");
        metalThemes.add(s_vp_compiereTheme);
        metalThemes.add(new ValueNamePair("org.compiere.plaf.CompiereThemeIce", "Compiere Ice"));
        s_vp_metalTheme = new ValueNamePair("javax.swing.plaf.metal.OceanTheme", "Ocean");
        metalThemes.add(s_vp_metalTheme);
        metalThemes.add(new ValueNamePair("javax.swing.plaf.metal.DefaultMetalTheme", "Steel"));
        metalThemes.add(new ValueNamePair("org.compiere.plaf.AquaTheme", "Aqua"));
        metalThemes.add(new ValueNamePair("org.compiere.plaf.CharcoalTheme", "Charcoal"));
        metalThemes.add(new ValueNamePair("org.compiere.plaf.ContrastTheme", "Contrast"));
        metalThemes.add(new ValueNamePair("org.compiere.plaf.EmeraldTheme", "Emerald"));
        metalThemes.add(new ValueNamePair("org.compiere.plaf.RubyTheme", "Ruby"));
        for (int i = 0; i < plafList.size(); ++i) {
            vp = (ValueNamePair)plafList.get(i);
            UIManager.installLookAndFeel(vp.getName(), vp.getValue());
        }
        plafList = new ArrayList();
        UIManager.LookAndFeelInfo[] lfInfo = UIManager.getInstalledLookAndFeels();
        for (int i = 0; i < lfInfo.length; ++i) {
            vp = new ValueNamePair(lfInfo[i].getClassName(), lfInfo[i].getName());
            plafList.add(vp);
            if (lfInfo[i].getName().equals("Adempiere")) {
                s_defaultPLAF = vp;
                log.finest(vp.getName() + " (default)");
                continue;
            }
            log.finest(vp.getName());
        }
        s_looks = new ValueNamePair[plafList.size()];
        plafList.toArray(s_looks);
        s_metalThemes = new ValueNamePair[metalThemes.size()];
        metalThemes.toArray(s_metalThemes);
        s_plasticThemes = new ValueNamePair[plasticThemes.size()];
        plasticThemes.toArray(s_plasticThemes);
        s_res = ResourceBundle.getBundle("org.compiere.plaf.PlafRes");
    }
}

