/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.util.logging.Level;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.compiere.Adempiere;
import org.compiere.db.CConnection;
import org.compiere.util.CLogMgt;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Ini;
import org.xml.sax.helpers.DefaultHandler;

public class PackIn {
    private CLogger log = CLogger.getCLogger("PackIn");
    public static String m_UpdateMode = "false";
    public static String m_Database = "Oracle";

    public String importXML(String fileName) {
        this.log.info("importXML:" + fileName);
        File in = new File(fileName);
        if (!in.exists()) {
            String msg = "File does not exist: " + fileName;
            this.log.info("importXML:" + msg);
            return msg;
        }
        try {
            this.log.info("starting");
            System.setProperty("javax.xml.parsers.SAXParserFactory", "org.apache.xerces.jaxp.SAXParserFactoryImpl");
            PackInHandler handler = new PackInHandler();
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser parser = factory.newSAXParser();
            String msg = "Start Parser";
            this.log.info(msg);
            parser.parse(in, (DefaultHandler)handler);
            msg = "End Parser";
            this.log.info(msg);
            return "OK.";
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "importXML:", e);
            return e.toString();
        }
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("Please give the file name to read as first parameter.");
            System.exit(1);
        }
        String file = args[0];
        Adempiere.startup(true);
        if (args.length > 8 && args[8].equals("AdempiereSys")) {
            System.out.println("**** WARNING: Working with system sequences AdempiereSys ****");
            Ini.setProperty("AdempiereSys", true);
        }
        PackIn impXML = new PackIn();
        if (args.length >= 6) {
            CConnection cc = CConnection.get();
            m_Database = cc.getType();
            DB.setDBTarget(cc);
        }
        Level logLevel = Level.FINER;
        switch (Integer.parseInt(args[6])) {
            case 1: {
                logLevel = Level.OFF;
                break;
            }
            case 2: {
                logLevel = Level.SEVERE;
                break;
            }
            case 3: {
                logLevel = Level.WARNING;
                break;
            }
            case 4: {
                logLevel = Level.INFO;
                break;
            }
            case 5: {
                logLevel = Level.CONFIG;
                break;
            }
            case 6: {
                logLevel = Level.FINE;
                break;
            }
            case 7: {
                logLevel = Level.FINER;
                break;
            }
            case 8: {
                logLevel = Level.FINEST;
                break;
            }
            case 9: {
                logLevel = Level.ALL;
            }
        }
        CLogMgt.setLevel(logLevel);
        CLogMgt.setLoggerLevel(logLevel, null);
        m_UpdateMode = args[7];
        impXML.importXML(file);
        System.exit(0);
    }
}

