/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.utils.repositories;

import java.io.Serializable;
import org.jpedal.utils.repositories.BaseVector;

public class Vector_Short
extends BaseVector
implements Serializable {
    private short[] items;

    public Vector_Short() {
        this.items = new short[this.max_size];
    }

    public Vector_Short(int n) {
        this.items = new short[this.max_size];
        this.max_size = n;
        this.items = new short[this.max_size];
    }

    public final short elementAt(int n) {
        if (n >= this.max_size) {
            this.checkSize(n);
        }
        return this.items[n];
    }

    public final short[] get() {
        return this.items;
    }

    public final void setElementAt(short s, int n) {
        if (n >= this.max_size) {
            this.checkSize(n);
        }
        this.items[n] = s;
    }

    public final void set(short[] sArray) {
        this.items = sArray;
    }

    public final void keep_larger(short s, short s2) {
        if (this.items[s] < this.items[s2]) {
            this.items[s] = this.items[s2];
        }
    }

    public final void keep_smaller(short s, short s2) {
        if (this.items[s] > this.items[s2]) {
            this.items[s] = this.items[s2];
        }
    }

    public final void clear() {
        if (this.current_item > 0) {
            for (int i = 0; i < this.current_item; ++i) {
                this.items[i] = 0;
            }
        } else {
            for (int i = 0; i < this.max_size; ++i) {
                this.items[i] = 0;
            }
        }
        this.current_item = 0;
    }

    public final int size() {
        return this.current_item + 1;
    }

    public final void removeElementAt(int n) {
        if (n >= 0) {
            for (int i = n; i < this.current_item - 1; ++i) {
                this.items[i] = this.items[i + 1];
            }
            this.items[this.current_item - 1] = 0;
        } else {
            this.items[0] = 0;
        }
        --this.current_item;
    }

    public final boolean contains(short s) {
        boolean bl = false;
        for (int i = 0; i < this.current_item; ++i) {
            if (this.items[i] != s) continue;
            i = this.current_item + 1;
            bl = true;
        }
        return bl;
    }

    public final short pull() {
        if (this.current_item > 0) {
            --this.current_item;
        }
        return this.items[this.current_item];
    }

    public final void push(short s) {
        this.checkSize(this.current_item);
        this.items[this.current_item] = s;
        ++this.current_item;
    }

    public final void addElement(short s) {
        this.checkSize(this.current_item);
        this.items[this.current_item] = s;
        ++this.current_item;
    }

    public final void add_together(short s, short s2) {
        this.items[s] = (short)(this.items[s] + this.items[s2]);
    }

    private final void checkSize(int n) {
        if (n >= this.max_size) {
            int n2 = this.max_size;
            this.max_size += this.increment_size;
            if (this.max_size <= n) {
                this.max_size = n + this.increment_size + 2;
            }
            short[] sArray = this.items;
            this.items = new short[this.max_size];
            System.arraycopy(sArray, 0, this.items, 0, n2);
            this.increment_size = this.incrementSize(this.increment_size);
        }
    }
}

