/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.utils.repositories;

import java.io.Serializable;
import org.jpedal.utils.repositories.BaseVector;

public class Vector_Double
extends BaseVector
implements Serializable {
    private double[] items;

    public Vector_Double() {
        this.items = new double[this.max_size];
    }

    public Vector_Double(int n) {
        this.items = new double[this.max_size];
        this.max_size = n;
        this.items = new double[this.max_size];
    }

    public final double[] get() {
        return this.items;
    }

    public final void removeElementAt(int n) {
        if (n >= 0) {
            for (int i = n; i < this.current_item - 1; ++i) {
                this.items[i] = this.items[i + 1];
            }
            this.items[this.current_item - 1] = 0.0;
        } else {
            this.items[0] = 0.0;
        }
        --this.current_item;
    }

    public final boolean contains(int n) {
        boolean bl = false;
        for (int i = 0; i < this.current_item; ++i) {
            if (this.items[i] != (double)n) continue;
            i = this.current_item + 1;
            bl = true;
        }
        return bl;
    }

    public final void addElement(double d) {
        this.checkSize(this.current_item);
        this.items[this.current_item] = d;
        ++this.current_item;
    }

    public final void set(double[] dArray) {
        this.items = dArray;
    }

    public final double elementAt(int n) {
        if (n >= this.max_size) {
            this.checkSize(n);
        }
        return this.items[n];
    }

    public final void clear() {
        if (this.current_item > 0) {
            for (int i = 0; i < this.current_item; ++i) {
                this.items[i] = 0.0;
            }
        } else {
            for (int i = 0; i < this.max_size; ++i) {
                this.items[i] = 0.0;
            }
        }
        this.current_item = 0;
    }

    public final double pull() {
        if (this.current_item > 0) {
            --this.current_item;
        }
        return this.items[this.current_item];
    }

    public final void push(double d) {
        this.checkSize(this.current_item);
        this.items[this.current_item] = d;
        ++this.current_item;
    }

    public final int size() {
        return this.current_item + 1;
    }

    public final void setElementAt(double d, int n) {
        if (n >= this.max_size) {
            this.checkSize(n);
        }
        this.items[n] = d;
    }

    private final void checkSize(int n) {
        if (n >= this.max_size) {
            int n2 = this.max_size;
            this.max_size += this.increment_size;
            if (this.max_size <= n) {
                this.max_size = n + this.increment_size + 2;
            }
            double[] dArray = this.items;
            this.items = new double[this.max_size];
            System.arraycopy(dArray, 0, this.items, 0, n2);
            this.increment_size = this.incrementSize(this.increment_size);
        }
    }
}

