/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects;

import java.util.StringTokenizer;
import org.jpedal.utils.Strip;
import org.jpedal.utils.repositories.Vector_Int;
import org.jpedal.utils.repositories.Vector_String;

public class PdfPageData {
    private static final String SEPARATOR = "|";
    private static final String ROTATION_SEPARATOR = "/";
    private final boolean debug = false;
    private Vector_Int rotationXX;
    private Vector_String mediaString;
    private Vector_String cropString;
    private Vector_Int mediaBoxWidths;
    private Vector_Int mediaBoxHeights;
    private Vector_Int mediaBoxXs;
    private Vector_Int mediaBoxYs;
    private Vector_Int cropBoxWidths;
    private Vector_Int cropBoxHeights;
    private Vector_Int cropBoxXs;
    private Vector_Int cropBoxYs;
    private int lastPage = -1;
    private int raw_rotation = 0;
    private int pagesRead = -1;
    private String defaultMediaValue = null;
    private int rotation = 0;
    private Vector_String rawValues = new Vector_String(500);
    private int cropBoxX = -99999;
    private int cropBoxY = -1;
    private int cropBoxW = -1;
    private int cropBoxH = -1;
    private int mediaBoxX = -1;
    private int mediaBoxY;
    private int mediaBoxW;
    private int mediaBoxH;
    private String cropValue = "";
    private String mediaValue = "";

    public void checkSizeSet(int n) {
        StringBuffer stringBuffer;
        if (this.mediaValue == null) {
            this.mediaValue = this.defaultMediaValue;
        }
        if (this.raw_rotation != 0) {
            stringBuffer = new StringBuffer("" + this.raw_rotation);
            stringBuffer.append(ROTATION_SEPARATOR);
            int n2 = this.mediaValue.lastIndexOf(ROTATION_SEPARATOR);
            if (n2 == -1) {
                stringBuffer.append(this.mediaValue);
            } else {
                stringBuffer.append(this.mediaValue.substring(n2 + 1));
            }
            this.mediaValue = stringBuffer.toString();
        }
        if (this.cropValue != null && !this.mediaValue.equals(this.cropValue)) {
            stringBuffer = new StringBuffer(this.mediaValue);
            stringBuffer.append(SEPARATOR);
            stringBuffer.append(this.cropValue);
            this.rawValues.setElementAt(stringBuffer.toString(), n);
        } else if (this.mediaValue != null && this.mediaValue.equals(this.defaultMediaValue)) {
            this.rawValues.setElementAt(null, n);
        } else {
            this.rawValues.setElementAt(this.mediaValue, n);
        }
        if (this.pagesRead < n) {
            this.pagesRead = n;
        }
        this.mediaValue = null;
        this.cropValue = null;
    }

    public final int getMediaBoxHeight(int n) {
        this.setSizeForPage(n);
        return this.mediaBoxH;
    }

    public final int getRotation(int n) {
        this.setSizeForPage(n);
        return this.rotation;
    }

    public final int getMediaBoxY(int n) {
        this.setSizeForPage(n);
        return this.mediaBoxY;
    }

    public final int getMediaBoxX(int n) {
        this.setSizeForPage(n);
        return this.mediaBoxX;
    }

    public void setMediaBox(String string) {
        this.mediaValue = Strip.removeArrayDeleminators(string);
        this.cropValue = null;
        if (this.defaultMediaValue == null) {
            this.defaultMediaValue = this.mediaValue;
        }
    }

    public void setCropBox(String string) {
        this.cropValue = Strip.removeArrayDeleminators(string);
    }

    public int setPageRotation(String string, int n) {
        this.raw_rotation = Integer.parseInt(string);
        if (this.raw_rotation < 0) {
            this.raw_rotation = 360 + this.raw_rotation;
        }
        return this.raw_rotation;
    }

    public final int getMediaBoxWidth(int n) {
        this.setSizeForPage(n);
        return this.mediaBoxW;
    }

    public String getMediaValue(int n) {
        int n2;
        int n3;
        String string = this.rawValues.elementAt(n);
        if (string.length() == 0) {
            string = this.defaultMediaValue;
        }
        if ((n3 = string.indexOf(ROTATION_SEPARATOR)) != -1) {
            string = string.substring(n3 + 1);
        }
        if ((n2 = string.indexOf(SEPARATOR)) == -1) {
            return string;
        }
        return string.substring(0, n2);
    }

    public String getCropValue(int n) {
        int n2;
        int n3;
        String string = this.rawValues.elementAt(n);
        if (string.length() == 0) {
            string = this.defaultMediaValue;
        }
        if ((n3 = string.indexOf(ROTATION_SEPARATOR)) != -1) {
            string = string.substring(n3 + 1);
        }
        if ((n2 = string.indexOf(SEPARATOR)) == -1) {
            return string;
        }
        return string.substring(n2 + 1);
    }

    public int getCropBoxX(int n) {
        this.setSizeForPage(n);
        return this.cropBoxX;
    }

    public int getCropBoxWidth(int n) {
        this.setSizeForPage(n);
        return this.cropBoxW;
    }

    public int getCropBoxY(int n) {
        this.setSizeForPage(n);
        return this.cropBoxY;
    }

    public int getCropBoxHeight(int n) {
        this.setSizeForPage(n);
        return this.cropBoxH;
    }

    private void setSizeForPage(int n) {
        if (n > this.pagesRead) {
            this.mediaBoxX = 0;
            this.mediaBoxY = 0;
            this.mediaBoxW = 0;
            this.mediaBoxH = 0;
            this.cropBoxX = 0;
            this.cropBoxY = 0;
            this.cropBoxW = 0;
            this.cropBoxH = 0;
        } else if (n > 0 && this.lastPage != n) {
            int n2;
            int n3;
            this.lastPage = n;
            this.rotation = 0;
            String string = this.rawValues.elementAt(n);
            if (string.length() == 0 && this.defaultMediaValue != null) {
                string = this.defaultMediaValue;
            }
            if ((n3 = string.indexOf(ROTATION_SEPARATOR)) != -1) {
                String string2 = string.substring(0, n3);
                this.rotation = Integer.parseInt(string2);
                string = string.substring(n3 + 1);
            }
            StringTokenizer stringTokenizer = (n2 = string.indexOf(SEPARATOR)) == -1 ? new StringTokenizer(string, " ") : new StringTokenizer(string.substring(0, n2), " ");
            this.mediaBoxX = 0;
            this.mediaBoxY = 0;
            this.mediaBoxW = 800;
            this.mediaBoxH = 800;
            if (stringTokenizer.countTokens() == 4) {
                this.mediaBoxX = (int)Float.parseFloat(stringTokenizer.nextToken());
                this.mediaBoxY = (int)Float.parseFloat(stringTokenizer.nextToken());
                this.mediaBoxW = (int)Float.parseFloat(stringTokenizer.nextToken()) - this.mediaBoxX;
                this.mediaBoxH = (int)Float.parseFloat(stringTokenizer.nextToken()) - this.mediaBoxY;
            }
            if (n2 != -1) {
                stringTokenizer = new StringTokenizer(string.substring(n2 + 1), " ");
                this.cropBoxX = (int)Float.parseFloat(stringTokenizer.nextToken());
                this.cropBoxY = (int)Float.parseFloat(stringTokenizer.nextToken());
                this.cropBoxW = (int)Float.parseFloat(stringTokenizer.nextToken()) - this.cropBoxX;
                this.cropBoxH = (int)Float.parseFloat(stringTokenizer.nextToken()) - this.cropBoxY;
            } else {
                this.cropBoxX = this.mediaBoxX;
                this.cropBoxY = this.mediaBoxY;
                this.cropBoxW = this.mediaBoxW;
                this.cropBoxH = this.mediaBoxH;
            }
        }
    }
}

