/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.jpedal.exception.PdfException;
import org.jpedal.utils.Strip;
import org.w3c.dom.Document;

public class PdfFormData {
    private List formObjects = new Vector();
    public static final int XFA_TEMPLATE = 0;
    public static final int XFA_DATASET = 1;
    public static final int XFA_CONFIG = 2;
    private StringBuffer xfaTemplate = null;
    private StringBuffer xfaDataset = null;
    private StringBuffer xfaConfig = null;
    private int formCount = 0;
    private int totalCount = 0;
    private boolean isDemo = false;
    private static boolean failed;

    public PdfFormData(boolean bl) {
        this.isDemo = bl;
    }

    public boolean hasXFAFormData() {
        return false;
    }

    public Document getXFAFormData(int n) throws PdfException {
        if (n == 0) {
            return null;
        }
        if (n == 1) {
            return null;
        }
        if (n == 2) {
            return null;
        }
        throw new PdfException("Unknown type for XFA");
    }

    public void setXFAFormData(int n, StringBuffer stringBuffer) throws PdfException {
        if (n == 0) {
            this.xfaTemplate = stringBuffer;
        } else if (n == 1) {
            this.xfaDataset = stringBuffer;
        } else if (n == 2) {
            this.xfaConfig = stringBuffer;
        } else {
            throw new PdfException("Unknown type for XFA");
        }
    }

    public void addFormElement(Map map) {
        String string;
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            Object v = map.get(k);
            if (!(v instanceof String) || (string = (String)v) == null) continue;
            if (string.startsWith("/")) {
                string = string.substring(1);
            }
            map.put(k, string);
        }
        string = (String)map.get("Rect");
        if (string != null) {
            map.put("Rect", Strip.removeArrayDeleminators(string));
        }
        this.formObjects.add(this.formCount, map);
        ++this.formCount;
    }

    private String makeDemo(String string) {
        if (this.isDemo & string != null) {
            StringBuffer stringBuffer = new StringBuffer(string);
            int n = stringBuffer.length();
            for (int i = 0; i < n; i += 4) {
                stringBuffer.replace(i, i + 1, "1");
            }
            string = stringBuffer.toString();
        }
        return string;
    }

    public final List getFormData() {
        return this.formObjects;
    }

    public void incrementCount(int n) {
        this.totalCount += n;
    }

    public int getTotalCount() {
        return this.totalCount;
    }
}

