/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects;

import java.awt.BasicStroke;
import java.awt.Stroke;
import java.awt.geom.Area;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.jpedal.color.PdfColor;
import org.jpedal.color.PdfPaint;
import org.jpedal.io.PdfObjectReader;

public class GraphicsState
implements Cloneable {
    public float x;
    public float y;
    private float strokeAlpha = -1.0f;
    private float nonstrokeAlpha = -1.0f;
    private boolean op = false;
    private boolean OP = false;
    PdfPaint nonstrokeColor = new PdfColor(0, 0, 0);
    PdfPaint strokeColor = new PdfColor(0, 0, 0);
    private Area current_clipping_shape = null;
    public float[][] CTM = new float[3][3];
    private Map gs_state = new Hashtable();
    private int current_line_dash_phase = 0;
    private Area TRmask = null;
    private int fill_type;
    private int mitre_limit = 0;
    private float[] current_line_dash_array = new float[0];
    private int current_line_cap_style = 0;
    private float current_line_width = 1.0f;
    private int current_line_join_style = 0;
    private int text_render_type = 2;
    int minX = 0;
    int minY = 0;
    public static final int FILL = 2;
    public static final int FILLSTROKE = 3;
    public static final int STROKE = 1;
    public static final int INVISIBLE = 4;
    public static final int CLIPTEXT = 7;

    public GraphicsState() {
        this.resetCTM();
    }

    public GraphicsState(int n, int n2) {
        this.minX = -n;
        this.minY = -n2;
        this.resetCTM();
    }

    public float getStrokeAlpha() {
        return this.strokeAlpha;
    }

    public float getNonStrokeAlpha() {
        return this.nonstrokeAlpha;
    }

    public boolean getStrokeOP() {
        return this.OP;
    }

    public boolean getNonStrokeOP() {
        return this.op;
    }

    public void readGraphicsState(Map map, PdfObjectReader pdfObjectReader) {
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = (String)map.get(string);
            Map map2 = pdfObjectReader.readObject(string2, false, null);
            this.gs_state.put("/" + string, map2);
        }
    }

    public final void setTextRenderType(int n) {
        this.text_render_type = n;
        this.TRmask = null;
    }

    public final int getTextRenderType() {
        return this.text_render_type;
    }

    public final void setMitreLimit(int n) {
        this.mitre_limit = n;
    }

    public final float getLineWidth() {
        return this.current_line_width;
    }

    public final void setFillType(int n) {
        this.fill_type = n;
    }

    public final void updateClip(Area area) {
        if (this.current_clipping_shape == null) {
            this.current_clipping_shape = area;
        } else {
            this.current_clipping_shape.intersect(area);
            if (this.current_clipping_shape.getBounds().getHeight() == 0.0) {
                this.current_clipping_shape = area;
            }
        }
    }

    public final void addClip(Area area) {
        if (this.TRmask == null) {
            this.TRmask = area;
        } else {
            this.TRmask.add(area);
        }
    }

    public final Stroke getStroke() {
        float f = this.current_line_width;
        if (this.CTM[0][0] != 0.0f) {
            f *= this.CTM[0][0];
        } else if (this.CTM[0][1] != 0.0f) {
            f *= this.CTM[0][1];
        }
        if (f < 0.0f) {
            f = -f;
        }
        if (this.mitre_limit < 1) {
            this.mitre_limit = 1;
        }
        BasicStroke basicStroke = this.current_line_dash_array.length > 0 ? new BasicStroke(f, this.current_line_cap_style, this.current_line_join_style, this.mitre_limit, this.current_line_dash_array, this.current_line_dash_phase) : new BasicStroke(f, this.current_line_cap_style, this.current_line_join_style, this.mitre_limit);
        return basicStroke;
    }

    public final void setLineWidth(float f) {
        this.current_line_width = f;
    }

    public final Area getClippingShape() {
        if (this.TRmask != null) {
            this.TRmask.intersect(this.current_clipping_shape);
            return this.TRmask;
        }
        return this.current_clipping_shape;
    }

    public void setMode(String string) {
        Map map = (Map)this.gs_state.get(string);
        this.strokeAlpha = -1.0f;
        this.nonstrokeAlpha = -1.0f;
        this.op = false;
        this.OP = false;
        String string2 = (String)map.get("CA");
        if (string2 != null) {
            this.strokeAlpha = Float.parseFloat(string2);
        }
        if ((string2 = (String)map.get("ca")) != null) {
            this.nonstrokeAlpha = Float.parseFloat(string2);
        }
        if ((string2 = (String)map.get("OP")) != null) {
            this.OP = Boolean.valueOf(string2);
        }
        this.op = (string2 = (String)map.get("op")) == null ? this.OP : Boolean.valueOf(string2);
    }

    public final void setCapStyle(int n) {
        this.current_line_cap_style = n;
    }

    public final void setJoinStyle(int n) {
        this.current_line_join_style = n;
    }

    public final void checkWholePageClip(int n) {
        if (this.current_clipping_shape != null && this.current_clipping_shape.getBounds().getHeight() >= (double)n) {
            this.current_clipping_shape = null;
        }
    }

    public final void setDashArray(float[] fArray) {
        this.current_line_dash_array = fArray;
    }

    public final Object clone() {
        Object object = null;
        try {
            object = super.clone();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return object;
    }

    public final void resetCTM() {
        this.CTM[0][0] = 1.0f;
        this.CTM[1][0] = 0.0f;
        this.CTM[2][0] = this.minX;
        this.CTM[0][1] = 0.0f;
        this.CTM[1][1] = 1.0f;
        this.CTM[2][1] = this.minY;
        this.CTM[0][2] = 0.0f;
        this.CTM[1][2] = 0.0f;
        this.CTM[2][2] = 1.0f;
    }

    public final void setDashPhase(int n) {
        this.current_line_dash_phase = n;
    }

    public final int getFillType() {
        return this.fill_type;
    }

    public final void setClippingShape(Area area) {
        this.current_clipping_shape = area;
    }

    public PdfPaint getNonstrokeColor() {
        return this.nonstrokeColor;
    }

    public void setNonstrokeColor(PdfPaint pdfPaint) {
        this.nonstrokeColor = pdfPaint;
    }

    public PdfPaint getStrokeColor() {
        return this.strokeColor;
    }

    public void setStrokeColor(PdfPaint pdfPaint) {
        this.strokeColor = pdfPaint;
    }
}

