/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.MessageDigest;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.jpedal.exception.PdfException;
import org.jpedal.exception.PdfSecurityException;
import org.jpedal.fonts.StandardFonts;
import org.jpedal.io.PdfFilteredReader;
import org.jpedal.io.SetSecurity;
import org.jpedal.io.TextTokens;
import org.jpedal.objects.PageLookup;
import org.jpedal.objects.PdfFileInformation;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Sorts;
import org.jpedal.utils.Strip;
import org.jpedal.utils.repositories.Vector_Int;

public class PdfObjectReader
extends PdfFilteredReader {
    private byte[] lastCompressedStream = null;
    private Map fields = new HashMap();
    private Vector_Int xref = new Vector_Int(100);
    private Map lastOffsetStart;
    private Map lastOffsetEnd;
    private int lastFirst;
    private Map objData = null;
    private Map nameLookup = new HashMap();
    private String lastRef = "";
    PdfFileInformation currentFileInformation = new PdfFileInformation();
    private boolean extractionIsAllowed = true;
    private static final byte[] endPattern = new byte[]{101, 110, 100, 111, 98, 106};
    private boolean isEncrypted = false;
    private boolean isInitialised = false;
    private byte[] encryptionPassword = new byte[0];
    private String infoObject = null;
    private byte[] encryptionKey = null;
    private boolean isFileViewable = true;
    private int rev = 0;
    private int keyLength = 5;
    private int P = 0;
    private byte[] O = new byte[0];
    private byte[] U = new byte[0];
    private String ID = "";
    private boolean isPasswordSupplied = false;
    private Cipher cipher = null;
    private String[] padding = new String[]{"28", "BF", "4E", "5E", "4E", "75", "8A", "41", "64", "00", "4E", "56", "FF", "FA", "01", "08", "2E", "2E", "00", "B6", "D0", "68", "3E", "80", "2F", "0C", "A9", "FE", "64", "53", "69", "7A"};
    private int[] ObjLengthTable;
    private boolean refTableInvalid = false;
    private final boolean testOp = false;
    private int miniumumCacheSize;
    private static final int[] powers = new int[]{1, 10, 100, 1000, 10000, 100000, 1000000, 10000000, 100000000, 1000000000};

    public PdfObjectReader() {
        this.fields.put("T", "x");
        this.fields.put("TM", "x");
        this.fields.put("TU", "x");
        this.fields.put("CA", "x");
        this.fields.put("R", "x");
        this.fields.put("V", "x");
        this.fields.put("RC", "x");
        this.fields.put("DA", "x");
        this.fields.put("DV", "x");
        this.fields.put("Contents", "x");
    }

    public final int readFirstStartRef() throws PdfException {
        int n;
        this.refTableInvalid = false;
        int n2 = -1;
        int n3 = 1019;
        StringBuffer stringBuffer = new StringBuffer();
        byte[] byArray = new byte[1024];
        try {
            n = (int)(this.pdf_datafile.length() - 1024L);
            if (n < 0) {
                n = 0;
                byArray = new byte[(int)this.pdf_datafile.length()];
            }
            this.movePointer(n);
            this.pdf_datafile.read(byArray);
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " reading last 1024 bytes");
            throw new PdfException(exception + " reading last 1024 bytes");
        }
        n = byArray.length;
        if (n3 > n) {
            n3 = n - 5;
        }
        while (n3 > -1 && (byArray[n3] != 116 || byArray[n3 + 1] != 120 || byArray[n3 + 2] != 114 || byArray[n3 + 3] != 101 || byArray[n3 + 4] != 102)) {
            --n3;
        }
        if (n3 == -1) {
            try {
                this.pdf_datafile.close();
            }
            catch (IOException iOException) {
                LogWriter.writeLog("Exception " + iOException + " closing file");
            }
            throw new PdfException("No Startref found in last 1024 bytes!!");
        }
        n3 += 5;
        while (n3 < 1024 && byArray[n3] == 10 | byArray[n3] == 32 | byArray[n3] == 13) {
            ++n3;
        }
        while (n3 < 1024 && byArray[n3] != 10 && byArray[n3] != 32 && byArray[n3] != 13) {
            stringBuffer.append((char)byArray[n3]);
            ++n3;
        }
        if (stringBuffer.length() > 0) {
            n2 = Integer.parseInt(stringBuffer.toString());
        }
        if (n2 == -1) {
            LogWriter.writeLog("No Startref found in last 1024 bytes!!");
            try {
                this.pdf_datafile.close();
            }
            catch (IOException iOException) {
                LogWriter.writeLog("Exception " + iOException + " closing file");
            }
            throw new PdfException("No Startref found in last 1024 bytes!!");
        }
        return n2;
    }

    public void setEncryptionPassword(String string) {
        this.encryptionPassword = string.getBytes();
    }

    public static Map directValuesToMap(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        int n = string.indexOf("<<");
        int n2 = string.indexOf(">>");
        String string2 = string.substring(n + 2, n2).trim();
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "/");
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            int n3 = string3.indexOf(" ");
            String string4 = "/" + string3.substring(0, n3);
            String string5 = string3.substring(n3 + 1);
            hashMap.put(string4, string5);
        }
        return hashMap;
    }

    public Object resolveToMapOrString(String string, Object object) {
        if (this.fields != null && this.fields.get(string) != null && object instanceof byte[]) {
            byte[] byArray = this.getByteTextStringValue(object, this.fields);
            object = this.getTextString(byArray);
        } else if (object instanceof String && ((String)object).endsWith(" R")) {
            Object object2 = this.getObjectValue(object);
            if (object2 instanceof Map) {
                Map map = (Map)object2;
                byte[] byArray = this.readStream((String)object);
                object = map;
            } else {
                object = object2;
            }
        }
        return object;
    }

    private byte[] readObjectData(int n) {
        int n2 = n + 1;
        long l = this.getPointer();
        if (l + (long)n > this.eof) {
            n = (int)(this.eof - l);
        }
        byte[] byArray = null;
        try {
            byArray = new byte[n + 6];
            this.pdf_datafile.read(byArray);
            int n3 = byArray.length;
            for (int i = n3 - 6; i > 5; --i) {
                if (byArray[i] != 101 || byArray[i + 1] != 110 || byArray[i + 2] != 100 || byArray[i + 3] != 111 || byArray[i + 4] != 98 || byArray[i + 5] != 106) continue;
                n2 = i + 5;
                i = 0;
            }
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, 0, byArray2, 0, n2);
            byArray = byArray2;
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " reading object");
        }
        return byArray;
    }

    private int readDictionary(String string, int n, Map map, int n2, byte[] byArray, boolean bl, Map map2) {
        boolean bl2 = false;
        Object var11_9 = null;
        StringBuffer stringBuffer = null;
        stringBuffer = new StringBuffer(20);
        while (!(++n2 >= byArray.length || byArray[n2] == 62 && byArray[n2 + 1] == 62 || byArray[n2] == 101 && byArray[n2 + 1] == 110 && byArray[n2 + 2] == 100 && byArray[n2 + 3] == 111)) {
            int n3;
            Object object;
            if (byArray[n2] == 60 && byArray[n2 + 1] == 60) {
                ++n2;
                object = new HashMap();
                map.put(stringBuffer.toString(), object);
                n2 = this.readDictionary(string, ++n, (Map)object, n2, byArray, bl, map2);
                stringBuffer = new StringBuffer(20);
                --n;
                if (byArray[n2] != 62 || byArray[n2 + 1] != 62) continue;
                ++n2;
                continue;
            }
            if (byArray[n2] == 47 && byArray[n2 + 1] == 47 && stringBuffer.length() == 0) {
                stringBuffer = new StringBuffer(32);
                ++n2;
                continue;
            }
            if (byArray[n2] == 47 & stringBuffer.length() == 0) {
                stringBuffer = new StringBuffer(20);
                ++n2;
                while (!(byArray[n2] == 32 | byArray[n2] == 13 | byArray[n2] == 10 | byArray[n2] == 91 | byArray[n2] == 47 | byArray[n2] == 40 | byArray[n2] == 60)) {
                    stringBuffer.append((char)byArray[n2]);
                    ++n2;
                }
                if (byArray[n2] == 32 && byArray[n2 - 1] == 47) {
                    stringBuffer.append(' ');
                }
                bl2 = map2 != null && stringBuffer.length() > 0 && map2.containsKey(stringBuffer.toString());
                if (!(byArray[n2] == 47 | byArray[n2] == 40 | byArray[n2] == 60 | byArray[n2] == 91)) continue;
                --n2;
                continue;
            }
            if (byArray[n2] == 32 | byArray[n2] == 13 | byArray[n2] == 10) continue;
            if (byArray[n2] == 60 && bl2) {
                Object object2;
                byte[] byArray2 = null;
                ByteArrayOutputStream byteArrayOutputStream = null;
                byteArrayOutputStream = new ByteArrayOutputStream();
                int n4 = 0;
                int n5 = ++n2;
                do {
                    n5 += 2;
                    ++n4;
                    while (byArray[n5] == 13 | byArray[n5] == 10) {
                        ++n5;
                    }
                } while (byArray[n5] != 62);
                byArray2 = new byte[n4];
                n4 = 0;
                do {
                    object2 = new StringBuffer(2);
                    for (n3 = 0; n3 < 2; ++n3) {
                        ((StringBuffer)object2).append((char)byArray[n2]);
                        ++n2;
                    }
                    byteArrayOutputStream.write(Integer.parseInt(((StringBuffer)object2).toString(), 16));
                    byArray2[n4] = (byte)Integer.parseInt(((StringBuffer)object2).toString(), 16);
                    ++n4;
                    while (byArray[n2] == 13 | byArray[n2] == 10) {
                        ++n2;
                    }
                } while (byArray[n2] != 62);
                try {
                    byteArrayOutputStream.close();
                    object2 = byteArrayOutputStream.toByteArray();
                    if (byArray2.length != ((Object)object2).length) {
                        System.out.println("Different lengths " + byArray2.length + " " + ((Object)object2).length);
                        System.exit(1);
                    }
                    for (n3 = 0; n3 < ((Object)object2).length; ++n3) {
                        if (object2[n3] == byArray2[n3]) continue;
                        System.out.println(n3 + " Different values " + (int)object2[n3] + " " + byArray2[n3]);
                        System.exit(1);
                    }
                    byArray2 = this.decrypt(byArray2, string, null, false);
                    map.put(stringBuffer.toString(), byArray2);
                }
                catch (Exception exception) {
                    LogWriter.writeLog("[PDF] Problem " + exception + " writing text string" + stringBuffer);
                    exception.printStackTrace();
                }
                stringBuffer = new StringBuffer(20);
                continue;
            }
            if (byArray[n2] == 40) {
                if (bl2) {
                    object = new ByteArrayOutputStream();
                    try {
                        if (byArray[n2 + 1] != 41) {
                            while (true) {
                                boolean bl3 = false;
                                if (byArray[++n2] == 92) {
                                    if (byArray[++n2] == 98) {
                                        byArray[n2] = 8;
                                    } else if (byArray[n2] == 110) {
                                        byArray[n2] = 10;
                                    } else if (byArray[n2] == 116) {
                                        byArray[n2] = 9;
                                    } else if (byArray[n2] == 114) {
                                        byArray[n2] = 13;
                                    } else if (byArray[n2] == 102) {
                                        byArray[n2] = 12;
                                    } else if (Character.isDigit((char)byArray[n2])) {
                                        StringBuffer stringBuffer2 = new StringBuffer(3);
                                        for (int i = 0; i < 3; ++i) {
                                            stringBuffer2.append((char)byArray[n2]);
                                            ++n2;
                                        }
                                        bl3 = true;
                                        byArray[--n2] = (byte)Integer.parseInt(stringBuffer2.toString(), 8);
                                    }
                                }
                                if (!bl3 && byArray[n2] == 41 && byArray[n2 - 1] != 92 | (byArray[n2 - 1] == 92 && byArray[n2 - 2] == 92)) break;
                                ((ByteArrayOutputStream)object).write(byArray[n2]);
                            }
                        }
                        ((ByteArrayOutputStream)object).close();
                        byte[] byArray3 = ((ByteArrayOutputStream)object).toByteArray();
                        byArray3 = this.decrypt(byArray3, string, null, false);
                        map.put(stringBuffer.toString(), byArray3);
                    }
                    catch (Exception exception) {
                        LogWriter.writeLog("[PDF] Problem " + exception + " handling text string" + stringBuffer);
                    }
                } else if (bl && stringBuffer.length() == 1 && stringBuffer.charAt(0) == 'U' | stringBuffer.charAt(0) == 'O') {
                    int n6 = 32;
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    do {
                        if (byArray[++n2] == 92) {
                            if (byArray[++n2] == 114) {
                                byArray[n2] = 13;
                            } else if (byArray[n2] == 110) {
                                byArray[n2] = 10;
                            } else if (byArray[n2] == 116) {
                                byArray[n2] = 9;
                            } else if (byArray[n2] == 102) {
                                byArray[n2] = 12;
                            } else if (byArray[n2] == 98) {
                                byArray[n2] = 8;
                            }
                        }
                        byteArrayOutputStream.write(byArray[n2]);
                    } while (--n6 != 0);
                    try {
                        byteArrayOutputStream.close();
                        map.put(stringBuffer.toString(), byteArrayOutputStream.toByteArray());
                    }
                    catch (Exception exception) {
                        LogWriter.writeLog("[PDF] Problem " + exception + " writing " + stringBuffer);
                    }
                } else {
                    int n7 = n2;
                    int n8 = 0;
                    boolean bl4 = false;
                    while (true) {
                        if (!bl4) {
                            ++n8;
                        }
                        if ((byArray[n2 - 1] != 92 || byArray[n2 - 2] == 92) && byArray[n2] == 41) break;
                        if (byArray[++n2] != 37 || byArray[n2 - 1] == 92) continue;
                        bl4 = true;
                    }
                    bl4 = false;
                    int n9 = 0;
                    char[] cArray = new char[n8];
                    while (true) {
                        if (!bl4) {
                            if (byArray[n7] == 13 | byArray[n7] == 10) {
                                cArray[n9] = 32;
                                ++n9;
                            } else {
                                cArray[n9] = (char)byArray[n7];
                                ++n9;
                            }
                        }
                        if (byArray[n7 - 1] == 92 & byArray[n7 - 2] == 92) {
                            byArray[n7 - 1] = 0;
                        }
                        if (byArray[n7 - 1] != 92 & byArray[n7] == 41) break;
                        if (byArray[++n7] != 37 || byArray[n7 - 1] == 92) continue;
                        bl4 = true;
                    }
                    String string2 = String.copyValueOf(cArray, 0, n8);
                    if (!string2.equals("null")) {
                        map.put(stringBuffer.toString(), string2);
                    }
                }
                stringBuffer = new StringBuffer(20);
                continue;
            }
            if (byArray[n2] == 91) {
                String string3;
                Object object3;
                int n10 = n2;
                int n11 = 0;
                boolean bl5 = false;
                boolean bl6 = false;
                int n12 = 0;
                int n13 = 0;
                n3 = 32;
                int n14 = 32;
                boolean bl7 = false;
                while (byArray[n2] == 32) {
                    ++n11;
                    ++n2;
                }
                while (true) {
                    if (byArray[n2] == 92) {
                        ++n2;
                    }
                    if (n11 > 7 && !bl7 && byArray[n2 - 7] == 47 && byArray[n2 - 6] == 73 && byArray[n2 - 5] == 110 && byArray[n2 - 4] == 100 && byArray[n2 - 3] == 101 && byArray[n2 - 2] == 120 && byArray[n2 - 1] == 101 && byArray[n2] == 100) {
                        bl7 = true;
                    }
                    if (byArray[n2] == 40 && byArray[n2 - 1] != 92 && bl7) {
                        bl6 = true;
                        n11 += 2;
                    } else if (bl6) {
                        if (byArray[n2] == 41 && byArray[n2 - 1] != 92) {
                            ++n11;
                            bl6 = false;
                        } else {
                            object3 = Integer.toHexString(byArray[n2] & 0xFF);
                            if (((String)object3).length() < 2) {
                                ++n11;
                            }
                            n11 += ((String)object3).length();
                        }
                    } else if (!bl5) {
                        if (byArray[n2] == 13 || byArray[n2] == 10) {
                            ++n11;
                        } else {
                            n3 = (char)byArray[n2];
                            if (n3 == 47 && n14 != 32) {
                                ++n11;
                            }
                            if (n3 != 32 && n14 == 41) {
                                ++n11;
                            }
                            ++n11;
                            n14 = n3;
                        }
                    }
                    if (byArray[n2 - 1] != 92 || byArray[n2 - 1] == 92 && byArray[n2 - 2] == 92 && byArray[n2 - 3] != 92) {
                        if (byArray[n2] == 40) {
                            ++n13;
                        } else if (byArray[n2] == 41) {
                            --n13;
                        }
                        if (n13 == 0) {
                            if (byArray[n2] == 91) {
                                ++n12;
                            } else if (byArray[n2] == 93) {
                                --n12;
                            }
                        }
                    }
                    if (n12 == 0 && byArray[n2 - 1] != 92 && byArray[n2] == 93) break;
                    if (byArray[++n2] != 37 || byArray[n2 - 1] == 92 || n12 != 0) continue;
                    bl5 = true;
                }
                object3 = new char[n11];
                int n15 = 0;
                n2 = n10;
                while (byArray[n2] == 32) {
                    object3[n15] = (char)byArray[n2];
                    ++n15;
                    ++n2;
                }
                bl5 = false;
                bl6 = false;
                n12 = 0;
                n13 = 0;
                n3 = 32;
                n14 = 32;
                while (true) {
                    if (byArray[n2] == 92) {
                        ++n2;
                    }
                    if (n2 > 7 && !bl7 && byArray[n2 - 7] == 47 && byArray[n2 - 6] == 73 && byArray[n2 - 5] == 110 && byArray[n2 - 4] == 100 && byArray[n2 - 3] == 101 && byArray[n2 - 2] == 120 && byArray[n2 - 1] == 101 && byArray[n2] == 100) {
                        bl7 = true;
                    }
                    if (byArray[n2] == 40 & byArray[n2 - 1] != 92 && bl7) {
                        bl6 = true;
                        object3[n15] = 32;
                        object3[++n15] = 60;
                        ++n15;
                    } else if (bl6) {
                        if (byArray[n2] == 41 & byArray[n2 - 1] != 92) {
                            object3[n15] = 62;
                            ++n15;
                            bl6 = false;
                        } else {
                            string3 = Integer.toHexString(byArray[n2] & 0xFF);
                            if (string3.length() < 2) {
                                object3[n15] = 48;
                                ++n15;
                            }
                            int n16 = string3.length();
                            for (int i = 0; i < n16; ++i) {
                                object3[n15] = string3.charAt(i);
                                ++n15;
                            }
                        }
                    } else if (!bl5) {
                        if (byArray[n2] == 13 | byArray[n2] == 10) {
                            object3[n15] = 32;
                            ++n15;
                        } else {
                            n3 = (char)byArray[n2];
                            if (n3 == 47 && n14 != 32) {
                                object3[n15] = 32;
                                ++n15;
                            }
                            if (n3 != 32 && n14 == 41) {
                                object3[n15] = 32;
                                ++n15;
                            }
                            object3[n15] = n3;
                            ++n15;
                            n14 = n3;
                        }
                    }
                    if (byArray[n2 - 1] != 92 | (byArray[n2 - 1] == 92 && byArray[n2 - 2] == 92 && byArray[n2 - 3] != 92)) {
                        if (byArray[n2] == 40) {
                            ++n13;
                        } else if (byArray[n2] == 41) {
                            --n13;
                        }
                        if (n13 == 0) {
                            if (byArray[n2] == 91) {
                                ++n12;
                            } else if (byArray[n2] == 93) {
                                --n12;
                            }
                        }
                    }
                    if (n12 == 0 && byArray[n2 - 1] != 92 & byArray[n2] == 93) break;
                    if (byArray[++n2] != 37 || byArray[n2 - 1] == 92 || n12 != 0) continue;
                    bl5 = true;
                }
                string3 = String.copyValueOf((char[])object3, 0, n15);
                if (!string3.equals("null")) {
                    map.put(stringBuffer.toString(), string3);
                }
                stringBuffer = new StringBuffer(20);
                continue;
            }
            if (byArray[n2] == 62 || byArray[n2] == 60 || stringBuffer.length() <= 0) continue;
            boolean bl8 = false;
            int n17 = n2;
            int n18 = 0;
            while (true) {
                if (byArray[n2] != 13 && byArray[n2] != 9 && byArray[n2] != 10 && !bl8) {
                    ++n18;
                }
                if (byArray[n2 + 1] == 47 || byArray[n2] != 62 && byArray[n2 + 1] == 62) break;
                if (byArray[++n2] != 37 || byArray[n2 - 1] == 92) continue;
                bl8 = true;
            }
            while (n18 > 0 && (byArray[n17 + n18 - 1] == 32 || byArray[n17 + n18 - 1] == 10 || byArray[n17 + n18 - 1] == 13 || byArray[n17 + n18 - 1] == 9)) {
                --n18;
            }
            char[] cArray = new char[n18];
            --n18;
            int n19 = 0;
            do {
                if (byArray[n17] != 13 && byArray[n17] != 9 && byArray[n17] != 10) {
                    cArray[n19] = (char)byArray[n17];
                    ++n19;
                }
                ++n17;
            } while (n19 <= n18);
            String string4 = String.copyValueOf(cArray, 0, n19);
            if (!string4.equals("null")) {
                map.put(stringBuffer.toString(), string4);
            }
            stringBuffer = new StringBuffer(20);
        }
        return n2;
    }

    public final byte[] readStream(Map map, String string, boolean bl) {
        byte[] byArray;
        Object v = map.get("DecodedStream");
        if (v == null) {
            byArray = (byte[])map.get("Stream");
            if (bl) {
                map.remove("Stream");
            }
            if (byArray != null) {
                try {
                    byArray = this.decrypt(byArray, string, null, false);
                }
                catch (Exception exception) {
                    byArray = null;
                    LogWriter.writeLog("Exception " + exception);
                }
            }
            if (byArray != null) {
                int n = 1;
                int n2 = 1;
                int n3 = 1;
                String string2 = (String)map.get("Height");
                if (string2 != null) {
                    n = Integer.parseInt(string2);
                }
                if ((string2 = (String)map.get("Width")) != null) {
                    n2 = Integer.parseInt(string2);
                }
                if ((string2 = this.getValue((String)map.get("Length"))) != null) {
                    n3 = Integer.parseInt(string2);
                }
                if (n * n2 == 1) {
                    n2 = n3;
                }
                String string3 = this.getValue((String)map.get("Filter"));
                boolean bl2 = false;
                Object v2 = map.get("ImageMask");
                if (v2 != null && v2.equals("true")) {
                    bl2 = true;
                }
                if (string3 != null && !string3.startsWith("/JPXDecode") && !string3.startsWith("/DCT")) {
                    try {
                        byArray = this.decodeFilters(byArray, string3, map, n2, n, true);
                    }
                    catch (Exception exception) {
                        LogWriter.writeLog("[PDF] Problem " + exception + " decompressing stream ");
                        byArray = null;
                    }
                } else if (n3 != 1 && n3 < byArray.length && byArray.length != n3) {
                    byte[] byArray2 = new byte[n3];
                    for (int i = 0; i < n3; ++i) {
                        byArray2[i] = byArray[i];
                    }
                    byArray = byArray2;
                }
            }
            if (byArray != null && bl) {
                map.put("DecodedStream", byArray);
            }
        } else {
            byArray = (byte[])v;
        }
        return byArray;
    }

    public final byte[] readStream(String string) {
        Map map = this.readObject(string, false, null);
        return this.readStream(map, string, true);
    }

    private byte[] readObjectData() {
        int n = 256;
        int n2 = 0;
        byte[] byArray = null;
        long l = this.getPointer();
        long l2 = -1L;
        long l3 = -1L;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            int n3;
            do {
                if (l + (long)n > this.eof) {
                    n = (int)(this.eof - l);
                }
                byte[] byArray2 = new byte[n];
                this.movePointer(l);
                this.pdf_datafile.read(byArray2);
                for (n3 = 0; n3 < n; ++n3) {
                    byte by = byArray2[n3];
                    n2 = by == endPattern[n2] ? ++n2 : 0;
                    byteArrayOutputStream.write(by);
                    if (n2 != 6) continue;
                    n3 = n;
                }
                l += (long)n;
            } while (n2 != 6);
            byteArrayOutputStream.close();
            byArray = byteArrayOutputStream.toByteArray();
            int n4 = 0;
            for (n3 = 0; n3 < byArray.length - 8; ++n3) {
                if (n4 < 2 && byArray[n3] == 32 && byArray[n3 + 1] == 111 && byArray[n3 + 2] == 98 && byArray[n3 + 3] == 106) {
                    ++n4;
                    l3 = n3;
                }
                if (n4 >= 2 || byArray[n3] != 101 || byArray[n3 + 1] != 110 || byArray[n3 + 2] != 100 || byArray[n3 + 3] != 115 || byArray[n3 + 4] != 116 || byArray[n3 + 5] != 114 || byArray[n3 + 6] != 101 || byArray[n3 + 7] != 97 || byArray[n3 + 8] != 109) continue;
                l2 = n3 + 9;
            }
            if (l2 > 0L && l3 > l2) {
                byte[] byArray3 = new byte[(int)l2];
                System.arraycopy(byArray, 0, byArray3, 0, (int)l2);
                byArray = byArray3;
            }
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " reading object");
        }
        return byArray;
    }

    public final Map readObject(int n, boolean bl, Map map) {
        boolean bl2 = false;
        boolean bl3 = false;
        this.objData = new HashMap();
        byte[] byArray = null;
        try {
            this.movePointer(n);
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception moving pointer to " + n);
        }
        byte[] byArray2 = this.readObjectData();
        StringBuffer stringBuffer = new StringBuffer("obj");
        StringBuffer stringBuffer2 = new StringBuffer();
        int n2 = 32;
        int n3 = 0;
        for (int i = 0; i < byArray2.length; ++i) {
            char c = (char)byArray2[i];
            if (c == '\n' | c == '\r') {
                c = ' ';
            }
            if (c == ' ' && n2 == 32) {
                n3 = 0;
            } else if (c == stringBuffer.charAt(n3)) {
                ++n3;
            } else {
                n3 = 0;
                stringBuffer2.append(c);
            }
            if (n3 == 3) break;
            n2 = c;
        }
        stringBuffer2.append('R');
        this.objData.put("Reference", stringBuffer2.toString());
        this.convertObjectBytesToMap(this.objData, stringBuffer2.toString(), bl, map, bl2, bl3, byArray, byArray2, false);
        this.lastRef = "-1";
        return this.objData;
    }

    public final synchronized Map readObject(String string, boolean bl, Map map) {
        if (string.equals(this.lastRef)) {
            return this.objData;
        }
        this.lastRef = string;
        boolean bl2 = false;
        boolean bl3 = false;
        this.objData = new HashMap();
        bl3 = map != null;
        if (bl2) {
            System.err.println("reading objectRef=" + string + "<");
        }
        if (string.endsWith("]")) {
            string = Strip.removeArrayDeleminators(string);
        }
        boolean bl4 = this.isCompressed(string);
        if (string.endsWith(" R")) {
            byte[] byArray = null;
            byte[] byArray2 = null;
            if (bl4) {
                int n = Integer.parseInt(string.substring(0, string.indexOf(" ")));
                int n2 = this.getCompressedStreamObject(string);
                String string2 = n2 + " 0 R";
                String string3 = null;
                int n3 = this.getOffsetInCompressedStream(string);
                HashMap hashMap = this.lastOffsetStart;
                HashMap hashMap2 = this.lastOffsetEnd;
                int n4 = this.lastFirst;
                boolean bl5 = true;
                byte[] byArray3 = this.lastCompressedStream;
                if (this.lastOffsetStart != null) {
                    string3 = (String)this.lastOffsetStart.get("" + n);
                }
                while (string3 == null) {
                    bl5 = false;
                    try {
                        this.movePointer(string2);
                    }
                    catch (Exception exception) {
                        LogWriter.writeLog("Exception moving pointer to " + string);
                    }
                    byArray2 = this.readObjectData(this.ObjLengthTable[n2]);
                    HashMap hashMap3 = new HashMap();
                    this.convertObjectBytesToMap(hashMap3, string, bl, map, bl2, bl3, byArray, byArray2, false);
                    hashMap = new HashMap();
                    hashMap2 = new HashMap();
                    n4 = Integer.parseInt((String)hashMap3.get("First"));
                    byArray3 = this.readStream(hashMap3, string, true);
                    this.extractCompressedObjectOffset(hashMap, hashMap2, n4, byArray3);
                    string3 = (String)hashMap.get("" + n);
                    string2 = (String)hashMap3.get("Extends");
                }
                if (!bl5) {
                    this.lastCompressedStream = byArray3;
                    this.lastOffsetStart = hashMap;
                    this.lastOffsetEnd = hashMap2;
                    this.lastFirst = n4;
                }
                int n5 = n4 + Integer.parseInt(string3);
                int n6 = byArray3.length;
                String string4 = (String)hashMap2.get("" + n);
                if (string4 != null) {
                    n6 = n4 + Integer.parseInt(string4);
                }
                int n7 = n6 - n5;
                byArray2 = new byte[n7];
                System.arraycopy(byArray3, n5, byArray2, 0, n7);
            } else {
                try {
                    this.movePointer(string);
                }
                catch (Exception exception) {
                    LogWriter.writeLog("Exception moving pointer to " + string);
                }
                int n = string.indexOf(" ");
                int n8 = Integer.parseInt(string.substring(0, n));
                byArray2 = bl | this.refTableInvalid ? this.readObjectData() : this.readObjectData(this.ObjLengthTable[n8]);
            }
            if (bl2) {
                System.out.println("convertObjectsToMap");
            }
            if (byArray2.length > 1) {
                this.convertObjectBytesToMap(this.objData, string, bl, map, bl2, bl3, byArray, byArray2, bl4);
            }
            if (bl2) {
                System.out.println("converted");
            }
        } else {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                for (int i = 0; i < string.length(); ++i) {
                    byteArrayOutputStream.write((byte)string.charAt(i));
                }
                if (bl2) {
                    System.out.println("reading dictionary");
                }
                byteArrayOutputStream.close();
                byte[] byArray = byteArrayOutputStream.toByteArray();
                if (byArray.length > 0) {
                    this.readDictionary(string, 1, this.objData, 0, byArray, bl, map);
                }
                LogWriter.writeLog("Direct object read " + string + "<<");
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        if (bl2) {
            System.out.println("object read");
        }
        return this.objData;
    }

    public final synchronized byte[] readObjectAsByteArray(String string, boolean bl) {
        byte[] byArray = null;
        if (string.endsWith("]")) {
            string = Strip.removeArrayDeleminators(string);
        }
        boolean bl2 = this.isCompressed(string);
        if (string.endsWith(" R")) {
            byte[] byArray2 = null;
            if (bl2) {
                int n = Integer.parseInt(string.substring(0, string.indexOf(" ")));
                int n2 = this.getCompressedStreamObject(string);
                String string2 = n2 + " 0 R";
                String string3 = null;
                int n3 = this.getOffsetInCompressedStream(string);
                HashMap hashMap = this.lastOffsetStart;
                HashMap hashMap2 = this.lastOffsetEnd;
                int n4 = this.lastFirst;
                boolean bl3 = true;
                byte[] byArray3 = this.lastCompressedStream;
                if (this.lastOffsetStart != null) {
                    string3 = (String)this.lastOffsetStart.get("" + n);
                }
                while (string3 == null) {
                    bl3 = false;
                    try {
                        this.movePointer(string2);
                    }
                    catch (Exception exception) {
                        LogWriter.writeLog("Exception moving pointer to " + string);
                    }
                    byArray = this.readObjectData(this.ObjLengthTable[n2]);
                    HashMap hashMap3 = new HashMap();
                    this.convertObjectBytesToMap(hashMap3, string, bl, null, false, false, byArray2, byArray, false);
                    hashMap = new HashMap();
                    hashMap2 = new HashMap();
                    n4 = Integer.parseInt((String)hashMap3.get("First"));
                    byArray3 = this.readStream(hashMap3, string, true);
                    this.extractCompressedObjectOffset(hashMap, hashMap2, n4, byArray3);
                    string3 = (String)hashMap.get("" + n);
                    string2 = (String)hashMap3.get("Extends");
                }
                if (!bl3) {
                    this.lastCompressedStream = byArray3;
                    this.lastOffsetStart = hashMap;
                    this.lastOffsetEnd = hashMap2;
                    this.lastFirst = n4;
                }
                int n5 = n4 + Integer.parseInt(string3);
                int n6 = byArray3.length;
                String string4 = (String)hashMap2.get("" + n);
                if (string4 != null) {
                    n6 = n4 + Integer.parseInt(string4);
                }
                int n7 = n6 - n5;
                byArray = new byte[n7];
                System.arraycopy(byArray3, n5, byArray, 0, n7);
            } else {
                try {
                    this.movePointer(string);
                }
                catch (Exception exception) {
                    LogWriter.writeLog("Exception moving pointer to " + string);
                }
                int n = string.indexOf(" ");
                int n8 = Integer.parseInt(string.substring(0, n));
                byArray = bl | this.refTableInvalid ? this.readObjectData() : this.readObjectData(this.ObjLengthTable[n8]);
            }
        } else {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            for (int i = 0; i < string.length(); ++i) {
                byteArrayOutputStream.write((byte)string.charAt(i));
            }
            try {
                byteArrayOutputStream.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            byArray = byteArrayOutputStream.toByteArray();
        }
        return byArray;
    }

    private void extractCompressedObjectOffset(Map map, Map map2, int n, byte[] byArray) {
        String string = null;
        String string2 = null;
        String string3 = null;
        StringBuffer stringBuffer = null;
        StringBuffer stringBuffer2 = null;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        for (int i = 0; i < n; ++i) {
            int n6;
            stringBuffer = new StringBuffer();
            stringBuffer2 = new StringBuffer();
            n2 = i;
            while (byArray[i] != 32) {
                stringBuffer.append((char)byArray[i]);
                ++i;
            }
            n3 = i - 1;
            int n7 = n3 - n2 + 1;
            char[] cArray = new char[n7];
            for (n6 = 0; n6 < n7; ++n6) {
                cArray[n6] = (char)byArray[n2 + n6];
            }
            string2 = new String(cArray);
            if (!string2.equals(stringBuffer.toString())) {
                System.out.println("Different=" + string2 + "<>" + stringBuffer + "<");
                System.exit(1);
            }
            while (byArray[i] == 32) {
                ++i;
            }
            n4 = i;
            while (byArray[i] != 32 && i < n) {
                stringBuffer2.append((char)byArray[i]);
                ++i;
            }
            n5 = i - 1;
            n7 = n5 - n4 + 1;
            cArray = new char[n7];
            for (n6 = 0; n6 < n7; ++n6) {
                cArray[n6] = (char)byArray[n4 + n6];
            }
            string3 = new String(cArray);
            if (!string3.equals(stringBuffer2.toString())) {
                System.out.println("Different=" + string3 + "<>" + stringBuffer2 + "<");
                System.exit(1);
            }
            map.put(string2, string3);
            if (string != null) {
                map2.put(string, string3);
            }
            string = string2;
        }
    }

    private void convertObjectBytesToMap(Map map, String string, boolean bl, Map map2, boolean bl2, boolean bl3, byte[] byArray, byte[] byArray2, boolean bl4) {
        int n;
        int n2 = 0;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        char c = ' ';
        StringBuffer stringBuffer = new StringBuffer();
        if (!bl4) {
            while (byArray2[n2] != 111 || byArray2[n2 + 1] != 98 || byArray2[n2 + 2] != 106) {
                ++n2;
            }
            n2 += 2;
            while (byArray2[n2] != 47 && !(byArray2[++n2] == 10 | byArray2[n2] == 13 | byArray2[n2] == 60 | byArray2[n2] == 91 | byArray2[n2] == 32)) {
            }
        }
        if (bl2) {
            for (n = n2; n < byArray2.length - 7; ++n) {
                System.err.print((char)byArray2[n]);
            }
            System.err.print("<==\n\n");
        }
        if (byArray2[n2] == 47 | byArray2[n2] == 91) {
            --n2;
        }
        while (n2 < byArray2.length - 7) {
            ++n2;
            if (bl2) {
                System.err.println((char)byArray2[n2]);
            }
            if (byArray2[n2] == 60 && byArray2[n2 + 1] == 60 | byArray2[n2 - 1] == 60) {
                if (byArray2[n2 - 1] != 60) {
                    ++n2;
                }
                if (bl2) {
                    System.err.println("Read dictionary");
                }
                n2 = this.readDictionary(string, 1, map, n2, byArray2, bl, map2);
                continue;
            }
            if (byArray2[n2] == 115 && byArray2[n2 + 1] == 116 && byArray2[n2 + 2] == 114 && byArray2[n2 + 3] == 101 && byArray2[n2 + 4] == 97 && byArray2[n2 + 5] == 109) {
                if (byArray2[n2 += 6] == 13 && byArray2[n2 + 1] == 10) {
                    n2 += 2;
                } else if (byArray2[n2] == 10 | byArray2[n2] == 13) {
                    // empty if block
                }
                n = ++n2;
                --n2;
                int n3 = 0;
                String string2 = (String)map.get("Length");
                if (string2 != null) {
                    if (string2.indexOf(" R") != -1) {
                        try {
                            int n4;
                            long l = this.movePointer(string2);
                            int n5 = 128;
                            if (l + (long)n5 > this.eof) {
                                n5 = (int)(this.eof - l - 1L);
                            }
                            StringBuffer stringBuffer2 = new StringBuffer();
                            byte[] byArray3 = new byte[n5];
                            this.pdf_datafile.read(byArray3);
                            for (n4 = 3; n4 >= n5 || byArray3[n4 - 3] != 111 || byArray3[n4 - 2] != 98 || byArray3[n4 - 1] != 106; ++n4) {
                            }
                            while (n4 >= n5 || !Character.isDigit((char)byArray3[n4])) {
                                ++n4;
                            }
                            while (n4 < n5 && Character.isDigit((char)byArray3[n4])) {
                                stringBuffer2.append((char)byArray3[n4]);
                                ++n4;
                            }
                            this.movePointer(l);
                            string2 = stringBuffer2.toString();
                        }
                        catch (Exception exception) {
                            LogWriter.writeLog("Exception moving pointer to " + string);
                            string2 = null;
                        }
                    }
                    if (string2 != null) {
                        n3 = Integer.parseInt(string2);
                        n2 = n + n3;
                    }
                }
                int n6 = 0;
                if (string2 == null) {
                    while (++n2 != byArray2.length && (byArray2[n2] != 101 || byArray2[n2 + 1] != 110 || byArray2[n2 + 2] != 100 || byArray2[n2 + 3] != 115 || byArray2[n2 + 4] != 116 || byArray2[n2 + 5] != 114 || byArray2[n2 + 6] != 101 || byArray2[n2 + 7] != 97 || byArray2[n2 + 8] != 109)) {
                    }
                    n6 = n2 - 1;
                    while (byArray2[n6] == 10 | byArray2[n6] == 13) {
                        --n6;
                    }
                    if (n6 > n) {
                        n3 = n6 - n + 1;
                    }
                }
                if (n + n3 > byArray2.length) {
                    n3 = byArray2.length - n;
                }
                byArray = new byte[n3];
                System.arraycopy(byArray2, n, byArray, 0, n3);
                n2 += 9;
                continue;
            }
            if (byArray2[n2] == 91) {
                if (bl2) {
                    System.err.println("read array");
                }
                n2 = this.readArray(string, n2, map, byArray2, bl, map2);
                continue;
            }
            if (!(byArray2[n2] != 60 & byArray2[n2] != 62)) continue;
            if (bl3) {
                if (byArray2[n2 - 1] == 92 && byArray2[n2 - 2] == 92) {
                    byteArrayOutputStream.write(byArray2[n2]);
                } else if (!((byArray2[n2] == 40 | byArray2[n2] == 41) & byArray2[n2 - 1] != 92)) {
                    byteArrayOutputStream.write(byArray2[n2]);
                }
            }
            if (byArray2[n2] == 10 | byArray2[n2] == 13 | byArray2[n2] == 32) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(' ');
                }
                c = ' ';
                continue;
            }
            if (byArray2[n2] == 47 && c != ' ') {
                stringBuffer.append(' ');
            }
            c = (char)byArray2[n2];
            stringBuffer.append(c);
        }
        if (stringBuffer.length() > 0 && (n = stringBuffer.toString().indexOf("%")) > -1) {
            stringBuffer.setLength(n);
        }
        if (stringBuffer.length() > 0) {
            String string3 = stringBuffer.toString().trim();
            if (bl3 && string3.startsWith("(")) {
                try {
                    byteArrayOutputStream.close();
                    byte[] byArray4 = byteArrayOutputStream.toByteArray();
                    byArray4 = this.decrypt(byArray4, string, null, false);
                    map.put("rawValue", byArray4);
                }
                catch (Exception exception) {
                    LogWriter.writeLog("Exception " + exception + " writing out text string");
                }
            } else {
                if (bl2) {
                    System.err.println("Remainder value=" + stringBuffer + "<<");
                }
                map.put("rawValue", string3);
            }
        }
        if (byArray != null) {
            map.put("Stream", byArray);
        }
        if (bl2) {
            System.err.println(map);
        }
        try {
            byteArrayOutputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private int readArray(String string, int n, Map map, byte[] byArray, boolean bl, Map map2) {
        int n2 = 0;
        int n3 = 0;
        boolean bl2 = false;
        boolean bl3 = false;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        while (true) {
            if (bl2) {
                int n4 = n;
                while (byArray[n4] == 13 | byArray[n4] == 10 | byArray[n4] == 32) {
                    ++n4;
                }
                if (byArray[n4] == 60 && byArray[n4 + 1] == 60) {
                    n = n4;
                    if (bl3) {
                        stringBuffer.append(stringBuffer2);
                        stringBuffer.append(' ');
                        stringBuffer2 = new StringBuffer();
                        n = this.readDictionary(string, 1, map, n, byArray, bl, map2);
                    } else {
                        HashMap hashMap = new HashMap();
                        map.put(stringBuffer2.substring(1), hashMap);
                        n = this.readDictionary(string, 1, hashMap, n, byArray, bl, map2);
                    }
                    if (byArray[n] == 62) {
                        ++n;
                    }
                    stringBuffer2 = new StringBuffer();
                } else {
                    if (stringBuffer.charAt(stringBuffer.length() - 1) != ' ') {
                        stringBuffer.append(' ');
                    }
                    stringBuffer.append(stringBuffer2);
                    stringBuffer.append(' ');
                    stringBuffer2 = new StringBuffer();
                    bl2 = false;
                    --n;
                }
            } else if (byArray[n] == 47) {
                bl2 = true;
                do {
                    stringBuffer2.append((char)byArray[n]);
                } while (byArray[++n] != 47 && byArray[n] != 13 && byArray[n] != 10 && byArray[n] != 32 && byArray[n] != 60 && byArray[n] != 91 && byArray[n] != 93);
                if (byArray[n] == 47 || byArray[n] == 91 || byArray[n] == 93 || byArray[n] == 60) {
                    --n;
                }
                if (stringBuffer2.toString().equals("/Separation")) {
                    bl3 = true;
                }
            } else {
                if (n > 0 && byArray[n - 1] == 47) {
                    stringBuffer.append('/');
                }
                if (byArray[n] == 13 | byArray[n] == 10) {
                    stringBuffer.append(' ');
                } else {
                    if (byArray[n] == 60 && byArray[n - 1] != 32) {
                        stringBuffer.append(' ');
                    }
                    if (n > 0 && byArray[n - 1] == 93) {
                        stringBuffer.append(' ');
                    }
                    stringBuffer.append((char)byArray[n]);
                }
                if (n == 0 || n > 0 && byArray[n - 1] != 92) {
                    if (byArray[n] == 91) {
                        ++n2;
                    } else if (byArray[n] == 93) {
                        ++n3;
                    }
                }
            }
            if (byArray[n] == 93 & n2 == n3) break;
            ++n;
        }
        map.put("rawValue", stringBuffer.toString().trim());
        return n;
    }

    public final String readReferenceTable() throws PdfException {
        int n = this.readFirstStartRef();
        int n2 = -1;
        this.xref.addElement(n);
        try {
            n2 = (int)this.pdf_datafile.length();
        }
        catch (Exception exception) {
            try {
                this.pdf_datafile.close();
            }
            catch (IOException iOException) {
                LogWriter.writeLog("Exception " + exception + " closing file");
            }
            throw new PdfException("Exception " + exception + " reading trailer");
        }
        if (n >= n2) {
            LogWriter.writeLog("Pointer not if file - trying to manually find startref");
            this.refTableInvalid = true;
            return this.findOffsets();
        }
        if (this.isCompressedStream(n, n2)) {
            return this.readCompressedStream(n, n2);
        }
        return this.readLegacyReferenceTable(n, n2);
    }

    private final int getWord(byte[] byArray, int n, int n2) {
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            n3 = (n3 << 8) + (byArray[n + i] & 0xFF);
        }
        return n3;
    }

    private String readCompressedStream(int n, int n2) throws PdfException {
        String string = "";
        String string2 = null;
        while (n != -1) {
            Object object;
            int n3;
            int n4;
            HashMap hashMap = this.readObject(n, false, null);
            String string3 = (String)hashMap.get("Reference");
            String string4 = (String)hashMap.get("Index");
            if (string4 == null) {
                n4 = 0;
                n3 = Integer.parseInt((String)hashMap.get("Size"));
            } else {
                String string5 = Strip.removeArrayDeleminators(string4);
                object = new StringTokenizer(string5);
                n4 = Integer.parseInt(((StringTokenizer)object).nextToken());
                n3 = Integer.parseInt(((StringTokenizer)object).nextToken());
            }
            string4 = (String)hashMap.get("W");
            object = new int[3];
            StringTokenizer stringTokenizer = new StringTokenizer(Strip.removeArrayDeleminators(string4));
            for (int i = 0; i < 3; ++i) {
                object[i] = Integer.parseInt(stringTokenizer.nextToken());
            }
            byte[] byArray = this.readStream(hashMap, string3, true);
            int n5 = 0;
            int[] nArray = new int[]{1, 0, 0};
            block7: for (int i = 0; i < n3; ++i) {
                int n6;
                int[] nArray2 = new int[3];
                for (n6 = 0; n6 < 3; ++n6) {
                    if (object[n6] == false) {
                        nArray2[n6] = nArray[n6];
                        continue;
                    }
                    nArray2[n6] = this.getWord(byArray, n5, (int)object[n6]);
                    n5 += object[n6];
                }
                n6 = 0;
                switch (nArray2[0]) {
                    case 0: {
                        n4 = nArray2[1];
                        int n7 = nArray2[2];
                        ++n4;
                        continue block7;
                    }
                    case 1: {
                        n6 = nArray2[1];
                        int n7 = nArray2[2];
                        this.storeObjectOffset(n4, n6, n7, false);
                        ++n4;
                        continue block7;
                    }
                    case 2: {
                        n6 = nArray2[1];
                        int n7 = nArray2[2];
                        this.storeObjectOffset(n4, n6, n7, true);
                        ++n4;
                        continue block7;
                    }
                    default: {
                        throw new PdfException("Exception Unsupported Compression mode with value " + nArray2[0]);
                    }
                }
            }
            if (string.length() == 0) {
                string4 = (String)hashMap.get("Root");
                if (string4 != null) {
                    string = string4;
                }
                if ((string2 = (String)hashMap.get("Encrypt")) != null) {
                    this.ID = (String)hashMap.get("ID");
                    if (this.ID == null) {
                        this.ID = "";
                    } else {
                        this.ID = Strip.removeArrayDeleminators(this.ID);
                        if (this.ID.startsWith("<")) {
                            this.ID = this.ID.substring(1, this.ID.indexOf(">"));
                        }
                    }
                }
                this.infoObject = (string4 = (String)hashMap.get("Info")) != null && !this.isEncrypted() | this.isPasswordSupplied() ? string4 : null;
            }
            if ((string4 = (String)hashMap.get("Prev")) != null) {
                hashMap = new HashMap();
                n = Integer.parseInt(string4);
                continue;
            }
            n = -1;
        }
        this.calculateObjectLength();
        return string;
    }

    private boolean isCompressedStream(int n, int n2) throws PdfException {
        boolean bl = false;
        int n3 = 50;
        int n4 = 0;
        int n5 = -1;
        byte[] byArray = new String("obj").getBytes();
        byte[] byArray2 = new String("ref").getBytes();
        block6: do {
            if (n + n3 > n2) {
                n3 = n2 - n;
            }
            if (n3 < 0) {
                n3 = 50;
            }
            byte[] byArray3 = new byte[n3];
            this.movePointer(n);
            try {
                this.pdf_datafile.read(byArray3);
            }
            catch (Exception exception) {
                try {
                    this.pdf_datafile.close();
                }
                catch (IOException iOException) {
                    LogWriter.writeLog("Exception " + exception + " closing file");
                }
                throw new PdfException("Exception " + exception + " scanning trailer for ref or obj");
            }
            for (int i = 0; i < n3; ++i) {
                byte by = byArray3[i];
                if (by == byArray2[n4] && n5 != 1) {
                    ++n4;
                    n5 = 2;
                } else if (by == byArray[n4] && n5 != 2) {
                    ++n4;
                    n5 = 1;
                } else {
                    n4 = 0;
                    n5 = -1;
                }
                n += n3;
                if (n4 == 2) continue block6;
            }
        } while (n4 != 2);
        if (n5 == -1) {
            try {
                this.pdf_datafile.close();
            }
            catch (IOException iOException) {
                LogWriter.writeLog("Exception 1 closing file");
            }
            throw new PdfException("Exception unable to find ref or obj in trailer");
        }
        return n5 == 1;
    }

    private final String readLegacyReferenceTable(int n, int n2) throws PdfException {
        String string = "";
        String string2 = "";
        String string3 = null;
        int n3 = 0;
        byte[] byArray = null;
        int n4 = 1024;
        int n5 = 0;
        int n6 = 0;
        byte[] byArray2 = new byte[]{37, 37, 69, 79, 70};
        HashMap hashMap = new HashMap();
        do {
            int n7;
            try {
                byArray = this.readTrailer(n4, n5, byArray2, n, n2);
            }
            catch (Exception exception) {
                byArray = null;
                try {
                    this.pdf_datafile.close();
                }
                catch (IOException iOException) {
                    LogWriter.writeLog("Exception " + exception + " closing file");
                }
                throw new PdfException("Exception " + exception + " reading trailer");
            }
            if (byArray == null) break;
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = new StringBuffer();
            StringBuffer stringBuffer3 = new StringBuffer();
            int n8 = byArray.length;
            for (n7 = 0; n7 < n8 && !(byArray[n7] == 116 & byArray[n7 + 1] == 114 & byArray[n7 + 2] == 97 & byArray[n7 + 3] == 105 & byArray[n7 + 4] == 108 & byArray[n7 + 5] == 101 & byArray[n7 + 6] == 114); ++n7) {
            }
            n6 = n7;
            while (byArray[n7] != 60 && byArray[n7 + 1] != 60) {
                ++n7;
            }
            n7 = this.readRef2(byArray, hashMap, n7, stringBuffer2, stringBuffer3);
            while (byArray[n7] != 116 && byArray[n7 + 1] != 120 && byArray[n7 + 2] != 114 && byArray[n7 + 3] != 101 && byArray[n7 + 4] != 102) {
                ++n7;
            }
            n7 += 8;
            while (n7 < n8 && byArray[n7] == 10 | byArray[n7] == 32 | byArray[n7] == 13) {
                ++n7;
            }
            while (n7 < n8 && byArray[n7] != 10 && byArray[n7] != 32 && byArray[n7] != 13) {
                stringBuffer.append((char)byArray[n7]);
                ++n7;
            }
            if (stringBuffer.length() > 0) {
                n = Integer.parseInt(stringBuffer.toString());
            }
            if (n == -1) {
                LogWriter.writeLog("Problem with startRef");
                continue;
            }
            if (byArray[0] == 120 & byArray[1] == 114 & byArray[2] == 101 & byArray[3] == 102) {
                n7 = 5;
                while (byArray[n7] == 10 | byArray[n7] == 32 | byArray[n7] == 13) {
                    ++n7;
                }
                n3 = this.readXRefs(n3, byArray, n6, n7);
                n7 = n6;
                if (string.length() == 0) {
                    string2 = (String)hashMap.get("Root");
                    if (string2 != null) {
                        string = string2;
                    }
                    if ((string3 = (String)hashMap.get("Encrypt")) != null) {
                        this.ID = (String)hashMap.get("ID");
                        if (this.ID == null) {
                            this.ID = "";
                        } else {
                            this.ID = Strip.removeArrayDeleminators(this.ID);
                            if (this.ID.startsWith("<")) {
                                this.ID = this.ID.substring(1, this.ID.indexOf(">"));
                            }
                        }
                    }
                    this.infoObject = (string2 = (String)hashMap.get("Info")) != null && !this.isEncrypted() | this.isPasswordSupplied() ? string2 : null;
                }
                if ((string2 = (String)hashMap.get("Prev")) != null) {
                    n4 = 1024;
                    n5 = 0;
                    hashMap = new HashMap();
                    n = Integer.parseInt(string2);
                    this.xref.addElement(n);
                    continue;
                }
                n = -1;
                continue;
            }
            n = -1;
            string = this.findOffsets();
            this.refTableInvalid = true;
        } while (n != -1);
        if (string3 != null) {
            this.readEncryptionObject(string3);
        }
        if (!this.refTableInvalid) {
            this.calculateObjectLength();
        }
        return string;
    }

    private void calculateObjectLength() {
        int n;
        int n2;
        try {
            this.xref.addElement((int)this.pdf_datafile.length());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        int[] nArray = this.xref.get();
        int n3 = nArray.length;
        int[] nArray2 = new int[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            nArray2[n2] = n2;
        }
        nArray2 = Sorts.quicksort(nArray, nArray2);
        n2 = this.offset.getCapacity();
        this.ObjLengthTable = new int[n2];
        int[] nArray3 = new int[n2];
        int[] nArray4 = new int[n2];
        int[] nArray5 = this.offset.get();
        boolean[] blArray = this.isCompressed.get();
        for (n = 0; n < n2; ++n) {
            if (blArray[n]) continue;
            nArray4[n] = nArray5[n];
            nArray3[n] = n;
        }
        nArray3 = Sorts.quicksort(nArray4, nArray3);
        n = 0;
        while (nArray4[nArray3[n]] == 0) {
            ++n;
        }
        int n4 = nArray4[nArray3[n]];
        int n5 = 0;
        while (nArray[nArray2[n5]] < n4 + 1) {
            ++n5;
        }
        while (n < n2 - 1) {
            int n6 = nArray4[nArray3[n + 1]];
            int n7 = n6 - n4 - 1;
            if (nArray[nArray2[n5]] < n6) {
                n7 = nArray[nArray2[n5]] - n4 - 1;
                while (nArray[nArray2[n5]] < n6 + 1) {
                    ++n5;
                }
            }
            this.ObjLengthTable[nArray3[n]] = n7;
            n4 = n6;
            while (nArray[nArray2[n5]] < n4 + 1) {
                ++n5;
            }
            ++n;
        }
        this.ObjLengthTable[nArray3[n]] = nArray[nArray2[n5]] - n4 - 1;
    }

    private int readXRefs(int n, byte[] byArray, int n2, int n3) {
        byte[] byArray2 = byArray;
        int n4 = 99;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int[] nArray = new int[5];
        int[] nArray2 = new int[5];
        while (n3 < n2) {
            int n9;
            int n10 = n3;
            int n11 = -1;
            while (byArray2[n3] != 10 & byArray2[n3] != 13) {
                if (n11 == -1 && byArray2[n3] == 37) {
                    n11 = n3 - 1;
                }
                ++n3;
            }
            if (n11 == -1) {
                n11 = n3 - 1;
            }
            while (byArray2[n10] == 32) {
                ++n10;
            }
            while (byArray2[n11] == 32) {
                --n11;
            }
            ++n3;
            n6 = 0;
            n8 = n11 - n10 + 1;
            if (n8 <= 0) continue;
            int n12 = 1;
            for (n9 = 1; n9 < n8; ++n9) {
                int n13 = byArray2[n10 + n9];
                if (n13 == 32 && n12 != 32) {
                    nArray[n6] = n9;
                    ++n6;
                } else if (n13 != 32 && n12 == 32) {
                    nArray2[n6] = n9;
                }
                n12 = n13;
            }
            nArray[n6] = n8;
            if (++n6 == 2) {
                n = this.parseInt(n10, n10 + nArray[0], byArray2);
                continue;
            }
            n5 = this.parseInt(n10, n10 + nArray[0], byArray2);
            n7 = this.parseInt(n10 + nArray2[1], n10 + nArray[1], byArray2);
            n4 = (char)byArray2[n10 + nArray2[2]];
            if (n4 == 110) {
                n9 = 0;
                int n14 = 20;
                if ((long)(n5 + n14) > this.eof) {
                    n14 = (int)(this.eof - (long)n5);
                }
                if (n14 > 0) {
                    byte[] byArray3 = new byte[n14];
                    this.movePointer(n5);
                    try {
                        this.pdf_datafile.read(byArray3);
                        for (int i = 4; i < n14; ++i) {
                            if (byArray3[i - 3] != 32 || byArray3[i - 2] != 111 || byArray3[i - 1] != 98 || byArray3[i] != 106) continue;
                            n9 = 1;
                            i = n14;
                        }
                        if (n9 != 0) {
                            this.storeObjectOffset(n, n5, n7, false);
                            this.xref.addElement(n5);
                        }
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            }
            ++n;
        }
        return n;
    }

    private int parseInt(int n, int n2, byte[] byArray) {
        int n3 = 0;
        int n4 = 0;
        --n;
        for (int i = n2 - 1; i > n; --i) {
            n3 += (byArray[i] - 48) * powers[n4];
            ++n4;
        }
        return n3;
    }

    private int readRef2(byte[] byArray, Map map, int n, StringBuffer stringBuffer, StringBuffer stringBuffer2) {
        while (byArray[++n] != 62 || byArray[n + 1] != 62) {
            if (byArray[n] == 47) {
                String string;
                ++n;
                while (!(byArray[n] == 32 | byArray[n] == 91 | byArray[n] == 10 | byArray[n] == 13 | byArray[n] == 60)) {
                    stringBuffer.append((char)byArray[n]);
                    ++n;
                }
                boolean bl = stringBuffer.length() != 2 || stringBuffer.charAt(0) != 'I' || stringBuffer.charAt(1) != 'D';
                if (byArray[n] != 91) {
                    while (byArray[n] == 32) {
                        ++n;
                    }
                }
                int n2 = 0;
                int n3 = 0;
                int n4 = 0;
                while (true) {
                    char c = (char)byArray[n];
                    if (byArray[n - 1] == 60 && byArray[n] == 60) {
                        ++n4;
                    }
                    if (c == '(' && n > 0 && byArray[n - 1] != 92 | (n > 1 && byArray[n - 1] == 92 && byArray[n - 2] != 92)) {
                        ++n3;
                    } else if (c == ')' && n > 0 && byArray[n - 1] != 92 | (n > 1 && byArray[n - 1] == 92 && byArray[n - 2] != 92)) {
                        ++n3;
                    }
                    if (c == '/' & bl && n4 == 0) {
                        --n;
                    }
                    if (!bl && c == ']' && n3 == 0 || n4 == 0 && c == '\n' | c == '\r' | (c == '/' && bl) && n2 > 0) break;
                    if (byArray[n] == 62 && byArray[n + 1] == 62) {
                        if (n4 == 0) break;
                        --n4;
                    }
                    if (c == '\\') {
                        c = (char)byArray[++n];
                    }
                    if (!((byArray[n] == 10 | byArray[n] == 13) & n2 == 0)) {
                        stringBuffer2.append((char)byArray[n]);
                        ++n2;
                    }
                    ++n;
                }
                if (!(string = (stringBuffer2 = this.removeTrailingSpaces(stringBuffer2)).toString()).equals("null")) {
                    int n5 = string.indexOf("%");
                    if (n5 != -1 & string.indexOf("\\%") != n5 - 1) {
                        string = string.substring(0, n5).trim();
                    }
                    map.put(stringBuffer.toString(), string);
                }
                stringBuffer = new StringBuffer();
                stringBuffer2 = new StringBuffer();
            }
            if (byArray[n] != 62 || byArray[n + 1] != 62) continue;
            break;
        }
        return n;
    }

    private byte[] readTrailer(int n, int n2, byte[] byArray, int n3, int n4) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        do {
            if (n3 + n > n4) {
                n = n4 - n3;
            }
            byte[] byArray2 = new byte[n];
            this.movePointer(n3);
            this.pdf_datafile.read(byArray2);
            boolean bl = false;
            for (int i = 0; i < n; ++i) {
                byte by = byArray2[i];
                n2 = by == byArray[n2] ? ++n2 : 0;
                if (n2 != 5) continue;
                for (int j = 0; j < i + 1; ++j) {
                    byteArrayOutputStream.write(byArray2[j]);
                }
                i = n;
                bl = true;
            }
            if (!bl) {
                byteArrayOutputStream.write(byArray2);
            }
            n3 += n;
        } while (n2 != 5);
        byteArrayOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    public final PdfFileInformation readPdfFileMetadata(String string) {
        if (this.infoObject != null && !this.isEncrypted | this.isPasswordSupplied) {
            this.readInformationObject(this.infoObject);
        }
        if (string != null) {
            this.currentFileInformation.setFileXMLMetaData(this.convertStreamToXML(string).toString());
        }
        return this.currentFileInformation;
    }

    public StringBuffer convertStreamToXML(String string) {
        StringBuffer stringBuffer = null;
        if (string != null) {
            stringBuffer = new StringBuffer();
            String string2 = "";
            BufferedReader bufferedReader = null;
            ByteArrayInputStream byteArrayInputStream = null;
            try {
                byte[] byArray = this.readStream(string);
                byteArrayInputStream = new ByteArrayInputStream(byArray);
                bufferedReader = new BufferedReader(new InputStreamReader(byteArrayInputStream));
                if (bufferedReader != null) {
                    while ((string2 = bufferedReader.readLine()) != null) {
                        stringBuffer.append(string2);
                        stringBuffer.append('\n');
                    }
                }
            }
            catch (Exception exception) {
                LogWriter.writeLog("Exception " + exception + " reading XML object " + string);
            }
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                    byteArrayInputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        return stringBuffer;
    }

    public final String getValue(String string) {
        if (string != null && string.endsWith(" R")) {
            Map map = this.readObject(string, false, null);
            string = (String)map.get("rawValue");
        }
        return string;
    }

    private final Object getObjectValue(Object object) {
        Object v;
        Map map = this.readObject((String)object, false, this.fields);
        int n = map.size();
        object = n == 1 ? ((v = map.get("rawValue")) != null ? (v instanceof String ? v : this.getTextString((byte[])v)) : map) : map;
        return object;
    }

    public final byte[] getByteTextStringValue(Object object, Map map) {
        if (object instanceof String) {
            String string = (String)object;
            if (string != null && string.endsWith(" R")) {
                Map map2 = this.readObject(string, false, map);
                object = (byte[])map2.get("rawValue");
            } else {
                return string.getBytes();
            }
        }
        return (byte[])object;
    }

    public final Map getSubDictionary(Object object) {
        if (object instanceof String) {
            return this.readObject((String)object, false, null);
        }
        return (Map)object;
    }

    private StringBuffer removeTrailingSpaces(StringBuffer stringBuffer) {
        int n = stringBuffer.length();
        for (int i = n - 1; i > -1; --i) {
            if (stringBuffer.charAt(i) == ' ') {
                stringBuffer.deleteCharAt(i);
                continue;
            }
            i = -2;
        }
        return stringBuffer;
    }

    public static String convertToString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            stringBuffer.append((char)byArray[i]);
        }
        return stringBuffer.toString();
    }

    public final boolean isEncrypted() {
        return this.isEncrypted;
    }

    public final boolean isPasswordSupplied() {
        return this.isPasswordSupplied;
    }

    public final boolean isExtractionAllowed() {
        return this.extractionIsAllowed;
    }

    public boolean isFileViewable() {
        return this.isFileViewable;
    }

    private final byte[] decrypt(byte[] byArray, String string, byte[] byArray2, boolean bl) throws PdfSecurityException {
        if (this.isEncrypted | bl) {
            int n;
            byte[] byArray3 = new byte[this.keyLength];
            if (string.length() > 0) {
                byArray3 = new byte[this.keyLength + 5];
            }
            if (byArray2 == null) {
                for (n = 0; n < this.keyLength; ++n) {
                    byArray3[n] = this.encryptionKey[n];
                }
            } else {
                for (n = 0; n < this.keyLength; ++n) {
                    byArray3[n] = byArray2[n];
                }
            }
            try {
                if (string.length() > 0) {
                    n = string.indexOf(" ");
                    int n2 = string.indexOf(" ", n + 1);
                    int n3 = Integer.parseInt(string.substring(0, n));
                    int n4 = Integer.parseInt(string.substring(n + 1, n2));
                    byArray3[this.keyLength] = (byte)(n3 & 0xFF);
                    byArray3[this.keyLength + 1] = (byte)(n3 >> 8 & 0xFF);
                    byArray3[this.keyLength + 2] = (byte)(n3 >> 16 & 0xFF);
                    byArray3[this.keyLength + 3] = (byte)(n4 & 0xFF);
                    byArray3[this.keyLength + 4] = (byte)(n4 >> 8 & 0xFF);
                }
                byte[] byArray4 = new byte[Math.min(byArray3.length, 16)];
                if (string.length() > 0) {
                    MessageDigest messageDigest = MessageDigest.getInstance("MD5");
                    messageDigest.update(byArray3);
                    System.arraycopy(messageDigest.digest(), 0, byArray4, 0, byArray4.length);
                } else {
                    System.arraycopy(byArray3, 0, byArray4, 0, byArray4.length);
                }
                if (this.cipher == null) {
                    this.cipher = Cipher.getInstance("RC4");
                }
                SecretKeySpec secretKeySpec = new SecretKeySpec(byArray4, "RC4");
                if (bl) {
                    this.cipher.init(1, secretKeySpec);
                } else {
                    this.cipher.init(2, secretKeySpec);
                }
                byArray = this.cipher.doFinal(byArray);
            }
            catch (Exception exception) {
                throw new PdfSecurityException("Exception " + exception + " decrypting content");
            }
        }
        return byArray;
    }

    private byte[] getPaddedKey(byte[] byArray) {
        int n;
        byte[] byArray2 = new byte[32];
        int n2 = byArray.length;
        if (n2 > 32) {
            n2 = 32;
        }
        for (n = 0; n < n2; ++n) {
            byArray2[n] = this.encryptionPassword[n];
        }
        for (n = n2; n < 32; ++n) {
            byArray2[n] = (byte)Integer.parseInt(this.padding[n - n2], 16);
        }
        return byArray2;
    }

    private boolean testUserPassword() throws PdfSecurityException {
        int n = 32;
        byte[] byArray = new byte[32];
        byte[] byArray2 = new byte[32];
        for (int i = 0; i < 32; ++i) {
            byArray[i] = (byte)Integer.parseInt(this.padding[i], 16);
        }
        byte[] byArray3 = (byte[])byArray.clone();
        if (this.rev == 2) {
            this.encryptionKey = this.calculateKey(this.O, this.P, this.ID);
            byArray3 = this.decrypt(byArray3, "", null, true);
        } else if (this.rev == 3) {
            n = 16;
            this.encryptionKey = this.calculateKey(this.O, this.P, this.ID);
            byte[] byArray4 = (byte[])this.encryptionKey.clone();
            MessageDigest messageDigest = null;
            try {
                messageDigest = MessageDigest.getInstance("MD5");
            }
            catch (Exception exception) {
                LogWriter.writeLog("Exception " + exception + " with digest");
            }
            messageDigest.update(byArray3);
            byArray2 = new byte[this.ID.length() / 2];
            for (int i = 0; i < this.ID.length(); i += 2) {
                String string = this.ID.substring(i, i + 2);
                byArray2[i / 2] = (byte)Integer.parseInt(string, 16);
            }
            byArray2 = messageDigest.digest(byArray2);
            byArray2 = this.decrypt(byArray2, "", null, true);
            byte[] byArray5 = new byte[this.keyLength];
            for (int i = 1; i <= 19; ++i) {
                for (int j = 0; j < this.keyLength; ++j) {
                    byArray5[j] = (byte)(byArray4[j] ^ i);
                }
                this.encryptionKey = byArray5;
                byArray2 = this.decrypt(byArray2, "", null, true);
            }
            this.encryptionKey = byArray4;
            byArray3 = new byte[32];
            System.arraycopy(byArray2, 0, byArray3, 0, 16);
            System.arraycopy(byArray, 0, byArray3, 16, 16);
        }
        boolean bl = true;
        for (int i = 0; i < n; ++i) {
            if (this.U[i] == byArray3[i]) continue;
            bl = false;
            i = this.U.length;
        }
        return bl;
    }

    private void setKey() throws PdfSecurityException {
        MessageDigest messageDigest = null;
        byte[] byArray = this.getPaddedKey(this.encryptionPassword);
        try {
            messageDigest = MessageDigest.getInstance("MD5");
            this.encryptionKey = messageDigest.digest(byArray);
            if (this.rev == 3) {
                for (int i = 0; i < 50; ++i) {
                    this.encryptionKey = messageDigest.digest(this.encryptionKey);
                }
            }
        }
        catch (Exception exception) {
            throw new PdfSecurityException("Exception " + exception + " generating encryption key");
        }
    }

    private boolean testOwnerPassword() throws PdfSecurityException {
        byte[] byArray = this.encryptionPassword;
        byte[] byArray2 = new byte[this.keyLength];
        byte[] byArray3 = (byte[])this.O.clone();
        this.setKey();
        byte[] byArray4 = (byte[])this.encryptionKey.clone();
        if (this.rev == 2) {
            byArray2 = this.decrypt(byArray3, "", null, false);
        } else if (this.rev == 3) {
            byArray2 = byArray3;
            byte[] byArray5 = new byte[this.keyLength];
            for (int i = 19; i >= 0; --i) {
                for (int j = 0; j < this.keyLength; ++j) {
                    byArray5[j] = (byte)(byArray4[j] ^ i);
                }
                this.encryptionKey = byArray5;
                byArray2 = this.decrypt(byArray2, "", null, false);
            }
        }
        this.encryptionPassword = byArray2;
        this.setKey();
        boolean bl = this.testUserPassword();
        if (!bl) {
            this.encryptionPassword = byArray;
            this.setKey();
        }
        return bl;
    }

    private final String findOffsets() throws PdfSecurityException {
        String string;
        block7: {
            LogWriter.writeLog("Corrupt xref table - trying to find objects manually");
            string = "";
            try {
                this.movePointer(0L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            while (true) {
                int n;
                String string2 = null;
                int n2 = (int)this.getPointer();
                try {
                    string2 = this.pdf_datafile.readLine();
                }
                catch (Exception exception) {
                    LogWriter.writeLog("Exception " + exception + " reading line");
                }
                if (string2 == null) break block7;
                if (string2.indexOf(" obj") != -1) {
                    int n3 = string2.indexOf(" ");
                    if (n3 <= -1) continue;
                    n = Integer.parseInt(string2.substring(0, n3));
                    this.storeObjectOffset(n, n2, 1, false);
                    continue;
                }
                if (string2.indexOf("Root") != -1) {
                    int n4 = string2.indexOf("Root") + 4;
                    n = string2.indexOf("R", n4);
                    if (n <= -1) continue;
                    string = string2.substring(n4, n + 1).trim();
                    continue;
                }
                if (string2.indexOf("/Encrypt") != -1) break;
            }
            throw new PdfSecurityException("Corrupted, encrypted file");
        }
        return string;
    }

    public final void readEncryptionObject(String string) throws PdfSecurityException {
        int n;
        int n2;
        String string2;
        if (!this.isInitialised) {
            this.isInitialised = true;
            SetSecurity.init();
        }
        Map map = this.readObject(string, true, null);
        String string3 = (String)map.get("Filter");
        int n3 = 1;
        String string4 = (String)map.get("V");
        if (string4 != null) {
            n3 = Integer.parseInt(string4);
        }
        if ((string4 = (String)map.get("Length")) != null) {
            this.keyLength = Integer.parseInt(string4) / 8;
        }
        if (n3 > 2 | string3.indexOf("Standard") == -1) {
            throw new PdfSecurityException("Unsupported Encryption method " + map);
        }
        this.rev = Integer.parseInt((String)map.get("R"));
        this.P = Integer.parseInt((String)map.get("P"));
        Object v = map.get("O");
        if (v instanceof String) {
            string2 = (String)v;
            int n4 = string2.length() / 2;
            this.O = new byte[n4];
            for (n2 = 0; n2 < n4; ++n2) {
                n = n2 * 2;
                this.O[n2] = (byte)Integer.parseInt(string2.substring(n, n + 2), 16);
            }
        } else {
            this.O = (byte[])v;
        }
        if ((string2 = map.get("U")) instanceof String) {
            String string5 = string2;
            n2 = string5.length() / 2;
            this.U = new byte[n2];
            for (n = 0; n < n2; ++n) {
                int n5 = n * 2;
                this.U[n] = (byte)Integer.parseInt(string5.substring(n5, n5 + 2), 16);
            }
        } else {
            this.U = (byte[])string2;
        }
        this.isEncrypted = true;
        this.isFileViewable = false;
        LogWriter.writeLog("File has encryption settings");
        try {
            this.verifyAccess();
        }
        catch (PdfSecurityException pdfSecurityException) {
            LogWriter.writeLog("File requires password");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void verifyAccess() throws PdfSecurityException {
        this.isPasswordSupplied = false;
        this.extractionIsAllowed = false;
        boolean bl = this.testOwnerPassword();
        if (!bl) {
            boolean bl2 = this.testUserPassword();
            if (!bl2) throw new PdfSecurityException("No valid password supplied");
            if (this.encryptionPassword.length > 0) {
                LogWriter.writeLog("Correct user password supplied ");
            }
            this.isFileViewable = true;
            this.isPasswordSupplied = true;
            if ((this.P & 0x10) != 16) return;
            this.extractionIsAllowed = true;
            return;
        } else {
            LogWriter.writeLog("Correct owner password supplied");
            this.isFileViewable = true;
            this.isPasswordSupplied = true;
            this.extractionIsAllowed = true;
        }
    }

    private byte[] calculateKey(byte[] byArray, int n, String string) throws PdfSecurityException {
        byte[] byArray2;
        MessageDigest messageDigest = null;
        byte[] byArray3 = null;
        byte[] byArray4 = this.getPaddedKey(this.encryptionPassword);
        try {
            int n2;
            messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.update(byArray4);
            messageDigest.update(byArray);
            byArray2 = new byte[]{(byte)(n & 0xFF), (byte)(n >> 8 & 0xFF), (byte)(n >> 16 & 0xFF), (byte)(n >> 24 & 0xFF)};
            messageDigest.update(byArray2);
            byArray3 = new byte[string.length() / 2];
            for (n2 = 0; n2 < string.length(); n2 += 2) {
                String string2 = string.substring(n2, n2 + 2);
                byArray3[n2 / 2] = (byte)Integer.parseInt(string2, 16);
            }
            byArray3 = messageDigest.digest(byArray3);
            if (this.rev == 3) {
                for (n2 = 0; n2 < 50; ++n2) {
                    byArray3 = messageDigest.digest(byArray3);
                }
            }
        }
        catch (Exception exception) {
            throw new PdfSecurityException("Exception " + exception + " generating encryption key");
        }
        byArray2 = new byte[this.keyLength];
        System.arraycopy(byArray3, 0, byArray2, 0, this.keyLength);
        return byArray2;
    }

    private final void readInformationObject(String string) {
        try {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            String[] stringArray = this.currentFileInformation.getFieldNames();
            for (int i = 0; i < stringArray.length; ++i) {
                hashMap.put(stringArray[i], "z");
            }
            Map map = this.readObject(string, false, hashMap);
            for (int i = 0; i < stringArray.length; ++i) {
                String string2;
                Object v = map.get(stringArray[i]);
                if (v == null) continue;
                if (v instanceof byte[]) {
                    string2 = this.getTextString((byte[])v);
                    this.currentFileInformation.setFieldValue(i, string2);
                    continue;
                }
                if (!(v instanceof String)) continue;
                string2 = (String)v;
                if (string2.indexOf("False") != -1) {
                    this.currentFileInformation.setFieldValue(i, "False");
                    continue;
                }
                if (string2.indexOf("False") == -1) continue;
                this.currentFileInformation.setFieldValue(i, "True");
            }
        }
        catch (Exception exception) {
            System.out.println(" problem with info");
            LogWriter.writeLog("Exception " + exception + " reading information object " + string);
        }
    }

    public byte[] getPdfBuffer() {
        return this.pdf_datafile.getPdfBuffer();
    }

    public String getTextString(byte[] byArray) {
        StandardFonts.checkLoaded(6);
        String string = "";
        StringBuffer stringBuffer = new StringBuffer();
        TextTokens textTokens = new TextTokens(byArray);
        if (textTokens.isUnicode()) {
            while (textTokens.hasMoreTokens()) {
                char c = textTokens.nextUnicodeToken();
                if (c == '\t') {
                    stringBuffer.append(' ');
                    continue;
                }
                if (c <= '\u001f') continue;
                stringBuffer.append(c);
            }
        } else {
            while (textTokens.hasMoreTokens()) {
                char c = textTokens.nextToken();
                if (c == '\t') {
                    stringBuffer.append(' ');
                    continue;
                }
                if (c <= '\u001f') continue;
                stringBuffer.append(StandardFonts.getEncodedChar(6, c));
            }
        }
        return stringBuffer.toString();
    }

    public void readNames(Object object) {
        block37: {
            String string;
            Map map;
            block38: {
                String string2;
                Object v;
                block36: {
                    map = null;
                    map = object instanceof String ? this.readObject((String)object, false, null) : (Map)object;
                    v = map.get("Dests");
                    String string3 = this.getValue((String)map.get("Names"));
                    if (string3 == null) break block36;
                    String string4 = Strip.removeArrayDeleminators(string3);
                    if (string4.startsWith("<feff")) {
                        StringTokenizer stringTokenizer = new StringTokenizer(string4);
                        while (stringTokenizer.hasMoreTokens()) {
                            String string5 = stringTokenizer.nextToken();
                            string5 = string5.substring(1, string5.length() - 1);
                            String string6 = stringTokenizer.nextToken() + " " + stringTokenizer.nextToken() + " " + stringTokenizer.nextToken();
                            this.nameLookup.put(string5, string6);
                        }
                    } else if (string4.indexOf("(") != -1) {
                        byte[] byArray = this.readObjectAsByteArray((String)object, false);
                        int n = byArray.length;
                        int n2 = 0;
                        while (byArray[n2] != 47 || byArray[n2 + 1] != 78 || byArray[n2 + 2] != 97 || byArray[n2 + 3] != 109 || byArray[n2 + 4] != 101 || byArray[n2 + 5] != 115) {
                            ++n2;
                        }
                        n2 += 5;
                        while (n2 < n) {
                            while (byArray[n2] != 40) {
                                ++n2;
                            }
                            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                            try {
                                int n3;
                                StringBuffer stringBuffer;
                                if (byArray[n2 + 1] != 41) {
                                    while (true) {
                                        boolean bl = false;
                                        if (byArray[++n2] == 92 && (byArray[n2 - 1] != 92 || byArray[n2 - 1] == 92 && byArray[n2 - 2] == 92)) {
                                            if (byArray[++n2] == 98) {
                                                byArray[n2] = 8;
                                            } else if (byArray[n2] == 110) {
                                                byArray[n2] = 10;
                                            } else if (byArray[n2] == 116) {
                                                byArray[n2] = 9;
                                            } else if (byArray[n2] == 114) {
                                                byArray[n2] = 13;
                                            } else if (byArray[n2] == 102) {
                                                byArray[n2] = 12;
                                            } else if (Character.isDigit((char)byArray[n2])) {
                                                stringBuffer = new StringBuffer(3);
                                                for (n3 = 0; n3 < 3; ++n3) {
                                                    stringBuffer.append((char)byArray[n2]);
                                                    ++n2;
                                                }
                                                bl = true;
                                                byArray[--n2] = (byte)Integer.parseInt(stringBuffer.toString(), 8);
                                            }
                                        }
                                        if (!bl && byArray[n2] == 41 && (byArray[n2 - 1] != 92 || byArray[n2 - 1] == 92 && byArray[n2 - 2] == 92)) break;
                                        byteArrayOutputStream.write(byArray[n2]);
                                    }
                                }
                                byteArrayOutputStream.close();
                                byte[] byArray2 = byteArrayOutputStream.toByteArray();
                                byArray2 = this.decrypt(byArray2, (String)object, null, false);
                                stringBuffer = new StringBuffer();
                                ++n2;
                                while (byArray[n2] == 32 | byArray[n2] == 10 | byArray[n2] == 13) {
                                    ++n2;
                                }
                                n3 = n2;
                                while (byArray[n3] == 32) {
                                    ++n3;
                                }
                                boolean bl = false;
                                while (byArray[n3] != 40 & n3 + 1 < n) {
                                    if (byArray[n3] == 91) {
                                        bl = true;
                                    }
                                    if (byArray[n3] == 93) break;
                                    ++n3;
                                }
                                if (bl) {
                                    n3 += 2;
                                }
                                int n4 = n3;
                                if (!bl && byArray[n3] == 93) {
                                    n4 = n;
                                }
                                while (byArray[n3] == 32) {
                                    --n3;
                                }
                                int n5 = n3 - n2;
                                stringBuffer = new StringBuffer(n5);
                                for (int i = 0; i < n5; ++i) {
                                    stringBuffer.append((char)byArray[i + n2]);
                                    if ((!bl && byArray[i + n2] == 82) | byArray[i + n2] == 93) break;
                                }
                                this.nameLookup.put(this.getTextString(byArray2), stringBuffer.toString());
                                n2 = n4;
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                        }
                    } else {
                        LogWriter.writeLog("Name list format not supported");
                    }
                    break block37;
                }
                if (v == null) break block38;
                Map map2 = null;
                map2 = v instanceof String ? this.readObject((String)v, false, null) : (Map)v;
                String string7 = (String)map2.get("Kids");
                if (string7 == null || (string2 = Strip.removeArrayDeleminators(this.getValue((String)map2.get("Kids")))).length() <= 0) break block37;
                StringTokenizer stringTokenizer = new StringTokenizer(string2, "R");
                while (stringTokenizer.hasMoreTokens()) {
                    this.readNames(stringTokenizer.nextToken().trim() + " R");
                }
                break block37;
            }
            String string8 = (String)map.get("Kids");
            if (string8 != null && (string = Strip.removeArrayDeleminators(this.getValue((String)map.get("Kids")))).length() > 0) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, "R");
                while (stringTokenizer.hasMoreTokens()) {
                    this.readNames(stringTokenizer.nextToken().trim() + " R");
                }
            }
        }
    }

    public String convertNameToRef(String string) {
        return (String)this.nameLookup.get(string);
    }

    public void flattenValuesInObject(boolean bl, boolean bl2, Map map, Map map2, Map map3, PageLookup pageLookup, String object) {
        if (bl) {
            map2.put("PageNumber", "1");
        }
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            HashMap hashMap;
            Object object2;
            String string = (String)iterator.next();
            Object object3 = null;
            if (string.equals("P")) {
                try {
                    object2 = map.get("P");
                    if (object2 != null && pageLookup != null && object2 instanceof String) {
                        int n = pageLookup.convertObjectToPageNumber((String)object2);
                        map2.put("PageNumber", "" + n);
                    }
                }
                catch (Exception exception) {}
            } else if (string.equals("Stream")) {
                object2 = this.readStream(map, (String)object, false);
                map2.put("DecodedStream", object2);
            } else if (!string.equals("Kids") && !string.equals("Parent")) {
                object3 = map.get(string);
            } else if (bl2 && string.equals("Kids") && (object2 = (String)map.get("Kids")) != null) {
                HashMap hashMap2 = new HashMap();
                if (((String)object2).startsWith("[")) {
                    object2 = ((String)object2).substring(1, ((String)object2).length() - 1).trim();
                }
                StringTokenizer stringTokenizer = new StringTokenizer((String)object2, "R");
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken().trim() + " R";
                    hashMap = new HashMap();
                    this.flattenValuesInObject(true, bl2, this.readObject(string2, false, map3), hashMap, map3, pageLookup, (String)object);
                    hashMap2.put(string2, hashMap);
                }
                map2.put("Kids", hashMap2);
            }
            if (object3 == null) continue;
            if (string.equals("rawValue")) {
                if (object3 instanceof byte[] && (object2 = (Object)this.getByteTextStringValue(object3, map3)) != null) {
                    object3 = this.getTextString((byte[])object2);
                }
            } else if (map3 != null && map3.get(string) != null && object3 instanceof byte[] && (object2 = (Object)this.getByteTextStringValue(object3, map3)) != null) {
                object3 = this.getTextString((byte[])object2);
            }
            if (object3 instanceof String) {
                object2 = object3.toString();
                StringTokenizer stringTokenizer = new StringTokenizer((String)object2);
                if (stringTokenizer.countTokens() == 3) {
                    int n = ((String)object2).indexOf(" R");
                    int n2 = ((String)object2).indexOf(" R", n + 1);
                    if (n2 == -1 && ((String)object2).endsWith("]") && ((String)object2).indexOf(" R") != -1) {
                        object = object2 = Strip.removeArrayDeleminators((String)object2);
                        hashMap = new HashMap();
                        this.flattenValuesInObject(bl, bl2, this.readObject((String)object2, false, map3), hashMap, map3, pageLookup, (String)object);
                        map2.put(string, hashMap);
                        continue;
                    }
                    if (n2 == -1 && ((String)object2).endsWith(" R")) {
                        hashMap = new HashMap();
                        object = object2;
                        this.flattenValuesInObject(bl, bl2, this.readObject((String)object2, false, map3), hashMap, map3, pageLookup, (String)object);
                        map2.put(string, hashMap);
                        continue;
                    }
                    map2.put(string, object3);
                    continue;
                }
                map2.put(string, object3);
                continue;
            }
            if (object3 instanceof Map) {
                object2 = (Map)object3;
                HashMap hashMap3 = new HashMap();
                this.flattenValuesInObject(bl, bl2, (Map)object2, hashMap3, map3, pageLookup, (String)object);
                map2.put(string, hashMap3);
                continue;
            }
            map2.put(string, object3);
        }
    }

    public void setCacheSize(int n) {
        this.miniumumCacheSize = n;
    }
}

