/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io;

import java.util.StringTokenizer;
import org.jpedal.exception.PdfException;
import org.jpedal.io.RandomAccessBuffer;
import org.jpedal.io.RandomAccessDataBuffer;
import org.jpedal.io.RandomAccessFileBuffer;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.repositories.Vector_Int;
import org.jpedal.utils.repositories.Vector_boolean;

public class PdfFileReader {
    protected RandomAccessBuffer pdf_datafile = null;
    protected int currentGeneration = 0;
    protected long eof = 0L;
    protected Vector_Int offset = new Vector_Int(2000);
    protected Vector_boolean isCompressed = new Vector_boolean(2000);
    private Vector_Int generation = new Vector_Int(2000);

    protected final long movePointer(String string) {
        long l = this.getOffset(string);
        return this.movePointer(l);
    }

    public final String getType() {
        String string = "";
        try {
            this.movePointer(0L);
            string = this.pdf_datafile.readLine();
            int n = string.indexOf("%PDF");
            if (n != -1) {
                string = string.substring(n + 5);
            }
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " in reading type");
        }
        return string;
    }

    public final void openPdfFile(String string) throws PdfException {
        try {
            this.pdf_datafile = new RandomAccessFileBuffer(string, "r");
            this.eof = this.pdf_datafile.length();
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " accessing file");
            throw new PdfException("Exception " + exception + " accessing file");
        }
    }

    public final void openPdfFile(byte[] byArray) throws PdfException {
        try {
            this.pdf_datafile = new RandomAccessDataBuffer(byArray);
            this.eof = this.pdf_datafile.length();
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " accessing file");
            throw new PdfException("Exception " + exception + " accessing file");
        }
        LogWriter.writeMethod("{openPdfFile} EOF=" + this.eof, 0);
    }

    protected final long movePointer(long l) {
        long l2 = 0L;
        try {
            if (l > this.pdf_datafile.length()) {
                LogWriter.writeLog("Attempting to access ref outside file");
            } else {
                l2 = this.getPointer();
                this.pdf_datafile.seek(l);
            }
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " moving pointer to  " + l + " in file. EOF =" + this.eof);
        }
        return l2;
    }

    protected final long getPointer() {
        long l = 0L;
        try {
            l = this.pdf_datafile.getFilePointer();
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " getting pointer in file");
        }
        return l;
    }

    public final void closePdfFile() {
        try {
            if (this.pdf_datafile != null) {
                this.pdf_datafile.close();
                this.pdf_datafile = null;
            }
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " closing file");
        }
    }

    protected final void storeObjectOffset(int n, int n2, int n3, boolean bl) {
        int n4 = 0;
        int n5 = 0;
        if (n < this.generation.getCapacity()) {
            n4 = this.generation.elementAt(n);
            n5 = this.offset.elementAt(n);
        }
        if (n4 < n3 | n5 == 0) {
            this.offset.setElementAt(n2, n);
            this.generation.setElementAt(n3, n);
            this.isCompressed.setElementAt(bl, n);
        }
    }

    protected final int getCompressedStreamObject(String string) {
        int n = 0;
        if (string.endsWith("R")) {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            n = Integer.parseInt(stringTokenizer.nextToken());
            this.currentGeneration = Integer.parseInt(stringTokenizer.nextToken());
        } else {
            LogWriter.writeLog("Error with reference .." + string);
        }
        return this.offset.elementAt(n);
    }

    protected final int getOffset(String string) {
        int n = 0;
        if (string.endsWith("R")) {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            n = Integer.parseInt(stringTokenizer.nextToken());
            this.currentGeneration = Integer.parseInt(stringTokenizer.nextToken());
        } else {
            LogWriter.writeLog("Error with reference .." + string);
        }
        return this.offset.elementAt(n);
    }

    protected final int getOffsetInCompressedStream(String string) {
        int n = 0;
        if (string.endsWith("R")) {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            n = Integer.parseInt(stringTokenizer.nextToken());
            this.currentGeneration = Integer.parseInt(stringTokenizer.nextToken());
        } else {
            LogWriter.writeLog("Error with reference .." + string);
        }
        return this.generation.elementAt(n);
    }

    protected final int getGen(String string) {
        int n = 0;
        if (string.endsWith("R")) {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            n = Integer.parseInt(stringTokenizer.nextToken());
            this.currentGeneration = Integer.parseInt(stringTokenizer.nextToken());
        } else {
            LogWriter.writeLog("Error with reference .." + string);
        }
        return this.generation.elementAt(n);
    }

    protected final boolean isCompressed(String string) {
        int n = 0;
        if (string.endsWith("R")) {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            n = Integer.parseInt(stringTokenizer.nextToken());
            this.currentGeneration = Integer.parseInt(stringTokenizer.nextToken());
        } else {
            LogWriter.writeLog("Error with reference .." + string);
        }
        return this.isCompressed.elementAt(n);
    }
}

