/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGImageDecoder;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.media.jai.JAI;
import org.jpedal.io.ColorSpaceConvertor;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Strip;

public class ObjectStore {
    private static final String separator = System.getProperty("file.separator");
    private String currentFilename = "";
    private static String temp_dir = "";
    private String cmyk_dir = temp_dir + "cmyk" + separator;
    private String key = "jpedal" + Math.random();
    private Map image_type = new Hashtable();
    private Map tempFileNames = new HashMap();
    public String fullFileName;

    public String getCurrentFilename() {
        return this.currentFilename;
    }

    public final void storeFileName(String string) {
        this.fullFileName = string;
        int n = string.indexOf("\\");
        if (n == -1) {
            n = string.indexOf("/");
        }
        while (n != -1) {
            if ((n = (string = string.substring(n + 1)).indexOf("\\")) != -1) continue;
            n = string.indexOf("/");
        }
        int n2 = string.lastIndexOf(".");
        if (n2 != -1) {
            string = string.substring(0, n2);
        }
        string = Strip.stripAllSpaces(string);
        this.currentFilename = string.toLowerCase();
    }

    public boolean saveRawCMYKImage(byte[] byArray, String string) {
        boolean bl = true;
        File file = new File(this.cmyk_dir);
        if (!file.exists()) {
            file.mkdirs();
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.cmyk_dir + string + ".jpg");
            this.tempFileNames.put(this.cmyk_dir + string + ".jpg", "#");
            fileOutputStream.write(byArray);
            fileOutputStream.flush();
            fileOutputStream.close();
        }
        catch (Exception exception) {
            LogWriter.writeLog("Unable to save CMYK jpeg " + string);
            bl = false;
        }
        return bl;
    }

    public final boolean saveStoredImage(String string, BufferedImage bufferedImage, boolean bl, boolean bl2, String string2) {
        boolean bl3 = false;
        int n = bufferedImage.getType();
        File file = new File(temp_dir);
        if (!file.exists()) {
            file.mkdirs();
        }
        if (string2.indexOf("tif") != -1) {
            if (n == 1 | n == 2 && string.indexOf("HIRES_") != 0) {
                bufferedImage = ColorSpaceConvertor.convertColorspace(bufferedImage, 5);
            }
            if (!bl) {
                this.image_type.put(string, "tif");
            }
            bl3 = this.saveStoredImage("TIFF", ".tif", ".tiff", string, bufferedImage, bl, bl2);
        } else if (string2.indexOf("jpg") != -1) {
            if (!bl) {
                this.image_type.put(string, "jpg");
            }
            bl3 = this.saveStoredJPEGImage(string, bufferedImage, bl, bl2);
        } else if (string2.indexOf("png") != -1) {
            if (!bl) {
                this.image_type.put(string, "png");
            }
            bl3 = this.saveStoredImage("PNG", ".png", ".png", string, bufferedImage, bl, bl2);
        }
        bufferedImage = null;
        return bl3;
    }

    public final String getImageType(String string) {
        return (String)this.image_type.get(string);
    }

    public final void init(String string) {
        this.key = string + System.currentTimeMillis();
        File file = new File(temp_dir);
        if (!file.exists()) {
            file.mkdirs();
        }
    }

    public final BufferedImage loadStoredImage(String string) {
        String string2 = (String)this.image_type.get(string);
        BufferedImage bufferedImage = null;
        if (string2 == null) {
            return null;
        }
        if (string2.equals("tif")) {
            bufferedImage = this.loadStoredImage(string, ".tif");
        } else if (string2.equals("jpg")) {
            bufferedImage = this.loadStoredJPEGImage(string);
        } else if (string2.equals("png")) {
            bufferedImage = this.loadStoredImage(string, ".png");
        }
        return bufferedImage;
    }

    public final void flush() {
        Object object;
        if (temp_dir.length() > 2) {
            object = this.tempFileNames.keySet().iterator();
            while (object.hasNext()) {
                String string = (String)object.next();
                if (string.indexOf(this.key) == -1) continue;
                File file = new File(string);
                file.delete();
            }
        }
        if (((File)(object = new File(this.cmyk_dir))).exists()) {
            ((File)object).delete();
            object = null;
        }
    }

    public void copyCMYKimages(String string) {
        File file = new File(this.cmyk_dir);
        if (file.exists()) {
            String[] stringArray = file.list();
            if (stringArray.length > 0) {
                File file2;
                if (!string.endsWith(separator)) {
                    string = string + separator;
                }
                if (!(file2 = new File(string)).exists()) {
                    file2.mkdirs();
                }
                file2 = null;
            }
            for (int i = 0; i < stringArray.length; ++i) {
                File file3 = new File(this.cmyk_dir + stringArray[i]);
                File file4 = new File(string + stringArray[i]);
                file3.renameTo(file4);
            }
        }
        file = null;
    }

    private final boolean saveStoredJPEGImage(String string, BufferedImage bufferedImage, boolean bl, boolean bl2) {
        JPEGImageEncoder jPEGImageEncoder;
        BufferedOutputStream bufferedOutputStream;
        boolean bl3 = false;
        boolean bl4 = false;
        String string2 = string;
        String string3 = "";
        if (!bl) {
            string2 = temp_dir + this.key + string;
            string3 = temp_dir + this.key + "R" + string;
            this.image_type.put("R" + string, this.image_type.get(string));
        }
        if (!string2.toLowerCase().endsWith(".jpg") & !string2.toLowerCase().endsWith(".jpeg")) {
            string2 = string2 + ".jpg";
            string3 = string3 + ".jpg";
        }
        try {
            bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(new File(string2)));
            jPEGImageEncoder = JPEGCodec.createJPEGEncoder((OutputStream)bufferedOutputStream);
            jPEGImageEncoder.encode(bufferedImage);
            this.tempFileNames.put(string2, "#");
            bufferedOutputStream.close();
            bl4 = true;
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " writing image " + bufferedImage + " as " + string2);
        }
        if (!bl4) {
            try {
                bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(new File(string2)));
                jPEGImageEncoder = JPEGCodec.createJPEGEncoder((OutputStream)bufferedOutputStream);
                jPEGImageEncoder.encode(bufferedImage);
                this.tempFileNames.put(string2, "#");
                bufferedOutputStream.close();
            }
            catch (Exception exception) {
                bl3 = true;
                LogWriter.writeLog("Exception " + exception + " writing image " + bufferedImage);
            }
        }
        if (bl2) {
            this.saveCopy(string2, string3);
            this.tempFileNames.put(string3, "#");
        }
        return bl3;
    }

    private final BufferedImage loadStoredImage(String string, String string2) {
        String string3 = temp_dir + this.key + string + string2;
        BufferedImage bufferedImage = null;
        try {
            bufferedImage = JAI.create((String)"fileload", (Object)string3).getAsBufferedImage();
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " loading " + string);
        }
        return bufferedImage;
    }

    private final void saveCopy(String string, String string2) {
        BufferedInputStream bufferedInputStream = null;
        BufferedOutputStream bufferedOutputStream = null;
        try {
            int n;
            bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
            bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string2));
            byte[] byArray = new byte[65535];
            while ((n = bufferedInputStream.read(byArray)) != -1) {
                bufferedOutputStream.write(byArray, 0, n);
            }
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " copying file");
        }
        try {
            bufferedOutputStream.close();
            bufferedInputStream.close();
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " closing files");
        }
        bufferedOutputStream = null;
        bufferedInputStream = null;
    }

    public final void saveAsCopy(String string, String string2) {
        BufferedInputStream bufferedInputStream = null;
        BufferedOutputStream bufferedOutputStream = null;
        String string3 = temp_dir + this.key + string;
        try {
            int n;
            bufferedInputStream = new BufferedInputStream(new FileInputStream(string3));
            bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string2));
            byte[] byArray = new byte[65535];
            while ((n = bufferedInputStream.read(byArray)) != -1) {
                bufferedOutputStream.write(byArray, 0, n);
            }
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " copying file");
        }
        try {
            bufferedOutputStream.close();
            bufferedInputStream.close();
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " closing files");
        }
    }

    public static final void copy(String string, String string2) {
        BufferedInputStream bufferedInputStream = null;
        BufferedOutputStream bufferedOutputStream = null;
        try {
            int n;
            bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
            bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string2));
            byte[] byArray = new byte[65535];
            while ((n = bufferedInputStream.read(byArray)) != -1) {
                bufferedOutputStream.write(byArray, 0, n);
            }
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " copying file");
        }
        try {
            bufferedOutputStream.close();
            bufferedInputStream.close();
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " closing files");
        }
    }

    private final BufferedImage loadStoredJPEGImage(String string) {
        String string2 = temp_dir + this.key + string + ".jpg";
        BufferedImage bufferedImage = null;
        File file = new File(string2);
        if (file.exists()) {
            try {
                BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(string2));
                JPEGImageDecoder jPEGImageDecoder = JPEGCodec.createJPEGDecoder((InputStream)bufferedInputStream);
                bufferedImage = jPEGImageDecoder.decodeAsBufferedImage();
                bufferedInputStream.close();
            }
            catch (Exception exception) {
                LogWriter.writeLog("Exception " + exception + " loading " + string);
            }
        } else {
            bufferedImage = new BufferedImage(100, 100, 1);
        }
        return bufferedImage;
    }

    private final boolean saveStoredImage(String string, String string2, String string3, String string4, BufferedImage bufferedImage, boolean bl, boolean bl2) {
        boolean bl3 = false;
        String string5 = string4;
        String string6 = "";
        if (!bl) {
            string5 = temp_dir + this.key + string4;
            string6 = temp_dir + this.key + "R" + string4;
            this.image_type.put("R" + string4, this.image_type.get(string4));
        }
        if (!string5.toLowerCase().endsWith(string2) & !string5.toLowerCase().endsWith(string3)) {
            string5 = string5 + string2;
            string6 = string6 + string2;
        }
        try {
            if (bufferedImage.getType() == 12 && string.equals("TIFF")) {
                bufferedImage = ColorSpaceConvertor.convertToRGB(bufferedImage);
            }
            JAI.create((String)"filestore", (RenderedImage)bufferedImage, (Object)string5, (Object)string);
            this.tempFileNames.put(string5, "#");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            LogWriter.writeLog(" Exception " + exception + " writing image " + bufferedImage + " with type " + bufferedImage.getType());
            bl3 = true;
        }
        if (bl2) {
            this.saveCopy(string5, string6);
            this.tempFileNames.put(string6, "#");
        }
        return bl3;
    }

    static {
        try {
            temp_dir = System.getProperty("java.io.tmpdir") + separator + "jpedal" + separator;
            File file = new File(temp_dir);
            if (!file.exists()) {
                file.mkdirs();
            }
        }
        catch (Exception exception) {
            LogWriter.writeLog("Unable to create temp dir at " + temp_dir);
        }
    }
}

