/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.images;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import org.jpedal.color.ColorSpaces;
import org.jpedal.io.ColorSpaceConvertor;
import org.jpedal.objects.GraphicsState;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Matrix;

public class ImageTransformerDouble {
    double ny = 0.0;
    double nx = 0.0;
    private Area clip = null;
    private BufferedImage current_image;
    private float[][] Trm;
    private float[][] Trm1;
    private float[][] Trm2;
    private float[][] CTM;
    private int i_x = 0;
    private int i_y = 0;
    private int i_w = 0;
    private int i_h = 0;
    private float scale = 1.0f;
    private boolean scaleImage;
    private boolean hasClip = false;

    public ImageTransformerDouble(int n, GraphicsState graphicsState, BufferedImage bufferedImage, boolean bl) {
        this.scale = n / 72;
        this.current_image = bufferedImage;
        this.scaleImage = bl;
        this.CTM = graphicsState.CTM;
        this.createMatrices();
        if (graphicsState.getClippingShape() != null) {
            this.clip = (Area)graphicsState.getClippingShape().clone();
        }
        this.calcCoordinates();
    }

    public final void doubleScaleTransformShear() {
        this.scale(this.Trm1);
        int n = (int)((float)this.current_image.getHeight() * this.Trm2[1][1]);
        this.current_image = ColorSpaceConvertor.convertToARGB(this.current_image);
        if (this.clip != null) {
            Area area = (Area)this.clip.clone();
            this.clipImage(true, area, n);
            this.i_x = (int)this.clip.getBounds2D().getMinX();
            this.i_y = (int)this.clip.getBounds2D().getMinY();
            this.i_w = (int)(this.clip.getBounds2D().getMaxX() - (double)this.i_x);
            this.i_h = (int)(this.clip.getBounds2D().getMaxY() - (double)this.i_y);
        }
    }

    public final void createClippedHiresScreenImage() {
        this.scale(this.Trm1);
        int n = (int)((float)this.current_image.getHeight() * this.Trm2[1][1]);
        this.current_image = ColorSpaceConvertor.convertToARGB(this.current_image);
        if (this.clip != null) {
            Area area = (Area)this.clip.clone();
            this.clipHiresImage(true, area, n);
        }
    }

    public final void doubleScaleTransformScale() {
        if ((double)this.CTM[0][0] != 0.0 & (double)this.CTM[1][1] != 0.0) {
            this.scale(this.Trm2);
        }
    }

    public final void completeImage() {
        if (this.CTM[0][1] > 0.0f & this.CTM[1][0] > 0.0f) {
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.scale(-1.0, -1.0);
            affineTransform.translate(-this.current_image.getWidth(), -this.current_image.getHeight());
            AffineTransformOp affineTransformOp = new AffineTransformOp(affineTransform, ColorSpaces.hints);
            this.current_image = affineTransformOp.filter(this.current_image, null);
        }
        if (this.hasClip) {
            this.i_x = (int)this.clip.getBounds2D().getMinX();
            this.i_y = (int)this.clip.getBounds2D().getMinY();
            this.i_w = this.current_image.getWidth();
            this.i_h = this.current_image.getHeight();
        }
    }

    private void scale(float[][] fArray) {
        int n = this.current_image.getWidth();
        int n2 = this.current_image.getHeight();
        if ((double)fArray[0][0] != 1.0 | (double)fArray[1][1] != 1.0 | (double)fArray[0][1] != 0.0 | (double)fArray[1][0] != 0.0 | this.scale != 1.0f) {
            AffineTransform affineTransform = new AffineTransform(fArray[0][0] * this.scale, fArray[1][0] * this.scale, fArray[0][1] * this.scale, fArray[1][1] * this.scale, 0.0f, 0.0f);
            Area area = new Area(new Rectangle(0, 0, n, n2));
            area.transform(affineTransform);
            this.ny = area.getBounds2D().getY();
            this.nx = area.getBounds2D().getX();
            affineTransform = new AffineTransform((double)(fArray[0][0] * this.scale), (double)(fArray[1][0] * this.scale), (double)(fArray[0][1] * this.scale), (double)(fArray[1][1] * this.scale), -this.nx, -this.ny);
            AffineTransformOp affineTransformOp = n > 10 & n2 > 10 ? new AffineTransformOp(affineTransform, ColorSpaces.hints) : new AffineTransformOp(affineTransform, null);
            if (this.scaleImage) {
                this.current_image = affineTransformOp.filter(this.current_image, null);
            }
        }
    }

    private void createMatrices() {
        int n;
        int n2;
        int n3 = this.current_image.getWidth();
        int n4 = this.current_image.getHeight();
        this.Trm = new float[3][3];
        this.Trm[0][0] = this.CTM[0][0] / (float)n3;
        this.Trm[0][1] = this.CTM[0][1] / (float)n3;
        this.Trm[0][2] = 0.0f;
        this.Trm[1][0] = this.CTM[1][0] / (float)n4;
        this.Trm[1][1] = this.CTM[1][1] / (float)n4;
        this.Trm[1][2] = 0.0f;
        this.Trm[2][0] = this.CTM[2][0];
        this.Trm[2][1] = this.CTM[2][1];
        this.Trm[2][2] = 1.0f;
        for (n2 = 0; n2 < 3; ++n2) {
            for (n = 0; n < 3; ++n) {
                if (!((double)this.Trm[n][n2] > 0.99 & this.Trm[n][n2] < 1.0f)) continue;
                this.Trm[n][n2] = 1.0f;
            }
        }
        this.Trm1 = new float[3][3];
        this.Trm2 = new float[3][3];
        if ((double)this.CTM[0][0] == 0.0 | (double)this.CTM[1][1] == 0.0) {
            this.Trm1 = this.Trm;
        } else {
            this.Trm1[0][0] = 1.0f / (this.CTM[0][0] / (float)n3);
            this.Trm1[0][1] = 0.0f;
            this.Trm1[0][2] = 0.0f;
            this.Trm1[1][0] = 0.0f;
            this.Trm1[1][1] = 1.0f / (this.CTM[1][1] / (float)n4);
            this.Trm1[1][2] = 0.0f;
            this.Trm1[2][0] = 0.0f;
            this.Trm1[2][1] = 0.0f;
            this.Trm1[2][2] = 1.0f;
            this.Trm1 = Matrix.multiply(this.Trm, this.Trm1);
            for (n2 = 0; n2 < 3; ++n2) {
                for (n = 0; n < 3; ++n) {
                    if (!((double)this.Trm1[n][n2] > 0.99 & this.Trm1[n][n2] < 1.0f)) continue;
                    this.Trm1[n][n2] = 1.0f;
                }
            }
        }
        this.Trm2[0][0] = this.CTM[0][0] / (float)n3;
        this.Trm2[0][1] = 0.0f;
        this.Trm2[0][2] = 0.0f;
        this.Trm2[1][0] = 0.0f;
        this.Trm2[1][1] = this.CTM[1][1] / (float)n4;
        this.Trm2[1][2] = 0.0f;
        this.Trm2[2][0] = 0.0f;
        this.Trm2[2][1] = 0.0f;
        this.Trm2[2][2] = 1.0f;
        for (n2 = 0; n2 < 3; ++n2) {
            for (n = 0; n < 3; ++n) {
                if (!((double)this.Trm2[n][n2] > 0.99 & this.Trm2[n][n2] < 1.0f)) continue;
                this.Trm2[n][n2] = 1.0f;
            }
        }
    }

    private final void calcCoordinates() {
        if (this.CTM[1][0] == 0.0f & this.CTM[0][1] == 0.0f) {
            this.i_x = (int)this.CTM[2][0];
            this.i_y = (int)this.CTM[2][1];
            this.i_w = (int)this.CTM[0][0];
            this.i_h = (int)this.CTM[1][1];
            if (this.i_w < 0) {
                this.i_w = -this.i_w;
            }
            if (this.i_h < 0) {
                this.i_h = -this.i_h;
            }
        } else {
            this.i_w = (int)Math.sqrt(this.CTM[0][0] * this.CTM[0][0] + this.CTM[0][1] * this.CTM[0][1]);
            this.i_h = (int)Math.sqrt(this.CTM[1][1] * this.CTM[1][1] + this.CTM[1][0] * this.CTM[1][0]);
            if (this.CTM[1][0] > 0.0f & this.CTM[0][1] < 0.0f) {
                this.i_x = (int)this.CTM[2][0];
                this.i_y = (int)(this.CTM[2][1] + this.CTM[0][1]);
            } else if (this.CTM[1][0] < 0.0f & this.CTM[0][1] > 0.0f) {
                this.i_x = (int)(this.CTM[2][0] + this.CTM[1][0]);
                this.i_y = (int)this.CTM[2][1];
            } else if (this.CTM[1][0] > 0.0f & this.CTM[0][1] > 0.0f) {
                this.i_x = (int)this.CTM[2][0];
                this.i_y = (int)this.CTM[2][1];
            } else {
                this.i_x = (int)this.CTM[2][0];
                this.i_y = (int)this.CTM[2][1];
            }
        }
        if (this.CTM[1][1] < 0.0f) {
            this.i_y -= this.i_h;
        }
        if (this.CTM[0][0] < 0.0f) {
            this.i_x -= this.i_w;
        }
    }

    public final int getImageY() {
        return this.i_y;
    }

    public final BufferedImage getImage() {
        return this.current_image;
    }

    public final int getImageW() {
        return this.i_w;
    }

    public final int getImageH() {
        return this.i_h;
    }

    public final int getImageX() {
        return this.i_x;
    }

    public final void clipImage(boolean bl, Area area, int n) {
        if (this.scale != 1.0f) {
            AffineTransform affineTransform = AffineTransform.getScaleInstance(this.scale, this.scale);
            area.transform(affineTransform);
        }
        double d = area.getBounds2D().getX();
        double d2 = area.getBounds2D().getY();
        double d3 = area.getBounds2D().getHeight();
        int n2 = this.current_image.getWidth();
        int n3 = this.current_image.getHeight();
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.scale(1.0, -1.0);
        affineTransform.translate(0.0, -this.current_image.getHeight());
        AffineTransformOp affineTransformOp = new AffineTransformOp(affineTransform, ColorSpaces.hints);
        this.current_image = affineTransformOp.filter(this.current_image, null);
        AffineTransform affineTransform2 = new AffineTransform();
        double d4 = -d3;
        double d5 = -this.CTM[2][0] * this.scale;
        double d6 = -(this.CTM[2][1] * this.scale);
        if (this.CTM[1][0] < 0.0f) {
            d5 -= (double)this.CTM[1][0];
        }
        if (this.CTM[0][0] < 0.0f && this.CTM[1][0] > 0.0f) {
            d5 -= (double)this.CTM[1][0];
        }
        if (this.CTM[0][1] < 0.0f) {
            d6 -= (double)this.CTM[0][1];
        }
        if (this.CTM[1][1] < 0.0f && this.CTM[0][1] > 0.0f) {
            d5 -= (double)this.CTM[0][1];
        }
        affineTransform2.translate(d5, d6);
        area.transform(affineTransform2);
        AffineTransform affineTransform3 = new AffineTransform(1.0f / this.Trm2[0][0], 0.0f, 0.0f, 1.0f / this.Trm2[1][1], 0.0f, 0.0f);
        area.transform(affineTransform3);
        int n4 = (int)area.getBounds().getX();
        int n5 = (int)area.getBounds().getY();
        int n6 = (int)area.getBounds().getWidth();
        int n7 = (int)area.getBounds().getHeight();
        Area area2 = new Area(new Rectangle(0, 0, n2, n3));
        area2.exclusiveOr(area);
        Graphics2D graphics2D = this.current_image.createGraphics();
        graphics2D.setComposite(AlphaComposite.Clear);
        graphics2D.fill(area2);
        AffineTransform affineTransform4 = new AffineTransform();
        affineTransform4.scale(1.0, -1.0);
        affineTransform4.translate(0.0, -this.current_image.getHeight());
        AffineTransformOp affineTransformOp2 = new AffineTransformOp(affineTransform4, ColorSpaces.hints);
        this.current_image = this.current_image.getSubimage(0, 0, this.current_image.getWidth(), this.current_image.getHeight());
        this.current_image = affineTransformOp2.filter(this.current_image, null);
        if (n5 < 0) {
            n7 -= n5;
            n5 = 0;
        } else if ((n5 = n3 - n7 - n5) < 0) {
            n5 = 0;
        }
        if (n4 < 0) {
            n6 -= n4;
            n4 = 0;
        }
        if (n6 > n2) {
            n6 = n2;
        }
        if (n7 > n3) {
            n7 = n3;
        }
        if (n5 + n7 > n3) {
            n7 = n3 - n5;
        }
        if (n4 + n6 > n2) {
            n6 = n2 - n4;
        }
        try {
            this.current_image = this.current_image.getSubimage(n4, n5, n6, n7);
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " extracting clipped image with values x=" + n4 + " y=" + n5 + " w=" + n6 + " h=" + n7 + " from image " + this.current_image);
        }
        double d7 = (double)this.i_x > d ? (double)this.i_x : d;
        double d8 = (double)this.i_y > d2 ? (double)this.i_y : d2;
        this.i_x = (int)d7;
        this.i_y = (int)d8;
        this.i_w = n6;
        this.i_h = n7;
    }

    public final void clipHiresImage(boolean bl, Area area, int n) {
        double d = area.getBounds2D().getX();
        double d2 = area.getBounds2D().getY();
        double d3 = area.getBounds2D().getHeight();
        int n2 = this.current_image.getWidth();
        int n3 = this.current_image.getHeight();
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.scale(1.0, -1.0);
        affineTransform.translate(0.0, -this.current_image.getHeight());
        AffineTransformOp affineTransformOp = new AffineTransformOp(affineTransform, ColorSpaces.hints);
        this.current_image = affineTransformOp.filter(this.current_image, null);
        AffineTransform affineTransform2 = new AffineTransform();
        double d4 = -d3;
        double d5 = -this.CTM[2][0] * this.scale;
        double d6 = -(this.CTM[2][1] * this.scale);
        if (this.CTM[1][0] < 0.0f) {
            d5 -= (double)this.CTM[1][0];
        }
        if (this.CTM[0][0] < 0.0f && this.CTM[1][0] > 0.0f) {
            d5 -= (double)this.CTM[1][0];
        }
        if (this.CTM[0][1] < 0.0f) {
            d6 -= (double)this.CTM[0][1];
        }
        if (this.CTM[1][1] < 0.0f && this.CTM[0][1] > 0.0f) {
            d5 -= (double)this.CTM[0][1];
        }
        affineTransform2.translate(d5, d6);
        area.transform(affineTransform2);
        AffineTransform affineTransform3 = new AffineTransform(1.0f / this.Trm2[0][0], 0.0f, 0.0f, 1.0f / this.Trm2[1][1], 0.0f, 0.0f);
        area.transform(affineTransform3);
        int n4 = (int)area.getBounds().getX();
        int n5 = (int)area.getBounds().getY();
        int n6 = (int)area.getBounds().getWidth();
        int n7 = (int)area.getBounds().getHeight();
        Area area2 = new Area(new Rectangle(0, 0, n2, n3));
        area2.exclusiveOr(area);
        Graphics2D graphics2D = this.current_image.createGraphics();
        graphics2D.setComposite(AlphaComposite.Clear);
        graphics2D.fill(area2);
        AffineTransform affineTransform4 = new AffineTransform();
        affineTransform4.scale(1.0, -1.0);
        affineTransform4.translate(0.0, -this.current_image.getHeight());
        AffineTransformOp affineTransformOp2 = new AffineTransformOp(affineTransform4, ColorSpaces.hints);
        this.current_image = this.current_image.getSubimage(0, 0, this.current_image.getWidth(), this.current_image.getHeight());
        this.current_image = affineTransformOp2.filter(this.current_image, null);
    }
}

