/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.gui;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.net.URL;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.ImageIcon;
import org.jpedal.objects.PdfAnnots;
import org.jpedal.utils.LogWriter;

public class Hotspots {
    protected Rectangle[] pos;
    private String[] annotationTypes = new String[0];
    private Color[] annotationColors;
    private Stroke[] annotationStrokes;
    private Color[] borderColor;
    private Image[] icons;
    private String[] tooltips;
    private int[] annotationType;
    private Image[] AnnotationIcons;
    private Map annotationLookup = new HashMap();

    public void setHotspots(PdfAnnots pdfAnnots) {
        int n = pdfAnnots.getAnnotCount();
        if (n > 0) {
            this.annotationColors = new Color[n];
            this.icons = new Image[n];
            this.annotationStrokes = new Stroke[n];
            this.borderColor = new Color[n];
            this.tooltips = new String[n];
            this.pos = new Rectangle[n];
            this.annotationType = new int[n];
            for (int i = 0; i < n; ++i) {
                int n2;
                String string = pdfAnnots.getAnnotObjectArea(i);
                String string2 = pdfAnnots.getAnnotSubType(i);
                StringTokenizer stringTokenizer = new StringTokenizer(string);
                int[] nArray = new int[4];
                for (n2 = 0; n2 < 4; ++n2) {
                    nArray[n2] = (int)Float.parseFloat(stringTokenizer.nextToken());
                }
                n2 = nArray[1] - nArray[3];
                this.pos[i] = n2 > 0 ? new Rectangle(nArray[0], nArray[1] - n2, nArray[2] - nArray[0], n2) : new Rectangle(nArray[0], nArray[3] + n2, nArray[2] - nArray[0], -n2);
                this.annotationColors[i] = pdfAnnots.getAnnotColor(i);
                this.annotationStrokes[i] = pdfAnnots.getBorderStroke(i);
                this.borderColor[i] = pdfAnnots.getBorderColor(i);
                this.tooltips[i] = pdfAnnots.getField(i, "Contents");
                Object v = this.annotationLookup.get(string2);
                int n3 = 0;
                if (v != null) {
                    n3 = (Integer)this.annotationLookup.get(string2);
                }
                this.icons[i] = v == null ? null : this.AnnotationIcons[n3];
                this.annotationType[i] = n3;
            }
        } else {
            this.pos = null;
            this.annotationStrokes = null;
            this.annotationColors = null;
            this.icons = null;
            this.tooltips = null;
        }
    }

    public void flushAnnotationsDisplayed() {
        this.annotationColors = null;
        this.annotationStrokes = null;
        this.borderColor = null;
        this.pos = null;
    }

    public Hotspots(String[] stringArray, String string) {
        this.init(stringArray, string);
    }

    private void init(String[] stringArray, String string) {
        this.annotationTypes = stringArray;
        int n = stringArray.length;
        this.AnnotationIcons = new Image[stringArray.length];
        for (int i = 1; i < n; ++i) {
            URL uRL = null;
            try {
                uRL = this.getClass().getResource("\\" + string + stringArray[i] + ".gif");
            }
            catch (Exception exception) {
                LogWriter.writeLog("Exception " + exception + " Unable to log images for annotations");
            }
            if (uRL == null) continue;
            this.AnnotationIcons[i] = new ImageIcon(uRL).getImage();
            this.annotationLookup.put(stringArray[i], new Integer(i));
        }
    }

    public Hotspots() {
        String[] stringArray = new String[]{"Other", "Text", "FileAttachment"};
        this.init(stringArray, "org/jpedal/examples/simpleviewer/annots/");
    }

    public String getTooltip(Point point, Map map, int n) {
        String string = null;
        if (this.pos != null) {
            int n2 = this.pos.length;
            for (int i = 0; i < n2; ++i) {
                if (this.pos[i] == null || this.tooltips[i] == null || !this.pos[i].contains(point)) continue;
                string = this.tooltips[i];
                if (map != null && map.get(n + "-" + this.annotationTypes[this.annotationType[i]]) == null) {
                    string = null;
                }
                i = n2;
            }
        }
        return string;
    }

    public void addHotspotsToDisplay(Graphics2D graphics2D, Hashtable hashtable, int n) {
        block9: {
            if (this.pos == null) break block9;
            int n2 = this.pos.length;
            if (hashtable != null) {
                for (int i = 0; i < this.annotationTypes.length; ++i) {
                    Image[] imageArray = (Image[])hashtable.get(n + "-" + this.annotationTypes[i]);
                    int n3 = 0;
                    if (imageArray == null) continue;
                    for (int j = 0; j < n2; ++j) {
                        try {
                            if (imageArray[n3] != null) {
                                AffineTransform affineTransform = new AffineTransform();
                                affineTransform.translate(this.pos[j].x, this.pos[j].y + imageArray[n3].getHeight(null));
                                affineTransform.scale(1.0, -1.0);
                                graphics2D.drawImage(imageArray[n3], affineTransform, null);
                            }
                        }
                        catch (Exception exception) {
                            LogWriter.writeLog("Insufficient icons for page");
                            j = n2;
                        }
                        ++n3;
                    }
                }
            } else {
                for (int i = 0; i < n2; ++i) {
                    if (this.pos == null || this.pos[i] == null || this.icons == null || this.icons[i] == null) continue;
                    if (this.annotationStrokes[i] != null) {
                        graphics2D.setColor(this.borderColor[i]);
                        graphics2D.setStroke(this.annotationStrokes[i]);
                        graphics2D.draw(this.pos[i]);
                    }
                    AffineTransform affineTransform = new AffineTransform();
                    affineTransform.translate(this.pos[i].x, this.pos[i].y + this.icons[i].getHeight(null));
                    affineTransform.scale(1.0, -1.0);
                    if (this.icons[i] == null) continue;
                    graphics2D.drawImage(this.icons[i], affineTransform, null);
                }
            }
        }
    }

    public Rectangle[] getAnnotationhotSpots() {
        return this.pos;
    }
}

