/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.function;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Map;
import java.util.StringTokenizer;
import org.jpedal.function.Function;
import org.jpedal.io.PdfObjectReader;

class Sampled
extends Function {
    private float[] domain;
    private float[] encode;
    private float[] decode;
    int[] size;
    int order;
    float[] samples;

    Sampled(byte[] byArray, Map map, float[] fArray, float[] fArray2, PdfObjectReader pdfObjectReader) {
        int n;
        int n2;
        int n3 = Integer.parseInt((String)map.get("BitsPerSample"));
        String string = (String)map.get("Order");
        if (string != null) {
            this.order = Integer.parseInt(string);
        }
        string = pdfObjectReader.getValue((String)map.get("Size"));
        StringTokenizer stringTokenizer = new StringTokenizer(string, "[] ");
        this.size = new int[stringTokenizer.countTokens()];
        int n4 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            this.size[n4] = Integer.parseInt(stringTokenizer.nextToken());
            ++n4;
        }
        string = (String)map.get("Encode");
        if (string != null) {
            string = pdfObjectReader.getValue(string);
            stringTokenizer = new StringTokenizer(string, "[] ");
            this.encode = new float[stringTokenizer.countTokens()];
            n4 = 0;
            while (stringTokenizer.hasMoreTokens()) {
                this.encode[n4] = Float.parseFloat(stringTokenizer.nextToken());
                ++n4;
            }
        } else {
            n2 = this.size.length;
            this.encode = new float[n2 * 2];
            for (n = 0; n < n2; ++n) {
                this.encode[n * 2 + 1] = this.size[n] - 1;
            }
        }
        if ((string = (String)map.get("Decode")) != null) {
            string = pdfObjectReader.getValue(string);
            stringTokenizer = new StringTokenizer(string, "[] ");
            this.decode = new float[stringTokenizer.countTokens()];
            n4 = 0;
            while (stringTokenizer.hasMoreTokens()) {
                this.decode[n4] = Float.parseFloat(stringTokenizer.nextToken());
                ++n4;
            }
        } else {
            n2 = fArray2.length;
            this.decode = new float[n2];
            for (n = 0; n < n2; ++n) {
                this.decode[n] = fArray2[n];
            }
        }
        this.samples = new float[byArray.length];
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            long l = 0L;
            long l2 = (1L << n3) - 1L;
            float f = 1L << n3;
            int n5 = 0;
            for (int i = 0; i < byArray.length; ++i) {
                while (n5 < n3) {
                    l = (l << 8) + (long)((InputStream)byteArrayInputStream).read();
                    n5 += 8;
                }
                long l3 = l >> n5 - n3 & l2;
                n5 -= n3;
                this.samples[i] = (float)l3 / f;
            }
            ((InputStream)byteArrayInputStream).close();
        }
        catch (Exception exception) {
            System.out.println("Exception " + exception + " reading stream for separation colorspace");
        }
        this.domain = fArray;
        this.range = fArray2;
    }

    public final String[] compute(float[] fArray, float[] fArray2) {
        int n = this.range.length / 2;
        float[] fArray3 = new float[n];
        String[] stringArray = new String[n];
        try {
            this.compute(fArray, fArray3, fArray2);
            for (int i = 0; i < n; ++i) {
                stringArray[i] = "" + fArray3[n - i - 1];
            }
        }
        catch (Exception exception) {
            System.out.println("Sampled exception " + exception);
            exception.printStackTrace();
        }
        return stringArray;
    }

    public final void compute(float[] fArray, float[] fArray2, float[] fArray3) {
        this.clip(fArray, fArray3);
        int n = fArray3.length / 2;
        int n2 = this.range.length / 2;
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            float f = this.encode[i * 2];
            float f2 = fArray[i];
            float f3 = fArray3[i * 2];
            float f4 = this.encode[i * 2 + 1];
            float f5 = fArray3[i * 2 + 1];
            float f6 = f + (f2 - f3) * (f4 - f) / (f5 - f3);
            if (f6 < 0.0f) {
                f6 = 0.0f;
            } else if (f6 > (float)(this.size[i] - 1)) {
                f6 = this.size[i] - 1;
            }
            float f7 = (float)Math.ceil(f6);
            float f8 = f7 - f6;
            int n4 = (n3 + (int)f6) * n2;
            int n5 = (n3 + (int)f7) * n2;
            int n6 = this.range.length / 2;
            for (int j = 0; j < n6; ++j) {
                float f9;
                float f10 = this.samples[n4 + j];
                float f11 = this.samples[n5 + j];
                float f12 = this.order == 1 ? f10 * (1.0f - f8) + f8 * f11 : f10 * (1.0f - f8) + f8 * f11;
                f = this.decode[j * 2];
                f4 = this.decode[j * 2 + 1];
                fArray2[j] = f9 = f + f12 * (f4 - f);
            }
            n3 = (n3 > 0 ? n3 : 1) * this.size[i];
        }
        this.clip(fArray2, this.range);
    }
}

