/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts;

import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;
import org.jpedal.PdfDecoder;
import org.jpedal.exception.PdfFontException;
import org.jpedal.fonts.GlyphFactory;
import org.jpedal.fonts.PdfGlyph;
import org.jpedal.fonts.StandardFonts;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Strip;
import org.jpedal.utils.ToInteger;

public class PdfFont {
    public Font javaFont = null;
    private String[] cachedValue = new String[256];
    public boolean is1C = false;
    protected String substituteFont = null;
    protected Hashtable charStrings = new Hashtable();
    protected boolean renderPage = false;
    private final float xscale = 0.001f;
    protected float[][] lastTrm = new float[3][3];
    protected int embeddedEnc = 1;
    protected String[] diffs;
    protected String fontName = "default";
    public boolean isFontEmbedded = false;
    protected boolean TTstreamisCID = false;
    protected String fontID = "";
    protected int maxCharCount = 256;
    protected boolean hasEncoding = true;
    protected String baseFontName = "";
    private boolean isDoubleByte = false;
    protected boolean remapFont = false;
    protected String defaultFont = "Lucida Sans";
    private static FontRenderContext frc;
    protected int fontTypes;
    protected String substituteFontFile = null;
    protected String substituteFontName = null;
    private String[] diffTable;
    private int fontFlag = 0;
    private float[] widthTable;
    private Font unscaledFont = null;
    protected PdfObjectReader currentPdfFile;
    protected ClassLoader loader = this.getClass().getClassLoader();
    protected Area[] cachedShapes = null;
    public double[] FontMatrix = new double[]{0.001, 0.0, 0.0, 0.001, 0.0, 0.0};
    public float[] FontBBox = new float[]{0.0f, 0.0f, 1.0f, 1.0f};
    protected boolean isHex = false;
    private String[] unicodeMappings;
    protected int fontEnc = -1;
    protected boolean isCIDFont = false;
    protected String[] CMAP;
    protected String CIDfontEncoding;
    private float defaultWidth = 1.0f;
    protected boolean isFontSubstituted = false;
    protected boolean hasFontEncoding;
    private String font_family_name;
    private int style;
    private static String[] fontList;
    private static boolean isCidJarPresent;

    public PdfFont() {
    }

    public PdfFont(PdfObjectReader pdfObjectReader) {
        this.init(pdfObjectReader);
    }

    public void createFont(String string) throws Exception {
    }

    public static void setStandardFontMappings() {
        String string;
        String string2;
        int n;
        int n2 = StandardFonts.files_names.length;
        for (n = 0; n < n2; ++n) {
            string2 = StandardFonts.files_names_bis[n].toLowerCase();
            if (string2.equals(string = StandardFonts.javaFonts[n].toLowerCase()) || PdfDecoder.fontSubstitutionAliasTable.containsKey(string2)) continue;
            PdfDecoder.fontSubstitutionAliasTable.put(string2, string);
        }
        for (n = 0; n < n2; ++n) {
            string2 = StandardFonts.files_names[n].toLowerCase();
            if (!string2.equals(string = StandardFonts.javaFonts[n].toLowerCase()) && !PdfDecoder.fontSubstitutionAliasTable.containsKey(string2)) {
                PdfDecoder.fontSubstitutionAliasTable.put(string2, string);
            }
            StandardFonts.javaFontList.put(StandardFonts.files_names[n], "x");
        }
    }

    public boolean isFontSubstituted() {
        return this.isFontSubstituted;
    }

    public boolean isDoubleByte() {
        return this.isDoubleByte;
    }

    protected final void setCIDFontDefaultWidth(String string) {
        this.defaultWidth = Float.parseFloat(string) / 1000.0f;
    }

    protected final void setCIDFontWidths(String string) {
        string = string.substring(1, string.length() - 1).trim();
        this.widthTable = new float[65536];
        for (int i = 0; i < 65536; ++i) {
            this.widthTable[i] = -1.0f;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, " []", true);
        String string2 = "";
        block1: while (stringTokenizer.hasMoreTokens() && stringTokenizer.hasMoreTokens()) {
            while ((string2 = stringTokenizer.nextToken()).equals(" ")) {
            }
            int n = Integer.parseInt(string2);
            while ((string2 = stringTokenizer.nextToken()).equals(" ")) {
            }
            if (string2.equals("[")) {
                while (true) {
                    if ((string2 = stringTokenizer.nextToken()).equals(" ")) {
                        continue;
                    }
                    if (string2.equals("]")) continue block1;
                    this.widthTable[n] = Float.parseFloat(string2) / 1000.0f;
                    ++n;
                }
            }
            int n2 = 1 + Integer.parseInt(string2);
            while ((string2 = stringTokenizer.nextToken()).equals(" ")) {
            }
            for (int i = n; i < n2; ++i) {
                this.widthTable[i] = Float.parseFloat(string2) / 1000.0f;
            }
        }
    }

    public final boolean isCIDFont() {
        return this.isCIDFont;
    }

    protected final void init(PdfObjectReader pdfObjectReader) {
        this.currentPdfFile = pdfObjectReader;
        if (this.isCIDFont) {
            this.maxCharCount = 65536;
        }
    }

    private final String getUnicodeMapping(int n) {
        if (this.unicodeMappings == null) {
            return null;
        }
        return this.unicodeMappings[n];
    }

    protected final void putFontEncoding(int n) {
        this.fontEnc = n;
        StandardFonts.checkLoaded(n);
    }

    public Area getStandardGlyph(float[][] fArray, int n, String string, float f) {
        if (this.lastTrm[0][0] != fArray[0][0] | this.lastTrm[1][0] != fArray[1][0] | this.lastTrm[0][1] != fArray[0][1] | this.lastTrm[1][1] != fArray[1][1]) {
            this.lastTrm = fArray;
            this.cachedShapes = null;
        }
        Area area = this.getCachedShape(n);
        double d = -1.0;
        double d2 = 1.0;
        if (fArray[1][0] < 0.0f & fArray[0][1] >= 0.0f | fArray[0][1] < 0.0f & fArray[1][0] >= 0.0f) {
            d2 = 1.0;
            d = -1.0;
        }
        if (area == null) {
            String string2 = string;
            if (this.remapFont && !this.getUnscaledFont().canDisplay(string2.charAt(0))) {
                string2 = "" + (char)(n + 61440);
            }
            if ((area = this.getGlyph(n, string, f)) != null) {
                AffineTransform affineTransform = new AffineTransform(d2 * (double)fArray[0][0], d2 * (double)fArray[0][1], d * (double)fArray[1][0], d * (double)fArray[1][1], 0.0, 0.0);
                area.transform(affineTransform);
            }
            this.setCachedShape(n, area);
        }
        return area;
    }

    public final String getGlyphValue(int n) {
        if (this.cachedValue[n] != null) {
            return this.cachedValue[n];
        }
        String string = null;
        if (this.isCIDFont) {
            String string2 = this.getUnicodeMapping(n);
            if (string2 != null) {
                string = string2;
            }
            if (string == null) {
                String string3 = this.CIDfontEncoding;
                if (this.diffTable != null) {
                    string = this.diffTable[n];
                } else if (string3 != null) {
                    String string4;
                    if (string3.startsWith("Identity-")) {
                        string = "" + (char)n;
                    } else if (this.CMAP != null && (string4 = this.CMAP[n]) != null) {
                        string = string4;
                    }
                }
                if (string == null) {
                    string = "" + (char)n;
                }
            }
        } else {
            string = this.getStandardGlyphValue(n);
        }
        this.cachedValue[n] = string;
        return string;
    }

    private final void handleCIDEncoding(String string) throws PdfFontException {
        String string2 = "";
        boolean bl = false;
        BufferedReader bufferedReader = null;
        if (string.startsWith("/")) {
            string = string.substring(1);
        }
        this.CIDfontEncoding = string;
        if (string.startsWith("Identity-")) {
            this.isDoubleByte = true;
        } else {
            Object object;
            if (!isCidJarPresent) {
                isCidJarPresent = true;
                object = Thread.currentThread().getContextClassLoader().getResourceAsStream("org/jpedal/res/cid/00_ReadMe.pdf");
                if (object == null) {
                    throw new PdfFontException("cid.jar not on classpath");
                }
            }
            this.CMAP = new String[65536];
            if (string.equals("ETenms-B5-H")) {
                string = "ETen-B5-H";
            } else if (string.equals("ETenms-B5-V")) {
                string = "ETen-B5-V";
            }
            try {
                bufferedReader = new BufferedReader(new InputStreamReader(this.loader.getResourceAsStream("org/jpedal/res/cid/" + string), "Cp1252"));
            }
            catch (Exception exception) {
                LogWriter.writeLog("Problem reading encoding for CID font " + this.fontID + " " + string + " Check CID.jar installed");
            }
            if (string.equals("UniJIS-UCS2-H")) {
                this.isDoubleByte = true;
            }
            if (bufferedReader != null) {
                while (true) {
                    try {
                        string2 = bufferedReader.readLine();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (string2 == null) break;
                    if (string2.indexOf("endcidrange") != -1) {
                        bl = false;
                    }
                    if (bl) {
                        object = new StringTokenizer(string2, " <>[]");
                        boolean bl2 = false;
                        if (string2.indexOf("[") != -1) {
                            bl2 = true;
                        }
                        int n = Integer.parseInt(((StringTokenizer)object).nextToken(), 16);
                        int n2 = Integer.parseInt(((StringTokenizer)object).nextToken(), 16);
                        int n3 = Integer.parseInt(((StringTokenizer)object).nextToken(), 16);
                        for (int i = n; i < n2 + 1; ++i) {
                            if (bl2) {
                                n3 = Integer.parseInt(((StringTokenizer)object).nextToken(), 16);
                                this.CMAP[i] = "" + (char)n3;
                                continue;
                            }
                            this.CMAP[i] = "" + (char)n3;
                            ++n3;
                        }
                    }
                    if (string2.indexOf("begincidrange") == -1) continue;
                    bl = true;
                }
            }
        }
        if (bufferedReader != null) {
            try {
                bufferedReader.close();
            }
            catch (Exception exception) {
                LogWriter.writeLog("Problem reading encoding for CID font " + this.fontID + " " + string + " Check CID.jar installed");
            }
        }
    }

    public final String getStandardGlyphValue(int n) {
        String string = this.getUnicodeMapping(n);
        if (string != null) {
            return string;
        }
        String string2 = "";
        String string3 = null;
        int n2 = this.getFontEncoding(true);
        string3 = this.getMappedChar(n, true);
        if (string3 != null) {
            String string4 = StandardFonts.getUnicodeName(this.fontEnc + string3);
            if (string4 != null) {
                string2 = string4;
            } else {
                string4 = StandardFonts.getUnicodeName(string3);
                if (string4 != null) {
                    string2 = string4;
                } else if (string3.length() == 1) {
                    string2 = string3;
                } else if (string3.length() > 1) {
                    char c = string3.charAt(0);
                    if (c == 'B' | c == 'C' | c == 'c' | c == 'G') {
                        string3 = string3.substring(1);
                        try {
                            int n3 = this.isHex ? Integer.valueOf(string3, 16) : Integer.parseInt(string3);
                            string2 = String.valueOf((char)n3);
                        }
                        catch (Exception exception) {
                            string2 = "";
                        }
                    } else {
                        string2 = "";
                    }
                } else {
                    string2 = "";
                }
            }
        } else if (n2 > -1) {
            string2 = StandardFonts.getEncodedChar(n2, n);
        }
        return string2;
    }

    public final Font setFont(String string, int n) {
        int n2;
        if (string.equals("Helv")) {
            string = "Helvetica";
        } else if (string.equals("HeBo")) {
            string = "Helvetica-BOLD";
        } else if (string.equals("ZaDb")) {
            string = "ZapfDingbats";
        }
        this.font_family_name = string;
        this.style = 0;
        boolean bl = false;
        String string2 = null;
        String string3 = null;
        if (this.font_family_name == null) {
            this.font_family_name = this.fontName;
        }
        String string4 = this.font_family_name;
        if (this.font_family_name != null) {
            string4 = this.font_family_name.toLowerCase();
        }
        if ((n2 = this.font_family_name.indexOf(",")) == -1) {
            n2 = this.font_family_name.indexOf("-");
        }
        if (n2 != -1) {
            string3 = (String)PdfDecoder.fontSubstitutionAliasTable.get(string4);
            string2 = string4.substring(n2 + 1, string4.length());
            this.style = this.getWeight(string2);
            this.font_family_name = this.font_family_name.substring(0, n2).toLowerCase();
            string4 = this.font_family_name;
            if (string4.endsWith("mt")) {
                string4 = string4.substring(0, string4.length() - 2);
            }
        }
        if (string3 == null) {
            string3 = (String)PdfDecoder.fontSubstitutionAliasTable.get(string4);
        }
        if (string3 != null && string3.equals("arialbd")) {
            string3 = "arial-bold";
        }
        if (string3 != null) {
            this.font_family_name = string3;
            n2 = this.font_family_name.indexOf("-");
            if (n2 != -1) {
                this.font_family_name = this.font_family_name.toLowerCase();
                string2 = this.font_family_name.substring(n2 + 1, this.font_family_name.length());
                this.style = this.getWeight(string2);
                this.font_family_name = this.font_family_name.substring(0, n2);
            }
            if ((string4 = this.font_family_name.toLowerCase()).endsWith("mt")) {
                string4 = string4.substring(0, string4.length() - 2);
            }
        }
        if (fontList != null) {
            int n3 = fontList.length;
            for (int i = 0; i < n3; ++i) {
                if (!fontList[i].equals(string4) && (string2 != null || !string4.startsWith(fontList[i]))) continue;
                bl = true;
                this.font_family_name = fontList[i];
                i = n3;
            }
        }
        if (!bl) {
            if (string2 == null) {
                String string5 = this.font_family_name.toLowerCase();
                this.style = this.getWeight(string5);
            }
            this.font_family_name = this.defaultFont;
        }
        this.unscaledFont = new Font(this.font_family_name, this.style, n);
        return this.unscaledFont;
    }

    private int getWeight(String string) {
        int n = 0;
        if (string.endsWith("mt")) {
            string = string.substring(0, string.length() - 2);
        }
        if (string.indexOf("heavy") != -1) {
            n = 1;
        } else if (string.indexOf("bold") != -1) {
            n = 1;
        } else if (string.indexOf("roman") != -1) {
            n = 0;
        }
        if (string.indexOf("italic") != -1) {
            n += 2;
        } else if (string.indexOf("oblique") != -1) {
            n += 2;
        }
        return n;
    }

    public final Font getJavaFont(int n) {
        String string;
        int n2 = 0;
        boolean bl = false;
        String string2 = null;
        Object var5_5 = null;
        String string3 = string = this.fontName;
        if (string != null) {
            string3 = string.toLowerCase();
        }
        if (string3.equals("arialmt")) {
            string = string3 = "arial";
        } else if (string3.equals("arial-boldmt")) {
            string = string3 = "arial Bold";
        }
        if (var5_5 != null) {
            string = var5_5;
            string3 = string.toLowerCase();
        }
        if (fontList != null) {
            int n3 = fontList.length;
            for (int i = 0; i < n3; ++i) {
                System.out.println(fontList[i] + "<>" + string3);
                if (fontList[i].indexOf(string3) == -1) continue;
                bl = true;
                string = fontList[i];
                i = n3;
            }
        }
        if (!bl && string2 == null) {
            String string4 = string.toLowerCase();
            if (string4.indexOf("heavy") != -1) {
                n2 = 1;
            } else if (string4.indexOf("bold") != -1) {
                n2 = 1;
            } else if (string4.indexOf("roman") != -1) {
                n2 = 0;
            }
            if (string4.indexOf("italic") != -1) {
                n2 += 2;
            } else if (string4.indexOf("oblique") != -1) {
                n2 += 2;
            }
        }
        if (bl) {
            return new Font(string, n2, n);
        }
        System.out.println("No match with " + this.baseFontName + " " + " " + string3 + " " + string2 + " " + n2);
        System.exit(1);
        return null;
    }

    public final void setDefaultDisplayFont(String string) {
        this.defaultFont = string;
    }

    public final Font getUnscaledFont() {
        if (this.unscaledFont == null) {
            this.unscaledFont = new Font(this.defaultFont, 0, 1);
        }
        return this.unscaledFont;
    }

    public final Font getJavaFontX(int n) {
        return new Font(this.font_family_name, this.style, n);
    }

    protected final void readGenericFontMetadata(Map map) {
        int n;
        Object object;
        LogWriter.writeMethod("{readGenericFontMetadata " + this.fontID + "}", 0);
        String string = (String)map.get("FontMatrix");
        if (string != null) {
            object = new StringTokenizer(string, "[] ");
            for (n = 0; n < 6; ++n) {
                this.FontMatrix[n] = Float.parseFloat(((StringTokenizer)object).nextToken());
            }
        }
        if ((object = (String)map.get("FontBBox")) != null) {
            StringTokenizer stringTokenizer = new StringTokenizer((String)object, "[] ");
            for (int i = 0; i < 4; ++i) {
                this.FontBBox[i] = Float.parseFloat(stringTokenizer.nextToken());
            }
        }
        this.baseFontName = this.currentPdfFile.getValue((String)map.get("BaseFont"));
        if (this.baseFontName == null) {
            this.baseFontName = this.currentPdfFile.getValue((String)map.get("FontName"));
        }
        this.baseFontName = this.baseFontName == null ? this.fontID : this.baseFontName.substring(1);
        this.fontName = this.baseFontName;
        n = this.baseFontName.indexOf("+");
        if (n == 6) {
            this.fontName = this.baseFontName.substring(n + 1);
        }
    }

    public final String getFontName() {
        StandardFonts.loadStandardFontWidth(this.fontName);
        return this.fontName;
    }

    public final String getRawFontName() {
        return this.baseFontName;
    }

    protected final int getFontEncoding(boolean bl) {
        int n = this.fontEnc;
        if (n == -1 && bl) {
            n = 1;
        }
        return n;
    }

    public final float getWidth(int n) {
        float f = -1.0f;
        if (this.widthTable != null) {
            f = this.widthTable[n];
        }
        if (f == -1.0f) {
            if (this.isCIDFont) {
                f = this.defaultWidth;
            } else {
                Float f2;
                String string = this.getMappedChar(n, false);
                if (string != null && string.equals(".notdef")) {
                    string = StandardFonts.getUnicodeChar(this.getFontEncoding(true), n);
                }
                f = (f2 = StandardFonts.getStandardWidth(this.fontName, string)) != null ? f2.floatValue() : 0.0f;
            }
        }
        return f;
    }

    public Map createCIDFont(Map map, Map map2) throws PdfFontException {
        Object v;
        Object object;
        Object object2;
        Object v2;
        String string;
        String string2;
        Object v3;
        Map map3 = null;
        this.cachedValue = new String[65536];
        String string3 = (String)map.get("Encoding");
        if (string3 != null) {
            this.handleCIDEncoding(string3);
        }
        if ((v3 = map.get("ToUnicode")) != null) {
            if (v3 instanceof String) {
                this.readUnicode(this.currentPdfFile.readStream((String)v3), this.fontID);
            } else {
                this.readUnicode((byte[])((Map)v3).get("DecodedStream"), this.fontID);
            }
        }
        if ((string2 = this.currentPdfFile.getValue((String)map2.get("W"))) != null) {
            this.setCIDFontWidths(string2);
        }
        if ((string = this.currentPdfFile.getValue((String)map2.get("DW"))) != null) {
            this.setCIDFontDefaultWidth(string);
        }
        if ((v2 = map2.get("CIDToGIDMap")) != null) {
            if (v2 instanceof String) {
                object2 = (String)v2;
                if (((String)object2).endsWith(" R")) {
                    object = this.currentPdfFile.readStream((String)object2);
                    for (int i = 0; i < ((Object)object).length; i += 2) {
                        char c = (char)((object[i] << 8) + object[i + 1]);
                        this.putMappedChar(i, "" + c);
                    }
                } else if (((String)object2).equals("/Identity")) {
                    this.handleCIDEncoding("Identity-");
                } else {
                    LogWriter.writeLog("not yet supported in demo.");
                    System.err.println("not yet supported in demo.");
                }
            } else {
                LogWriter.writeLog("not yet supported in demo.");
                System.err.println("not yet supported in demo.");
            }
        }
        object2 = map2.get("CIDSystemInfo");
        object = new Hashtable();
        object = object2 instanceof Map ? (Map)object2 : this.currentPdfFile.readObject((String)object2, false, null);
        String string4 = (String)object.get("Ordering");
        if (string4 != null) {
            if (string4.indexOf("Japan") != -1) {
                this.substituteFontFile = "kochi-mincho.ttf";
                this.substituteFontName = "Kochi Mincho";
                this.TTstreamisCID = false;
            } else if (string4.indexOf("Korean") != -1) {
                System.err.println("Unsupported font encoding " + string4);
            } else if (string4.indexOf("Chinese") != -1) {
                System.err.println("Chinese " + string4);
            }
            if (this.substituteFontName != null) {
                LogWriter.writeLog("Using font " + this.substituteFontName + " for " + string4);
            }
        }
        if ((v = map2.get("FontDescriptor")) != null) {
            map3 = null;
            if (v instanceof String) {
                String string5 = (String)v;
                if (string5.length() > 1) {
                    map3 = this.currentPdfFile.readObject(string5, false, null);
                }
            } else {
                map3 = (Map)v;
            }
            if (map3 != null) {
                this.readGenericFontMetadata(map3);
            }
        }
        return map3;
    }

    protected final void selectDefaultFont() {
    }

    public void readWidths(Map map) throws Exception {
        LogWriter.writeMethod("{readWidths}" + map, 0);
        String string = this.currentPdfFile.getValue((String)map.get("FirstChar"));
        int n = 1;
        if (string != null) {
            n = ToInteger.getInteger(string);
        }
        String string2 = this.currentPdfFile.getValue((String)map.get("LastChar"));
        boolean bl = false;
        String string3 = this.currentPdfFile.getValue((String)map.get("Widths"));
        if (string3 != null) {
            this.widthTable = new float[this.maxCharCount];
            for (int i = 0; i < this.maxCharCount; ++i) {
                this.widthTable[i] = -1.0f;
            }
            String string4 = string3.substring(1, string3.length() - 1).trim();
            StringTokenizer stringTokenizer = new StringTokenizer(string4);
            int n2 = ToInteger.getInteger(string2);
            float f = (float)(1.0 / this.FontMatrix[0]);
            if (f < 0.0f) {
                f = -f;
            }
            for (int i = n; i < n2 + 1; ++i) {
                float f2;
                if (!stringTokenizer.hasMoreTokens()) {
                    f2 = 0.0f;
                    continue;
                }
                f2 = this.fontTypes == 3 ? Float.parseFloat(stringTokenizer.nextToken()) / f : Float.parseFloat(stringTokenizer.nextToken()) * 0.001f;
                this.widthTable[i] = f2;
            }
        }
    }

    public Map createFont(Map map, String string, boolean bl, Map map2) throws Exception {
        int n;
        Object object;
        Object object2;
        Object v;
        LogWriter.writeMethod("{readNonCIDFont}" + map + "{render=" + bl, 0);
        if (fontList == null & bl) {
            fontList = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
            int n2 = fontList.length;
            for (int i = 0; i < n2; ++i) {
                PdfFont.fontList[i] = fontList[i].toLowerCase();
            }
        }
        this.fontID = string;
        this.renderPage = bl;
        this.readGenericFontMetadata(map);
        String string2 = (String)map.get("Subtype");
        if (string2 == null) {
            string2 = "";
        }
        if ((v = map.get("ToUnicode")) != null) {
            if (v instanceof String) {
                this.readUnicode(this.currentPdfFile.readStream((String)v), string);
            } else {
                this.readUnicode((byte[])((Map)v).get("DecodedStream"), string);
            }
        }
        String string3 = (String)map.get("FirstChar");
        int n3 = 1;
        if (string3 != null) {
            n3 = ToInteger.getInteger(string3);
        }
        String string4 = (String)map.get("LastChar");
        boolean bl2 = false;
        String string5 = this.currentPdfFile.getValue((String)map.get("Widths"));
        if (string5 != null) {
            this.widthTable = new float[this.maxCharCount];
            for (int i = 0; i < this.maxCharCount; ++i) {
                this.widthTable[i] = -1.0f;
            }
            object2 = string5.substring(1, string5.length() - 1).trim();
            object = new StringTokenizer((String)object2);
            int n4 = ToInteger.getInteger(string4) + 1;
            float f = -1.0f;
            float f2 = (float)(1.0 / this.FontMatrix[0]);
            f2 = -f2;
            for (n = n3; n < n4; ++n) {
                f = !((StringTokenizer)object).hasMoreTokens() ? 0.0f : (this.fontTypes == 3 ? Float.parseFloat(((StringTokenizer)object).nextToken()) / f2 : Float.parseFloat(((StringTokenizer)object).nextToken()) * 0.001f);
                this.widthTable[n] = f;
            }
        }
        if ((object2 = map.get("Encoding")) != null) {
            if (object2 instanceof String) {
                this.handleFontEncoding((String)object2, null, string2);
            } else {
                this.handleFontEncoding("", (Map)object2, string2);
            }
        } else {
            this.handleNoEncoding();
        }
        object = null;
        Object v2 = map.get("FontDescriptor");
        if (v2 instanceof String) {
            String string6 = (String)v2;
            if (string6 != null && string6.length() > 1) {
                object = this.currentPdfFile.readObject(string6, false, null);
            }
        } else {
            object = (Map)v2;
        }
        if (object != null) {
            int n5 = 0;
            String string7 = (String)object.get("Flags");
            if (string7 != null) {
                n5 = Integer.parseInt(string7);
            }
            this.fontFlag = n5;
            this.remapFont = false;
            n = this.fontFlag;
            if ((n & 4) == 4) {
                this.remapFont = true;
            }
        }
        return object;
    }

    private void handleNoEncoding() {
        if (this.baseFontName.equals("ZapfDingbats") | this.baseFontName.equals("ZaDb")) {
            this.putFontEncoding(5);
            this.defaultFont = "Zapf Dingbats";
            StandardFonts.checkLoaded(5);
        } else if (this.baseFontName.equals("Symbol")) {
            this.putFontEncoding(4);
        } else {
            this.putFontEncoding(1);
        }
        this.hasEncoding = false;
    }

    private final void handleFontEncoding(String string, Map map, String string2) {
        this.hasFontEncoding = true;
        int n = this.getFontEncoding(false);
        String string3 = "";
        int n2 = n;
        if (n2 == -1) {
            n2 = string2.equals("/TrueType") ? 0 : 1;
        }
        if (string.indexOf(" ") != -1 | map != null) {
            if (map == null) {
                map = this.currentPdfFile.readObject(string, false, null);
            }
            String string4 = this.currentPdfFile.getValue((String)map.get("BaseEncoding"));
            String string5 = this.currentPdfFile.getValue((String)map.get("Differences"));
            if (string4 != null) {
                if (string4.startsWith("/")) {
                    string4 = string4.substring(1);
                }
                string3 = string4;
                this.hasEncoding = true;
            } else {
                this.handleNoEncoding();
            }
            if (string5 != null) {
                string5 = Strip.removeArrayDeleminators(string5);
                int n3 = 0;
                String string6 = " \r\n";
                StringTokenizer stringTokenizer = new StringTokenizer(string5, " /\r\n", true);
                while (stringTokenizer.hasMoreTokens()) {
                    String string7 = stringTokenizer.nextToken();
                    if (string6.indexOf(string7) != -1) continue;
                    if (string7.equals("/")) {
                        string7 = stringTokenizer.nextToken();
                        while (string6.indexOf(string7) != -1) {
                            string7 = stringTokenizer.nextToken();
                        }
                        this.putMappedChar(n3, string7);
                        ++n3;
                        char c = string7.charAt(0);
                        if (!(c == 'B' | c == 'c' | c == 'C' | c == 'G')) continue;
                        int n4 = 1;
                        int n5 = string7.length();
                        while (!this.isHex && n4 < n5) {
                            this.isHex = Character.isLetter(string7.charAt(n4++));
                        }
                        continue;
                    }
                    if (!Character.isDigit(string7.charAt(0))) continue;
                    n3 = Integer.parseInt(string7);
                }
            }
        } else {
            string3 = string;
        }
        if (string3.indexOf("MacRomanEncoding") != -1) {
            n2 = 0;
        } else if (string3.indexOf("WinAnsiEncoding") != -1) {
            n2 = 2;
        } else if (string3.indexOf("MacExpertEncoding") != -1) {
            n2 = 3;
        } else if (string3.indexOf("STD") == -1 & n2 == -1) {
            LogWriter.writeLog("Encoding type " + string3 + " not implemented");
        }
        if (n2 > -1) {
            this.putFontEncoding(n2);
        }
    }

    protected final void putMappedChar(int n, String string) {
        if (this.diffTable == null) {
            this.diffTable = new String[this.maxCharCount];
        }
        if (this.diffTable[n] == null) {
            this.diffTable[n] = string;
        }
    }

    protected final void setCachedShape(int n, Area area) {
        Area[] areaArray = this.cachedShapes;
        if (areaArray == null) {
            this.cachedShapes = areaArray = new Area[this.maxCharCount];
        }
        if (area == null) {
            areaArray[n] = null;
            areaArray[n] = null;
        } else {
            areaArray[n] = (Area)area.clone();
        }
    }

    public double getType3Ydisplacement(int n) {
        return 0.0;
    }

    public final String getMappedChar(int n, boolean bl) {
        String string = null;
        if (this.diffTable != null) {
            string = this.diffTable[n];
        }
        if (bl && string != null && string.equals(".notdef")) {
            string = " ";
        }
        if (string == null) {
            string = StandardFonts.getUnicodeChar(this.getFontEncoding(true), n);
        }
        if (this.isFontEmbedded && string == null) {
            if (this.diffs != null) {
                string = this.diffs[n];
            }
            if (string == null) {
                string = StandardFonts.getUnicodeChar(this.embeddedEnc, n);
            }
        }
        return string;
    }

    protected final String getEmbeddedChar(int n) {
        String string = null;
        if (this.isFontEmbedded) {
            if (this.diffs != null) {
                string = this.diffs[n];
            }
            if (string == null) {
                string = StandardFonts.getUnicodeChar(this.embeddedEnc, n);
            }
        }
        return string;
    }

    protected final void readUnicode(byte[] byArray, String string) {
        String string2 = "";
        int n = 0;
        BufferedReader bufferedReader = null;
        ByteArrayInputStream byteArrayInputStream = null;
        this.unicodeMappings = new String[this.maxCharCount];
        try {
            byteArrayInputStream = new ByteArrayInputStream(byArray);
            bufferedReader = new BufferedReader(new InputStreamReader(byteArrayInputStream));
            if (bufferedReader != null) {
                while ((string2 = bufferedReader.readLine()) != null) {
                    int n2;
                    int n3;
                    String string3;
                    int n4;
                    StringTokenizer stringTokenizer;
                    if (string2.indexOf("endbf") != -1) {
                        n = 0;
                    }
                    if (n == 1) {
                        stringTokenizer = new StringTokenizer(string2, " <>[]");
                        n4 = Integer.parseInt(stringTokenizer.nextToken(), 16);
                        string3 = stringTokenizer.nextToken();
                        String string4 = "";
                        if (string3.length() < 4) {
                            n3 = Integer.parseInt(stringTokenizer.nextToken(), 16);
                            string4 = String.valueOf((char)n3);
                        } else {
                            for (n2 = 0; n2 < string3.length(); n2 += 4) {
                                n3 = Integer.parseInt(string3.substring(n2, n2 + 4), 16);
                                string4 = string4 + String.valueOf((char)n3);
                            }
                        }
                        this.unicodeMappings[n4] = string4;
                    } else if (n == 2) {
                        stringTokenizer = new StringTokenizer(string2, " <>[]");
                        n4 = Integer.parseInt(stringTokenizer.nextToken(), 16);
                        int n5 = Integer.parseInt(stringTokenizer.nextToken(), 16);
                        string3 = "";
                        while (stringTokenizer.hasMoreTokens()) {
                            string3 = string3 + stringTokenizer.nextToken();
                        }
                        int n6 = 0;
                        for (n2 = n4; n2 < n5 + 1; ++n2) {
                            String string5 = "";
                            int n7 = string3.length();
                            for (int i = 0; i < n7; i += 4) {
                                n3 = Integer.parseInt(string3.substring(i, i + 4), 16);
                                if (n2 + 4 > n7) {
                                    n3 += n6;
                                }
                                string5 = string5 + String.valueOf((char)n3);
                            }
                            this.unicodeMappings[n2] = string5;
                            ++n6;
                        }
                    }
                    if (string2.indexOf("beginbfchar") != -1) {
                        n = 1;
                        continue;
                    }
                    if (string2.indexOf("beginbfrange") == -1) continue;
                    n = 2;
                }
            }
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception setting up text object " + exception);
        }
        if (bufferedReader != null) {
            try {
                byteArrayInputStream.close();
                bufferedReader.close();
            }
            catch (IOException iOException) {
                LogWriter.writeLog("Exception setting up text object " + iOException);
            }
        }
    }

    public final int getFontType() {
        return this.fontTypes;
    }

    public Area getApproximateGlyph(float[][] fArray, int n, String string, float f) {
        if (this.lastTrm[0][0] != fArray[0][0] | this.lastTrm[1][0] != fArray[1][0] | this.lastTrm[0][1] != fArray[0][1] | this.lastTrm[1][1] != fArray[1][1]) {
            this.lastTrm = fArray;
            this.cachedShapes = null;
        }
        Area area = this.getCachedShape(n);
        double d = -1.0;
        double d2 = 1.0;
        if (fArray[1][0] < 0.0f & fArray[0][1] >= 0.0f | fArray[0][1] < 0.0f & fArray[1][0] >= 0.0f) {
            d2 = 1.0;
            d = -1.0;
        }
        if (area == null) {
            double d3;
            double d4;
            String string2 = string;
            if (this.remapFont && !this.getUnscaledFont().canDisplay(string2.charAt(0))) {
                string2 = "" + (char)(n + 61440);
            }
            GlyphVector glyphVector = this.getUnscaledFont().createGlyphVector(frc, string2);
            area = new Area(glyphVector.getOutline());
            double d5 = glyphVector.getOutline().getBounds2D().getX();
            AffineTransform affineTransform = null;
            if (d5 < 0.0) {
                d5 = -d5;
                affineTransform = AffineTransform.getTranslateInstance(d5 * 2.0, 0.0);
                area.transform(affineTransform);
            }
            if ((d4 = (double)f / (d3 = glyphVector.getVisualBounds().getWidth() + d5 * 2.0)) < 1.0) {
                affineTransform = AffineTransform.getScaleInstance(d4, 1.0);
                area.transform(affineTransform);
            }
            affineTransform = new AffineTransform(d2 * (double)fArray[0][0], d2 * (double)fArray[0][1], d * (double)fArray[1][0], d * (double)fArray[1][1], 0.0, 0.0);
            area.transform(affineTransform);
            this.setCachedShape(n, area);
        }
        return area;
    }

    protected Area getGlyph(int n, String string, float f) {
        Object object;
        boolean bl = true;
        GlyphVector glyphVector = null;
        String string2 = string;
        if (this.remapFont && !this.getUnscaledFont().canDisplay(string2.charAt(0))) {
            string2 = "" + (char)(n + 61440);
        }
        if (!this.getUnscaledFont().canDisplay(string2.charAt(0))) {
            string2 = string;
            bl = false;
        }
        if (bl) {
            glyphVector = this.getUnscaledFont().createGlyphVector(frc, string2);
        } else {
            object = new Font(this.defaultFont, 0, 1);
            if (!((Font)object).canDisplay(string2.charAt(0))) {
                object = new Font("lucida", 0, 1);
            }
            if (((Font)object).canDisplay(string2.charAt(0))) {
                glyphVector = ((Font)object).createGlyphVector(frc, string2);
            }
        }
        object = null;
        if (glyphVector != null) {
            double d;
            object = new Area(glyphVector.getOutline());
            double d2 = glyphVector.getOutline().getBounds2D().getX();
            AffineTransform affineTransform = null;
            if (d2 < 0.0) {
                d2 = -d2;
                affineTransform = AffineTransform.getTranslateInstance(d2, 0.0);
                ((Area)object).transform(affineTransform);
            }
            if ((d = (double)f / ((Area)object).getBounds2D().getWidth()) < 1.0) {
                affineTransform = AffineTransform.getScaleInstance(d, 1.0);
                ((Area)object).transform(affineTransform);
            }
        }
        return object;
    }

    protected final Area getCachedShape(int n) {
        Area[] areaArray = this.cachedShapes;
        if (areaArray == null) {
            return null;
        }
        Area area = areaArray[n];
        if (area == null) {
            return null;
        }
        return (Area)area.clone();
    }

    public String getSubstituteFont() {
        return this.substituteFontName;
    }

    public boolean isValidCodeRange(int n) {
        if (this.CMAP == null) {
            return false;
        }
        System.out.println(this.CMAP[n] + "<<" + n);
        return this.CMAP[n] != null;
    }

    public float getTTWidth(String string, int n, String string2) {
        return 0.0f;
    }

    public PdfGlyph getEmbeddedGlyph(GlyphFactory glyphFactory, String string, float[][] fArray, int n, String string2, float f) {
        return null;
    }

    public void setSubtype(int n) {
        this.fontTypes = n;
    }

    static {
        PdfFont.setStandardFontMappings();
        frc = new FontRenderContext(null, true, true);
    }
}

