/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.simpleviewer.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.lang.reflect.InvocationTargetException;
import javax.media.jai.JAI;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.jpedal.PdfDecoder;
import org.jpedal.examples.simpleviewer.utils.SwingWorker;
import org.jpedal.objects.PdfPageData;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.repositories.Vector_Object;

public class ThumbnailPanel
extends JPanel {
    public boolean interrupt = false;
    public boolean drawing;
    private JButton[] pageButton;
    private boolean[] buttonDrawn;
    private boolean[] isLandscape;
    private int[] pageHeight;
    private final int thumbH = 100;
    private final int thumbW = 70;
    private JScrollPane thumbnailScrollPane = new JScrollPane();

    public ThumbnailPanel() {
        this.thumbnailScrollPane.setHorizontalScrollBarPolicy(30);
        this.thumbnailScrollPane.setVerticalScrollBarPolicy(20);
    }

    public void createThumbnailsOnDecode(int n, PdfDecoder pdfDecoder) {
        this.drawing = true;
        int n2 = pdfDecoder.getPageCount();
        for (int i = -5; i < 5; ++i) {
            int n3 = i + n;
            if (this.interrupt) {
                i = 5;
            }
            if (n3 >= n2) {
                i = 5;
                continue;
            }
            if (n3 <= 0 || this.buttonDrawn[n3] || this.pageButton[n3] == null) continue;
            int n4 = 100;
            if (this.isLandscape[n3]) {
                n4 = 70;
            }
            BufferedImage bufferedImage = pdfDecoder.getPageAsThumbnail(n3 + 1, n4);
            if (this.interrupt) {
                i = 5;
                continue;
            }
            this.createThumbnail(bufferedImage, n3 + 1, false);
        }
        this.interrupt = false;
        this.drawing = false;
    }

    public void createThumbnailsFromImages(String[] stringArray, Vector_Object vector_Object) {
        this.drawing = true;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            BufferedImage bufferedImage = null;
            try {
                if (stringArray[i] == null) continue;
                Object object = vector_Object.elementAt(i);
                if (object == null) {
                    bufferedImage = JAI.create((String)"fileload", (Object)stringArray[i]).getAsBufferedImage();
                    vector_Object.addElement(bufferedImage);
                } else {
                    bufferedImage = (BufferedImage)object;
                }
                if (bufferedImage == null) continue;
                int n2 = bufferedImage.getWidth();
                int n3 = bufferedImage.getHeight();
                Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
                graphics2D.setColor(Color.black);
                graphics2D.draw(new Rectangle(0, 0, n2 - 1, n3 - 1));
                ImageIcon imageIcon = n3 > n2 ? new ImageIcon(bufferedImage.getScaledInstance(-1, 100, 4)) : new ImageIcon(bufferedImage.getScaledInstance(100, -1, 4));
                this.pageButton[i].setIcon(imageIcon);
                this.pageButton[i].setVisible(true);
                this.buttonDrawn[i] = true;
                this.add(this.pageButton[i]);
                continue;
            }
            catch (Exception exception) {
                LogWriter.writeLog("Exception " + exception + " loading " + stringArray[i]);
            }
        }
        this.drawing = false;
    }

    public void setupThumbnailsOnDecode(final int n, PdfDecoder pdfDecoder) {
        Rectangle rectangle;
        int n2 = pdfDecoder.getPageCount();
        for (int i = 0; i < n2; ++i) {
            if (i == n - 1) continue;
            this.pageButton[i].setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        }
        if (n2 > 1 && n > 0) {
            this.pageButton[n - 1].setBorder(BorderFactory.createLineBorder(Color.red));
        }
        if (!(rectangle = this.getVisibleRect()).contains(this.pageButton[n - 1].getBounds())) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        ThumbnailPanel.this.scrollRectToVisible(ThumbnailPanel.this.pageButton[n - 1].getBounds());
                    }
                });
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
        }
    }

    public void drawVisibleThumbnailsOnScroll(final PdfDecoder pdfDecoder) {
        SwingWorker swingWorker = new SwingWorker(){

            public Object construct() {
                ThumbnailPanel.this.drawing = true;
                try {
                    Rectangle rectangle = ThumbnailPanel.this.getVisibleRect();
                    int n = pdfDecoder.getPageCount();
                    for (int i = 0; i < n; ++i) {
                        if (ThumbnailPanel.this.interrupt) {
                            i = n;
                            continue;
                        }
                        if (i <= 0 || ThumbnailPanel.this.buttonDrawn[i] || ThumbnailPanel.this.pageButton[i] == null || !rectangle.intersects(ThumbnailPanel.this.pageButton[i].getBounds())) continue;
                        int n2 = 100;
                        if (ThumbnailPanel.this.isLandscape[i]) {
                            n2 = 70;
                        }
                        float f = (float)n2 / (float)ThumbnailPanel.this.pageHeight[i];
                        BufferedImage bufferedImage = pdfDecoder.getPageAsThumbnail(i + 1, n2);
                        ThumbnailPanel.this.createThumbnail(bufferedImage, i + 1, false);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ThumbnailPanel.this.interrupt = false;
                ThumbnailPanel.this.drawing = false;
                return null;
            }
        };
        swingWorker.start();
    }

    public void addNewThumbnails(int n, PdfDecoder pdfDecoder) {
        if (!this.buttonDrawn[n - 1]) {
            int n2 = 100;
            if (this.isLandscape[n - 1]) {
                n2 = 70;
            }
            BufferedImage bufferedImage = pdfDecoder.getPageAsThumbnail(n2);
            this.createThumbnail(bufferedImage, n, true);
        }
    }

    private BufferedImage createBlankThumbnail(int n, int n2) {
        BufferedImage bufferedImage = new BufferedImage(n + 1, n2 + 1, 1);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.setColor(Color.white);
        graphics2D.fill(new Rectangle(0, 0, n, n2));
        graphics2D.setColor(Color.black);
        graphics2D.draw(new Rectangle(0, 0, n, n2));
        graphics2D.drawLine(0, 0, n, n2);
        graphics2D.drawLine(0, n2, n, 0);
        return bufferedImage;
    }

    private void createThumbnail(BufferedImage bufferedImage, int n, boolean bl) {
        --n;
        if (bufferedImage != null) {
            Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
            graphics2D.setColor(Color.black);
            graphics2D.draw(new Rectangle(0, 0, bufferedImage.getWidth() - 1, bufferedImage.getHeight() - 1));
            ImageIcon imageIcon = new ImageIcon(bufferedImage.getScaledInstance(-1, bufferedImage.getHeight(), 2));
            this.pageButton[n].setIcon(imageIcon);
            this.buttonDrawn[n] = true;
        }
    }

    public JScrollPane setupThumbnails(int n, int[] nArray, int n2) {
        Font font = new Font("Serif", 0, 12);
        this.thumbnailScrollPane.getViewport().add(this);
        this.setLayout(new GridLayout(n, 1, 0, 10));
        this.scrollRectToVisible(new Rectangle(0, 0, 1, 1));
        this.thumbnailScrollPane.getVerticalScrollBar().setUnitIncrement(80);
        BufferedImage bufferedImage = this.createBlankThumbnail(70, 100);
        ImageIcon imageIcon = new ImageIcon(bufferedImage.getScaledInstance(-1, 100, 4));
        this.isLandscape = new boolean[n];
        this.pageHeight = new int[n];
        this.pageButton = new JButton[n];
        this.buttonDrawn = new boolean[n];
        for (int i = 0; i < n; ++i) {
            int n3 = i + 1;
            this.pageButton[i] = n2 < 2 ? new JButton("" + n3, imageIcon) : new JButton("" + n3 + " ( Page " + nArray[i] + " )", imageIcon);
            this.isLandscape[i] = false;
            this.pageHeight[i] = 100;
            this.pageButton[i].setVerticalTextPosition(3);
            this.pageButton[i].setHorizontalTextPosition(0);
            if (i == 0 && n > 1) {
                this.pageButton[0].setBorder(BorderFactory.createLineBorder(Color.red));
            } else {
                this.pageButton[i].setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            }
            this.pageButton[i].setFont(font);
            this.add((Component)this.pageButton[i], "Center");
        }
        return this.thumbnailScrollPane;
    }

    public void resetHighlightedThumbnail(int n) {
        if (this.pageButton != null) {
            int n2 = this.pageButton.length;
            for (int i = 0; i < n2; ++i) {
                if (i == n) {
                    this.pageButton[i].setBorder(BorderFactory.createLineBorder(Color.red));
                    continue;
                }
                this.pageButton[i].setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            }
        }
    }

    public JScrollPane setupThumbnails(int n, Font font, String string, PdfPageData pdfPageData) {
        this.thumbnailScrollPane.getViewport().add(this);
        this.setLayout(new GridLayout(n, 1, 0, 10));
        this.scrollRectToVisible(new Rectangle(0, 0, 1, 1));
        this.thumbnailScrollPane.getVerticalScrollBar().setUnitIncrement(80);
        BufferedImage bufferedImage = this.createBlankThumbnail(70, 100);
        BufferedImage bufferedImage2 = this.createBlankThumbnail(100, 70);
        ImageIcon imageIcon = new ImageIcon(bufferedImage2.getScaledInstance(-1, 70, 4));
        ImageIcon imageIcon2 = new ImageIcon(bufferedImage.getScaledInstance(-1, 100, 4));
        this.isLandscape = new boolean[n];
        this.pageHeight = new int[n];
        this.pageButton = new JButton[n];
        this.buttonDrawn = new boolean[n];
        for (int i = 0; i < n; ++i) {
            ImageIcon imageIcon3;
            ImageIcon imageIcon4;
            int n2;
            int n3;
            int n4 = i + 1;
            int n5 = pdfPageData.getCropBoxWidth(n4);
            int n6 = pdfPageData.getCropBoxHeight(n4);
            int n7 = pdfPageData.getRotation(n4);
            if (n7 == 0 | n7 == 180) {
                n3 = pdfPageData.getMediaBoxHeight(n4);
                n2 = pdfPageData.getMediaBoxWidth(n4);
                imageIcon4 = imageIcon;
                imageIcon3 = imageIcon2;
            } else {
                n3 = pdfPageData.getMediaBoxWidth(n4);
                n2 = pdfPageData.getMediaBoxHeight(n4);
                imageIcon4 = imageIcon2;
                imageIcon3 = imageIcon;
            }
            if (n5 > n6) {
                this.pageButton[i] = new JButton(string + " " + n4, imageIcon4);
                this.isLandscape[i] = true;
                this.pageHeight[i] = n3;
            } else {
                this.pageButton[i] = new JButton(string + " " + n4, imageIcon3);
                this.isLandscape[i] = false;
                this.pageHeight[i] = n3;
            }
            this.pageButton[i].setVerticalTextPosition(3);
            this.pageButton[i].setHorizontalTextPosition(0);
            if (i == 0 && n > 1) {
                this.pageButton[0].setBorder(BorderFactory.createLineBorder(Color.red));
            } else {
                this.pageButton[i].setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            }
            this.pageButton[i].setFont(font);
            this.add((Component)this.pageButton[i], "Center");
        }
        return this.thumbnailScrollPane;
    }

    public JButton getButton(int n) {
        return this.pageButton[n];
    }
}

