/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.simpleviewer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.TextArea;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.accessibility.Accessible;
import javax.imageio.ImageIO;
import javax.media.jai.JAI;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.RepaintManager;
import javax.swing.Timer;
import javax.swing.border.EtchedBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jpedal.PdfDecoder;
import org.jpedal.examples.simpleviewer.gui.SearchList;
import org.jpedal.examples.simpleviewer.gui.ThumbnailPanel;
import org.jpedal.examples.simpleviewer.utils.FileFilterer;
import org.jpedal.examples.simpleviewer.utils.SwingWorker;
import org.jpedal.exception.PdfException;
import org.jpedal.exception.PdfFontException;
import org.jpedal.io.StatusBar;
import org.jpedal.objects.PdfAnnots;
import org.jpedal.objects.PdfFileInformation;
import org.jpedal.objects.PdfPageData;
import org.jpedal.utils.LogWriter;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SimpleViewer
extends JFrame {
    protected ResourceBundle bundle;
    Map textPages = new HashMap();
    Map textRectangles = new HashMap();
    JTextField searchText;
    JCheckBox searchAll;
    JTextField searchCount;
    DefaultListModel listModel;
    SearchList results;
    boolean display = true;
    protected boolean switchModes = true;
    private boolean showThumbnailsdefault;
    private boolean showThumbnails = this.showThumbnailsdefault = false;
    public ThumbnailPanel thumbnails = new ThumbnailPanel();
    final boolean extractImageOnSelection = true;
    protected final String separator = System.getProperty("file.separator");
    protected PdfDecoder decode_pdf;
    protected PdfAnnots pageAnnotations;
    protected JScrollPane bookmarkScrollPane = new JScrollPane();
    protected JTabbedPane navOptionsPanel = new JTabbedPane();
    protected JSplitPane displayPane;
    private JTree tree;
    protected Container c;
    static SimpleViewer current;
    private boolean isPDF = true;
    protected String titleMessage = null;
    private HashMap pageLookupTable = new HashMap();
    private Map pointLookupTable = new HashMap();
    private boolean ignoreAlteredBookmark = false;
    private String inputDir = System.getProperty("user.dir");
    protected int currentPage = 1;
    protected String target;
    protected int rotation = 0;
    public int m_x1;
    public int m_y1;
    public int m_x2;
    public int m_y2;
    public int old_m_x2 = -1;
    public int old_m_y2 = -1;
    protected int x;
    protected int y;
    public Rectangle currentRectangle = null;
    public int cx;
    public int cy;
    protected static int printingThreads;
    SwingWorker worker = null;
    SwingWorker searcher = null;
    public boolean isSearch = false;
    JButton searchButton = new JButton("search");
    private static JLabel coords;
    protected int pageCount = 1;
    protected float scaling = 1.0f;
    protected String selectedFile = null;
    protected boolean isProcessing = false;
    protected String[] scalingValues = new String[]{"25", "50", "75", "100", "125", "150", "200", "250", "500", "750", "1000"};
    protected float[] scalingFloatValues = new float[]{0.25f, 0.5f, 0.75f, 1.0f, 1.25f, 1.5f, 2.0f, 2.5f, 5.0f, 7.5f, 10.0f};
    private final int defaultSelection = 0;
    protected JComboBox scalingBox;
    JScrollPane scrollPane = new JScrollPane();
    private final String[] rotationValues = new String[]{"0", "90", "180", "270"};
    protected JComboBox rotationBox = new JComboBox<String>(this.rotationValues);
    protected JLabel pageCounter1;
    protected JTextField pageCounter2 = new JTextField(4);
    protected JLabel pageCounter3;
    private Map messages = null;
    private BufferedImage img = null;
    private final int inset = 25;
    private long size;
    private String message = "";
    private static int currentFileCount;
    protected JButton first = new JButton();
    protected JButton fback = new JButton();
    protected JButton back = new JButton();
    protected JButton forward = new JButton();
    protected JButton fforward = new JButton();
    protected JButton end = new JButton();
    private final String[] annotTypes = new String[]{"Other", "Text", "FileAttachment"};
    private boolean allowScrolling = true;
    private boolean hasOutlinesDrawn = false;
    private JButton bookmarksButton = new JButton();
    private int cropX;
    private int cropY;
    private int cropW;
    private int cropH;
    private int mediaW;
    private int mediaH;
    private int mediaX;
    private int mediaY;
    private final Font textFont = new Font("Serif", 0, 12);
    private final Font headFont = new Font("SansSerif", 1, 14);
    protected StatusBar statusBar = new StatusBar(Color.orange);
    private String[] ocr = new String[]{"TeleForm", "dgn2pdf"};
    public int divLocation = 170;
    private int thumbLocation = 200;
    private int minimumScreenWidth = 800;
    private int dx;
    private int dy = 0;
    private double viewportScale = 1.0;
    protected int maxViewY = 0;
    private ThumbPainter painter = new ThumbPainter();
    protected boolean showOutlines = true;
    private int itemFoundCount = 0;
    private boolean useHiresImage;

    public void setupViewer(String string) {
        this.setupViewer();
        this.openDefaultFile(string);
    }

    protected void openDefaultFile(String string) {
        if (string != null) {
            File file = new File(string);
            if (!file.exists()) {
                JOptionPane.showMessageDialog(this, string + "\n" + this.getMessage("PdfViewerdoesNotExist.message"));
            } else if (file.isDirectory()) {
                JOptionPane.showMessageDialog(this, string + "\n" + this.getMessage("PdfViewerFileIsDirectory.message"));
            } else {
                this.selectedFile = string;
                this.setViewerTitle(null);
                this.size = file.length() >> 10;
                String string2 = System.getProperty("Page");
                String string3 = System.getProperty("Bookmark");
                if (string2 != null) {
                    int n = -1;
                    try {
                        n = Integer.parseInt(string2);
                        if (n < 1) {
                            n = -1;
                            System.err.println(string2 + " must be 1 or larger. Opening on page 1");
                            LogWriter.writeLog(string2 + " must be 1 or larger. Opening on page 1");
                        }
                        if (n != -1) {
                            this.openFile(file, n);
                        }
                    }
                    catch (Exception exception) {
                        System.err.println(string2 + "is not a valid number for a page number. Opening on page 1");
                        LogWriter.writeLog(string2 + "is not a valid number for a page number. Opening on page 1");
                    }
                } else if (string3 != null) {
                    this.openFile(file, string3);
                } else {
                    this.openFile(string);
                }
            }
            string = null;
        }
    }

    public final void flush() {
        File file;
        String[] stringArray;
        if (this.target != null && (stringArray = (file = new File(this.target)).list()) != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                File file2 = new File(this.target + this.separator + stringArray[i]);
                file2.delete();
            }
        }
    }

    public void setupViewer() {
        String string = System.getProperty("thumbnail");
        if (string != null && string.equals("true")) {
            this.showThumbnailsdefault = true;
            this.showThumbnails = true;
        }
        this.setupGUI();
    }

    protected void init(ResourceBundle resourceBundle) {
        if (resourceBundle == null) {
            try {
                this.bundle = ResourceBundle.getBundle("org.jpedal.international.messages");
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.out.println("Exception loading resource bundle");
            }
        } else {
            this.bundle = resourceBundle;
        }
        this.decode_pdf = new PdfDecoder();
        this.decode_pdf.setInset(25, 25);
        this.decode_pdf.setStatusBarObject(this.statusBar);
        try {
            this.decode_pdf.setDefaultDisplayFont("SansSerif");
        }
        catch (PdfFontException pdfFontException) {
            System.out.println(pdfFontException.getMessage());
            String[] stringArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
            System.out.println(this.getMessage("PdfViewerFontsFound.message"));
            System.out.println("=====================\n");
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                Font font = new Font(stringArray[i], 1, 10);
                System.out.println(stringArray[i] + " (" + this.getMessage("PdfViewerFontsPostscript.message") + "=" + font.getPSName() + ")");
            }
            System.exit(1);
        }
        this.c = this.getContentPane();
        this.c.setLayout(new BorderLayout());
        RepaintManager repaintManager = RepaintManager.currentManager(this);
        repaintManager.setDoubleBufferingEnabled(true);
        this.scrollPane.getViewport().add(this.decode_pdf);
        this.scrollPane.setVerticalScrollBarPolicy(20);
        this.scrollPane.setHorizontalScrollBarPolicy(30);
        this.scrollPane.getVerticalScrollBar().setUnitIncrement(80);
        this.scrollPane.getHorizontalScrollBar().setUnitIncrement(80);
        this.bookmarkScrollPane.setHorizontalScrollBarPolicy(30);
        this.bookmarkScrollPane.setVerticalScrollBarPolicy(20);
        this.navOptionsPanel.setTabPlacement(1);
        this.displayPane = new JSplitPane(1, this.navOptionsPanel, this.scrollPane);
        this.displayPane.setOneTouchExpandable(true);
        this.c.add((Component)this.displayPane, "Center");
    }

    private void createUniqueAnnontationIcons() {
        int n = 20;
        int n2 = 20;
        int n3 = 1;
        for (int i = 1; i < n + 1; ++i) {
            Image[] imageArray = new Image[n2];
            for (int j = 0; j < n2; ++j) {
                imageArray[j] = new BufferedImage(32, 32, 2);
                Graphics2D graphics2D = (Graphics2D)imageArray[j].getGraphics();
                graphics2D.setColor(Color.black);
                graphics2D.fill(new Rectangle(0, 0, 32, 32));
                graphics2D.setColor(Color.red);
                graphics2D.draw(new Rectangle(0, 0, 32, 32));
                graphics2D.setColor(Color.white);
                graphics2D.drawString(i + "/" + j + this.annotTypes[n3], 0, 10);
            }
            this.decode_pdf.addUserIconsForAnnotations(i, this.annotTypes[n3], imageArray);
        }
    }

    private void readChildNodes(Node node, DefaultMutableTreeNode defaultMutableTreeNode) {
        NodeList nodeList = node.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Object object;
            Node node2 = nodeList.item(i);
            Element element = (Element)node2;
            String string = element.getAttribute("title");
            String string2 = element.getAttribute("page");
            String string3 = element.getAttribute("Dest");
            String string4 = element.getAttribute("objectRef");
            this.pageLookupTable.put(string, string2);
            if (string3 != null && string3.indexOf("/XYZ") != -1) {
                String string5;
                object = new StringTokenizer(string3 = string3.substring(string3.indexOf("/XYZ") + 4), "[] ");
                String string6 = ((StringTokenizer)object).nextToken();
                if (string6.equals("null")) {
                    string6 = "0";
                }
                if ((string5 = ((StringTokenizer)object).nextToken()).equals("null")) {
                    string5 = "0";
                }
                this.pointLookupTable.put(string, new Point((int)Float.parseFloat(string6), (int)Float.parseFloat(string5)));
            }
            object = new DefaultMutableTreeNode(string);
            defaultMutableTreeNode.add((MutableTreeNode)object);
            if (!node2.hasChildNodes()) continue;
            this.readChildNodes(node2, (DefaultMutableTreeNode)object);
        }
    }

    private void expandAll() {
        for (int i = 0; i < this.tree.getRowCount(); ++i) {
            this.tree.expandRow(i);
        }
    }

    private void createOutlinePanels() {
        boolean bl = false;
        if (this.showThumbnails) {
            int n = this.decode_pdf.getPageCount();
            if (n > 100) {
                this.showThumbnails = false;
                LogWriter.writeLog("Thumbnails not used on files over 100 pages long");
            } else {
                bl = true;
                this.navOptionsPanel.add((Component)this.thumbnails.setupThumbnails(n, this.textFont, this.getMessage("PdfViewerPageLabel.text"), this.decode_pdf.getPdfPageData()), this.getMessage("PdfViewerTitle.thumbnails"));
                for (int i = 0; i < n; ++i) {
                    this.thumbnails.getButton(i).addActionListener(new PageChanger(i));
                }
                this.thumbnails.addComponentListener(this.painter);
            }
        }
        if (this.decode_pdf.hasOutline() && this.showOutlines) {
            bl = true;
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Root");
            Node node = this.decode_pdf.getOutlineAsXML().getFirstChild();
            if (node != null) {
                this.readChildNodes(node, defaultMutableTreeNode);
                this.tree = new JTree(defaultMutableTreeNode);
                this.expandAll();
                this.tree.setRootVisible(false);
                this.bookmarkScrollPane.getViewport().add(this.tree);
                this.navOptionsPanel.add((Component)this.bookmarkScrollPane, this.getMessage("PdfViewerTitle.bookmarks"));
                this.tree.addTreeSelectionListener(new TreeSelectionListener(){

                    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                        if (SimpleViewer.this.ignoreAlteredBookmark) {
                            return;
                        }
                        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)SimpleViewer.this.tree.getLastSelectedPathComponent();
                        if (defaultMutableTreeNode == null) {
                            return;
                        }
                        Object object = defaultMutableTreeNode.getUserObject();
                        String string = (String)defaultMutableTreeNode.getUserObject();
                        String string2 = (String)SimpleViewer.this.pageLookupTable.get(string);
                        if (string2 != null && string2.length() > 0) {
                            Point point;
                            int n = Integer.parseInt(string2);
                            if (!SimpleViewer.this.isProcessing && SimpleViewer.this.currentPage != n) {
                                SimpleViewer.this.currentPage = n;
                                SimpleViewer.this.scalingBox.setSelectedIndex(0);
                                SimpleViewer.this.decode_pdf.setPageParameters(SimpleViewer.this.scaling, SimpleViewer.this.currentPage);
                                SimpleViewer.this.decodePage(false);
                            }
                            if ((point = (Point)SimpleViewer.this.pointLookupTable.get(string)) != null) {
                                SimpleViewer.this.decode_pdf.ensurePointIsVisible(point);
                            }
                        } else {
                            System.out.println("No dest page set for " + string);
                        }
                    }
                });
                this.tree.getSelectionModel().setSelectionMode(1);
            } else {
                bl = false;
                this.bookmarksButton.setEnabled(false);
            }
        }
        if (bl && !this.showThumbnails) {
            this.navOptionsPanel.setVisible(true);
            this.displayPane.setDividerLocation(this.divLocation);
            this.displayPane.invalidate();
            this.displayPane.repaint();
        }
    }

    private void removeOutlinePanels() {
        this.thumbnails.removeAll();
        this.bookmarkScrollPane.setMinimumSize(new Dimension(50, this.getHeight()));
        if (!this.showThumbnails) {
            this.navOptionsPanel.setVisible(false);
        }
        this.navOptionsPanel.removeAll();
        this.hasOutlinesDrawn = false;
        this.bookmarksButton.setEnabled(this.decode_pdf.hasOutline());
    }

    protected int[] updateXY(MouseEvent mouseEvent) {
        this.x = (int)((float)(mouseEvent.getX() - 25) / this.scaling);
        this.y = (int)((float)(mouseEvent.getY() - 25) / this.scaling);
        if (this.maxViewY != 0) {
            this.x = (int)((double)((float)this.x - (float)this.dx * this.scaling) / this.viewportScale);
            this.y = (int)(((double)this.mediaH - (double)((float)this.mediaH - (float)this.y / this.scaling - (float)this.dy) / this.viewportScale) * (double)this.scaling);
        }
        int[] nArray = new int[2];
        if (this.rotation == 90) {
            nArray[1] = this.x + this.cropY;
            nArray[0] = this.y + this.cropX;
        } else if (this.rotation == 180) {
            nArray[0] = this.mediaW - (this.x + this.mediaW - this.cropW - this.cropX);
            nArray[1] = this.y + this.cropY;
        } else if (this.rotation == 270) {
            nArray[1] = this.mediaH - (this.x + this.mediaH - this.cropH - this.cropY);
            nArray[0] = this.mediaW - (this.y + this.mediaW - this.cropW - this.cropX);
        } else {
            nArray[0] = this.x + this.cropX;
            nArray[1] = this.mediaH - (this.y + this.mediaH - this.cropH - this.cropY);
        }
        return nArray;
    }

    public void checkLinks(boolean bl) {
        this.message = "";
        Rectangle[] rectangleArray = this.decode_pdf.getPageHotspots();
        if (rectangleArray != null) {
            int n = rectangleArray.length;
            int n2 = -1;
            for (int i = 0; i < n; ++i) {
                if (rectangleArray[i] == null || !rectangleArray[i].contains(this.cx, this.cy)) continue;
                n2 = i;
                i = n;
            }
            if (n2 != -1) {
                bl = false;
                if (bl) {
                    Map map = this.pageAnnotations.getAnnotRawData(n2);
                    Map map2 = this.decode_pdf.resolveToMapOrString("A", map);
                    String string = this.pageAnnotations.getAnnotSubType(n2);
                    if (string.equals("Link") && map2 != null) {
                        Iterator iterator = map2.keySet().iterator();
                        JPanel jPanel = new JPanel();
                        jPanel.setLayout(new BoxLayout(jPanel, 1));
                        while (iterator.hasNext()) {
                            String string2 = (String)iterator.next();
                            jPanel.add(new JLabel(string2 + " : " + this.decode_pdf.resolveToMapOrString(string2, map)));
                        }
                        JOptionPane.showMessageDialog(this, jPanel, this.getMessage("PdfViewerTitle.annots"), -1);
                    } else if (string.equals("Text")) {
                        String string3;
                        String string4 = this.pageAnnotations.getField(n2, "T");
                        if (string4 == null) {
                            string4 = this.getMessage("PdfViewerAnnots.notitle");
                        }
                        if ((string3 = this.pageAnnotations.getField(n2, "Contents")) == null) {
                            string3 = this.getMessage("PdfViewerAnnots.nocont");
                        }
                        JOptionPane.showMessageDialog(this, new TextArea(string3), string4, -1);
                    } else if (string.equals("FileAttachment")) {
                        Map map3 = this.decode_pdf.resolveToMapOrString("FS", map);
                        if (map3 != null) {
                            map3 = (Map)map3.get("EF");
                        }
                        if (map3 != null) {
                            map3 = (Map)map3.get("F");
                        }
                        if (map3 != null) {
                            byte[] byArray = (byte[])map3.get("DecodedStream");
                            if (byArray == null) {
                                JOptionPane.showMessageDialog(this, this.getMessage("PdfViewerAnnots.nofile"));
                            } else {
                                JFileChooser jFileChooser = new JFileChooser(this.inputDir);
                                jFileChooser.setFileSelectionMode(0);
                                int n3 = jFileChooser.showSaveDialog(this);
                                if (n3 == 0) {
                                    File file = jFileChooser.getSelectedFile();
                                    try {
                                        FileOutputStream fileOutputStream = new FileOutputStream(file);
                                        fileOutputStream.write(byArray);
                                        fileOutputStream.close();
                                    }
                                    catch (Exception exception) {
                                        exception.printStackTrace();
                                    }
                                }
                            }
                        }
                    } else {
                        JPanel jPanel = new JPanel();
                        jPanel.setLayout(new BoxLayout(jPanel, 1));
                        Iterator iterator = map.keySet().iterator();
                        while (iterator.hasNext()) {
                            String string5 = (String)iterator.next();
                            jPanel.add(new JLabel(string5 + " : " + this.decode_pdf.resolveToMapOrString(string5, map)));
                        }
                        JOptionPane.showMessageDialog(this, jPanel, this.getMessage("PdfViewerAnnots.nosubtype") + " " + string, -1);
                    }
                } else {
                    this.message = this.getMessage("PdfViewerAnnots.entered") + " " + n2;
                }
            }
        }
    }

    protected final JScrollPane createPane(JTextPane jTextPane, String string, boolean bl) throws BadLocationException {
        Object object;
        jTextPane.setEditable(true);
        jTextPane.setFont(new Font("Lucida", 0, 14));
        jTextPane.setToolTipText(this.getMessage("PdfViewerTooltip.text"));
        Document document = jTextPane.getDocument();
        jTextPane.setBorder(BorderFactory.createTitledBorder(new EtchedBorder(), this.getMessage("PdfViewerTitle.text")));
        jTextPane.setForeground(Color.black);
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        SimpleAttributeSet simpleAttributeSet2 = new SimpleAttributeSet();
        SimpleAttributeSet simpleAttributeSet3 = new SimpleAttributeSet();
        StyleConstants.setForeground(simpleAttributeSet, Color.blue);
        StyleConstants.setForeground(simpleAttributeSet2, Color.black);
        StyleConstants.setForeground(simpleAttributeSet3, Color.black);
        int n = 0;
        if (bl && string != null) {
            object = new StringTokenizer(string, "<>", true);
            while (((StringTokenizer)object).hasMoreTokens()) {
                String string2 = ((StringTokenizer)object).nextToken();
                if (string2.equals("<") && ((StringTokenizer)object).hasMoreTokens()) {
                    String string3 = string2 + ((StringTokenizer)object).nextToken() + ((StringTokenizer)object).nextToken();
                    document.insertString(n, string3, simpleAttributeSet);
                    n += string3.length();
                    continue;
                }
                document.insertString(n, string2, simpleAttributeSet2);
                n += string2.length();
            }
        } else {
            document.insertString(n, string, simpleAttributeSet3);
        }
        object = new JScrollPane();
        ((JScrollPane)object).getViewport().add(jTextPane);
        ((JScrollPane)object).setHorizontalScrollBarPolicy(31);
        ((JScrollPane)object).setVerticalScrollBarPolicy(20);
        return object;
    }

    public void updateCords(MouseEvent mouseEvent) {
        int n;
        int n2 = mouseEvent.getX() - 25;
        int n3 = mouseEvent.getY() - 25;
        if (this.maxViewY != 0) {
            n2 = (int)((double)((float)n2 - (float)this.dx * this.scaling) / this.viewportScale);
            n3 = (int)(((double)this.mediaH - (double)((float)this.mediaH - (float)n3 / this.scaling - (float)this.dy) / this.viewportScale) * (double)this.scaling);
        }
        this.cx = (int)((float)n2 / this.scaling);
        this.cy = (int)((float)n3 / this.scaling);
        if (this.rotation == 90) {
            n = this.cx + this.cropY;
            this.cx = this.cy + this.cropX;
            this.cy = n;
        } else if (this.rotation == 180) {
            this.cx = this.mediaW - (this.cx + this.mediaW - this.cropW - this.cropX);
            this.cy += this.cropY;
        } else if (this.rotation == 270) {
            n = this.mediaH - (this.cx + this.mediaH - this.cropH - this.cropY);
            this.cx = this.mediaW - (this.cy + this.mediaW - this.cropW - this.cropX);
            this.cy = n;
        } else {
            this.cx += this.cropX;
            this.cy = this.mediaH - (this.cy + this.mediaH - this.cropH - this.cropY);
        }
        if (this.isProcessing | this.selectedFile == null) {
            coords.setText("  X:  Y:   ");
        } else {
            coords.setText("  X: " + this.cx + " Y: " + this.cy + " " + " " + this.message);
        }
        if (this.allowScrolling && !mouseEvent.isShiftDown()) {
            n = this.decode_pdf.getScrollInterval() * 2;
            Rectangle rectangle = new Rectangle(mouseEvent.getX() - n, mouseEvent.getY() - n, n * 2, n * 2);
            if (!this.decode_pdf.getVisibleRect().contains(rectangle)) {
                this.decode_pdf.scrollRectToVisible(rectangle);
            }
        }
    }

    protected void setupGUI() {
        this.init(null);
        this.setViewerTitle(this.getMessage("PdfViewerOs.message") + "  " + "EO-2.60b11");
        this.initGUIComponents();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this.getContentPane().add((Component)jPanel, "North");
        this.decode_pdf.addMouseMotionListener(new mouse_mover());
        this.decode_pdf.addMouseListener(new mouse_clicker());
        JMenuBar jMenuBar = new JMenuBar();
        jPanel.add((Component)jMenuBar, "North");
        this.createMenu(jMenuBar, true);
        JToolBar jToolBar = new JToolBar();
        jToolBar.setBorder(BorderFactory.createEmptyBorder());
        jToolBar.setLayout(new FlowLayout(3));
        jToolBar.setFloatable(false);
        jToolBar.setFont(new Font("SansSerif", 0, 8));
        jPanel.add((Component)jToolBar, "Center");
        JToolBar jToolBar2 = new JToolBar();
        jToolBar2.setBorder(BorderFactory.createEmptyBorder());
        jToolBar2.setLayout(new FlowLayout(3));
        jToolBar2.setFloatable(false);
        jToolBar2.setFont(new Font("SansSerif", 0, 8));
        jPanel.add((Component)jToolBar2, "South");
        this.createButtons(jToolBar);
        jToolBar.add(Box.createHorizontalGlue());
        jToolBar.add(Box.createHorizontalGlue());
        jToolBar.add(Box.createHorizontalGlue());
        jToolBar.add(Box.createHorizontalGlue());
        this.createPageNavigation(jToolBar);
        this.createPageSizingButtons(jToolBar2);
        this.setupScreen();
    }

    protected void setupScreen() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n = dimension.width / 2;
        int n2 = dimension.height / 2;
        if (n < this.minimumScreenWidth) {
            n = this.minimumScreenWidth;
        }
        this.setSize(n, n2);
        if (this.showThumbnails) {
            this.displayPane.setDividerLocation(this.thumbLocation);
        }
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new FrameCloser());
        this.show();
    }

    protected void createPageSizingButtons(JToolBar jToolBar) {
        JLabel jLabel = new JLabel(this.getMessage("PdfViewerTooltip.scaling"));
        jToolBar.add(jLabel);
        jLabel.setToolTipText(this.getMessage("PdfViewerTooltip.zoomin"));
        jToolBar.add(this.scalingBox);
        this.scalingBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!SimpleViewer.this.isProcessing && SimpleViewer.this.selectedFile != null) {
                    SimpleViewer.this.zoom();
                }
            }
        });
        jToolBar.add(Box.createHorizontalGlue());
        JLabel jLabel2 = new JLabel(this.getMessage("PdfViewerRotation.text"));
        jLabel2.setToolTipText(this.getMessage("PdfViewerTooltip.rotation"));
        jToolBar.add(jLabel2);
        jToolBar.add(this.rotationBox);
        this.rotationBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (SimpleViewer.this.selectedFile != null) {
                    SimpleViewer.this.rotation = Integer.parseInt((String)SimpleViewer.this.rotationBox.getSelectedItem());
                    SimpleViewer.this.zoom();
                    SimpleViewer.this.decode_pdf.updateUI();
                }
            }
        });
        this.statusBar.setColorForSubroutines(Color.blue);
        jToolBar.add(this.statusBar.getStatusObject());
        JToolBar jToolBar2 = new JToolBar();
        jToolBar2.setBorder(BorderFactory.createEmptyBorder());
        jToolBar2.setLayout(new FlowLayout(3));
        jToolBar2.setFloatable(false);
        jToolBar2.setFont(new Font("SansSerif", 2, 10));
        jToolBar2.add(new JLabel(this.getMessage("PdfViewerCursorLoc")));
        jToolBar.add(Box.createHorizontalGlue());
        jToolBar2.add(coords);
        coords.setBackground(Color.white);
        coords.setOpaque(true);
        coords.setBorder(BorderFactory.createLineBorder(Color.black, 1));
        jToolBar.add(jToolBar2);
    }

    protected void createPressedLook(AbstractButton abstractButton, ImageIcon imageIcon) {
        BufferedImage bufferedImage = new BufferedImage(imageIcon.getIconWidth() + 2, imageIcon.getIconHeight() + 2, 2);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.drawImage(imageIcon.getImage(), 1, 1, null);
        graphics2D.dispose();
        ImageIcon imageIcon2 = new ImageIcon(bufferedImage);
        abstractButton.setPressedIcon(imageIcon2);
    }

    private void createButtons(JToolBar jToolBar) {
        this.openButton(jToolBar);
        JButton jButton = new JButton();
        jButton.setBorderPainted(false);
        ImageIcon imageIcon = new ImageIcon(this.getClass().getResource("/org/jpedal/examples/simpleviewer/print.gif"));
        jButton.setIcon(imageIcon);
        this.createPressedLook(jButton, imageIcon);
        jButton.setToolTipText(this.getMessage("PdfViewerPrint.tip"));
        jToolBar.add(jButton);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (printingThreads > 0) {
                    JOptionPane.showMessageDialog(SimpleViewer.this.c, SimpleViewer.this.getMessage("PdfViewerPrintWait.message"));
                } else if (SimpleViewer.this.isProcessing) {
                    JOptionPane.showMessageDialog(SimpleViewer.this.c, SimpleViewer.this.getMessage("PdfViewerDecodeWait.message"));
                } else if (SimpleViewer.this.selectedFile != null) {
                    if (printingThreads == 0) {
                        SimpleViewer.this.printDialog();
                    } else {
                        JOptionPane.showMessageDialog(SimpleViewer.this.c, SimpleViewer.this.getMessage("PdfViewerPrintFinish.message"));
                    }
                } else {
                    JOptionPane.showMessageDialog(SimpleViewer.this.c, SimpleViewer.this.getMessage("PdfViewerNoFile.message"));
                }
            }
        });
        jToolBar.add(Box.createHorizontalGlue());
        this.bookmarksButton.setBorderPainted(false);
        ImageIcon imageIcon2 = new ImageIcon(this.getClass().getResource("/org/jpedal/examples/simpleviewer/bookmarks.gif"));
        this.bookmarksButton.setIcon(imageIcon2);
        this.createPressedLook(this.bookmarksButton, imageIcon2);
        if (this.showThumbnails) {
            this.bookmarksButton.setToolTipText(this.getMessage("PdfViewerShowide.bookmarks"));
        } else {
            this.bookmarksButton.setToolTipText(this.getMessage("PdfViewerShowHide2.bookmarks"));
        }
        jToolBar.add(this.bookmarksButton);
        this.bookmarksButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = !SimpleViewer.this.navOptionsPanel.isVisible();
                SimpleViewer.this.navOptionsPanel.setVisible(bl);
                if (bl) {
                    SimpleViewer.this.displayPane.setDividerLocation(SimpleViewer.this.divLocation);
                } else {
                    SimpleViewer.this.displayPane.setDividerLocation(0);
                }
            }
        });
        jToolBar.add(Box.createHorizontalGlue());
        this.createPropertyIcon(jToolBar);
        this.createFontButton(jToolBar);
        this.createAboutButton(jToolBar);
    }

    protected void openButton(JToolBar jToolBar) {
        JButton jButton = new JButton();
        ImageIcon imageIcon = new ImageIcon(this.getClass().getResource("/org/jpedal/examples/simpleviewer/open.gif"));
        jButton.setIcon(imageIcon);
        this.createPressedLook(jButton, imageIcon);
        jButton.setToolTipText(this.getMessage("PdfViewerTooltip.open"));
        jButton.setBorderPainted(false);
        jToolBar.add(jButton);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (printingThreads > 0) {
                    JOptionPane.showMessageDialog(SimpleViewer.this.c, SimpleViewer.this.getMessage("PdfViewerPrintWait.message"));
                } else if (SimpleViewer.this.isProcessing) {
                    JOptionPane.showMessageDialog(SimpleViewer.this.c, SimpleViewer.this.getMessage("PdfViewerDecodeWait.message"));
                } else {
                    SimpleViewer.this.selectFile();
                }
            }
        });
        jToolBar.add(Box.createHorizontalGlue());
    }

    protected void createPropertyIcon(JToolBar jToolBar) {
        JButton jButton = new JButton();
        jButton.setBorderPainted(false);
        ImageIcon imageIcon = new ImageIcon(this.getClass().getResource("/org/jpedal/examples/simpleviewer/properties.gif"));
        jButton.setIcon(imageIcon);
        this.createPressedLook(jButton, imageIcon);
        jButton.setToolTipText(this.getMessage("PdfViewer.propsMessage"));
        jToolBar.add(jButton);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SimpleViewer.this.showPropertiesBox();
            }
        });
        jToolBar.add(Box.createHorizontalGlue());
    }

    protected void createAboutButton(JToolBar jToolBar) {
        JButton jButton = new JButton();
        jButton.setBorderPainted(false);
        ImageIcon imageIcon = new ImageIcon(this.getClass().getResource("/org/jpedal/examples/simpleviewer/about.gif"));
        jButton.setIcon(imageIcon);
        this.createPressedLook(jButton, imageIcon);
        jButton.setToolTipText(this.getMessage("PdfViewerTooltip.about"));
        jToolBar.add(jButton);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SimpleViewer.this.showInfoBox();
            }
        });
    }

    protected void createFontButton(JToolBar jToolBar) {
        JButton jButton = new JButton();
        jButton.setBorderPainted(false);
        ImageIcon imageIcon = new ImageIcon(this.getClass().getResource("/org/jpedal/examples/simpleviewer/font.gif"));
        jButton.setIcon(imageIcon);
        this.createPressedLook(jButton, imageIcon);
        jButton.setToolTipText(this.getMessage("PdfViewerFontDetails.text"));
        jToolBar.add(jButton);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SimpleViewer.this.showFontsBox();
            }
        });
        jToolBar.add(Box.createHorizontalGlue());
    }

    protected void createPageNavigation(JToolBar jToolBar) {
        URL uRL = this.getClass().getResource("/org/jpedal/examples/simpleviewer/start.gif");
        this.first.setBorderPainted(false);
        this.first.setIcon(new ImageIcon(uRL));
        this.createPressedLook(this.first, new ImageIcon(uRL));
        this.first.setToolTipText(this.getMessage("PdfViewerRewindToStart"));
        jToolBar.add(this.first);
        this.first.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (SimpleViewer.this.selectedFile != null && SimpleViewer.this.pageCount > 1 && SimpleViewer.this.currentPage != 1) {
                    SimpleViewer.this.back(SimpleViewer.this.currentPage - 1);
                }
            }
        });
        URL uRL2 = this.getClass().getResource("/org/jpedal/examples/simpleviewer/fback.gif");
        this.fback.setBorderPainted(false);
        this.fback.setIcon(new ImageIcon(uRL2));
        this.createPressedLook(this.fback, new ImageIcon(uRL2));
        this.fback.setToolTipText(this.getMessage("PdfViewerRewind10"));
        jToolBar.add(this.fback);
        this.fback.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (SimpleViewer.this.selectedFile != null) {
                    SimpleViewer.this.back(10);
                }
            }
        });
        URL uRL3 = this.getClass().getResource("/org/jpedal/examples/simpleviewer/back.gif");
        this.back.setBorderPainted(false);
        this.back.setIcon(new ImageIcon(uRL3));
        this.createPressedLook(this.back, new ImageIcon(uRL3));
        this.back.setToolTipText(this.getMessage("PdfViewerRewind1"));
        jToolBar.add(this.back);
        this.back.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (SimpleViewer.this.selectedFile != null) {
                    SimpleViewer.this.back(1);
                }
            }
        });
        jToolBar.add(this.pageCounter1);
        jToolBar.add(this.pageCounter2);
        jToolBar.add(this.pageCounter3);
        URL uRL4 = this.getClass().getResource("/org/jpedal/examples/simpleviewer/forward.gif");
        this.forward.setBorderPainted(false);
        this.forward.setIcon(new ImageIcon(uRL4));
        this.createPressedLook(this.forward, new ImageIcon(uRL4));
        this.forward.setToolTipText(this.getMessage("PdfViewerForward1"));
        jToolBar.add(this.forward);
        this.forward.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (SimpleViewer.this.selectedFile != null) {
                    SimpleViewer.this.forward(1);
                }
            }
        });
        URL uRL5 = this.getClass().getResource("/org/jpedal/examples/simpleviewer/fforward.gif");
        this.fforward.setBorderPainted(false);
        this.fforward.setIcon(new ImageIcon(uRL5));
        this.createPressedLook(this.fforward, new ImageIcon(uRL5));
        this.fforward.setToolTipText(this.getMessage("PdfViewerForward10"));
        jToolBar.add(this.fforward);
        this.fforward.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (SimpleViewer.this.selectedFile != null) {
                    SimpleViewer.this.forward(10);
                }
            }
        });
        URL uRL6 = this.getClass().getResource("/org/jpedal/examples/simpleviewer/end.gif");
        this.end.setBorderPainted(false);
        this.end.setIcon(new ImageIcon(uRL6));
        this.createPressedLook(this.end, new ImageIcon(uRL6));
        this.end.setToolTipText(this.getMessage("PdfViewerForwardLast"));
        jToolBar.add(this.end);
        this.end.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (SimpleViewer.this.selectedFile != null && SimpleViewer.this.pageCount > 1 && SimpleViewer.this.pageCount - SimpleViewer.this.currentPage > 0) {
                    SimpleViewer.this.forward(SimpleViewer.this.pageCount - SimpleViewer.this.currentPage);
                }
            }
        });
        jToolBar.add(Box.createHorizontalGlue());
    }

    protected void initGUIComponents() {
        String[] stringArray = new String[]{this.getMessage("PdfViewerScaleWindow.text"), this.getMessage("PdfViewerScaleHeight.text"), this.getMessage("PdfViewerScaleWidth.text"), "25", "50", "75", "100", "125", "150", "200", "250", "500", "750", "1000"};
        this.scalingValues = stringArray;
        float[] fArray = new float[]{1.0f, 1.0f, 1.0f, 0.25f, 0.5f, 0.75f, 1.0f, 1.25f, 1.5f, 2.0f, 2.5f, 5.0f, 7.5f, 10.0f};
        this.scalingFloatValues = fArray;
        this.scalingBox = new JComboBox<String>(stringArray);
        if (!this.showThumbnails) {
            this.navOptionsPanel.setVisible(false);
        }
        this.pageCounter1 = new JLabel(this.getMessage("PdfViewerPageLabel.text"));
        this.pageCounter1.setOpaque(false);
        this.pageCounter2.setEditable(true);
        this.pageCounter2.setToolTipText(this.getMessage("PdfViewerTooltip.goto"));
        this.pageCounter2.setBorder(BorderFactory.createLineBorder(Color.black));
        this.pageCounter2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n;
                String string = SimpleViewer.this.pageCounter2.getText().trim();
                try {
                    n = Integer.parseInt(string);
                    if (n > SimpleViewer.this.decode_pdf.getPageCount() | n < 1) {
                        JOptionPane.showMessageDialog(SimpleViewer.this.c, SimpleViewer.this.getMessage("PdfViewerPageLabel.text") + " " + string + " " + SimpleViewer.this.getMessage("PdfViewerOutOfRange.text") + " " + SimpleViewer.this.decode_pdf.getPageCount());
                        n = SimpleViewer.this.currentPage;
                        SimpleViewer.this.pageCounter2.setText("" + SimpleViewer.this.currentPage);
                    }
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(SimpleViewer.this.c, ">" + string + "< " + SimpleViewer.this.getMessage("PdfViewerInvalidNumber.text"));
                    n = SimpleViewer.this.currentPage;
                    SimpleViewer.this.pageCounter2.setText("" + SimpleViewer.this.currentPage);
                }
                if (!SimpleViewer.this.isProcessing && SimpleViewer.this.currentPage != n) {
                    SimpleViewer.this.currentPage = n;
                    SimpleViewer.this.decodePage(false);
                    SimpleViewer.this.zoom();
                }
            }
        });
        this.pageCounter3 = new JLabel(this.getMessage("PdfViewerOfLabel.text") + " ");
        this.pageCounter3.setOpaque(false);
        this.scalingBox.setBackground(Color.white);
        this.scalingBox.setEditable(true);
        this.scalingBox.setPreferredSize(new Dimension(85, 25));
        this.scalingBox.setSelectedIndex(0);
        this.rotationBox.setBackground(Color.white);
        this.rotationBox.setSelectedIndex(0);
    }

    protected void createMenu(JMenuBar jMenuBar, boolean bl) {
        JMenu jMenu;
        JMenu jMenu2 = new JMenu(this.getMessage("PdfViewerFile.text"));
        jMenuBar.add(jMenu2);
        if (bl) {
            jMenu = new JMenu(this.getMessage("PdfViewerHelp.text"));
            jMenuBar.add(jMenu);
            this.infoOption(jMenu);
        }
        jMenu = new JMenu(this.getMessage("PdfViewerMenu.options"));
        jMenuBar.add(jMenu);
        this.optionAutoscroll(jMenu);
        if (bl) {
            this.openOption(jMenu2);
            this.saveOption(jMenu2);
        }
        this.fontsOption(jMenu2);
        this.docInfoOption(jMenu2);
        this.pageInfoOption(jMenu2);
        if (bl) {
            this.printOption(jMenu2);
        }
        this.exitOption(jMenu2);
    }

    private void optionAutoscroll(JMenu jMenu) {
        JMenuItem jMenuItem = new JMenuItem(this.getMessage("PdfViewerTitle.autoscroll"));
        jMenuItem.setToolTipText(this.getMessage("PdfViewerTooltip.autoscroll"));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SimpleViewer.this.allowScrolling = !SimpleViewer.this.allowScrolling;
            }
        });
        jMenu.add(jMenuItem);
    }

    private void exitOption(JMenu jMenu) {
        JMenuItem jMenuItem = new JMenuItem(this.getMessage("PdfViewerExit.text"));
        jMenuItem.setToolTipText(this.getMessage("PdfViewerShutdown.text"));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (printingThreads > 0) {
                    JOptionPane.showMessageDialog(SimpleViewer.this.c, SimpleViewer.this.getMessage("PdfViewerStillPrinting.text"));
                } else {
                    SimpleViewer.this.exit();
                }
            }
        });
        jMenu.add(jMenuItem);
    }

    private void printOption(JMenu jMenu) {
        JMenuItem jMenuItem = new JMenuItem(this.getMessage("PdfViewerPrint.text"));
        jMenu.add(jMenuItem);
        jMenuItem.setToolTipText(this.getMessage("PdfViewerTooltip.print"));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (SimpleViewer.this.selectedFile != null) {
                    if (printingThreads == 0) {
                        SimpleViewer.this.printDialog();
                    } else {
                        JOptionPane.showMessageDialog(SimpleViewer.this.c, SimpleViewer.this.getMessage("PdfViewerPrintFinish.message"));
                    }
                } else {
                    JOptionPane.showMessageDialog(SimpleViewer.this.c, SimpleViewer.this.getMessage("PdfViewerNoFile.message"));
                }
            }
        });
    }

    private void pageInfoOption(JMenu jMenu) {
        JMenuItem jMenuItem = new JMenuItem(this.getMessage("PdfViewerMenu.pageSize"));
        jMenuItem.setToolTipText(this.getMessage("PdfViewerTooltip.pageSize"));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PdfPageData pdfPageData = SimpleViewer.this.decode_pdf.getPdfPageData();
                if (pdfPageData != null) {
                    JPanel jPanel = new JPanel();
                    jPanel.setLayout(new BoxLayout(jPanel, 3));
                    JLabel jLabel = new JLabel(SimpleViewer.this.getMessage("PdfViewerCoords.text"));
                    jLabel.setFont(SimpleViewer.this.headFont);
                    jPanel.add(jLabel);
                    jPanel.add(Box.createRigidArea(new Dimension(0, 5)));
                    JLabel jLabel2 = new JLabel(SimpleViewer.this.getMessage("PdfViewermediaBox.text") + pdfPageData.getMediaValue(SimpleViewer.this.currentPage));
                    jLabel2.setFont(SimpleViewer.this.textFont);
                    jPanel.add(jLabel2);
                    jPanel.add(Box.createRigidArea(new Dimension(0, 5)));
                    JLabel jLabel3 = new JLabel(SimpleViewer.this.getMessage("PdfViewercropBox.text") + pdfPageData.getCropValue(SimpleViewer.this.currentPage));
                    jLabel3.setFont(SimpleViewer.this.textFont);
                    jPanel.add(jLabel3);
                    jPanel.add(Box.createRigidArea(new Dimension(0, 5)));
                    JLabel jLabel4 = new JLabel(SimpleViewer.this.getMessage("PdfViewerrotation.text") + pdfPageData.getRotation(SimpleViewer.this.currentPage));
                    jLabel4.setFont(SimpleViewer.this.textFont);
                    jPanel.add(jLabel4);
                    jPanel.add(Box.createRigidArea(new Dimension(0, 5)));
                    JOptionPane.showMessageDialog(SimpleViewer.this.c, jPanel, SimpleViewer.this.getMessage("PdfViewersize.text"), -1);
                } else {
                    JOptionPane.showMessageDialog(SimpleViewer.this.c, SimpleViewer.this.getMessage("PdfVieweremptyFile.message"), SimpleViewer.this.getMessage("PdfViewerTooltip.pageSize"), -1);
                }
            }
        });
        jMenu.add(jMenuItem);
    }

    private void docInfoOption(JMenu jMenu) {
        JMenuItem jMenuItem = new JMenuItem(this.getMessage("PdfViewerProperties"));
        jMenuItem.setToolTipText(this.getMessage("PdfViewerMenu.props"));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SimpleViewer.this.showPropertiesBox();
            }
        });
        jMenu.add(jMenuItem);
    }

    private void fontsOption(JMenu jMenu) {
        JMenuItem jMenuItem = new JMenuItem(this.getMessage("PdfViewerMenu.fonts"));
        jMenuItem.setToolTipText(this.getMessage("PdfViewerTooltip.fonts"));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SimpleViewer.this.showFontsBox();
            }
        });
        jMenu.add(jMenuItem);
    }

    private void infoOption(JMenu jMenu) {
        JMenuItem jMenuItem = new JMenuItem(this.getMessage("PdfViewerMenu.about"));
        jMenuItem.setToolTipText(this.getMessage("PdfViewerTooltip.about"));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SimpleViewer.this.showInfoBox();
            }
        });
        jMenu.add(jMenuItem);
    }

    private void openOption(JMenu jMenu) {
        JMenuItem jMenuItem = new JMenuItem(this.getMessage("PdfViewerOpen.text"));
        jMenuItem.setToolTipText(this.getMessage("PdfViewerTooltip.open"));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (printingThreads > 0) {
                    JOptionPane.showMessageDialog(SimpleViewer.this.c, SimpleViewer.this.getMessage("PdfViewerPrintWait.message"));
                } else if (SimpleViewer.this.isProcessing) {
                    JOptionPane.showMessageDialog(SimpleViewer.this.c, SimpleViewer.this.getMessage("PdfViewerDecodeWait.message"));
                } else {
                    SimpleViewer.this.selectFile();
                }
            }
        });
        jMenu.add(jMenuItem);
    }

    private void saveOption(JMenu jMenu) {
        JMenuItem jMenuItem = new JMenuItem(this.getMessage("PdfViewerSave.text"));
        jMenuItem.setToolTipText(this.getMessage("PdfViewerTooltip.save"));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = new JFileChooser(SimpleViewer.this.inputDir);
                jFileChooser.setSelectedFile(new File(SimpleViewer.this.inputDir + "/" + SimpleViewer.this.selectedFile));
                jFileChooser.addChoosableFileFilter(new FileFilterer(new String[]{"pdf"}, "Pdf (*.pdf)"));
                jFileChooser.setFileSelectionMode(0);
                int n = jFileChooser.showSaveDialog(null);
                if (n == 0) {
                    File file = jFileChooser.getSelectedFile();
                    FileInputStream fileInputStream = null;
                    FileOutputStream fileOutputStream = null;
                    try {
                        int n2;
                        fileInputStream = new FileInputStream(SimpleViewer.this.selectedFile);
                        fileOutputStream = new FileOutputStream(file.toString() + ".pdf");
                        byte[] byArray = new byte[4096];
                        while ((n2 = fileInputStream.read(byArray)) != -1) {
                            fileOutputStream.write(byArray, 0, n2);
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    try {
                        fileInputStream.close();
                        fileOutputStream.close();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        });
        jMenu.add(jMenuItem);
    }

    protected void showPropertiesBox() {
        PdfFileInformation pdfFileInformation = this.decode_pdf.getFileInformationData();
        if (pdfFileInformation != null) {
            JPanel jPanel = new JPanel();
            jPanel.setOpaque(false);
            jPanel.setLayout(new BoxLayout(jPanel, 1));
            JLabel jLabel = new JLabel(this.getMessage("PdfViewerGeneral"));
            jLabel.setFont(this.headFont);
            jLabel.setOpaque(false);
            jPanel.add(jLabel);
            jLabel.setAlignmentX(0.5f);
            JLabel jLabel2 = new JLabel(this.getMessage("PdfViewerFileName") + this.selectedFile);
            jLabel2.setFont(this.textFont);
            jLabel2.setOpaque(false);
            jPanel.add(jLabel2);
            JLabel jLabel3 = new JLabel(this.getMessage("PdfViewerFilePath") + this.inputDir);
            jLabel3.setFont(this.textFont);
            jLabel3.setOpaque(false);
            jPanel.add(jLabel3);
            JLabel jLabel4 = new JLabel(this.getMessage("PdfViewerFileSize") + this.size + " K");
            jLabel4.setFont(this.textFont);
            jLabel3.setOpaque(false);
            jPanel.add(jLabel4);
            JLabel jLabel5 = new JLabel(this.getMessage("PdfViewerPageCount") + this.pageCount);
            jLabel5.setOpaque(false);
            jLabel5.setFont(this.textFont);
            jPanel.add(jLabel5);
            JLabel jLabel6 = new JLabel("PDF " + this.decode_pdf.getPDFVersion());
            jLabel6.setOpaque(false);
            jLabel6.setFont(this.textFont);
            jPanel.add(jLabel6);
            jPanel.add(Box.createRigidArea(new Dimension(0, 15)));
            JLabel jLabel7 = new JLabel(this.getMessage("PdfViewerProperties"));
            jLabel7.setFont(this.headFont);
            jLabel7.setOpaque(false);
            jPanel.add(jLabel7);
            jLabel7.setAlignmentX(0.5f);
            String[] stringArray = pdfFileInformation.getFieldValues();
            String[] stringArray2 = pdfFileInformation.getFieldNames();
            int n = stringArray2.length;
            JLabel[] jLabelArray = new JLabel[n];
            for (int i = 0; i < n; ++i) {
                if (stringArray[i].length() <= 0) continue;
                jLabelArray[i] = new JLabel(stringArray2[i] + " = " + stringArray[i]);
                jLabelArray[i].setFont(this.textFont);
                jLabelArray[i].setOpaque(false);
                jPanel.add(jLabelArray[i]);
            }
            jPanel.add(Box.createRigidArea(new Dimension(0, 5)));
            String string = pdfFileInformation.getFileXMLMetaData();
            if (string.length() > 0) {
                JLabel jLabel8 = new JLabel("XML metadata");
                jLabel8.setFont(this.headFont);
                jPanel.add(jLabel8);
                JTextArea jTextArea = new JTextArea();
                jTextArea.setRows(5);
                jTextArea.setColumns(15);
                jTextArea.setLineWrap(true);
                jTextArea.setText(string);
                jPanel.add(new JScrollPane(jTextArea));
                jTextArea.setCaretPosition(0);
                jTextArea.setOpaque(false);
                jPanel.add(Box.createRigidArea(new Dimension(0, 5)));
            }
            jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            JOptionPane.showMessageDialog(this, jPanel, this.getMessage("PdfViewerMenu.props"), -1);
        } else {
            JOptionPane.showMessageDialog(this, this.getMessage("PdfVieweremptyFile.message"), this.getMessage("PdfViewerMenu.props"), -1);
        }
    }

    private void showFontsBox() {
        JPanel jPanel = new JPanel();
        jPanel.setPreferredSize(new Dimension(400, 300));
        jPanel.setOpaque(false);
        jPanel.setEnabled(false);
        jPanel.setLayout(new BoxLayout(jPanel, 3));
        JLabel jLabel = new JLabel(this.getMessage("PdfViewerFontList.title"));
        jLabel.setFont(this.headFont);
        jLabel.setOpaque(false);
        jPanel.add(jLabel);
        jLabel.setAlignmentX(0.5f);
        jPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        String string = this.decode_pdf.getFontsInFile();
        if (string.length() > 0) {
            JTextArea jTextArea = new JTextArea();
            jTextArea.setLineWrap(false);
            jTextArea.setText(string);
            jPanel.add(jTextArea);
            jTextArea.setCaretPosition(0);
            jTextArea.setOpaque(false);
            jPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        }
        JOptionPane.showMessageDialog(this, jPanel, this.getMessage("PdfViewerFontList.subtitle"), -1);
    }

    protected void showInfoBox() {
        Accessible accessible;
        JPanel jPanel = new JPanel();
        jPanel.setPreferredSize(new Dimension(400, 230));
        jPanel.setOpaque(false);
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        JLabel jLabel = new JLabel(this.getMessage("PdfViewerInfo.title"));
        jLabel.setOpaque(false);
        jLabel.setFont(this.headFont);
        jLabel.setAlignmentX(0.5f);
        jPanel.add(jLabel);
        jPanel.add(Box.createRigidArea(new Dimension(0, 15)));
        String string = this.getMessage("PdfViewerInfo1") + this.getMessage("PdfViewerInfo2");
        if (string.length() > 0) {
            accessible = new JTextArea();
            ((JComponent)((Object)accessible)).setOpaque(false);
            ((JTextComponent)accessible).setText(string);
            ((JTextArea)accessible).setLineWrap(true);
            ((JTextArea)accessible).setWrapStyleWord(true);
            jPanel.add((Component)((Object)accessible));
            ((JComponent)((Object)accessible)).setAlignmentX(0.5f);
        }
        accessible = new ImageIcon(this.getClass().getResource("/org/jpedal/examples/simpleviewer/logo.gif"));
        jPanel.add(Box.createRigidArea(new Dimension(0, 25)));
        JLabel jLabel2 = new JLabel((Icon)((Object)accessible));
        jLabel2.setAlignmentX(0.5f);
        jPanel.add(jLabel2);
        JLabel jLabel3 = new JLabel("http://www.jpedal.org");
        jLabel3.setForeground(Color.blue);
        jLabel3.setAlignmentX(0.5f);
        jPanel.add(jLabel3);
        jPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JOptionPane.showMessageDialog(this, jPanel, this.getMessage("PdfViewerInfo3"), -1);
    }

    protected void printDialog() {
        if (!this.isPDF) {
            JOptionPane.showMessageDialog(this.c, "Printing is not available on images at this time");
        } else {
            ++printingThreads;
            Thread thread = new Thread(){

                public void run() {
                    Object var1_1 = null;
                    boolean bl = false;
                    try {
                        String string = SimpleViewer.this.getMessage("PdfViewera4Border");
                        SimpleViewer.this.decode_pdf.enableScaledPrinting(false);
                        PrinterJob printerJob = PrinterJob.getPrinterJob();
                        PageFormat pageFormat = printerJob.defaultPage();
                        Paper paper = new Paper();
                        paper.setSize(595.0, 842.0);
                        paper.setImageableArea(43.0, 43.0, 509.0, 756.0);
                        boolean bl2 = true;
                        block13: while (bl2) {
                            Object[] objectArray = new String[]{SimpleViewer.this.getMessage("PdfViewerHelp.text"), SimpleViewer.this.getMessage("PdfViewera4"), SimpleViewer.this.getMessage("PdfViewera4borderless"), SimpleViewer.this.getMessage("PdfViewera5"), SimpleViewer.this.getMessage("PdfVieweruseScaleOnPrinting.text"), SimpleViewer.this.getMessage("PdfViewerCancel.text"), SimpleViewer.this.getMessage("PdfViewerPrint.text")};
                            JTextArea jTextArea = new JTextArea(SimpleViewer.this.getMessage("PdfViewerPrintInfo1") + "\n=============\n" + SimpleViewer.this.getMessage("PdfViewerPrintInfo2") + " " + string + "\n" + SimpleViewer.this.getMessage("PdfViewerPrintInfo3") + paper.getWidth() + "\n" + SimpleViewer.this.getMessage("PdfViewerPrintInfo4") + paper.getHeight() + "\n" + SimpleViewer.this.getMessage("PdfViewerPrintInfo5") + paper.getImageableX() + " " + paper.getImageableY() + " " + paper.getImageableWidth() + " " + paper.getImageableHeight() + "\n" + SimpleViewer.this.getMessage("PdfViewerPrintInfo6") + "\n\n" + SimpleViewer.this.getMessage("PdfViewerPrintInfo7") + "\n===========\n" + SimpleViewer.this.getMessage("PdfViewerPrintInfo8") + "\n" + SimpleViewer.this.getMessage("PdfViewerPrintInfo9") + "\n" + SimpleViewer.this.getMessage("PdfViewerPrintInfo10") + "\n\n" + SimpleViewer.this.getMessage("PdfViewerPrintScalingValue") + SimpleViewer.this.decode_pdf.getScaleForPrinting());
                            jTextArea.setColumns(30);
                            jTextArea.setWrapStyleWord(true);
                            int n = JOptionPane.showOptionDialog(SimpleViewer.this.c, jTextArea, SimpleViewer.this.getMessage("PdfViewerPrintOptions.title"), 0, 1, null, objectArray, objectArray[0]);
                            switch (n) {
                                case 0: {
                                    JTextArea jTextArea2 = new JTextArea(SimpleViewer.this.getMessage("PdfViewerHelp.message"));
                                    JOptionPane.showMessageDialog(SimpleViewer.this.c, jTextArea2);
                                    continue block13;
                                }
                                case 1: {
                                    string = SimpleViewer.this.getMessage("PdfViewera4");
                                    paper.setSize(595.0, 842.0);
                                    paper.setImageableArea(43.0, 43.0, 509.0, 756.0);
                                    continue block13;
                                }
                                case 2: {
                                    string = SimpleViewer.this.getMessage("PdfViewera4borderless");
                                    paper.setSize(595.0, 842.0);
                                    paper.setImageableArea(0.0, 0.0, 595.0, 842.0);
                                    JOptionPane.showMessageDialog(SimpleViewer.this.c, SimpleViewer.this.getMessage("PdfViewerPrintWarning"));
                                    continue block13;
                                }
                                case 3: {
                                    string = SimpleViewer.this.getMessage("PdfViewera5");
                                    paper.setSize(297.0, 421.0);
                                    paper.setImageableArea(23.0, 23.0, 254.0, 378.0);
                                    continue block13;
                                }
                                case 4: {
                                    if (SimpleViewer.this.decode_pdf.usePageScaling) {
                                        SimpleViewer.this.decode_pdf.enableScaledPrinting(false);
                                        continue block13;
                                    }
                                    SimpleViewer.this.decode_pdf.enableScaledPrinting(true);
                                    continue block13;
                                }
                                case 5: {
                                    bl = true;
                                    bl2 = false;
                                    continue block13;
                                }
                                case 6: {
                                    bl2 = false;
                                    continue block13;
                                }
                            }
                            System.out.println("No selection");
                        }
                        if (!bl) {
                            pageFormat.setPaper(paper);
                            printerJob.setPageable(SimpleViewer.this.decode_pdf);
                            SimpleViewer.this.decode_pdf.setPageFormat(pageFormat);
                            boolean bl3 = printerJob.printDialog();
                            if (bl3) {
                                printerJob.print();
                            }
                        }
                    }
                    catch (PrinterException printerException) {
                        LogWriter.writeLog("Exception " + printerException + " printing");
                        JOptionPane.showMessageDialog(SimpleViewer.this.c, printerException.getMessage() + " " + printerException + " " + " " + printerException.getCause());
                    }
                    catch (Exception exception) {
                        LogWriter.writeLog("Exception " + exception + " printing");
                        exception.printStackTrace();
                        JOptionPane.showMessageDialog(SimpleViewer.this.c, "Exception " + exception);
                    }
                    catch (Error error) {
                        LogWriter.writeLog("Error " + error + " printing");
                        JOptionPane.showMessageDialog(SimpleViewer.this.c, "Error " + error);
                    }
                    if (!bl && !SimpleViewer.this.decode_pdf.isPageSuccessful()) {
                        JOptionPane.showMessageDialog(SimpleViewer.this.c, "Problems encountered\n " + SimpleViewer.this.decode_pdf.getPageFailureMessage() + "\n");
                    }
                    --printingThreads;
                    SimpleViewer.this.decode_pdf.invalidate();
                    SimpleViewer.this.decode_pdf.updateUI();
                    SimpleViewer.this.repaint();
                    if (!bl) {
                        JOptionPane.showMessageDialog(SimpleViewer.this.c, SimpleViewer.this.getMessage("PdfViewerPrintingFinished"));
                    }
                }
            };
            thread.start();
        }
    }

    public static void main(String[] stringArray) {
        current = new SimpleViewer();
        if (stringArray.length > 0) {
            current.setupViewer(stringArray[0]);
        } else {
            current.setupViewer();
        }
    }

    public void selectFile() {
        JFileChooser jFileChooser = new JFileChooser(this.inputDir);
        if (this.selectedFile != null) {
            jFileChooser.setSelectedFile(new File(this.selectedFile));
        }
        jFileChooser.setFileSelectionMode(0);
        String[] stringArray = new String[]{"pdf"};
        String[] stringArray2 = new String[]{"png", "tif", "tiff", "jpg", "jpeg"};
        jFileChooser.addChoosableFileFilter(new FileFilterer(stringArray2, "Images (Tiff, Jpeg,Png)"));
        jFileChooser.addChoosableFileFilter(new FileFilterer(stringArray, "Pdf (*.pdf)"));
        int n = jFileChooser.showOpenDialog(this.c);
        this.decode_pdf.invalidate();
        this.decode_pdf.repaint();
        File file = jFileChooser.getSelectedFile();
        if (file != null && n == 0) {
            try {
                this.selectedFile = file.getCanonicalPath();
                this.size = file.length() >> 10;
                this.inputDir = jFileChooser.getCurrentDirectory().getCanonicalPath();
                this.setViewerTitle(null);
            }
            catch (Exception exception) {
                System.err.println("Exception " + exception + " getting paths");
            }
            File file2 = new File(this.selectedFile);
            if (!file2.exists()) {
                JOptionPane.showMessageDialog(this, this.getMessage("PdfViewerFile.text") + this.selectedFile + this.getMessage("PdfViewerNotExist"));
            } else if (this.selectedFile != null & !this.isProcessing) {
                this.decode_pdf.repaint();
                if (this.isProcessing | this.worker != null && this.thumbnails.drawing) {
                    this.thumbnails.interrupt = true;
                    while (this.thumbnails.drawing) {
                        try {
                            Thread.sleep(20L);
                        }
                        catch (InterruptedException interruptedException) {
                            interruptedException.printStackTrace();
                        }
                    }
                    this.thumbnails.interrupt = false;
                }
                this.decode_pdf.flushObjectValues(true);
                this.decode_pdf.resetViewableArea();
                this.thumbnails.removeComponentListener(this.painter);
                this.openFile(this.selectedFile);
            }
        } else {
            this.decode_pdf.repaint();
            JOptionPane.showMessageDialog(this, this.getMessage("PdfViewerNoSelection"));
        }
    }

    public void setViewerTitle(String string) {
        if (string != null) {
            this.setTitle(string);
        } else {
            this.setViewerTitle(this.getMessage("PdfViewerOs.message") + "  " + "EO-2.60b11" + " " + this.selectedFile);
        }
    }

    public void openFile(File file, String string) {
        this.showThumbnails = this.showThumbnailsdefault;
        this.maxViewY = 0;
        try {
            int n;
            Object v;
            boolean bl = this.openUpFile(file.getCanonicalPath());
            Node node = this.decode_pdf.getOutlineAsXML().getFirstChild();
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Root");
            if (node != null) {
                this.readChildNodes(node, defaultMutableTreeNode);
            }
            if ((v = this.pageLookupTable.get(string)) == null) {
                throw new PdfException("Unknown bookmark " + string);
            }
            this.currentPage = n = Integer.parseInt((String)v);
            if (bl) {
                this.processPage();
            }
        }
        catch (Exception exception) {
            System.err.println("Exception " + exception + " processing file");
            this.isProcessing = false;
        }
    }

    public void openFile(File file, int n) {
        this.showThumbnails = this.showThumbnailsdefault;
        this.maxViewY = 0;
        try {
            boolean bl = this.openUpFile(file.getCanonicalPath());
            this.currentPage = n;
            if (bl) {
                this.processPage();
            }
        }
        catch (Exception exception) {
            System.err.println("Exception " + exception + " processing file");
            this.isProcessing = false;
        }
    }

    private void openFile(String string) {
        String string2 = System.getProperty("hires");
        if (string2 != null) {
            this.useHiresImage = true;
        }
        this.showThumbnails = this.showThumbnailsdefault;
        this.maxViewY = 0;
        this.isPDF = string.toLowerCase().endsWith(".pdf");
        boolean bl = this.openUpFile(string);
        this.currentPage = 1;
        try {
            if (bl) {
                this.processPage();
            }
        }
        catch (Exception exception) {
            System.err.println("Exception " + exception + " decoding file");
            exception.printStackTrace();
        }
        this.isProcessing = false;
    }

    private boolean openUpFile(String string) {
        this.maxViewY = 0;
        boolean bl = true;
        this.scaling = 1.0f;
        this.scalingBox.setSelectedIndex(0);
        this.decode_pdf.closePdfFile();
        try {
            if (this.isPDF) {
                this.decode_pdf.openPdfFile(string);
            } else {
                boolean bl2;
                boolean bl3 = bl2 = string.toLowerCase().indexOf(".tif") != -1;
                if (bl2) {
                    try {
                        this.img = JAI.create((String)"fileload", (Object)string).getAsBufferedImage();
                    }
                    catch (Exception exception) {
                        LogWriter.writeLog("Exception " + exception + " loading " + string);
                    }
                } else {
                    try {
                        this.img = ImageIO.read(new File(string));
                    }
                    catch (Exception exception) {
                        LogWriter.writeLog("Exception " + exception + " loading " + string);
                    }
                }
                this.decode_pdf.resetForNonPDFPage();
                PdfPageData pdfPageData = this.decode_pdf.getPdfPageData();
                pdfPageData.setMediaBox("0 0 " + this.img.getWidth() + " " + this.img.getHeight());
                pdfPageData.checkSizeSet(1);
                this.resetRotationBox();
            }
            this.statusBar.resetStatus("opening file");
            if (this.decode_pdf.isEncrypted() && !this.decode_pdf.isFileViewable()) {
                bl = false;
                String string2 = JOptionPane.showInputDialog(this, (Object)this.getMessage("PdfViewerPassword.message"));
                if (string2 != null) {
                    this.decode_pdf.setEncryptionPassword(string2);
                    this.decode_pdf.verifyAccess();
                    if (this.decode_pdf.isFileViewable()) {
                        bl = true;
                    }
                }
            }
            this.removeOutlinePanels();
            if (!bl) {
                JOptionPane.showMessageDialog(this, this.getMessage("PdfViewerPasswordRequired.message"));
            } else {
                ++currentFileCount;
                this.currentPage = 1;
            }
        }
        catch (Exception exception) {
            System.err.println("Exception " + exception + " opening file");
            JOptionPane.showMessageDialog(this, this.getMessage("PdfViewerOpenerror"));
            System.exit(1);
            this.isProcessing = false;
        }
        return bl;
    }

    private void processPage() {
        if (this.isPDF && this.switchModes) {
            PdfFileInformation pdfFileInformation = this.decode_pdf.getFileInformationData();
            this.decode_pdf.setRenderMode(3);
            String[] stringArray = pdfFileInformation.getFieldValues();
            String[] stringArray2 = pdfFileInformation.getFieldNames();
            for (int i = 0; i < stringArray2.length; ++i) {
                if (stringArray2[i].equals("Creator") | stringArray2[i].equals("Producer")) {
                    for (int j = 0; j < this.ocr.length; ++j) {
                        if (!stringArray[i].equals(this.ocr[j])) continue;
                        this.decode_pdf.setRenderMode(2);
                        this.decode_pdf.setEnableLegacyJPEGConversion(true);
                    }
                }
                if (stringArray2[i].equals("Creator")) {
                    if (stringArray[i].equals("XPP")) {
                        this.decode_pdf.useHiResScreenDisplay(true);
                    } else {
                        this.decode_pdf.useHiResScreenDisplay(false);
                    }
                }
                if (!this.useHiresImage) continue;
                this.decode_pdf.useHiResScreenDisplay(true);
            }
        }
        this.pageCount = this.decode_pdf.getPageCount();
        if (!this.isPDF) {
            this.pageCount = 1;
            this.decode_pdf.useHiResScreenDisplay(true);
        }
        if (this.pageCount < this.currentPage) {
            this.currentPage = this.pageCount;
            System.err.println(this.currentPage + " out of range. Opening on last page");
            LogWriter.writeLog(this.currentPage + " out of range. Opening on last page");
        }
        this.decode_pdf.setExtractionMode(0, 72, this.scaling);
        this.zoom();
        this.decode_pdf.setPDFBorder(BorderFactory.createLineBorder(Color.black, 1));
        this.decode_pdf.disableBorderForPrinting();
        this.pageCounter2.setForeground(Color.black);
        this.pageCounter2.setText(" " + this.currentPage);
        this.pageCounter3.setText(this.getMessage("PdfViewerOfLabel.text") + " " + this.pageCount);
        this.resetRotationBox();
        if (this.isPDF) {
            this.decodePage(true);
        } else {
            this.decodeImage(true);
        }
    }

    private void resetRotationBox() {
        PdfPageData pdfPageData = this.decode_pdf.getPdfPageData();
        this.rotation = pdfPageData.getRotation(this.currentPage);
        if (this.rotationBox.getSelectedIndex() != this.rotation / 90) {
            this.rotationBox.setSelectedIndex(this.rotation / 90);
        } else {
            this.decode_pdf.repaint();
        }
    }

    public void zoom() {
        if (this.decode_pdf != null) {
            int n;
            Object object;
            int n2 = this.scalingBox.getSelectedIndex();
            if (n2 == -1) {
                object = (String)this.scalingBox.getSelectedItem();
                float f = -1.0f;
                if (object != null && ((String)object).length() > 0) {
                    block24: {
                        try {
                            f = Float.parseFloat((String)object);
                        }
                        catch (Exception exception) {
                            char c;
                            int n3;
                            f = -1.0f;
                            n = ((String)object).length();
                            for (n3 = 0; n3 < n && ((c = ((String)object).charAt(n3)) >= '0' && c <= '9') | c == '.'; ++n3) {
                            }
                            if (n3 > 0) {
                                object = ((String)object).substring(0, n3);
                            }
                            if (f != -1.0f) break block24;
                            try {
                                f = Float.parseFloat((String)object);
                            }
                            catch (Exception exception2) {
                                f = -1.0f;
                            }
                        }
                    }
                    if (f > 1000.0f) {
                        f = 1000.0f;
                    }
                }
                if (f == -1.0f) {
                    n2 = 0;
                    this.scalingBox.setSelectedItem(this.scalingBox.getItemAt(n2));
                } else {
                    this.scaling = f / 100.0f;
                    this.scalingBox.setSelectedItem(f + "");
                }
            }
            if (n2 != -1) {
                if (n2 < 3) {
                    int n4;
                    int n5;
                    object = this.decode_pdf.getPdfPageData();
                    n = ((PdfPageData)object).getRotation(this.currentPage);
                    if (this.rotation == 90 || this.rotation == 270) {
                        n5 = ((PdfPageData)object).getCropBoxHeight(this.currentPage);
                        n4 = ((PdfPageData)object).getCropBoxWidth(this.currentPage);
                    } else {
                        n5 = ((PdfPageData)object).getCropBoxWidth(this.currentPage);
                        n4 = ((PdfPageData)object).getCropBoxHeight(this.currentPage);
                    }
                    float f = this.scrollPane.getViewport().getWidth() - 25 - 25 - this.displayPane.getDividerSize();
                    float f2 = this.scrollPane.getViewport().getHeight() - 25 - 25;
                    float f3 = 0.0f;
                    float f4 = 0.0f;
                    f3 = f / (float)n5;
                    f4 = f2 / (float)n4;
                    if (n2 == 0) {
                        this.scaling = f3 < f4 ? f3 : f4;
                    } else if (n2 == 1) {
                        this.scaling = f4;
                    } else if (n2 == 2) {
                        this.scaling = f3;
                    }
                } else {
                    this.scaling = this.scalingFloatValues[n2];
                }
            }
            if ((float)((PdfPageData)(object = this.decode_pdf.getPdfPageData())).getCropBoxHeight(this.currentPage) * this.scaling < 100.0f && (float)((PdfPageData)object).getCropBoxWidth(this.currentPage) * this.scaling < 100.0f && this.isPDF) {
                this.scaling = 1.0f;
                this.scalingBox.setSelectedItem("100");
            }
            if (this.decode_pdf != null) {
                this.decode_pdf.setPageParameters(this.scaling, this.currentPage, this.rotation);
            }
            this.decode_pdf.invalidate();
            this.scrollPane.repaint();
            this.validate();
        }
    }

    public void forward(int n) {
        if (!this.isProcessing) {
            if (this.currentPage + n <= this.pageCount) {
                this.currentPage += n;
                this.statusBar.resetStatus("Loading Page " + this.currentPage);
                this.decode_pdf.setPageParameters(this.scaling, this.currentPage);
                this.decodePage(false);
                if (this.scalingBox.getSelectedIndex() < 3) {
                    this.zoom();
                }
            }
        } else {
            JOptionPane.showMessageDialog(this, this.getMessage("PdfViewerDecodeWait.message"));
        }
    }

    protected void decodePage(final boolean bl) {
        this.decode_pdf.setFoundTextAreas(null);
        this.currentRectangle = null;
        this.scalingBox.setEnabled(false);
        this.rotationBox.setEnabled(false);
        this.decode_pdf.clearScreen();
        if (this.isProcessing | this.worker != null && this.thumbnails.drawing) {
            this.thumbnails.interrupt = true;
            while (this.thumbnails.drawing) {
                try {
                    Thread.sleep(20L);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
            this.thumbnails.interrupt = false;
        }
        this.isProcessing = true;
        if (!this.hasOutlinesDrawn) {
            this.hasOutlinesDrawn = true;
            this.createOutlinePanels();
        }
        this.worker = new SwingWorker(){

            public Object construct() {
                try {
                    SimpleViewer.this.statusBar.updateStatus("Decoding Page", 0);
                    if (bl && SimpleViewer.this.showThumbnails) {
                        SimpleViewer.this.zoom();
                    }
                    if (Thread.interrupted()) {
                        throw new InterruptedException();
                    }
                    try {
                        SimpleViewer.this.decode_pdf.decodePage(SimpleViewer.this.currentPage);
                        PdfPageData pdfPageData = SimpleViewer.this.decode_pdf.getPdfPageData();
                        SimpleViewer.this.mediaW = pdfPageData.getMediaBoxWidth(SimpleViewer.this.currentPage);
                        SimpleViewer.this.mediaH = pdfPageData.getMediaBoxHeight(SimpleViewer.this.currentPage);
                        SimpleViewer.this.mediaX = pdfPageData.getMediaBoxX(SimpleViewer.this.currentPage);
                        SimpleViewer.this.mediaY = pdfPageData.getMediaBoxY(SimpleViewer.this.currentPage);
                        SimpleViewer.this.cropX = pdfPageData.getCropBoxX(SimpleViewer.this.currentPage);
                        SimpleViewer.this.cropY = pdfPageData.getCropBoxY(SimpleViewer.this.currentPage);
                        SimpleViewer.this.cropW = pdfPageData.getCropBoxWidth(SimpleViewer.this.currentPage);
                        SimpleViewer.this.cropH = pdfPageData.getCropBoxHeight(SimpleViewer.this.currentPage);
                        SimpleViewer.this.resetRotationBox();
                        SimpleViewer.this.statusBar.updateStatus("Displaying Page", 0);
                    }
                    catch (Exception exception) {
                        System.err.println("Exception " + exception + " decoding page");
                        exception.printStackTrace();
                    }
                    SimpleViewer.this.pageCounter2.setForeground(Color.black);
                    SimpleViewer.this.pageCounter2.setText(" " + SimpleViewer.this.currentPage);
                    SimpleViewer.this.pageCounter3.setText(SimpleViewer.this.getMessage("PdfViewerOfLabel.text") + " " + SimpleViewer.this.pageCount);
                    if (SimpleViewer.this.decode_pdf.hasEmbeddedFonts() && !SimpleViewer.this.decode_pdf.supportsEmbeddedFonts()) {
                        JOptionPane.showMessageDialog(SimpleViewer.this.c, "Page contains embedded fonts which may not display correctly using Font substitution.");
                    }
                    if (SimpleViewer.this.showThumbnails) {
                        SimpleViewer.this.thumbnails.addNewThumbnails(SimpleViewer.this.currentPage, SimpleViewer.this.decode_pdf);
                    } else {
                        SimpleViewer.this.isProcessing = false;
                    }
                    SimpleViewer.this.setViewerTitle(null);
                    if (SimpleViewer.this.showThumbnails) {
                        SimpleViewer.this.thumbnails.setupThumbnailsOnDecode(SimpleViewer.this.currentPage, SimpleViewer.this.decode_pdf);
                        SimpleViewer.this.isProcessing = false;
                        SimpleViewer.this.thumbnails.createThumbnailsOnDecode(SimpleViewer.this.currentPage, SimpleViewer.this.decode_pdf);
                    }
                }
                catch (Exception exception) {
                    SimpleViewer.this.setViewerTitle(null);
                }
                SimpleViewer.this.selectBookmark();
                SimpleViewer.this.statusBar.setProgress(100);
                SimpleViewer.this.scalingBox.setEnabled(true);
                SimpleViewer.this.rotationBox.setEnabled(true);
                return null;
            }
        };
        this.worker.start();
    }

    protected void decodeImage(final boolean bl) {
        this.decode_pdf.setFoundTextAreas(null);
        this.currentRectangle = null;
        this.scalingBox.setEnabled(false);
        this.rotationBox.setEnabled(false);
        this.decode_pdf.clearScreen();
        if (this.isProcessing | this.worker != null && this.thumbnails.drawing) {
            this.thumbnails.interrupt = true;
            while (this.thumbnails.drawing) {
                try {
                    Thread.sleep(20L);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
            this.thumbnails.interrupt = false;
        }
        this.isProcessing = true;
        this.worker = new SwingWorker(){

            public Object construct() {
                try {
                    SimpleViewer.this.statusBar.updateStatus("Decoding Page", 0);
                    SimpleViewer.this.decode_pdf.addImage(SimpleViewer.this.img);
                    if (bl && SimpleViewer.this.showThumbnails) {
                        SimpleViewer.this.zoom();
                    }
                    if (Thread.interrupted()) {
                        throw new InterruptedException();
                    }
                    SimpleViewer.this.pageCounter2.setForeground(Color.black);
                    SimpleViewer.this.pageCounter2.setText(" " + SimpleViewer.this.currentPage);
                    SimpleViewer.this.pageCounter3.setText(SimpleViewer.this.getMessage("PdfViewerOfLabel.text") + " " + SimpleViewer.this.pageCount);
                    SimpleViewer.this.setViewerTitle(null);
                }
                catch (Exception exception) {
                    SimpleViewer.this.setViewerTitle(null);
                }
                SimpleViewer.this.statusBar.setProgress(100);
                SimpleViewer.this.scalingBox.setEnabled(true);
                SimpleViewer.this.rotationBox.setEnabled(true);
                return null;
            }
        };
        this.worker.start();
    }

    public void back(int n) {
        if (!this.isProcessing) {
            if (this.currentPage - n >= 1) {
                this.currentPage -= n;
                this.statusBar.resetStatus("loading page " + this.currentPage);
                this.decode_pdf.setPageParameters(this.scaling, this.currentPage);
                this.decodePage(false);
                if (this.scalingBox.getSelectedIndex() < 3) {
                    this.zoom();
                }
            }
        } else {
            JOptionPane.showMessageDialog(this, this.getMessage("PdfViewerDecodeWait.message"));
        }
    }

    public void exit() {
        if (this.showThumbnails && this.thumbnails.drawing) {
            this.thumbnails.interrupt = true;
            while (this.thumbnails.drawing) {
                try {
                    Thread.sleep(20L);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
            this.thumbnails.interrupt = false;
        }
        JOptionPane.showConfirmDialog(this, new JLabel(this.getMessage("PdfViewerExiting")), this.getMessage("PdfViewerprogramExit"), -1, -1);
        this.decode_pdf.closePdfFile();
        if (this.target != null) {
            this.flush();
        }
        System.exit(1);
    }

    protected String getMessage(String string) {
        String string2 = null;
        try {
            string2 = this.bundle.getString(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (string2 == null) {
            try {
                if (this.messages == null) {
                    this.initMessages();
                }
                string2 = (String)this.messages.get(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (string2 == null) {
            string2 = string;
        }
        return string2;
    }

    private void initMessages() {
        String string = null;
        BufferedReader bufferedReader = null;
        ClassLoader classLoader = this.getClass().getClassLoader();
        String string2 = "Cp1252";
        try {
            this.messages = new HashMap();
            bufferedReader = new BufferedReader(new InputStreamReader(classLoader.getResourceAsStream("org/jpedal/international/messages.properties"), string2));
            if (bufferedReader == null) {
                LogWriter.writeLog("Unable to open messages.properties from jar");
            }
            while ((string = bufferedReader.readLine()) != null) {
                int n = string.indexOf(61);
                if (n == -1) continue;
                this.messages.put(string.substring(0, n), string.substring(n + 1));
            }
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " reading message Bundle");
        }
        if (bufferedReader != null) {
            try {
                bufferedReader.close();
            }
            catch (Exception exception) {
                LogWriter.writeLog("Exception " + exception + " reading lookup table for pdf  for abobe map");
            }
        }
    }

    protected void selectBookmark() {
        if (!this.decode_pdf.hasOutline()) {
            return;
        }
    }

    private void traverse() {
        TreeModel treeModel = this.tree.getModel();
        if (treeModel != null) {
            this.walk(treeModel, treeModel.getRoot());
        }
    }

    private void walk(TreeModel treeModel, Object object) {
        int n = treeModel.getChildCount(object);
        for (int i = 0; i < n; ++i) {
            Object object2 = treeModel.getChild(object, i);
            if (treeModel.isLeaf(object2)) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object2;
                String string = (String)defaultMutableTreeNode.getUserObject();
                String string2 = (String)this.pageLookupTable.get(string);
                if (string2.length() <= 0) continue;
                try {
                    if (Integer.parseInt(string2) != this.currentPage) continue;
                    this.ignoreAlteredBookmark = true;
                    this.tree.setSelectionPath(new TreePath(defaultMutableTreeNode.getPath()));
                    this.ignoreAlteredBookmark = false;
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("bad page number: " + string2);
                    this.ignoreAlteredBookmark = false;
                }
                continue;
            }
            this.walk(treeModel, object2);
        }
    }

    private void createLookupTable(TreeModel treeModel, Object object) {
        int n = treeModel.getChildCount(object);
        for (int i = 0; i < n; ++i) {
            Object object2 = treeModel.getChild(object, i);
            if (treeModel.isLeaf(object2)) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object2;
                String string = (String)defaultMutableTreeNode.getUserObject();
                String string2 = (String)this.pageLookupTable.get(string);
                try {
                    if (Integer.parseInt(string2) != this.currentPage) continue;
                    this.tree.setSelectionPath(new TreePath(defaultMutableTreeNode.getPath()));
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("bad page number: " + string2);
                }
                continue;
            }
            this.walk(treeModel, object2);
        }
    }

    static {
        printingThreads = 0;
        coords = new JLabel();
        currentFileCount = 0;
    }

    protected class FrameCloser
    extends WindowAdapter {
        public void windowClosing(WindowEvent windowEvent) {
            if (SimpleViewer.this.target != null) {
                SimpleViewer.this.flush();
            }
            if (printingThreads > 0) {
                JOptionPane.showMessageDialog(SimpleViewer.this.c, SimpleViewer.this.getMessage("PdfViewerBusyPrinting.message"));
            }
            if (!SimpleViewer.this.isProcessing) {
                int n;
                if (SimpleViewer.this.showThumbnails && SimpleViewer.this.thumbnails.drawing) {
                    SimpleViewer.this.thumbnails.interrupt = true;
                    while (SimpleViewer.this.thumbnails.drawing) {
                        try {
                            Thread.sleep(20L);
                        }
                        catch (InterruptedException interruptedException) {
                            interruptedException.printStackTrace();
                        }
                    }
                    SimpleViewer.this.thumbnails.interrupt = false;
                }
                if ((n = JOptionPane.showConfirmDialog(SimpleViewer.this.c, SimpleViewer.this.getMessage("PdfViewerCloseing.message"), null, 0)) == 0) {
                    SimpleViewer.this.decode_pdf.closePdfFile();
                    System.exit(0);
                }
            } else {
                JOptionPane.showMessageDialog(SimpleViewer.this.c, SimpleViewer.this.getMessage("PdfViewerDecodeWait.message"));
            }
        }
    }

    protected class mouse_clicker
    extends MouseAdapter {
        protected mouse_clicker() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            int n = (int)((float)(mouseEvent.getX() - 25) / SimpleViewer.this.scaling);
            int n2 = (int)((float)(mouseEvent.getY() - 25) / SimpleViewer.this.scaling);
            if (SimpleViewer.this.maxViewY != 0) {
                n = (int)((double)((float)n - (float)SimpleViewer.this.dx * SimpleViewer.this.scaling) / SimpleViewer.this.viewportScale);
                n2 = (int)(((double)SimpleViewer.this.mediaH - (double)((float)SimpleViewer.this.mediaH - (float)n2 / SimpleViewer.this.scaling - (float)SimpleViewer.this.dy) / SimpleViewer.this.viewportScale) * (double)SimpleViewer.this.scaling);
            }
            if (SimpleViewer.this.rotation == 90) {
                SimpleViewer.this.m_y1 = n + SimpleViewer.this.cropY;
                SimpleViewer.this.m_x1 = n2 + SimpleViewer.this.cropX;
            } else if (SimpleViewer.this.rotation == 180) {
                SimpleViewer.this.m_x1 = SimpleViewer.this.mediaW - (n + SimpleViewer.this.mediaW - SimpleViewer.this.cropW - SimpleViewer.this.cropX);
                SimpleViewer.this.m_y1 = n2 + SimpleViewer.this.cropY;
            } else if (SimpleViewer.this.rotation == 270) {
                SimpleViewer.this.m_y1 = SimpleViewer.this.mediaH - (n + SimpleViewer.this.mediaH - SimpleViewer.this.cropH - SimpleViewer.this.cropY);
                SimpleViewer.this.m_x1 = SimpleViewer.this.mediaW - (n2 + SimpleViewer.this.mediaW - SimpleViewer.this.cropW - SimpleViewer.this.cropX);
            } else {
                SimpleViewer.this.m_x1 = n + SimpleViewer.this.cropX;
                SimpleViewer.this.m_y1 = SimpleViewer.this.mediaH - (n2 + SimpleViewer.this.mediaH - SimpleViewer.this.cropH - SimpleViewer.this.cropY);
            }
            SimpleViewer.this.updateCords(mouseEvent);
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            SimpleViewer.this.checkLinks(true);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            SimpleViewer.this.old_m_x2 = -1;
            SimpleViewer.this.old_m_y2 = -1;
            SimpleViewer.this.updateCords(mouseEvent);
            if (!SimpleViewer.this.isPDF || mouseEvent.isShiftDown()) {
                // empty if block
            }
            SimpleViewer.this.decode_pdf.updateCursorBoxOnScreen(null, null);
            SimpleViewer.this.decode_pdf.setHighlightedAreas(null);
            SimpleViewer.this.decode_pdf.repaintArea(new Rectangle(SimpleViewer.this.m_x1 - SimpleViewer.this.cropX, SimpleViewer.this.m_y2 + SimpleViewer.this.cropY, SimpleViewer.this.m_x2 - SimpleViewer.this.m_x1 + SimpleViewer.this.cropX, SimpleViewer.this.m_y1 - SimpleViewer.this.m_y2 + SimpleViewer.this.cropY), SimpleViewer.this.mediaH);
            SimpleViewer.this.decode_pdf.repaint();
        }
    }

    protected class mouse_mover
    implements MouseMotionListener {
        public void mouseDragged(MouseEvent mouseEvent) {
            int[] nArray = SimpleViewer.this.updateXY(mouseEvent);
            SimpleViewer.this.m_x2 = nArray[0];
            SimpleViewer.this.m_y2 = nArray[1];
            this.scrollAndUpdateCoords(mouseEvent);
            this.generateNewCursorBox();
            SimpleViewer.this.checkLinks(false);
        }

        protected void scrollAndUpdateCoords(MouseEvent mouseEvent) {
            int n = SimpleViewer.this.decode_pdf.getScrollInterval();
            Rectangle rectangle = new Rectangle(mouseEvent.getX(), mouseEvent.getY(), n, n);
            if (SimpleViewer.this.allowScrolling && !SimpleViewer.this.decode_pdf.getVisibleRect().contains(rectangle)) {
                SimpleViewer.this.decode_pdf.scrollRectToVisible(rectangle);
            }
            SimpleViewer.this.updateCords(mouseEvent);
        }

        protected void generateNewCursorBox() {
            if (SimpleViewer.this.old_m_x2 != -1 | SimpleViewer.this.old_m_y2 != -1 | Math.abs(SimpleViewer.this.m_x2 - SimpleViewer.this.old_m_x2) > 5 | Math.abs(SimpleViewer.this.m_y2 - SimpleViewer.this.old_m_y2) > 5) {
                int n = SimpleViewer.this.m_x1;
                if (SimpleViewer.this.m_x1 > SimpleViewer.this.m_x2) {
                    n = SimpleViewer.this.m_x2;
                }
                int n2 = SimpleViewer.this.m_y1;
                if (SimpleViewer.this.m_y1 > SimpleViewer.this.m_y2) {
                    n2 = SimpleViewer.this.m_y2;
                }
                int n3 = Math.abs(SimpleViewer.this.m_x2 - SimpleViewer.this.m_x1);
                int n4 = Math.abs(SimpleViewer.this.m_y2 - SimpleViewer.this.m_y1);
                SimpleViewer.this.currentRectangle = new Rectangle(n, n2, n3, n4);
                SimpleViewer.this.decode_pdf.updateCursorBoxOnScreen(SimpleViewer.this.currentRectangle, Color.blue);
                Rectangle[] rectangleArray = new Rectangle[2];
                rectangleArray[0] = SimpleViewer.this.currentRectangle;
                SimpleViewer.this.decode_pdf.setHighlightedAreas(rectangleArray);
                SimpleViewer.this.old_m_x2 = SimpleViewer.this.m_x2;
                SimpleViewer.this.old_m_y2 = SimpleViewer.this.m_y2;
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            SimpleViewer.this.updateCords(mouseEvent);
            SimpleViewer.this.checkLinks(false);
        }
    }

    class PageChanger
    implements ActionListener {
        int page;

        public PageChanger(int n) {
            this.page = ++n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (!SimpleViewer.this.isProcessing && SimpleViewer.this.currentPage != this.page) {
                SimpleViewer.this.currentPage = this.page;
                SimpleViewer.this.statusBar.resetStatus("");
                SimpleViewer.this.scalingBox.setSelectedIndex(0);
                SimpleViewer.this.decode_pdf.setPageParameters(SimpleViewer.this.scaling, SimpleViewer.this.currentPage);
                SimpleViewer.this.decodePage(false);
            }
        }
    }

    private class ThumbPainter
    extends ComponentAdapter {
        Timer trapMultipleMoves;

        private ThumbPainter() {
            this.trapMultipleMoves = this.trapMultipleMoves = new Timer(250, new ActionListener(this){
                private final /* synthetic */ ThumbPainter this$1;
                {
                    this.this$1 = thumbPainter;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    if (ThumbPainter.access$500((ThumbPainter)this.this$1).worker != null && ThumbPainter.access$500((ThumbPainter)this.this$1).thumbnails.drawing) {
                        ThumbPainter.access$500((ThumbPainter)this.this$1).thumbnails.interrupt = true;
                        while (ThumbPainter.access$500((ThumbPainter)this.this$1).thumbnails.drawing) {
                            try {
                                Thread.sleep(20L);
                            }
                            catch (InterruptedException interruptedException) {
                                interruptedException.printStackTrace();
                            }
                        }
                        ThumbPainter.access$500((ThumbPainter)this.this$1).thumbnails.interrupt = false;
                    }
                    while (ThumbPainter.access$500((ThumbPainter)this.this$1).isProcessing) {
                        try {
                            Thread.sleep(20L);
                        }
                        catch (InterruptedException interruptedException) {
                            interruptedException.printStackTrace();
                        }
                    }
                    ThumbPainter.access$500((ThumbPainter)this.this$1).thumbnails.drawVisibleThumbnailsOnScroll(ThumbPainter.access$500((ThumbPainter)this.this$1).decode_pdf);
                }
            });
        }

        public void componentMoved(ComponentEvent componentEvent) {
            if (this.trapMultipleMoves.isRunning()) {
                this.trapMultipleMoves.stop();
            }
            this.trapMultipleMoves.setRepeats(false);
            this.trapMultipleMoves.start();
        }

        static /* synthetic */ SimpleViewer access$500(ThumbPainter thumbPainter) {
            return thumbPainter.SimpleViewer.this;
        }
    }
}

