/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.printing;

import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.PrinterJob;
import java.io.File;
import java.lang.reflect.Array;
import java.util.Hashtable;
import javax.print.PrintService;
import javax.print.attribute.Attribute;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.SetOfIntegerSyntax;
import org.jpedal.PdfDecoder;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.repositories.Vector_Int;

public class SilentPrint {
    private static boolean debugCode = true;
    SetOfIntegerSyntax range = null;
    private final String separator = System.getProperty("file.separator");
    private PdfDecoder decode_pdf = null;
    private int maxCopies = 5;
    Vector_Int pages = new Vector_Int();
    private int copiesToPrint = 1;
    private int pageCount;
    private String printer = "PSC 1600 series";
    private String tray = null;
    static /* synthetic */ Class class$javax$print$attribute$standard$Media;

    public SilentPrint(String string) {
        if (string.toLowerCase().endsWith(".pdf")) {
            this.decodeAndPrintFile(string);
        } else {
            String[] stringArray = null;
            File file = null;
            if (!string.endsWith(this.separator)) {
                string = string + this.separator;
            }
            try {
                file = new File(string);
                if (!file.isDirectory()) {
                    System.err.println(string + " is not a directory. Exiting program");
                }
                stringArray = file.list();
            }
            catch (Exception exception) {
                LogWriter.writeLog("Exception trying to access file " + exception.getMessage());
            }
            long l = stringArray.length;
            int n = 0;
            while ((long)n < l) {
                if (stringArray[n].toLowerCase().endsWith(".pdf")) {
                    SilentPrint.logMessage(string + stringArray[n]);
                    this.decodeAndPrintFile(string + stringArray[n]);
                }
                ++n;
            }
        }
    }

    private void decodeAndPrintFile(String string) {
        try {
            SilentPrint.logMessage("Opening file :" + string + " to print.");
            this.decode_pdf = new PdfDecoder(true);
            this.decode_pdf.openPdfFile(string);
            this.pageCount = this.decode_pdf.getPageCount();
        }
        catch (Exception exception) {
            this.reportError("Exception " + exception + " in pdf code");
        }
        if (this.decode_pdf.isEncrypted() && !this.decode_pdf.isExtractionAllowed()) {
            SilentPrint.logMessage("Encrypted settings");
        } else {
            this.printAllCopies();
        }
        this.decode_pdf.closePdfFile();
    }

    private final void printAllCopies() {
        for (int i = 0; i < this.copiesToPrint; ++i) {
            SilentPrint.logMessage("========================");
            SilentPrint.logMessage("\nPrinting copy " + (i + 1));
            SilentPrint.logMessage("========================");
            this.printCopy(i);
        }
    }

    private final void printCopy(int n) {
        int n2 = this.decode_pdf.getPageCount();
        int n3 = this.pages.size();
        SilentPrint.logMessage("pages=" + n3);
        for (int i = 0; i < n3; ++i) {
            if (this.range != null && !this.range.contains(i + 1)) continue;
            this.printPage(i);
        }
    }

    private void printPage(int n) {
        try {
            int n2;
            PrinterJob printerJob = PrinterJob.getPrinterJob();
            PageFormat pageFormat = printerJob.defaultPage();
            HashPrintRequestAttributeSet hashPrintRequestAttributeSet = new HashPrintRequestAttributeSet();
            PrintService[] printServiceArray = PrinterJob.lookupPrintServices();
            boolean bl = false;
            int n3 = printServiceArray.length;
            for (n2 = 0; n2 < n3; ++n2) {
                if (printServiceArray[n2].getName().indexOf(this.printer) == -1) continue;
                printerJob.setPrintService(printServiceArray[n2]);
                n2 = n3;
                bl = true;
            }
            if (!bl) {
                String string = "";
                for (int i = 0; i < n3; ++i) {
                    string = string + printServiceArray[i].getName() + ",";
                }
                this.reportError("Printer " + this.printer + " not supported. Options=" + string);
            } else {
                if (this.tray != null) {
                    Class<?>[] classArray;
                    n2 = printerJob.getPrintService().isAttributeCategorySupported(class$javax$print$attribute$standard$Media == null ? (class$javax$print$attribute$standard$Media = SilentPrint.class$("javax.print.attribute.standard.Media")) : class$javax$print$attribute$standard$Media) ? 1 : 0;
                    if (n2 != 0) {
                        classArray = new Hashtable();
                        Class clazz = class$javax$print$attribute$standard$Media == null ? (class$javax$print$attribute$standard$Media = SilentPrint.class$("javax.print.attribute.standard.Media")) : class$javax$print$attribute$standard$Media;
                        Object object = printerJob.getPrintService().getSupportedAttributeValues(clazz, null, null);
                        if (object == null) {
                            SilentPrint.logMessage("Attribute " + clazz + " not supported");
                        } else if (object.getClass().isArray()) {
                            for (int i = 0; i < Array.getLength(object); ++i) {
                                Object object2 = Array.get(object, i);
                                classArray.put(object2.toString(), object2);
                                SilentPrint.logMessage("Atribute values " + object2.toString());
                            }
                        }
                        Object v = classArray.get(this.tray);
                        if (v != null) {
                            hashPrintRequestAttributeSet.add((Attribute)v);
                        }
                    } else {
                        SilentPrint.logMessage("Tray " + this.tray + " not implemented");
                        SilentPrint.logMessage("Atributes implemented are ");
                        classArray = printerJob.getPrintService().getSupportedAttributeCategories();
                        for (int i = 0; i < classArray.length; ++i) {
                            SilentPrint.logMessage(">>" + classArray[i].getName());
                        }
                    }
                }
                if (debugCode) {
                    Attribute[] attributeArray = hashPrintRequestAttributeSet.toArray();
                    int n4 = attributeArray.length;
                    for (int i = 0; i < n4; ++i) {
                        SilentPrint.logMessage(i + " " + attributeArray[i].getName() + " " + attributeArray[i].toString());
                    }
                }
                Paper paper = new Paper();
                paper.setSize(595.0, 842.0);
                paper.setImageableArea(0.0, 0.0, 595.0, 842.0);
                pageFormat.setPaper(paper);
                printerJob.setCopies(1);
                this.decode_pdf.setPageFormat(pageFormat);
                printerJob.setPageable(this.decode_pdf);
                printerJob.print();
            }
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " printing");
        }
        catch (Error error) {
            LogWriter.writeLog("Error " + error + " printing");
        }
    }

    private static void logMessage(String string) {
        if (debugCode) {
            System.out.println(string);
            LogWriter.writeLog(string);
        }
    }

    private void reportError(String string) {
        System.err.println(string);
        LogWriter.writeLog(string);
    }

    public static void main(String[] stringArray) {
        SilentPrint.logMessage("Simple demo to print pages");
        if (stringArray.length != 1) {
            SilentPrint.logMessage("File name or directory must be supplied");
        }
        String string = stringArray[0];
        SilentPrint.logMessage("File :" + string);
        File file = new File(string);
        if (!file.exists()) {
            SilentPrint.logMessage("File " + string + " not found");
        }
        SilentPrint silentPrint = new SilentPrint(string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

